/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-05-22 12:41:45 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `dgfdcv_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=8332 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=572 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `dgfdcv_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=24929 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=973 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_sliders7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_slides7` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `dgfdcv_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=366 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11046 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `dgfdcv_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dgfdcv_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tds_billing` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `billing_first_name` varchar(50) DEFAULT NULL,
  `billing_last_name` varchar(60) DEFAULT NULL,
  `billing_company_name` varchar(500) DEFAULT NULL,
  `billing_vat_number` varchar(50) DEFAULT NULL,
  `billing_address` varchar(500) DEFAULT NULL,
  `billing_country` varchar(50) DEFAULT NULL,
  `billing_city` varchar(50) DEFAULT NULL,
  `billing_county` varchar(50) DEFAULT NULL,
  `billing_post_code` varchar(50) DEFAULT NULL,
  `billing_phone` varchar(50) DEFAULT NULL,
  `billing_email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `tds_companies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_cui` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_j` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_bank_account` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_post_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_vat_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tds_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(35) NOT NULL,
  `value` varchar(35) NOT NULL,
  `type` varchar(35) NOT NULL,
  `usage_limit` int DEFAULT NULL,
  `desc` varchar(255) NOT NULL DEFAULT '',
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `tds_options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `value` longtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;

CREATE TABLE `tds_payment_bank` (
  `id` int NOT NULL AUTO_INCREMENT,
  `account_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `account_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `bank_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `routing_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `iban` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `bic_swift` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `instruction` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tds_payment_paypal` (
  `id` int NOT NULL AUTO_INCREMENT,
  `client_id` varchar(255) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `is_sandbox` tinyint(1) NOT NULL,
  `client_id_sandbox` varchar(255) NOT NULL,
  `instructions` varchar(1000) DEFAULT '',
  `description` varchar(1000) DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tds_payment_stripe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `is_active` tinyint(1) NOT NULL,
  `is_sandbox` tinyint(1) NOT NULL,
  `secret_key` varchar(255) NOT NULL,
  `public_key` varchar(255) NOT NULL,
  `sandbox_secret_key` varchar(255) NOT NULL,
  `sandbox_public_key` varchar(255) NOT NULL,
  `webhook_endpoint` varchar(255) NOT NULL DEFAULT '',
  `webhook_endpoint_secret` varchar(255) NOT NULL DEFAULT '',
  `payment_methods` longtext,
  `instructions` varchar(1000) NOT NULL DEFAULT '',
  `automatic_tax` tinyint(1) DEFAULT '1',
  `description` varchar(1000) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tds_paypal_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `subscription_id` int DEFAULT NULL,
  `order_id` varchar(50) DEFAULT '',
  `order_intent` varchar(50) DEFAULT '',
  `order_status` varchar(50) DEFAULT '',
  `order_payer_id` varchar(50) DEFAULT '',
  `order_payer_given_name` varchar(50) DEFAULT '',
  `order_payer_surname` varchar(50) DEFAULT '',
  `order_payer_email` varchar(50) DEFAULT '',
  `order_payee_id` varchar(50) DEFAULT '',
  `order_payee_email` varchar(50) DEFAULT '',
  `order_amount_currency_code` varchar(50) DEFAULT '',
  `order_amount_value` varchar(50) DEFAULT '',
  `order_info` text,
  `order_create_time` varchar(40) DEFAULT '',
  `order_update_time` varchar(40) DEFAULT '',
  `order_capture_create_time` varchar(40) DEFAULT '',
  `order_capture_update_time` varchar(40) DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `tds_plans` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `price` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `interval_count` int NOT NULL DEFAULT '1',
  `interval` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `months_in_cycle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `trial_days` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `is_free` tinyint(1) DEFAULT '0',
  `is_unlimited` tinyint(1) DEFAULT '0',
  `is_with_credits` tinyint(1) DEFAULT '0',
  `is_donation` tinyint(1) DEFAULT '0',
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `list` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `publishing_limits` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `automatic_delistings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `credits` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `auto_subscribe` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tds_subscriptions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `plan_id` int NOT NULL,
  `user_id` int NOT NULL,
  `ref_id` int DEFAULT NULL,
  `billing_first_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_last_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_company_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_cui` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_j` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_address` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_county` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_bank_account` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_post_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `billing_vat_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `price` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `next_price` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `curr_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `curr_pos` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `curr_th_sep` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `curr_dec_sep` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `curr_dec_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_free` tinyint(1) DEFAULT '0',
  `is_unlimited` tinyint(1) DEFAULT '0',
  `is_with_credits` tinyint(1) DEFAULT '0',
  `is_donation` tinyint(1) DEFAULT '0',
  `cycle_interval` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cycle_interval_count` int NOT NULL DEFAULT '1',
  `last_months_in_cycle` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `start_day` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `trial_days` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `start_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `stripe_payment_intent` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `stripe_payment_method` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `stripe_payment_status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `stripe_payment_info` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `stripe_invoice_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `stripe_subscription_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `stripe_customer_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `confirm_key` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `canceled` tinyint NOT NULL DEFAULT '0',
  `coupon_id` int NOT NULL DEFAULT '0',
  `credits` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `plan_posts_remaining` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `tds_trackings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rdr_url` varchar(255) NOT NULL,
  `click_count` bigint NOT NULL DEFAULT '0',
  `page_html` varchar(2000) NOT NULL,
  `notes` varchar(255) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `tds_trackings_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `page_html` varchar(2000) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: dgfdcv_actionscheduler_actions */
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("46", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-01 10:36:40", "2023-04-01 15:06:40", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680345400;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680345400;}", "3", "1", "2023-04-01 10:36:47", "2023-04-01 15:06:47", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("50", "action_scheduler/migration_hook", "failed", "2023-04-01 10:38:53", "2023-04-01 15:08:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680345533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680345533;}", "1", "1", "2023-04-01 10:38:57", "2023-04-01 15:08:57", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("66", "action_scheduler/migration_hook", "failed", "2023-09-16 18:48:31", "2023-09-16 22:18:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694890111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694890111;}", "1", "1", "2023-09-16 18:49:23", "2023-09-16 22:19:23", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("74", "action_scheduler/migration_hook", "failed", "2023-09-22 16:48:01", "2023-09-22 20:18:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1695401281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1695401281;}", "1", "1", "2023-09-22 16:49:16", "2023-09-22 20:19:16", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("78", "action_scheduler/migration_hook", "failed", "2023-09-22 17:19:28", "2023-09-22 20:49:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1695403168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1695403168;}", "1", "1", "2023-09-22 17:20:30", "2023-09-22 20:50:30", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("89", "action_scheduler/migration_hook", "failed", "2023-10-09 07:41:50", "2023-10-09 11:11:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1696837310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1696837310;}", "1", "1", "2023-10-09 07:41:58", "2023-10-09 11:11:58", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("97", "action_scheduler/migration_hook", "failed", "2023-10-10 15:02:40", "2023-10-10 18:32:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1696950160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1696950160;}", "1", "1", "2023-10-10 15:02:52", "2023-10-10 18:32:52", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("99", "action_scheduler/migration_hook", "failed", "2023-10-10 15:05:29", "2023-10-10 18:35:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1696950329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1696950329;}", "1", "1", "2023-10-10 15:06:30", "2023-10-10 18:36:30", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("104", "action_scheduler/migration_hook", "failed", "2023-10-11 16:03:32", "2023-10-11 19:33:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1697040212;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1697040212;}", "1", "1", "2023-10-11 16:04:34", "2023-10-11 19:34:34", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("187", "action_scheduler/migration_hook", "failed", "2024-09-06 12:11:56", "2024-09-06 16:41:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725624716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725624716;}", "1", "1", "2024-09-06 12:12:55", "2024-09-06 16:42:55", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("203", "woocommerce_cleanup_draft_orders", "pending", "2025-05-23 12:37:20", "2025-05-23 16:07:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748003840;s:18:\"\0*\0first_timestamp\";i:1680345407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748003840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("166", "action_scheduler/migration_hook", "failed", "2024-08-08 05:27:00", "2024-08-08 09:57:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723094820;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723094820;}", "1", "1", "2024-08-08 05:27:32", "2024-08-08 09:57:32", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("202", "woocommerce_cleanup_draft_orders", "complete", "2025-05-01 11:50:46", "2025-05-01 15:20:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746100246;s:18:\"\0*\0first_timestamp\";i:1680345407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746100246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-05-22 12:37:20", "2025-05-22 16:07:20", "0", NULL, "10");
INSERT INTO `dgfdcv_actionscheduler_actions` VALUES("201", "woocommerce_cleanup_draft_orders", "complete", "2025-04-17 15:26:53", "2025-04-17 18:56:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744903613;s:18:\"\0*\0first_timestamp\";i:1680345407;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744903613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-04-30 11:50:46", "2025-04-30 15:20:46", "0", NULL, "10");

/* INSERT TABLE DATA: dgfdcv_actionscheduler_groups */
INSERT INTO `dgfdcv_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `dgfdcv_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `dgfdcv_actionscheduler_groups` VALUES("3", "woocommerce-remote-inbox-engine");
INSERT INTO `dgfdcv_actionscheduler_groups` VALUES("4", "");
INSERT INTO `dgfdcv_actionscheduler_groups` VALUES("5", "woocommerce-db-updates");

/* INSERT TABLE DATA: dgfdcv_actionscheduler_logs */
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("104", "46", "action failed via WP Cron: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-01 10:36:47", "2023-04-01 15:06:47");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("103", "46", "عملیات توسط WP Cron شروع شد", "2023-04-01 10:36:47", "2023-04-01 15:06:47");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("100", "46", "ایجاد فعالیت", "2023-04-01 10:36:40", "2023-04-01 15:06:40");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("110", "50", "ایجاد فعالیت", "2023-04-01 10:37:53", "2023-04-01 15:07:53");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("111", "50", "عملیات توسط Async Request شروع شد", "2023-04-01 10:38:57", "2023-04-01 15:08:57");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("112", "50", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-04-01 10:38:57", "2023-04-01 15:08:57");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("158", "66", "ایجاد فعالیت", "2023-09-16 18:47:31", "2023-09-16 22:17:31");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("159", "66", "عملیات توسط WP Cron شروع شد", "2023-09-16 18:49:23", "2023-09-16 22:19:23");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("160", "66", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-16 18:49:23", "2023-09-16 22:19:23");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("182", "74", "ایجاد فعالیت", "2023-09-22 16:47:01", "2023-09-22 20:17:01");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("183", "74", "عملیات توسط WP Cron شروع شد", "2023-09-22 16:49:16", "2023-09-22 20:19:16");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("184", "74", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-22 16:49:16", "2023-09-22 20:19:16");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("194", "78", "ایجاد فعالیت", "2023-09-22 17:18:28", "2023-09-22 20:48:28");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("195", "78", "عملیات توسط WP Cron شروع شد", "2023-09-22 17:20:30", "2023-09-22 20:50:30");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("196", "78", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-22 17:20:30", "2023-09-22 20:50:30");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("521", "187", "ایجاد فعالیت", "2024-09-06 12:10:56", "2024-09-06 16:40:56");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("522", "187", "عملیات توسط WP Cron شروع شد", "2024-09-06 12:12:55", "2024-09-06 16:42:55");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("523", "187", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-06 12:12:55", "2024-09-06 16:42:55");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("227", "89", "ایجاد فعالیت", "2023-10-09 07:40:50", "2023-10-09 11:10:50");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("228", "89", "عملیات توسط WP Cron شروع شد", "2023-10-09 07:41:58", "2023-10-09 11:11:58");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("229", "89", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-09 07:41:58", "2023-10-09 11:11:58");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("251", "97", "ایجاد فعالیت", "2023-10-10 15:01:40", "2023-10-10 18:31:40");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("252", "97", "عملیات توسط WP Cron شروع شد", "2023-10-10 15:02:52", "2023-10-10 18:32:52");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("253", "97", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-10 15:02:52", "2023-10-10 18:32:52");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("257", "99", "ایجاد فعالیت", "2023-10-10 15:04:29", "2023-10-10 18:34:29");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("258", "99", "عملیات توسط WP Cron شروع شد", "2023-10-10 15:06:30", "2023-10-10 18:36:30");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("259", "99", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-10 15:06:30", "2023-10-10 18:36:30");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("272", "104", "ایجاد فعالیت", "2023-10-11 16:02:32", "2023-10-11 19:32:32");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("273", "104", "عملیات توسط WP Cron شروع شد", "2023-10-11 16:04:34", "2023-10-11 19:34:34");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("274", "104", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-10-11 16:04:34", "2023-10-11 19:34:34");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("566", "201", "action started via WP Cron", "2025-04-30 11:50:46", "2025-04-30 15:20:46");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("567", "201", "action complete via WP Cron", "2025-04-30 11:50:46", "2025-04-30 15:20:46");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("568", "202", "action created", "2025-04-30 11:50:46", "2025-04-30 15:20:46");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("570", "202", "عملیات توسط Async Request کامل شد", "2025-05-22 12:37:20", "2025-05-22 16:07:20");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("569", "202", "عملیات توسط Async Request شروع شد", "2025-05-22 12:37:20", "2025-05-22 16:07:20");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("565", "201", "action created", "2025-04-16 15:26:53", "2025-04-16 18:56:53");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("460", "166", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-08 05:27:32", "2024-08-08 09:57:32");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("459", "166", "عملیات توسط WP Cron شروع شد", "2024-08-08 05:27:32", "2024-08-08 09:57:32");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("458", "166", "ایجاد فعالیت", "2024-08-08 05:26:00", "2024-08-08 09:56:00");
INSERT INTO `dgfdcv_actionscheduler_logs` VALUES("571", "203", "ایجاد فعالیت", "2025-05-22 12:37:20", "2025-05-22 16:07:20");

/* INSERT TABLE DATA: dgfdcv_comments */
INSERT INTO `dgfdcv_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2022-04-13 15:02:42", "2022-04-13 11:32:42", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `dgfdcv_comments` VALUES("2", "159", "مدیر سایت", "fatemeh.amighi1995@gmail.com", "", "::1", "2022-05-20 14:20:03", "2022-05-20 09:50:03", "این یک دیدگاه تست است", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.67 Safari/537.36", "comment", "0", "2");
INSERT INTO `dgfdcv_comments` VALUES("3", "159", "مدیر سایت", "fatemeh.amighi1995@gmail.com", "", "::1", "2022-05-20 15:03:22", "2022-05-20 10:33:22", "پاسخ برای دیدگاه", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.67 Safari/537.36", "comment", "2", "2");

/* INSERT TABLE DATA: dgfdcv_duplicator_packages */
INSERT INTO `dgfdcv_duplicator_packages` VALUES("25", "newspaper", "978f84dac597629a8130_20250522124056", "20", "2025-05-22 12:41:44", "news2", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-05-22 12:40:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:25;s:4:\"Name\";s:9:\"newspaper\";s:4:\"Hash\";s:35:\"978f84dac597629a8130_20250522124056\";s:8:\"NameHash\";s:45:\"newspaper_978f84dac597629a8130_20250522124056\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:55:\"newspaper_978f84dac597629a8130_20250522124056_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:5:\"news2\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:57:\"newspaper_978f84dac597629a8130_20250522124056_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"F:/laragon/www/news-demo\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2496;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:20185;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-05-22 12:40:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:9:\"newspaper\";s:4:\"Hash\";s:35:\"978f84dac597629a8130_20250522124056\";s:8:\"NameHash\";s:45:\"newspaper_978f84dac597629a8130_20250522124056\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:63:\"newspaper_978f84dac597629a8130_20250522124056_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"F:/laragon/www/news-demo/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:58:\"newspaper_978f84dac597629a8130_20250522124056_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:115:\"F:/laragon/www/news-demo/wp-content/backups-dup-lite/tmp/newspaper_978f84dac597629a8130_20250522124056_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"F:/laragon/www/news-demo/wp-admin\";i:1;s:36:\"F:/laragon/www/news-demo/wp-includes\";i:2;s:45:\"F:/laragon/www/news-demo/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"F:/laragon/www/news-demo\";i:1;s:24:\"F:/laragon/www/news-demo\";i:2;s:35:\"F:/laragon/www/news-demo/wp-content\";i:3;s:43:\"F:/laragon/www/news-demo/wp-content/uploads\";i:4;s:43:\"F:/laragon/www/news-demo/wp-content/plugins\";i:5;s:46:\"F:/laragon/www/news-demo/wp-content/mu-plugins\";i:6;s:42:\"F:/laragon/www/news-demo/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"F:/laragon/www/news-demo/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: dgfdcv_options */
INSERT INTO `dgfdcv_options` VALUES("1", "siteurl", "http://localhost/news-demo", "yes");
INSERT INTO `dgfdcv_options` VALUES("2", "home", "http://localhost/news-demo", "yes");
INSERT INTO `dgfdcv_options` VALUES("3", "blogname", "دمو 1 - دمو پیشفرض", "yes");
INSERT INTO `dgfdcv_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `dgfdcv_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("6", "admin_email", "bghjgjh@dffgdfg.com", "yes");
INSERT INTO `dgfdcv_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `dgfdcv_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `dgfdcv_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `dgfdcv_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `dgfdcv_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `dgfdcv_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `dgfdcv_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `dgfdcv_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `dgfdcv_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `dgfdcv_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `dgfdcv_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `dgfdcv_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `dgfdcv_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `dgfdcv_options` VALUES("29", "rewrite_rules", "a:672:{s:13:\"tdc-review/?$\";s:30:\"index.php?post_type=tdc-review\";s:43:\"tdc-review/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=tdc-review&feed=$matches[1]\";s:38:\"tdc-review/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=tdc-review&feed=$matches[1]\";s:30:\"tdc-review/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=tdc-review&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:49:\"tds_list/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?tds_list=$matches[1]&feed=$matches[2]\";s:44:\"tds_list/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?tds_list=$matches[1]&feed=$matches[2]\";s:25:\"tds_list/([^/]+)/embed/?$\";s:41:\"index.php?tds_list=$matches[1]&embed=true\";s:37:\"tds_list/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?tds_list=$matches[1]&paged=$matches[2]\";s:19:\"tds_list/([^/]+)/?$\";s:30:\"index.php?tds_list=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"tdc-review/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tdc-review/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tdc-review/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tdc-review/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tdc-review/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tdc-review/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tdc-review/([^/]+)/embed/?$\";s:43:\"index.php?tdc-review=$matches[1]&embed=true\";s:31:\"tdc-review/([^/]+)/trackback/?$\";s:37:\"index.php?tdc-review=$matches[1]&tb=1\";s:51:\"tdc-review/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?tdc-review=$matches[1]&feed=$matches[2]\";s:46:\"tdc-review/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?tdc-review=$matches[1]&feed=$matches[2]\";s:39:\"tdc-review/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tdc-review=$matches[1]&paged=$matches[2]\";s:46:\"tdc-review/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tdc-review=$matches[1]&cpage=$matches[2]\";s:47:\"tdc-review/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?tdc-review=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"tdc-review/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"tdc-review/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"tdc-review/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tdc-review=$matches[1]&page=$matches[2]\";s:27:\"tdc-review/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tdc-review/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tdc-review/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tdc-review/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tdc-review/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tdc-review/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:60:\"tdc-review-criteria/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?tdc-review-criteria=$matches[1]&feed=$matches[2]\";s:55:\"tdc-review-criteria/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?tdc-review-criteria=$matches[1]&feed=$matches[2]\";s:36:\"tdc-review-criteria/([^/]+)/embed/?$\";s:52:\"index.php?tdc-review-criteria=$matches[1]&embed=true\";s:48:\"tdc-review-criteria/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?tdc-review-criteria=$matches[1]&paged=$matches[2]\";s:30:\"tdc-review-criteria/([^/]+)/?$\";s:41:\"index.php?tdc-review-criteria=$matches[1]\";s:44:\"tdc-review-email/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"tdc-review-email/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"tdc-review-email/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdc-review-email/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdc-review-email/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"tdc-review-email/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"tdc-review-email/([^/]+)/embed/?$\";s:49:\"index.php?tdc-review-email=$matches[1]&embed=true\";s:37:\"tdc-review-email/([^/]+)/trackback/?$\";s:43:\"index.php?tdc-review-email=$matches[1]&tb=1\";s:45:\"tdc-review-email/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tdc-review-email=$matches[1]&paged=$matches[2]\";s:52:\"tdc-review-email/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?tdc-review-email=$matches[1]&cpage=$matches[2]\";s:53:\"tdc-review-email/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?tdc-review-email=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"tdc-review-email/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"tdc-review-email/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"tdc-review-email/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?tdc-review-email=$matches[1]&page=$matches[2]\";s:33:\"tdc-review-email/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"tdc-review-email/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"tdc-review-email/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tdc-review-email/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tdc-review-email/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"tdc-review-email/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"tdcpt_app_listing/([^/]+)/embed/?$\";s:50:\"index.php?tdcpt_app_listing=$matches[1]&embed=true\";s:38:\"tdcpt_app_listing/([^/]+)/trackback/?$\";s:44:\"index.php?tdcpt_app_listing=$matches[1]&tb=1\";s:46:\"tdcpt_app_listing/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tdcpt_app_listing=$matches[1]&paged=$matches[2]\";s:53:\"tdcpt_app_listing/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?tdcpt_app_listing=$matches[1]&cpage=$matches[2]\";s:54:\"tdcpt_app_listing/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?tdcpt_app_listing=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"tdcpt_app_listing/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:71:\"tdcpt_app_listing/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"tdcpt_app_listing/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?tdcpt_app_listing=$matches[1]&page=$matches[2]\";s:34:\"tdcpt_app_listing/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"tdcpt_app_listing/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"tdcpt_app_listing/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"tdcpt_app_listing/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"tdcpt_app_listing/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"tdcpt_app_listing/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"tdtax_app_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_app_category=$matches[1]&feed=$matches[2]\";s:54:\"tdtax_app_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_app_category=$matches[1]&feed=$matches[2]\";s:35:\"tdtax_app_category/([^/]+)/embed/?$\";s:51:\"index.php?tdtax_app_category=$matches[1]&embed=true\";s:47:\"tdtax_app_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?tdtax_app_category=$matches[1]&paged=$matches[2]\";s:29:\"tdtax_app_category/([^/]+)/?$\";s:40:\"index.php?tdtax_app_category=$matches[1]\";s:54:\"tdtax_app_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tdtax_app_tag=$matches[1]&feed=$matches[2]\";s:49:\"tdtax_app_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tdtax_app_tag=$matches[1]&feed=$matches[2]\";s:30:\"tdtax_app_tag/([^/]+)/embed/?$\";s:46:\"index.php?tdtax_app_tag=$matches[1]&embed=true\";s:42:\"tdtax_app_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdtax_app_tag=$matches[1]&paged=$matches[2]\";s:24:\"tdtax_app_tag/([^/]+)/?$\";s:35:\"index.php?tdtax_app_tag=$matches[1]\";s:59:\"tdtax_app_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_app_location=$matches[1]&feed=$matches[2]\";s:54:\"tdtax_app_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_app_location=$matches[1]&feed=$matches[2]\";s:35:\"tdtax_app_location/([^/]+)/embed/?$\";s:51:\"index.php?tdtax_app_location=$matches[1]&embed=true\";s:47:\"tdtax_app_location/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?tdtax_app_location=$matches[1]&paged=$matches[2]\";s:29:\"tdtax_app_location/([^/]+)/?$\";s:40:\"index.php?tdtax_app_location=$matches[1]\";s:41:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"tdcpt_tourism/([^/]+)/embed/?$\";s:46:\"index.php?tdcpt_tourism=$matches[1]&embed=true\";s:34:\"tdcpt_tourism/([^/]+)/trackback/?$\";s:40:\"index.php?tdcpt_tourism=$matches[1]&tb=1\";s:42:\"tdcpt_tourism/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_tourism=$matches[1]&paged=$matches[2]\";s:49:\"tdcpt_tourism/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_tourism=$matches[1]&cpage=$matches[2]\";s:50:\"tdcpt_tourism/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?tdcpt_tourism=$matches[1]&wc/file/transient=$matches[3]\";s:56:\"tdcpt_tourism/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"tdcpt_tourism/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"tdcpt_tourism/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?tdcpt_tourism=$matches[1]&page=$matches[2]\";s:30:\"tdcpt_tourism/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"tdcpt_tourism/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"tdcpt_tourism/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tdcpt_tourism/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tdcpt_tourism/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"tdcpt_tourism/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"tdtax_attractions/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tdtax_attractions=$matches[1]&feed=$matches[2]\";s:53:\"tdtax_attractions/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?tdtax_attractions=$matches[1]&feed=$matches[2]\";s:34:\"tdtax_attractions/([^/]+)/embed/?$\";s:50:\"index.php?tdtax_attractions=$matches[1]&embed=true\";s:46:\"tdtax_attractions/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tdtax_attractions=$matches[1]&paged=$matches[2]\";s:28:\"tdtax_attractions/([^/]+)/?$\";s:39:\"index.php?tdtax_attractions=$matches[1]\";s:39:\"tdcpt_courses/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"tdcpt_courses/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"tdcpt_courses/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdcpt_courses/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdcpt_courses/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"tdcpt_courses/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"tdcpt_courses/(.+?)/embed/?$\";s:46:\"index.php?tdcpt_courses=$matches[1]&embed=true\";s:32:\"tdcpt_courses/(.+?)/trackback/?$\";s:40:\"index.php?tdcpt_courses=$matches[1]&tb=1\";s:40:\"tdcpt_courses/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_courses=$matches[1]&paged=$matches[2]\";s:47:\"tdcpt_courses/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_courses=$matches[1]&cpage=$matches[2]\";s:48:\"tdcpt_courses/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?tdcpt_courses=$matches[1]&wc/file/transient=$matches[3]\";s:54:\"tdcpt_courses/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"tdcpt_courses/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"tdcpt_courses/(.+?)(?:/([0-9]+))?/?$\";s:52:\"index.php?tdcpt_courses=$matches[1]&page=$matches[2]\";s:54:\"tdtax_domains/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tdtax_domains=$matches[1]&feed=$matches[2]\";s:49:\"tdtax_domains/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?tdtax_domains=$matches[1]&feed=$matches[2]\";s:30:\"tdtax_domains/([^/]+)/embed/?$\";s:46:\"index.php?tdtax_domains=$matches[1]&embed=true\";s:42:\"tdtax_domains/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdtax_domains=$matches[1]&paged=$matches[2]\";s:24:\"tdtax_domains/([^/]+)/?$\";s:35:\"index.php?tdtax_domains=$matches[1]\";s:52:\"tdtax_price/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?tdtax_price=$matches[1]&feed=$matches[2]\";s:47:\"tdtax_price/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?tdtax_price=$matches[1]&feed=$matches[2]\";s:28:\"tdtax_price/([^/]+)/embed/?$\";s:44:\"index.php?tdtax_price=$matches[1]&embed=true\";s:40:\"tdtax_price/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tdtax_price=$matches[1]&paged=$matches[2]\";s:22:\"tdtax_price/([^/]+)/?$\";s:33:\"index.php?tdtax_price=$matches[1]\";s:39:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"tdcpt_tunes/([^/]+)/embed/?$\";s:44:\"index.php?tdcpt_tunes=$matches[1]&embed=true\";s:32:\"tdcpt_tunes/([^/]+)/trackback/?$\";s:38:\"index.php?tdcpt_tunes=$matches[1]&tb=1\";s:40:\"tdcpt_tunes/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tdcpt_tunes=$matches[1]&paged=$matches[2]\";s:47:\"tdcpt_tunes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?tdcpt_tunes=$matches[1]&cpage=$matches[2]\";s:48:\"tdcpt_tunes/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?tdcpt_tunes=$matches[1]&wc/file/transient=$matches[3]\";s:54:\"tdcpt_tunes/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"tdcpt_tunes/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"tdcpt_tunes/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?tdcpt_tunes=$matches[1]&page=$matches[2]\";s:28:\"tdcpt_tunes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"tdcpt_tunes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"tdcpt_tunes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"tdcpt_tunes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"tdcpt_tunes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"tdcpt_tunes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"tdtax_music/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?tdtax_music=$matches[1]&feed=$matches[2]\";s:45:\"tdtax_music/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?tdtax_music=$matches[1]&feed=$matches[2]\";s:26:\"tdtax_music/(.+?)/embed/?$\";s:44:\"index.php?tdtax_music=$matches[1]&embed=true\";s:38:\"tdtax_music/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tdtax_music=$matches[1]&paged=$matches[2]\";s:20:\"tdtax_music/(.+?)/?$\";s:33:\"index.php?tdtax_music=$matches[1]\";s:56:\"tdtax_subgenres/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_subgenres=$matches[1]&feed=$matches[2]\";s:51:\"tdtax_subgenres/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_subgenres=$matches[1]&feed=$matches[2]\";s:32:\"tdtax_subgenres/([^/]+)/embed/?$\";s:48:\"index.php?tdtax_subgenres=$matches[1]&embed=true\";s:44:\"tdtax_subgenres/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tdtax_subgenres=$matches[1]&paged=$matches[2]\";s:26:\"tdtax_subgenres/([^/]+)/?$\";s:37:\"index.php?tdtax_subgenres=$matches[1]\";s:41:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"tdcpt_doctors/([^/]+)/embed/?$\";s:46:\"index.php?tdcpt_doctors=$matches[1]&embed=true\";s:34:\"tdcpt_doctors/([^/]+)/trackback/?$\";s:40:\"index.php?tdcpt_doctors=$matches[1]&tb=1\";s:42:\"tdcpt_doctors/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_doctors=$matches[1]&paged=$matches[2]\";s:49:\"tdcpt_doctors/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?tdcpt_doctors=$matches[1]&cpage=$matches[2]\";s:50:\"tdcpt_doctors/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?tdcpt_doctors=$matches[1]&wc/file/transient=$matches[3]\";s:56:\"tdcpt_doctors/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"tdcpt_doctors/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"tdcpt_doctors/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?tdcpt_doctors=$matches[1]&page=$matches[2]\";s:30:\"tdcpt_doctors/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"tdcpt_doctors/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"tdcpt_doctors/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tdcpt_doctors/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"tdcpt_doctors/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"tdcpt_doctors/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"tdcpt_contacts/([^/]+)/embed/?$\";s:47:\"index.php?tdcpt_contacts=$matches[1]&embed=true\";s:35:\"tdcpt_contacts/([^/]+)/trackback/?$\";s:41:\"index.php?tdcpt_contacts=$matches[1]&tb=1\";s:43:\"tdcpt_contacts/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?tdcpt_contacts=$matches[1]&paged=$matches[2]\";s:50:\"tdcpt_contacts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?tdcpt_contacts=$matches[1]&cpage=$matches[2]\";s:51:\"tdcpt_contacts/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?tdcpt_contacts=$matches[1]&wc/file/transient=$matches[3]\";s:57:\"tdcpt_contacts/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"tdcpt_contacts/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"tdcpt_contacts/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?tdcpt_contacts=$matches[1]&page=$matches[2]\";s:31:\"tdcpt_contacts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"tdcpt_contacts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"tdcpt_contacts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tdcpt_contacts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tdcpt_contacts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"tdcpt_contacts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"tdtax_specialty/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_specialty=$matches[1]&feed=$matches[2]\";s:51:\"tdtax_specialty/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_specialty=$matches[1]&feed=$matches[2]\";s:32:\"tdtax_specialty/([^/]+)/embed/?$\";s:48:\"index.php?tdtax_specialty=$matches[1]&embed=true\";s:44:\"tdtax_specialty/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tdtax_specialty=$matches[1]&paged=$matches[2]\";s:26:\"tdtax_specialty/([^/]+)/?$\";s:37:\"index.php?tdtax_specialty=$matches[1]\";s:53:\"tdtax_gender/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tdtax_gender=$matches[1]&feed=$matches[2]\";s:48:\"tdtax_gender/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tdtax_gender=$matches[1]&feed=$matches[2]\";s:29:\"tdtax_gender/([^/]+)/embed/?$\";s:45:\"index.php?tdtax_gender=$matches[1]&embed=true\";s:41:\"tdtax_gender/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tdtax_gender=$matches[1]&paged=$matches[2]\";s:23:\"tdtax_gender/([^/]+)/?$\";s:34:\"index.php?tdtax_gender=$matches[1]\";s:55:\"tdtax_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?tdtax_location=$matches[1]&feed=$matches[2]\";s:50:\"tdtax_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?tdtax_location=$matches[1]&feed=$matches[2]\";s:31:\"tdtax_location/([^/]+)/embed/?$\";s:47:\"index.php?tdtax_location=$matches[1]&embed=true\";s:43:\"tdtax_location/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?tdtax_location=$matches[1]&paged=$matches[2]\";s:25:\"tdtax_location/([^/]+)/?$\";s:36:\"index.php?tdtax_location=$matches[1]\";s:45:\"tdcpt_directories/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"tdcpt_directories/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"tdcpt_directories/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"tdcpt_directories/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"tdcpt_directories/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"tdcpt_directories/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"tdcpt_directories/([^/]+)/embed/?$\";s:50:\"index.php?tdcpt_directories=$matches[1]&embed=true\";s:38:\"tdcpt_directories/([^/]+)/trackback/?$\";s:44:\"index.php?tdcpt_directories=$matches[1]&tb=1\";s:46:\"tdcpt_directories/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tdcpt_directories=$matches[1]&paged=$matches[2]\";s:53:\"tdcpt_directories/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?tdcpt_directories=$matches[1]&cpage=$matches[2]\";s:54:\"tdcpt_directories/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?tdcpt_directories=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"tdcpt_directories/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:71:\"tdcpt_directories/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"tdcpt_directories/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?tdcpt_directories=$matches[1]&page=$matches[2]\";s:34:\"tdcpt_directories/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"tdcpt_directories/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"tdcpt_directories/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"tdcpt_directories/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"tdcpt_directories/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"tdcpt_directories/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"tdtax_services/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?tdtax_services=$matches[1]&feed=$matches[2]\";s:50:\"tdtax_services/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?tdtax_services=$matches[1]&feed=$matches[2]\";s:31:\"tdtax_services/([^/]+)/embed/?$\";s:47:\"index.php?tdtax_services=$matches[1]&embed=true\";s:43:\"tdtax_services/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?tdtax_services=$matches[1]&paged=$matches[2]\";s:25:\"tdtax_services/([^/]+)/?$\";s:36:\"index.php?tdtax_services=$matches[1]\";s:56:\"tdtax_locations/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_locations=$matches[1]&feed=$matches[2]\";s:51:\"tdtax_locations/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tdtax_locations=$matches[1]&feed=$matches[2]\";s:32:\"tdtax_locations/([^/]+)/embed/?$\";s:48:\"index.php?tdtax_locations=$matches[1]&embed=true\";s:44:\"tdtax_locations/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tdtax_locations=$matches[1]&paged=$matches[2]\";s:26:\"tdtax_locations/([^/]+)/?$\";s:37:\"index.php?tdtax_locations=$matches[1]\";s:38:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tdcpt_jobs/([^/]+)/embed/?$\";s:43:\"index.php?tdcpt_jobs=$matches[1]&embed=true\";s:31:\"tdcpt_jobs/([^/]+)/trackback/?$\";s:37:\"index.php?tdcpt_jobs=$matches[1]&tb=1\";s:39:\"tdcpt_jobs/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tdcpt_jobs=$matches[1]&paged=$matches[2]\";s:46:\"tdcpt_jobs/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tdcpt_jobs=$matches[1]&cpage=$matches[2]\";s:47:\"tdcpt_jobs/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?tdcpt_jobs=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"tdcpt_jobs/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"tdcpt_jobs/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"tdcpt_jobs/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tdcpt_jobs=$matches[1]&page=$matches[2]\";s:27:\"tdcpt_jobs/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tdcpt_jobs/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tdcpt_jobs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tdcpt_jobs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tdcpt_jobs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tdcpt_jobs/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"tdcpt_job_apps/([^/]+)/embed/?$\";s:47:\"index.php?tdcpt_job_apps=$matches[1]&embed=true\";s:35:\"tdcpt_job_apps/([^/]+)/trackback/?$\";s:41:\"index.php?tdcpt_job_apps=$matches[1]&tb=1\";s:43:\"tdcpt_job_apps/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?tdcpt_job_apps=$matches[1]&paged=$matches[2]\";s:50:\"tdcpt_job_apps/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?tdcpt_job_apps=$matches[1]&cpage=$matches[2]\";s:51:\"tdcpt_job_apps/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?tdcpt_job_apps=$matches[1]&wc/file/transient=$matches[3]\";s:57:\"tdcpt_job_apps/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"tdcpt_job_apps/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"tdcpt_job_apps/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?tdcpt_job_apps=$matches[1]&page=$matches[2]\";s:31:\"tdcpt_job_apps/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"tdcpt_job_apps/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"tdcpt_job_apps/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tdcpt_job_apps/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"tdcpt_job_apps/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"tdcpt_job_apps/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"tdcpt_companies/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"tdcpt_companies/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"tdcpt_companies/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"tdcpt_companies/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"tdcpt_companies/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"tdcpt_companies/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"tdcpt_companies/([^/]+)/embed/?$\";s:48:\"index.php?tdcpt_companies=$matches[1]&embed=true\";s:36:\"tdcpt_companies/([^/]+)/trackback/?$\";s:42:\"index.php?tdcpt_companies=$matches[1]&tb=1\";s:44:\"tdcpt_companies/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tdcpt_companies=$matches[1]&paged=$matches[2]\";s:51:\"tdcpt_companies/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tdcpt_companies=$matches[1]&cpage=$matches[2]\";s:52:\"tdcpt_companies/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?tdcpt_companies=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"tdcpt_companies/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"tdcpt_companies/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"tdcpt_companies/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tdcpt_companies=$matches[1]&page=$matches[2]\";s:32:\"tdcpt_companies/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"tdcpt_companies/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"tdcpt_companies/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"tdcpt_companies/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"tdcpt_companies/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"tdcpt_companies/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"tdtax_job_salaries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_job_salaries=$matches[1]&feed=$matches[2]\";s:54:\"tdtax_job_salaries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_job_salaries=$matches[1]&feed=$matches[2]\";s:35:\"tdtax_job_salaries/([^/]+)/embed/?$\";s:51:\"index.php?tdtax_job_salaries=$matches[1]&embed=true\";s:47:\"tdtax_job_salaries/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?tdtax_job_salaries=$matches[1]&paged=$matches[2]\";s:29:\"tdtax_job_salaries/([^/]+)/?$\";s:40:\"index.php?tdtax_job_salaries=$matches[1]\";s:61:\"tdtax_job_work_types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tdtax_job_work_types=$matches[1]&feed=$matches[2]\";s:56:\"tdtax_job_work_types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tdtax_job_work_types=$matches[1]&feed=$matches[2]\";s:37:\"tdtax_job_work_types/([^/]+)/embed/?$\";s:53:\"index.php?tdtax_job_work_types=$matches[1]&embed=true\";s:49:\"tdtax_job_work_types/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?tdtax_job_work_types=$matches[1]&paged=$matches[2]\";s:31:\"tdtax_job_work_types/([^/]+)/?$\";s:42:\"index.php?tdtax_job_work_types=$matches[1]\";s:57:\"tdtax_job_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tdtax_job_skills=$matches[1]&feed=$matches[2]\";s:52:\"tdtax_job_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tdtax_job_skills=$matches[1]&feed=$matches[2]\";s:33:\"tdtax_job_skills/([^/]+)/embed/?$\";s:49:\"index.php?tdtax_job_skills=$matches[1]&embed=true\";s:45:\"tdtax_job_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tdtax_job_skills=$matches[1]&paged=$matches[2]\";s:27:\"tdtax_job_skills/([^/]+)/?$\";s:38:\"index.php?tdtax_job_skills=$matches[1]\";s:59:\"tdtax_job_benefits/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_job_benefits=$matches[1]&feed=$matches[2]\";s:54:\"tdtax_job_benefits/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?tdtax_job_benefits=$matches[1]&feed=$matches[2]\";s:35:\"tdtax_job_benefits/([^/]+)/embed/?$\";s:51:\"index.php?tdtax_job_benefits=$matches[1]&embed=true\";s:47:\"tdtax_job_benefits/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?tdtax_job_benefits=$matches[1]&paged=$matches[2]\";s:29:\"tdtax_job_benefits/([^/]+)/?$\";s:40:\"index.php?tdtax_job_benefits=$matches[1]\";s:61:\"tdtax_job_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tdtax_job_categories=$matches[1]&feed=$matches[2]\";s:56:\"tdtax_job_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?tdtax_job_categories=$matches[1]&feed=$matches[2]\";s:37:\"tdtax_job_categories/([^/]+)/embed/?$\";s:53:\"index.php?tdtax_job_categories=$matches[1]&embed=true\";s:49:\"tdtax_job_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?tdtax_job_categories=$matches[1]&paged=$matches[2]\";s:31:\"tdtax_job_categories/([^/]+)/?$\";s:42:\"index.php?tdtax_job_categories=$matches[1]\";s:62:\"tdtax_company_markets/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?tdtax_company_markets=$matches[1]&feed=$matches[2]\";s:57:\"tdtax_company_markets/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?tdtax_company_markets=$matches[1]&feed=$matches[2]\";s:38:\"tdtax_company_markets/([^/]+)/embed/?$\";s:54:\"index.php?tdtax_company_markets=$matches[1]&embed=true\";s:50:\"tdtax_company_markets/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?tdtax_company_markets=$matches[1]&paged=$matches[2]\";s:32:\"tdtax_company_markets/([^/]+)/?$\";s:43:\"index.php?tdtax_company_markets=$matches[1]\";s:64:\"tdtax_company_countries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?tdtax_company_countries=$matches[1]&feed=$matches[2]\";s:59:\"tdtax_company_countries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?tdtax_company_countries=$matches[1]&feed=$matches[2]\";s:40:\"tdtax_company_countries/([^/]+)/embed/?$\";s:56:\"index.php?tdtax_company_countries=$matches[1]&embed=true\";s:52:\"tdtax_company_countries/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?tdtax_company_countries=$matches[1]&paged=$matches[2]\";s:34:\"tdtax_company_countries/([^/]+)/?$\";s:45:\"index.php?tdtax_company_countries=$matches[1]\";s:67:\"tdtax_company_technologies/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?tdtax_company_technologies=$matches[1]&feed=$matches[2]\";s:62:\"tdtax_company_technologies/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?tdtax_company_technologies=$matches[1]&feed=$matches[2]\";s:43:\"tdtax_company_technologies/([^/]+)/embed/?$\";s:59:\"index.php?tdtax_company_technologies=$matches[1]&embed=true\";s:55:\"tdtax_company_technologies/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?tdtax_company_technologies=$matches[1]&paged=$matches[2]\";s:37:\"tdtax_company_technologies/([^/]+)/?$\";s:48:\"index.php?tdtax_company_technologies=$matches[1]\";s:63:\"tdtax_company_benefits/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?tdtax_company_benefits=$matches[1]&feed=$matches[2]\";s:58:\"tdtax_company_benefits/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?tdtax_company_benefits=$matches[1]&feed=$matches[2]\";s:39:\"tdtax_company_benefits/([^/]+)/embed/?$\";s:55:\"index.php?tdtax_company_benefits=$matches[1]&embed=true\";s:51:\"tdtax_company_benefits/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?tdtax_company_benefits=$matches[1]&paged=$matches[2]\";s:33:\"tdtax_company_benefits/([^/]+)/?$\";s:44:\"index.php?tdtax_company_benefits=$matches[1]\";s:44:\"tdcpt_case_studies/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"tdcpt_case_studies/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"tdcpt_case_studies/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdcpt_case_studies/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdcpt_case_studies/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"tdcpt_case_studies/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"tdcpt_case_studies/(.+?)/embed/?$\";s:51:\"index.php?tdcpt_case_studies=$matches[1]&embed=true\";s:37:\"tdcpt_case_studies/(.+?)/trackback/?$\";s:45:\"index.php?tdcpt_case_studies=$matches[1]&tb=1\";s:45:\"tdcpt_case_studies/(.+?)/page/?([0-9]{1,})/?$\";s:58:\"index.php?tdcpt_case_studies=$matches[1]&paged=$matches[2]\";s:52:\"tdcpt_case_studies/(.+?)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?tdcpt_case_studies=$matches[1]&cpage=$matches[2]\";s:53:\"tdcpt_case_studies/(.+?)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?tdcpt_case_studies=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"tdcpt_case_studies/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"tdcpt_case_studies/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"tdcpt_case_studies/(.+?)(?:/([0-9]+))?/?$\";s:57:\"index.php?tdcpt_case_studies=$matches[1]&page=$matches[2]\";s:44:\"tdcpt_properties/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"tdcpt_properties/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"tdcpt_properties/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdcpt_properties/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"tdcpt_properties/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"tdcpt_properties/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"tdcpt_properties/([^/]+)/embed/?$\";s:49:\"index.php?tdcpt_properties=$matches[1]&embed=true\";s:37:\"tdcpt_properties/([^/]+)/trackback/?$\";s:43:\"index.php?tdcpt_properties=$matches[1]&tb=1\";s:45:\"tdcpt_properties/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tdcpt_properties=$matches[1]&paged=$matches[2]\";s:52:\"tdcpt_properties/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?tdcpt_properties=$matches[1]&cpage=$matches[2]\";s:53:\"tdcpt_properties/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?tdcpt_properties=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"tdcpt_properties/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"tdcpt_properties/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"tdcpt_properties/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?tdcpt_properties=$matches[1]&page=$matches[2]\";s:33:\"tdcpt_properties/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"tdcpt_properties/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"tdcpt_properties/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tdcpt_properties/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tdcpt_properties/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"tdcpt_properties/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:60:\"tdtax_property_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?tdtax_property_type=$matches[1]&feed=$matches[2]\";s:55:\"tdtax_property_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?tdtax_property_type=$matches[1]&feed=$matches[2]\";s:36:\"tdtax_property_type/([^/]+)/embed/?$\";s:52:\"index.php?tdtax_property_type=$matches[1]&embed=true\";s:48:\"tdtax_property_type/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?tdtax_property_type=$matches[1]&paged=$matches[2]\";s:30:\"tdtax_property_type/([^/]+)/?$\";s:41:\"index.php?tdtax_property_type=$matches[1]\";s:67:\"tdtax_property_transaction/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?tdtax_property_transaction=$matches[1]&feed=$matches[2]\";s:62:\"tdtax_property_transaction/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?tdtax_property_transaction=$matches[1]&feed=$matches[2]\";s:43:\"tdtax_property_transaction/([^/]+)/embed/?$\";s:59:\"index.php?tdtax_property_transaction=$matches[1]&embed=true\";s:55:\"tdtax_property_transaction/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?tdtax_property_transaction=$matches[1]&paged=$matches[2]\";s:37:\"tdtax_property_transaction/([^/]+)/?$\";s:48:\"index.php?tdtax_property_transaction=$matches[1]\";s:64:\"tdtax_property_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?tdtax_property_location=$matches[1]&feed=$matches[2]\";s:59:\"tdtax_property_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?tdtax_property_location=$matches[1]&feed=$matches[2]\";s:40:\"tdtax_property_location/([^/]+)/embed/?$\";s:56:\"index.php?tdtax_property_location=$matches[1]&embed=true\";s:52:\"tdtax_property_location/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?tdtax_property_location=$matches[1]&paged=$matches[2]\";s:34:\"tdtax_property_location/([^/]+)/?$\";s:45:\"index.php?tdtax_property_location=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:49:\"vc_grid_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?vc_grid_item=$matches[1]&wc/file/transient=$matches[3]\";s:55:\"vc_grid_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"tdb_templates/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"tdb_templates/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"tdb_templates/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdb_templates/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"tdb_templates/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"tdb_templates/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"tdb_templates/(.+?)/embed/?$\";s:46:\"index.php?tdb_templates=$matches[1]&embed=true\";s:32:\"tdb_templates/(.+?)/trackback/?$\";s:40:\"index.php?tdb_templates=$matches[1]&tb=1\";s:40:\"tdb_templates/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?tdb_templates=$matches[1]&paged=$matches[2]\";s:47:\"tdb_templates/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?tdb_templates=$matches[1]&cpage=$matches[2]\";s:48:\"tdb_templates/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?tdb_templates=$matches[1]&wc/file/transient=$matches[3]\";s:54:\"tdb_templates/.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"tdb_templates/.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"tdb_templates/(.+?)(?:/([0-9]+))?/?$\";s:52:\"index.php?tdb_templates=$matches[1]&page=$matches[2]\";s:35:\"td_book/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"td_book/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"td_book/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"td_book/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"td_book/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"td_book/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"td_book/([^/]+)/embed/?$\";s:40:\"index.php?td_book=$matches[1]&embed=true\";s:28:\"td_book/([^/]+)/trackback/?$\";s:34:\"index.php?td_book=$matches[1]&tb=1\";s:36:\"td_book/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?td_book=$matches[1]&paged=$matches[2]\";s:43:\"td_book/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?td_book=$matches[1]&cpage=$matches[2]\";s:44:\"td_book/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?td_book=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"td_book/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"td_book/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"td_book/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?td_book=$matches[1]&page=$matches[2]\";s:24:\"td_book/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"td_book/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"td_book/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"td_book/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"td_book/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"td_book/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"genre/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?td_genre=$matches[1]&feed=$matches[2]\";s:41:\"genre/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?td_genre=$matches[1]&feed=$matches[2]\";s:22:\"genre/([^/]+)/embed/?$\";s:41:\"index.php?td_genre=$matches[1]&embed=true\";s:34:\"genre/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?td_genre=$matches[1]&paged=$matches[2]\";s:16:\"genre/([^/]+)/?$\";s:30:\"index.php?td_genre=$matches[1]\";s:47:\"writer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?td_writer=$matches[1]&feed=$matches[2]\";s:42:\"writer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?td_writer=$matches[1]&feed=$matches[2]\";s:23:\"writer/([^/]+)/embed/?$\";s:42:\"index.php?td_writer=$matches[1]&embed=true\";s:35:\"writer/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?td_writer=$matches[1]&paged=$matches[2]\";s:17:\"writer/([^/]+)/?$\";s:31:\"index.php?td_writer=$matches[1]\";s:37:\"tds_email/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"tds_email/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"tds_email/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tds_email/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"tds_email/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"tds_email/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"tds_email/([^/]+)/embed/?$\";s:42:\"index.php?tds_email=$matches[1]&embed=true\";s:30:\"tds_email/([^/]+)/trackback/?$\";s:36:\"index.php?tds_email=$matches[1]&tb=1\";s:38:\"tds_email/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?tds_email=$matches[1]&paged=$matches[2]\";s:45:\"tds_email/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?tds_email=$matches[1]&cpage=$matches[2]\";s:46:\"tds_email/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?tds_email=$matches[1]&wc/file/transient=$matches[3]\";s:52:\"tds_email/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"tds_email/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"tds_email/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?tds_email=$matches[1]&page=$matches[2]\";s:26:\"tds_email/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"tds_email/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"tds_email/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"tds_email/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"tds_email/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"tds_email/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"tds_locker/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tds_locker/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tds_locker/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tds_locker/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tds_locker/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tds_locker/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tds_locker/([^/]+)/embed/?$\";s:43:\"index.php?tds_locker=$matches[1]&embed=true\";s:31:\"tds_locker/([^/]+)/trackback/?$\";s:37:\"index.php?tds_locker=$matches[1]&tb=1\";s:39:\"tds_locker/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tds_locker=$matches[1]&paged=$matches[2]\";s:46:\"tds_locker/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tds_locker=$matches[1]&cpage=$matches[2]\";s:47:\"tds_locker/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?tds_locker=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"tds_locker/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"tds_locker/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"tds_locker/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tds_locker=$matches[1]&page=$matches[2]\";s:27:\"tds_locker/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tds_locker/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tds_locker/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tds_locker/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tds_locker/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tds_locker/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=166&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("24837", "revslider-global-settings", "{\"getTec\":{\"engine\":\"SR7\"}}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24843", "_transient_timeout_td_update_theme_Newspaper", "1748176378", "off");
INSERT INTO `dgfdcv_options` VALUES("24844", "_transient_td_update_theme_Newspaper", "1", "off");
INSERT INTO `dgfdcv_options` VALUES("24853", "revslider_update_revision_current", "6.7.24", "auto");
INSERT INTO `dgfdcv_options` VALUES("24854", "_site_transient_timeout_theme_roots", "1747919005", "off");
INSERT INTO `dgfdcv_options` VALUES("24855", "_site_transient_theme_roots", "a:2:{s:15:\"Newspaper-child\";s:7:\"/themes\";s:9:\"Newspaper\";s:7:\"/themes\";}", "off");
INSERT INTO `dgfdcv_options` VALUES("24856", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1747928067", "off");
INSERT INTO `dgfdcv_options` VALUES("24857", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:7051;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4889;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2799;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2711;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2114;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2037;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1950;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1899;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1608;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1608;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1602;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1555;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1513;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1507;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1467;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1335;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1317;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1236;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1225;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1175;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1160;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1042;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1039;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1034;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1006;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:999;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:998;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:968;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:931;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:925;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:921;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:908;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:907;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:901;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:900;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:848;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:828;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:801;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:782;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:769;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:764;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:758;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:748;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:737;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:710;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:705;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:678;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:669;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:656;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:637;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:634;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:633;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:627;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:624;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:622;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:622;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:618;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:616;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:614;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:608;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:603;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:595;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:587;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:585;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:584;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:578;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:573;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:566;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:556;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:551;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:547;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:533;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:531;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:526;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:523;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:510;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:507;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:500;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:496;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:485;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:478;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:468;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:461;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:460;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:460;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:460;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:457;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:455;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:454;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:449;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:433;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:430;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:420;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:419;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:411;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:409;}}", "off");
INSERT INTO `dgfdcv_options` VALUES("24892", "_transient_timeout__woocommerce_upload_directory_status", "1748003836", "off");
INSERT INTO `dgfdcv_options` VALUES("24893", "_transient__woocommerce_upload_directory_status", "protected", "off");
INSERT INTO `dgfdcv_options` VALUES("24895", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24896", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24897", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24898", "_site_transient_timeout_woocommerce_blocks_patterns", "1750509438", "off");
INSERT INTO `dgfdcv_options` VALUES("24899", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:5:\"9.8.5\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:75:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:91:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:80:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:81:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:87:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:88:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:97:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:85:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:81:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:83:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:116:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:89:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:87:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:108:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:91:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:94:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:86:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:93:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:99:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:104:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:98:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:103:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:104:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:97:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:97:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:97:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:115:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:88:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:85:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:101:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:91:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:88:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:106:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\woocommerce/patterns/three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `dgfdcv_options` VALUES("24901", "woocommerce_gateway_order", "a:4:{s:33:\"_wc_offline_payment_methods_group\";i:0;s:4:\"bacs\";i:1;s:6:\"cheque\";i:2;s:3:\"cod\";i:3;}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24902", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1747939040", "off");
INSERT INTO `dgfdcv_options` VALUES("24903", "_transient_action_scheduler_last_pastdue_actions_check", "1747917440", "off");
INSERT INTO `dgfdcv_options` VALUES("24904", "_transient_timeout_wc_tracks_blog_details", "1748003840", "off");
INSERT INTO `dgfdcv_options` VALUES("24905", "_transient_wc_tracks_blog_details", "a:6:{s:3:\"url\";s:26:\"http://localhost/news-demo\";s:9:\"blog_lang\";s:5:\"fa_IR\";s:7:\"blog_id\";b:0;s:8:\"store_id\";s:36:\"40b456e3-2cdf-4f74-88ba-081408f8a957\";s:14:\"products_count\";i:0;s:10:\"wc_version\";s:5:\"9.8.5\";}", "off");
INSERT INTO `dgfdcv_options` VALUES("24906", "_transient_timeout_orders-all-statuses", "1748522241", "off");
INSERT INTO `dgfdcv_options` VALUES("24907", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1739619692\";s:5:\"value\";a:0:{}}", "off");
INSERT INTO `dgfdcv_options` VALUES("24593", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:3;s:3:\"all\";i:3;s:8:\"approved\";s:1:\"3\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "on");
INSERT INTO `dgfdcv_options` VALUES("24580", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"daeae5f90038a17ae9d19ea392af9b32\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `dgfdcv_options` VALUES("24830", "_transient_timeout_feed_mod_813f86eb29c12d6094f1acd1445797e5", "1747960187", "off");
INSERT INTO `dgfdcv_options` VALUES("24831", "_transient_feed_mod_813f86eb29c12d6094f1acd1445797e5", "1747916987", "off");
INSERT INTO `dgfdcv_options` VALUES("24832", "_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "1747960187", "off");
INSERT INTO `dgfdcv_options` VALUES("24833", "_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/2025/02/12/%D8%AE%D8%B7%D8%B1%D8%A7%D8%AA-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D9%85%D8%AD%D8%B5%D9%88%D9%84%D8%A7%D8%AA-%D9%86%D8%A7%D9%84-%D9%88-%DA%A9%D8%B1%DA%A9-%D8%B4%D8%AF%D9%87/\'>خطرات استفاده از محصولات نال و کرک شده</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/2024/11/17/%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D9%81%D8%A7%D8%B1%D8%B3%DB%8C-%D9%86%DA%AF%D8%A7%D8%B1%D8%B4-%DB%B7-%DB%B6/\'>وردپرس فارسی نگارش ۶.۷</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/\'>آموزش مشارکت در ترجمه وردپرس</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2024/04/21/%D9%BE%DB%8C%D9%88%D8%B3%D8%AA%D9%86-%D8%A8%D9%87-%DA%AF%D8%B1%D9%88%D9%87-%D9%85%D8%AA%D8%B1%D8%AC%D9%85%DB%8C%D9%86-%D9%88-%D8%AA%D9%88%D8%B3%D8%B9%D9%87-%D8%AF%D9%87%D9%86%D8%AF%DA%AF%D8%A7%D9%86/\'>پیوستن به گروه مترجمین و توسعه دهندگان وردپرس فارسی</a></li><li><a class=\'rsswidget\' href=\'https://fa.wordpress.org/team/2024/02/17/%D9%85%D8%B9%D8%B1%D9%81%DB%8C-%D8%AA%DB%8C%D9%85-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D9%81%D8%A7%D8%B1%D8%B3%DB%8C/\'>معرفی تیم وردپرس فارسی</a></li></ul></div>", "off");
INSERT INTO `dgfdcv_options` VALUES("24834", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("24865", "auto_update_themes", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("24867", "rtl_rsm_delayTime", "a:4:{s:10:\"selfUpdate\";i:1748003732;s:18:\"deleteDownloadFile\";i:0;s:8:\"wpLoaded\";i:1747917665;s:22:\"checkUpdateProductList\";i:1747919133;}", "off");
INSERT INTO `dgfdcv_options` VALUES("24868", "rtl_rsm_localProducts", "TY1LD4IwEIT_itmzlrZgQRLjzZMaY4wnLljX0MgrUNID4b_bx0Evs9_MbnZm2MYlZ693ycQzoygY5DMcVY0PHEbVtZADI5TsYA1n1d7k9J-nhNr8rnSN1hcTFQl3ylPPieds5QcG4zRmTqVcXdCM17LHwXkq_WEiwtJzOPc_U_zlgWNmy0-q_djuSut-zIuoiIwxZND1RlfYIJFdU0SHfs8FzTgsyxc", "on");
INSERT INTO `dgfdcv_options` VALUES("24869", "rtl_rsm_lastSync", "1747917333", "off");
INSERT INTO `dgfdcv_options` VALUES("24916", "_transient_timeout__woocommerce_helper_subscriptions", "1747918428", "off");
INSERT INTO `dgfdcv_options` VALUES("24917", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("24880", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `dgfdcv_options` VALUES("24881", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `dgfdcv_options` VALUES("24882", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `dgfdcv_options` VALUES("24883", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `dgfdcv_options` VALUES("24884", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `dgfdcv_options` VALUES("24885", "woocommerce_email_improvements_disabled_count", "1", "auto");
INSERT INTO `dgfdcv_options` VALUES("24886", "woocommerce_email_improvements_first_disabled_at", "2025-05-22 12:37:16", "auto");
INSERT INTO `dgfdcv_options` VALUES("24887", "woocommerce_email_improvements_last_disabled_at", "2025-05-22 12:37:16", "auto");
INSERT INTO `dgfdcv_options` VALUES("24888", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "on");
INSERT INTO `dgfdcv_options` VALUES("24889", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `dgfdcv_options` VALUES("24890", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `dgfdcv_options` VALUES("18109", "woocommerce_product_match_featured_image_by_sku", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("17571", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1746013835;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("24924", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1695228934;s:10:\"updateTime\";i:1747917544;}", "off");
INSERT INTO `dgfdcv_options` VALUES("18110", "woocommerce_feature_order_attribution_enabled", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("713", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `dgfdcv_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `dgfdcv_options` VALUES("33", "active_plugins", "a:25:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:11:\"amp/amp.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"js_composer/js_composer.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:37:\"td-cloud-library/td-cloud-library.php\";i:6;s:27:\"td-composer/td-composer.php\";i:7;s:43:\"td-custom-post-type/td-custom-post-type.php\";i:8;s:45:\"td-demo-app-find-pro/td-app-find-pro-demo.php\";i:9;s:45:\"td-demo-cali-sight-pro/td-cali-sight-demo.php\";i:10;s:45:\"td-demo-coaching-pro/td-coaching-pro-demo.php\";i:11;s:43:\"td-demo-compass-pro/td-compass-pro-demo.php\";i:12;s:43:\"td-demo-doctors-pro/td-doctors-pro-demo.php\";i:13;s:59:\"td-demo-eastcoast-check-pro/td-eastcoast-check-pro-demo.php\";i:14;s:45:\"td-demo-job-hunt-pro/td-job-hunt-pro-demo.php\";i:15;s:45:\"td-demo-momentum-pro/td-momentum-pro-demo.php\";i:16;s:51:\"td-demo-real-estate-pro/td-real-estate-pro-demo.php\";i:17;s:41:\"td-demo-rent-a-car/td-demo-rent-a-car.php\";i:18;s:37:\"td-mobile-plugin/td-mobile-plugin.php\";i:19;s:31:\"td-newsletter/td-newsletter.php\";i:20;s:39:\"td-social-counter/td-social-counter.php\";i:21;s:37:\"td-standard-pack/td-standard-pack.php\";i:22;s:35:\"td-subscription/td-subscription.php\";i:23;s:17:\"td-woo/td-woo.php\";i:24;s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("24866", "rtl_rsm_autoUpdate", "a:2:{s:7:\"plugins\";a:0:{}s:6:\"themes\";a:0:{}}", "off");
INSERT INTO `dgfdcv_options` VALUES("15631", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("14159", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("720", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `dgfdcv_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `dgfdcv_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("39", "recently_edited", "a:5:{i:0;s:62:\"F:/laragon/www/news-demo/wp-content/themes/Newspaper/style.css\";i:1;s:97:\"F:/laragon/www/news-demo/wp-content/plugins/td-demo-compass-pro/td-compass-pro-demo-cm-styles.php\";i:2;s:87:\"F:/laragon/www/news-demo/wp-content/plugins/td-demo-compass-pro/td-compass-pro-demo.php\";i:3;s:55:\"F:/laragon/www/news-demo/wp-content/plugins/amp/amp.php\";i:4;s:60:\"F:/laragon/www/news-demo/wp-content/themes/Newspaper/rtl.css\";}", "no");
INSERT INTO `dgfdcv_options` VALUES("40", "template", "Newspaper", "yes");
INSERT INTO `dgfdcv_options` VALUES("41", "stylesheet", "Newspaper", "yes");
INSERT INTO `dgfdcv_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `dgfdcv_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `dgfdcv_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `dgfdcv_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `dgfdcv_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `dgfdcv_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `dgfdcv_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `dgfdcv_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `dgfdcv_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `dgfdcv_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `dgfdcv_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `dgfdcv_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `dgfdcv_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `dgfdcv_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `dgfdcv_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `dgfdcv_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `dgfdcv_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `dgfdcv_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `dgfdcv_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `dgfdcv_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `dgfdcv_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `dgfdcv_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("82", "page_on_front", "166", "yes");
INSERT INTO `dgfdcv_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `dgfdcv_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `dgfdcv_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("91", "admin_email_lifespan", "1755171455", "yes");
INSERT INTO `dgfdcv_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `dgfdcv_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `dgfdcv_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `dgfdcv_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `dgfdcv_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `dgfdcv_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `dgfdcv_options` VALUES("100", "dgfdcv_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `dgfdcv_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `dgfdcv_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("104", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:10:\"td-default\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("105", "cron", "a:31:{i:1747917735;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1747918043;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1747919046;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1747920717;a:2:{s:17:\"amp_validate_urls\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:31:\"amp_validated_url_stylesheet_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1747920732;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1747920899;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1747921036;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1747927977;a:1:{s:21:\"td_instagram_cron_job\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"3hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1747928236;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747939036;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747943335;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747947600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747956762;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747960609;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747960654;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747978020;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747978718;a:1:{s:19:\"td_clear_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747979243;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747989117;a:2:{s:33:\"amp_monitor_css_transient_caching\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:22:\"amp_validation_data_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747999962;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1747999986;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1748000025;a:1:{s:13:\"tds_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1748000094;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1748003846;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1748255400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1748451313;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1748495165;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1748517482;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1748518362;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1749213496;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `dgfdcv_options` VALUES("24819", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-11-01 09:05:28\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-07 10:58:34\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-02-20 08:42:35\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-20 09:09:15\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2025-05-15 15:31:31\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-29 09:58:15\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-26 01:22:31\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-24 21:44:57\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-13 15:13:30\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-18 00:54:23\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-18 00:53:35\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-24 21:46:51\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-09 06:59:42\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-11-08 19:43:34\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-06 12:48:35\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-22 09:01:08\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-22 08:43:39\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-03-25 15:37:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-24 08:06:50\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-12-09 22:28:42\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-06 18:22:17\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-21 21:07:12\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-24 23:50:28\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-29 19:32:31\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-30 16:22:26\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2025-02-26 16:06:47\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-15 07:29:26\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-12 09:41:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-29 15:18:18\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-06 13:34:01\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-30 04:41:14\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-26 05:46:56\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-01 00:45:13\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-07 19:33:01\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-16 00:22:55\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-30 18:01:46\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-07 12:33:24\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-01 18:55:24\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-28 12:54:20\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-19 19:00:11\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-18 18:37:51\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-22 08:31:12\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2025-03-20 16:41:38\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-29 06:00:20\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-21 06:18:02\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-28 07:17:17\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-13 18:37:02\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-27 20:02:13\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-08 10:26:43\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-02 11:51:48\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-05 11:53:58\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-02 11:55:29\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-26 07:20:36\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-12 10:49:08\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-16 03:16:13\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.2\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-25 20:25:55\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-03 07:52:09\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-16 23:11:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-12 20:43:45\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-29 12:00:43\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-04-30 22:14:00\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.1\";s:7:\"updated\";s:19:\"2025-05-04 17:30:55\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `dgfdcv_options` VALUES("24847", "vc_version", "8.4.1", "auto");
INSERT INTO `dgfdcv_options` VALUES("24561", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `dgfdcv_options` VALUES("24722", "_transient_timeout_woocommerce_blocks_asset_api_script_data", "1750509457", "off");
INSERT INTO `dgfdcv_options` VALUES("24723", "_transient_woocommerce_blocks_asset_api_script_data", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"4d43a4bcb41a5a6336c2\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"df3cbcae422855d48387\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"0d3321630119e50d175f\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"94f6fdb24497762c3877\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"13ca26913ccb282c047e\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"6d08dccfb4bf1a392a0d\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"4d3dbff32a4959449c1d\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"ce9125bf472706dea11a\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"a3e67bb0b09f566d5bdf\",\"dependencies\":[\"wc-settings\",\"wp-html-entities\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"a5f075e4ff6dd6090875\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"a16e7eb12f5267371fe0\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"2def9412eeabab2071b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"0ea5d4718f1bb3c42ede\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"c163716dbc1e3cc6748c\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"e4169377f115faded81a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"daf82f32ab7ca75c7285\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"http:\\/\\/localhost\\/news-demo\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"a06716cace69cf0ce81f\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"wc-9.8.5\",\"hash\":\"2eadbe16a17851fdb46b242131343013\"}", "off");
INSERT INTO `dgfdcv_options` VALUES("24821", "_site_transient_browser_0e0369e2813db7deb26e5937c353aab4", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"136.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `dgfdcv_options` VALUES("24822", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1747960186", "off");
INSERT INTO `dgfdcv_options` VALUES("24823", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `dgfdcv_options` VALUES("24824", "_transient_timeout_feed_9ba2df8849616f02166b8f7242d75067", "1747960186", "off");
INSERT INTO `dgfdcv_options` VALUES("24825", "_transient_feed_9ba2df8849616f02166b8f7242d75067", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 10:36:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60244\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"خطرات استفاده از محصولات نال و کرک شده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 09:39:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1120\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:515:\"استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&#160;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم. 1. احترام به [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13685:\"\n<p>استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&nbsp;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>1. احترام به قانون کپی‌رایت</strong></h4>\n\n\n\n<p>هر نرم‌افزاری که توسط توسعه‌دهندگان یا تیم‌های برنامه‌نویسی تولید می‌شود، نتیجه‌ زحمت، زمان و هزینه‌ زیادی است. اکثر این نرم‌افزارها نسخه‌های رایگان یا آزمایشی نیز ارائه می‌دهند تا کاربران بتوانند قبل از خرید، آن‌ها را امتحان کنند.<br>استفاده از نسخه‌های نال شده این محصولات، نه تنها نقض قانون کپی‌رایت، بلکه یک عمل غیر اخلاقی محسوب می‌شود. این کار نه تنها زحمات توسعه‌دهنده را بی‌ارزش می‌کند، بلکه توسعه و نوآوری در نرم‌افزارها را نیز کاهش می‌دهد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. خطرات امنیتی</strong></h4>\n\n\n\n<p>استفاده از محصولات نال می‌تواند امنیت شما و وب‌سایتتان را به شدت به خطر بیندازد.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>محصول نال چیست؟</strong><strong><br></strong>محصولات نال در واقع نسخه‌های غیرقانونی نرم‌افزارهایی هستند که سیستم لایسنس آن‌ها دور زده شده است. این نسخه‌ها اغلب توسط افرادی عرضه می‌شوند که اهداف نامعلومی دارند، از جمله تزریق کدهای مخرب.</li>\n\n\n\n<li><strong>عدم دریافت به‌روزرسانی‌ها</strong><strong><br></strong>یکی از بزرگ‌ترین مزایای محصولات اصلی، ارائه به‌روزرسانی‌های منظم برای رفع باگ‌ها و ارتقای امنیت است. کاربران محصولات نال، این آپدیت‌ها را دریافت نمی‌کنند و در نتیجه، سایت آن‌ها در برابر حملات سایبری آسیب‌پذیر می‌شود.</li>\n\n\n\n<li><strong>عدم پشتیبانی</strong><strong><br></strong>محصولات پرمیوم معمولاً با پشتیبانی کامل توسعه‌دهندگان همراه هستند. کاربران محصولات نال به این پشتیبانی دسترسی ندارند و در صورت بروز مشکل، باید خودشان آن را حل کنند.</li>\n\n\n\n<li><strong>کدهای مخرب</strong><strong><br></strong>محصولات نال اغلب شامل کدهای مخربی هستند که می‌توانند اطلاعات حساس شما مانند رمزهای عبور، اطلاعات بانکی و حتی اطلاعات مشتریان شما را به سرقت ببرند. این مسئله به ویژه برای سایت‌های فروشگاهی و کسب‌وکارهای آنلاین بسیار خطرناک است.</li>\n\n\n\n<li><strong>سو استفاده از منابع سرور</strong><strong><br></strong>استفاده از محصولات نال در برخی موارد منجر به سوء استفاده هکرها از منابع سرور، ارسال ایمیل‌های تبلیغاتی، دریافت دسترسی و تلاش برای نفوذ به سرور و هک کردن آن می‌شود که می‌تواند نتایج مخرب و مشکل زایی برای سرور و یا آدرس IP آن و حتی سایت‌های مشترک دیگر میزبانی‌شده بر روی آن داشته باشد.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>3. تاثیرات منفی بر سئو</strong></h4>\n\n\n\n<p>استفاده از محصولات نال ممکن است باعث ایجاد لینک‌های اسپم، پاپ‌آپ‌های تبلیغاتی و حتی تغییرات مخفی در کد سایت شود. این موارد ممکن است باعث کاهش رتبه سایت شما در موتورهای جستجو شده و اعتماد کاربران را نیز از بین ببرد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>4. انگیزه‌های ارائه‌دهندگان محصولات نال</strong></h4>\n\n\n\n<p>افرادی که محصولات نال را ارائه می‌دهند، معمولاً به دنبال منافع شخصی هستند. برخی از انگیزه‌های آن‌ها عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>تزریق تبلیغات و لینک‌های اسپم به سایت شما.</li>\n\n\n\n<li>سرقت اطلاعات شخصی مانند نام کاربری، رمز عبور، ایمیل و اطلاعات مالی.</li>\n\n\n\n<li>آلوده کردن فایل‌ها و سرورهای شما به بدافزارها.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چگونه بفهمیم یک محصول نال است؟</strong></h3>\n\n\n\n<p>تشخیص محصولات نال برای افرادی که با ویژگی‌های نسخه‌های اورجینال آشنا نیستند، ممکن است دشوار باشد. اما با چند نکته ساده می‌توان از خرید این محصولات جلوگیری کرد:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>فروشگاه عرضه‌کننده محصول:</strong><strong><br></strong>هر محصول تجاری، تنها در فروشگاه رسمی تولیدکننده آن به فروش می‌رسد. اگر یک فروشگاه دیگر، از جمله فروشگاه‌های ایرانی، محصولاتی مانند قالب وودمارت (WoodMart)، افزونه المنتور (Elementor) یا سایر افزونه‌ها و قالب‌های پرمیوم را با عنوان نگارش اصل و اورجینال ارائه کند، در حال فروش نسخه نال محصول است. توجه داشته باشید هیچ وب‌سایتی از این امر مستثنی نیست.</li>\n\n\n\n<li><strong>قیمت غیرمعقول:</strong><strong><br></strong>محصولات نال معمولاً با قیمتی بسیار کمتر از نسخه اورجینال به فروش می‌رسند. اگر یک قالب یا افزونه با قیمت بسیار پایین‌تر از سایت اصلی عرضه شود، احتمال نال بودن آن بسیار زیاد است.</li>\n\n\n\n<li><strong>عدم ارائه لایسنس معتبر:</strong><strong><br></strong>محصولات اصلی همراه با یک لایسنس معتبر عرضه می‌شوند که امکان فعال‌سازی و دریافت به‌روزرسانی‌ها را فراهم می‌کند. اگر محصولی فاقد لایسنس معتبر باشد یا لایسنس غیرقابل تأیید ارائه دهد، احتمالاً نال شده است.</li>\n\n\n\n<li><strong>بررسی نظرات کاربران و اعتبار فروشنده:</strong><strong><br></strong>پیش از خرید، نظرات کاربران را بررسی کنید و از معتبر بودن فروشگاه اطمینان حاصل کنید. فروشگاه‌های معتبر اطلاعات واضحی درباره محصولات ارائه می‌دهند و به سوالات کاربران پاسخ شفاف می‌دهند.</li>\n\n\n\n<li><strong>محصولات نگارش اصلی کد شده نمی‌باشند</strong><strong><br></strong>باید توجه داشته باشید که وردپرس بر اساس GPL و کد باز (Open Source) منتشر شده است. این به این معنی است که تمامی افزونه‌ها و پوسته‌های مرتبط با آن، باید به صورت کد باز منتشر شوند، حتی هر افزونه و یا پوسته‌ای که نگارش Premium یا Pro باشد باید به صورت Open Source به کاربران ارائه شوند، حال آنکه متاسفانه بسیاری از فروشگاه‌های ایرانی، نسخه‌های Premium و Pro را که کد باز هستند، کدگذاری کرده و با دخل تصرف بیشتر و یا اضافه کردن سیستم‌های لایسنس پیچیده‌تر، سعی در فروش بیشتر و در نتیجه پیچیده‌تر کردن محصول نهایی می‌کنند که این کار در نهایت منجر به سنگین‌تر شدن سایت و زمان بارگذاری بیشتر سایت و مشکلات دیگر می‌شود.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چطور محصولات اورجینال بخریم؟</strong></h3>\n\n\n\n<p>با توجه به مشکلات خرید دلاری برای کاربران ایرانی، می‌توانید از روش‌های زیر استفاده کنید:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>سایت‌های واسطه:</strong><strong><br></strong>برخی از سایت‌های معتبر واسطه ایرانی امکان خرید دلاری را برای شما فراهم می‌کنند. این سایت‌ها با دریافت مبلغ ریالی، محصول مورد نظر شما را از سایت اصلی خریداری کرده و اطلاعات لایسنس را در اختیار شما قرار می‌دهند. قبل از استفاده از خدمات این سایت‌ها، اعتبار آن‌ها را بررسی کنید.</li>\n\n\n\n<li><strong>دوستان یا آشنایان دارای حساب بین‌المللی:</strong><strong><br></strong>اگر دوستان یا آشنایانی دارید که دسترسی به کارت‌های بین‌المللی مانند مسترکارت یا ویزا کارت دارند، می‌توانید از آن‌ها برای خرید محصولات کمک بگیرید.</li>\n\n\n\n<li><strong>پیشنهاد دیگر: استفاده از تخفیف‌ها و باندل‌ها</strong><strong><br></strong>بسیاری از توسعه‌دهندگان محصولات وردپرس، در بازه‌های زمانی خاص مانند جمعه سیاه (Black Friday) یا مناسبت‌های دیگر، تخفیف‌های چشمگیری ارائه می‌دهند. با کمی برنامه‌ریزی می‌توانید محصولات اورجینال را با هزینه کمتری خریداری کنید.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>جمع‌بندی:</strong></h3>\n\n\n\n<p>خرید محصولات اصلی، علاوه بر حمایت از توسعه‌دهندگان، به شما این امکان را می‌دهد که از امکانات زیر بهره‌مند شوید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>پشتیبانی مداوم:</strong> حل مشکلات و پاسخ به سوالات شما.</li>\n\n\n\n<li><strong>دریافت به‌روزرسانی‌ها:</strong> محافظت سایت در برابر آسیب‌پذیری‌ها.</li>\n\n\n\n<li><strong>دسترسی به امکانات کامل و مستندات:</strong> بهره‌گیری از تمامی قابلیت‌های محصول به صورت بهینه.</li>\n</ul>\n\n\n\n<p>با خرید نسخه‌های اورجینال، هم امنیت و عملکرد سایت خود را تضمین می‌کنید و هم به توسعه تکنولوژی‌های بهتر کمک می‌کنید.</p>\n\n\n\n<p>استفاده از محصولات نال نه تنها غیراخلاقی و غیرقانونی است، بلکه می‌تواند خطرات جدی برای امنیت، عملکرد و اعتبار سایت شما ایجاد کند. به جای انتخاب این محصولات، از نسخه‌های رایگان یا لایسنس‌دار استفاده کنید. این کار نه تنها باعث حمایت از توسعه‌دهندگان می‌شود، بلکه امنیت و کیفیت سایت شما را تضمین می‌کند.</p>\n\n\n\n<p>اگر هزینه یک محصول برایتان بالا است، به دنبال جایگزین‌های رایگان یا تخفیف‌های فصلی باشید، اما هرگز امنیت و اعتبار خود را فدای استفاده از محصولات نال نکنید.</p>\n\n\n\n<p><strong>نوشته شده توسط:</strong> <a href=\"https://profiles.wordpress.org/asadiy4n/\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/asadiy4n/\">حسین اسدیان</a> و <a href=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\" data-type=\"link\" data-id=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\">تیم وردپرس فارسی</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:235:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۷\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/11/17/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b7-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 17 Nov 2024 20:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1103\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"به وردپرس ۶.۷ خوش آمدید! وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11038:\"\n<h2 class=\"wp-block-heading has-huge-font-size\"><strong>به وردپرس ۶.۷ خوش آمدید!</strong></h2>\n\n\n\n<p>وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت خود را با یک نمای کلان طراحی کنید و از جزئیات فاصله بگیرید تا تصویر کلی را به زندگی بیاورید</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معرفی پوسته Twenty Twenty-Five<br>امکان بی‌پایان بدون پیچیدگی</strong></h4>\n\n\n\n<p>پوسته Twenty Twenty-Five یک پوسته انعطاف‌پذیر و متمرکز بر طراحی را ارائه می‌دهد که به شما این امکان را می‌دهد تا سایت‌های خیره‌کننده‌ای را به سادگی بسازید. زیبایی‌شناسی خود را با مجموعه‌ای از گزینه‌های سبک، الگوهای بلوک و پالت‌های رنگی سفارشی کنید. این پوسته که به اصول اساسی خود پایبند است، واقعاً می‌تواند با شما رشد کند</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px;height:auto\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>تصویر کلی را با ویژگی Zoom Out ببینید<br>محتوای خود را از یک دیدگاه جدید کاوش کنید</strong></h4>\n\n\n\n<p>محتوای خود را به‌طور کامل و به شیوه‌ای بی‌سابقه ویرایش و مرتب کنید. نمای وسیع‌تری از سایت شما این امکان را می‌دهد که الگوها را به دلخواه خود اضافه، ویرایش، جابجا یا حذف کنید. معمار درون خود را در آغوش بگیرید</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-zoom-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>بلوک‌ها و فیلدهای سفارشی را بدون دردسر (یا کدنویسی) متصل کنید<br>راهی ساده برای ایجاد محتوای پویا</strong></h4>\n\n\n\n<p>این ویژگی یک رابط کاربری جدید برای اتصال بلوک‌ها به فیلدهای سفارشی معرفی می‌کند و کنترل محتوای پویا را به‌طور مستقیم در ویرایشگر قرار می‌دهد. بلوک‌ها را تنها با چند کلیک به فیلدها متصل کنید و انعطاف‌پذیری و کارایی را در هنگام ساخت افزایش دهید. مشتریان شما، شما را دوست خواهند داشت—انگار که قبلاً دوست نداشتند!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-block-bindings-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معمار درون فونت‌شناس خود را در آغوش بگیرید<br>بخش جدید سبک، امکانات جدید</strong></h4>\n\n\n\n<p>با افزودن جدید به رابط Styles، اندازه‌های پیش‌فرض فونت را ایجاد، ویرایش، حذف و اعمال کنید. می‌توانید تنظیمات پیش‌فرض پوسته را نادیده بگیرید یا اندازه فونت سفارشی خود را ایجاد کنید که شامل تایپوگرافی سیال برای مقیاس‌بندی پاسخگو باشد. به جزئیات بپردازید!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-font-presets-2.png?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>عملکرد</strong></h4>\n\n\n\n<p>وردپرس ۶.۷ به‌روزرسانی‌های مهمی در زمینه عملکرد ارائه می‌دهد، از جمله بارگذاری سریع‌تر الگوها، پیش‌نمایش‌های بهینه‌شده در مؤلفه‌های نمای داده، بهبود پشتیبانی از PHP 8+ و حذف کدهای منسوخ، اندازه‌های خودکار برای تصاویر بارگذاری شده به‌صورت تنبل و پردازش کارآمدتر برچسب‌ها در API HTML.</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>دسترس‌پذیری</strong></h4>\n\n\n\n<p>بیش از ۶۵ اصلاح و بهبود در زمینه دسترس‌پذیری بر جنبه‌های بنیادی تجربه وردپرس تمرکز دارد، از بهبود مؤلفه‌های رابط کاربری و ناوبری با کیبورد در ویرایشگر، تا عنوان دسترس‌پذیر در صفحه‌های ورود به وردپرس و برچسب‌گذاری واضح‌تر در سرتاسر.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-heic-1.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>پشتیبانی از تصاویر HEIC</strong><br>پشتیبانی از تصاویر HEIC مدیریت رسانه را بهبود می‌بخشد و امکان استفاده از تصاویر با کیفیت بالا و فضای بهینه را در تمام بلوک‌ها فراهم می‌کند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-streamlined-query-loops.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>بلوک Query Loop بهینه‌شده</strong><br>بهبودهای انجام‌شده در بلوک Query Loop قابلیت استفاده را افزایش می‌دهد و با خودکارسازی تنظیمات پیش‌فرض و تجمیع گزینه‌های کلیدی، سفارشی‌سازی را آسان‌تر می‌کند</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-preview-dropdown.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>گسترش منوی کشویی پیش‌نمایش</strong><br>بهبودهای انجام‌شده در گزینه‌های پیش‌نمایش به افزونه‌ها و پوسته‌ها این امکان را می‌دهد که موارد سفارشی را به منوی کشویی اضافه کنند و نحوه پیش‌نمایش محتوا را غنی‌تر کنند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-site-background.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>سفارشی‌سازی پس‌زمینه سایت</strong><br>ابزارهای بهبود یافته پس‌زمینه، سفارشی‌سازی بلوک‌ها را افزایش می‌دهند و امکان تنظیمات جهانی را فراهم می‌کنند، که به حفظ انسجام در سرتاسر سایت کمک کرده و تلاش‌های طراحی را ساده‌تر می‌سازد.</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-template-registration.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>API ثبت الگو</strong><br>این API جدید ثبت الگوهای سفارشی را برای افزونه‌ها ساده‌تر می‌کند و امکان نادیده‌گیری پوسته و ایجاد الگوهای سفارشی برای دسته‌بندی‌ها را برای انعطاف‌پذیری بیشتر فراهم می‌آورد</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-refined-pages.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>نمای بهبود یافته صفحات در ویرایشگر سایت</strong><br>ویرایش را با نمای صفحات بهبود یافته که گزینه‌های فیلتر سفارشی را ارائه می‌دهند، ساده‌تر کنید. با تغییر نمایش فیلترها، به نمای‌های بهینه‌شده‌ای مانند منتشر شده و پیش‌نویس‌ها بدون شلوغی دسترسی پیدا کنید.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>برای مشاهدهٔ جامع تمام ویژگی‌ها و بهبودهای جدید در وردپرس ۶.۷، آن را به‌روز و امتحان کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۶\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/07/16/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 08:08:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:646:\"وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از: پالت‌های رنگ و مجموعه‌های فونت انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5177:\"\n<p>وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پالت‌های رنگ و مجموعه‌های فونت</li>\n\n\n\n<li>پیش‌نمایش سریع برای برگه‌ها</li>\n\n\n\n<li>بازگرداندن به‌روزرسانی‌های خودکار افزونه</li>\n\n\n\n<li>باز‌نویسی‌ها</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"567\" src=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png\" alt=\"\" class=\"wp-image-1081\" srcset=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png 1024w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-300x166.png 300w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-768x426.png 768w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1536x851.png 1536w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-2048x1135.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پالت‌های رنگ و مجموعه‌های فونت</h2>\n\n\n\n<p><strong>انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.</strong><br>سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را ارائه می‌کنند و امکان سفارشی‌سازی را بدون تغییر استایل گسترده‌تر سایت، فراتر از تنظیمات رنگ یا تایپوگرافی فراهم می‌کنند.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پیش‌نمایش سریع برای برگه‌ها</h2>\n\n\n\n<p><strong>گردش کاری خود را با چیدمان جدیدی که برای برگه‌ها ایجاد شده‌است، ساده کنید.&nbsp;</strong><br>تمام برگه‌هایتان و پیش‌نمایش هر برگهٔ انتخابی را قبل از ویرایش از طریق یک چیدمان جدید پهلو به پهلو در ویرایشگر سایت مشاهده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بازگرداندن به‌روزرسانی‌های خودکار افزونه</h2>\n\n\n\n<p><strong>افزونه‌های خود را با خیال راحت بصورت خودکار به‌روزرسانی کنید.</strong><br>از سهولت به‌روزرسانی خودکار افزونه‌ها با ایمنی بازگرداندن در صورت بروز مشکل، لذت ببرید و امنیت سایتتان را بهبود ببخشید و در عین حال مدت از کار افتادن احتمالی سایت را به حداقل برسانید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">باز‌نویسی‌ها</h2>\n\n\n\n<p><strong>افزودن قابلیت سفارشی‌سازی محتوا در الگوهای همگام‌سازی شده.</strong><br>اجازه می‌دهد که قطعات خاصی از محتوا در هر نمونه از یک الگوی همگام‌سازی‌شده را سفارشی و در عین حال سبکی ثابت را برای همه نمونه‌ها حفظ کنید و به‌روزرسانی‌های آینده را ساده‌تر می‌کند. در حال حاضر، می‌توانید برای بلوک‌های عنوان، پاراگراف، دکمه و تصویر، از باز‌نویسی‌ها استفاده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<p>ه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-6/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1080\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/04/02/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 07:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از: با کتابخانه فونت آشنا شوید بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید. فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7323:\"\n<p>وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از:<br></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>کتابخانه فونت جدید</li>\n\n\n\n<li>پس زمینه و ابزار سایه پیشرفته</li>\n\n\n\n<li>جزئیات بیشتری در اصلاحات استایل</li>\n\n\n\n<li>کنترل بهتر لینک</li>\n\n\n\n<li>نماهای داده جدید</li>\n\n\n\n<li>به‌روزرسانی عملکرد</li>\n\n\n\n<li>بهبود دسترسی</li>\n\n\n\n<li></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid.png\"><img decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png\" alt=\"\" class=\"wp-image-1077\" srcset=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png 1024w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-300x169.png 300w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-768x432.png 768w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1536x864.png 1536w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-2048x1153.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">با کتابخانه فونت آشنا شوید</h2>\n\n\n\n<p>بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید.</p>\n\n\n\n<p>فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی سفارشی به سازندگان سایت و ناشران، حق انتخاب بیشتری می‌دهد.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پس زمینه و ابزار سایه پیشرفته</h2>\n\n\n\n<p>با استفاده از ابزارهای طراحی به‌روز، راه‌های بیشتری برای افزودن جذابیت بصری به چیدمان‌ها بیابید. تنظیمات اندازه، تکرار و نقطه کانونی را روی تصاویر پس زمینه خود کنترل کنید تا آن‌ها را با هم ترکیب و یا برجسته کنید. با افزودن پشتیبانی از سایه‌ها به بلوک‌های بیشتر، در طرح‌هایتان عمق بصری ایجاد و یا کمی هویت به آن‌ها تزریق کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جزئیات بیشتری را از اصلاحات استایل خود دریافت کنید</h2>\n\n\n\n<p>پروژه‌های خلاقانه را با داشتن تصویر کامل‌تری از آنچه انجام شده است — و آنچه می‌توانید به آن برگردید، انجام بدهید. جزئیاتی مانند نشان‌های زمانی، خلاصه‌ی سریع و فهرست صفحه‌بندی‌شده‌ی همه ویرایش‌ها را دریافت کنید. برای مشاهده تغییرات، خارج از آنچه روی آن کار می‌کنید، به ویرایش‌های موجود در کتابچه سبک نگاه کنید. اکنون رونوشت‌ها برای الگوها و اجزای قالب نیز در دسترس است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">کنترل بهتر لینک</h2>\n\n\n\n<p>پیوندها را به راحتی با تجربه پیوندسازی قابل درک‌تر ایجاد و مدیریت کنید، با یک رابط کاربری ساده و میانبرهایی برای کپی کردن پیوندها.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">نماهای داده جدید را کاوش کنید</h2>\n\n\n\n<p>هر بخش از سایت شما با کتابخانه‌ای از اطلاعات و داده‌ها همراه است — اکنون، می‌توانید آنچه را که نیاز دارید به سرعت پیدا کنید و آن را هر طور که دوست دارید سازماندهی کنید. نماهای داده برای صفحات، قالب‌ها، الگوها و بخش‌های قالب به شما امکان می‌دهد داده‌ها را در یک نمای جدول یا شبکه‌ای مشاهده کنید، با گزینه‌هایی برای تغییر زمینه‌ها و ایجاد تغییرات دسته‌جمعی.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">به‌روزرسانی عملکرد</h2>\n\n\n\n<p>این نگارش شامل بیش از ۱۱۰ به روز‌رسانی عملکرد، با افزایش چشمگیر سرعت و کارایی در ویرایشگر پست و ویرایشگر سایت است. بارگیری بیش از دو برابر سریعتر از نگارش ۶٫۴ است، با سرعت پردازش ورودی تا پنج برابر سریعتر از نگارش قبلی. زمان بارگذاری سایت‌های ترجمه شده تا ۲۵٪ در این نگارش بهبود یافته‌ است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بهبود دسترسی</h2>\n\n\n\n<p>این نگارش شامل بیش از ۶۵ بهبود دسترسی‌پذیری در سراسر پلتفرم است که آن را بیش از همیشه در دسترس قرار می‌دهد. این شامل یک اصلاح مهم است که دسترسی به منوهای فرعی مدیریت را برای کاربران صفحه‌خوان و دیگرانی که با صفحه‌کلید پیمایش می‌کنند، رفع انسداد می‌کند. این نگارش همچنین اصلاحاتی را برای کنتراست رنگ در حالت‌های تمرکز مدیر، موقعیت‌یابی عناصر و فوکوس مکان‌نما و موارد بسیار دیگر، اضافه می‌کند که به بهبود تجربه وردپرس برای همه کمک می‌کند.</p>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fa.wordpress.org/2023/11/07/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-6-4-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 11:20:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=905\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:600:\"این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1955:\"\n<p>این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف بی‌نظیر ساختار با بلوک‌ها را کشف کنید و به ایده‌های خود اجازه بدهید که پرواز کنند.</p>\n\n\n\n<p>بسیاری از ویژگی‌ها و بهبودهای وردپرس 6.4 در دسته &#8220;کوچک اما قدرتمند&#8221; قرار دارند. همراه با زیبایی چند منظوره قالب Twenty Twenty-Four (دو هزار و بیست و چهار)، این به‌روزرسانی‌ها به خالقان محتوا و توسعه‌دهندگان سایت کمک می‌کنند تا زمان و تلاش خود را صرفه‌جویی کنند و در عین حال تجربه وردپرس با ارزش و کم دردسر را که جهان انتظار دارده است، ارائه دهند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/files/2024/02/tt41.png\"><img decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2024/02/tt41.png\" alt=\"وردپرس 6.4\" class=\"wp-image-906\" srcset=\"https://fa.wordpress.org/files/2024/02/tt41.png 1024w, https://fa.wordpress.org/files/2024/02/tt41-300x195.png 300w, https://fa.wordpress.org/files/2024/02/tt41-768x500.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\">وردپرس 6.4</figcaption></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۳\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2023/08/20/wordpress-6-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 20 Aug 2023 20:15:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:513:\"با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2248:\"\n<p>با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها و پیمایش به روز شده ای را خواهید دید که به شما کمک می کند با تلاش کمتر کار کنید و ایجاد کنید، ابزارهایی طراحی کنید که کنترل بیشتری بر طرح بندی به شما می‌دهد، و عملکردهای افزوده شده‌ای را که تجربه ساخت سایت را غنی می کند. وردپرس 6.3 فصل مهمی را در تکامل وردپرس به عنوان ابزاری برای بیان مشخص می‌کند. این نقطه اوج سال‌ها کار صدها مشارکت‌کننده است که تجربه ویرایش قوی‌تر و منسجم‌تری را برای ساخت وب‌سایت‌هایی با بلوک به ارمغان می‌آورد. این به تلاش برای قابل دسترس ساختن انتشار وب برای همه ادامه می دهد &#8211; بنابراین فقط یک شروع جدید است!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/08/site-editor-2.png?resize=1024%2C666&amp;ssl=1\" alt=\"\" /></figure>\n\n\n\n<p>وردپرس جدید را از لینک زیر دریافت نمایید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"858\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 07:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=760\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد. تازه‌ترین نگارش راهنمای زمینهٔ وردپرس را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید. برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10296:\"\n<p>وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد.</p>\n\n\n\n<div class=\"wp-block-jetpack-tiled-gallery alignfull is-style-rectangular\"><div class=\"tiled-gallery__gallery\"><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:66.70764%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"763\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-site-editor/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.29236%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"764\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-navigation/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"765\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-block-inserter/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"766\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-split-controls-fixed/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"767\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-openverse/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-headers.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"768\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-headers/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-headers.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"769\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-out-of-beta/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"770\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-distraction-free/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"771\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-custom-css/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"772\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-copy-paste/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div></div></div>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"760\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/2020/12/09/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b5%d9%ab%db%b8-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2020 14:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:611:\"&#8212; سه نیروی اساسی مدیریت ابزارک‌ها با بلوک‌ها بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16226:\"\n<p class=\"has-text-align-center has-white-color has-text-color\">&#8212;</p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\"> سه نیروی اساسی </h2>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png\" alt=\"\" class=\"wp-image-698 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png 1024w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-300x225.png 300w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-768x576.png 768w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-440x330.png 440w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">مدیریت ابزارک‌ها با بلوک‌ها</h3>\n\n\n\n<p>بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون کد گرفته تا کتابخانه گسترده بلوک‌های اصلی و شخص ثالث. برای توسعه‌دهندگانمان، شما می‌توانید جزئیات بیشتر را در <a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">یادداشت توسعه ابزارک‌ها</a> پیدا کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"811\" src=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png\" alt=\"\" class=\"wp-image-697 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png 1024w, https://fa.wordpress.org/files/2021/07/about-query-loop-300x238.png 300w, https://fa.wordpress.org/files/2021/07/about-query-loop-768x608.png 768w, https://fa.wordpress.org/files/2021/07/about-query-loop.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمایش نوشته‌ها با بلوک‌ها و الگوهای جدید</h3>\n\n\n\n<p>بلوک چرخه درخواست امکان نمایش نوشته‌ها را براساس پارامترهای تعیین‌شده فراهم می‌کند؛ نظیر یک چرخه PHP بدون کدنویسی. به آسانی نوشته‌های یک دسته خاص را نمایش دهید یا کارهایی نظیر ایجاد یک برگه نمونه کار یا یک برگه کامل از دستورات آشپزی مورد علاقه شما انجام دهید. به بلوک آخرین نوشته‌ها به عنوان یک بلوک بسیار پیچیده و قوی فکر کنید! به علاوه، پیشنهادات الگو باعث می‌شود تا ایجاد لیستی از نوشته‌ها با طراحی مورد نظرتان آسان‌تر از گذشته قابل انجام باشد.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png\" alt=\"\" class=\"wp-image-699 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png 1024w, https://fa.wordpress.org/files/2020/12/about-template-300x195.png 300w, https://fa.wordpress.org/files/2020/12/about-template-768x499.png 768w, https://fa.wordpress.org/files/2020/12/about-template.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">ویرایش قالب اطراف نوشته‌ها</h3>\n\n\n\n<p>شما می‌توانید از ویرایشگر بلوک آشنا برای ویرایش قالب‌هایی که محتوای شما را در اختیار دارند استفاده کنید—به سادگی یک بلوک پوسته یا یک پوسته را که این ویژگی را انتخاب کرده است فعال کنید. از ویرایش نوشته‌ها به ویرایش برگه‌های خود بروید و دوباره بازگردید، همه اینها در حالی‌است که از ویرایشگر بلوک آشنا استفاده می‌کنید. بیش از ۲۰ بلوک جدید سارگاز با پوسته‌ها در دسترس است. در مورد این قابلیت و اینکه چطور می‌توان آن را تجربه کرد در یادداشت‌های انتشار بخوانید.</p>\n</div></div>\n\n\n\n<p> </p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">سه همیار گردش کار</h2>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-list-view.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"803\" src=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png\" alt=\"\" class=\"wp-image-700 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png 1024w, https://fa.wordpress.org/files/2020/12/about-list-view-300x235.png 300w, https://fa.wordpress.org/files/2020/12/about-list-view-768x602.png 768w, https://fa.wordpress.org/files/2020/12/about-list-view.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمای کلی ساختار برگه</h3>\n\n\n\n<p>گاهی شما نیاز به یک برگه فرود ساده نیاز داری ، اما گاهی نیاز به یک چیز قوی‌تر دارید. با اضافه شدن بلوک‌ها‌ی بیشتر، ادغام الوگها، و آسان شده ایجاد محتوا، راه‌حل‌های جدیدی لازم است تا بتوان محتوای پیچیده را به راحتی جستجو کرد. مشاهده فهرستی بهترین راه برای پرش بین لایه‌های محتوا و بلوک‌های تو در تو است. از آنجا که مشاهده فهرستی به شما یک نمای کلی از تمام بلوک‌های محتوای شما می‌دهد، اکنون می‌توانید به سرعت و دقیق به بلوک مورد نیاز خود بروید. آماده تمرکز کامل بر روی محتوای خود هستید؟ این را متناسب با گردش کار خود روشن یا خاموش کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"555\" src=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png\" alt=\"\" class=\"wp-image-701 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png 1024w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-300x163.png 300w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-768x416.png 768w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">الگوهای پیشنهادی برای بلوک‌ها</h3>\n\n\n\n<p>شروع در این نسخه ابزار دگرگونی الگو که الگوهای بلوک را بر اساس بلوکی که استفاده می‌کنید پیشنهاد می‌دهد. هم‌اکنون، می‌توانید این را در بلوک کوئری و بلوک آیکون شبکه‌های اجتماعی استفاده نمایید. با اضافه شدن الگوهای بیشتر، شما می‌توانید از نحوه سبک دادن به سایت خود بدون اینکه هرگز از ویرایشگر خارج شوید الهام بگیرید!</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-duotone.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"837\" src=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png\" alt=\"\" class=\"wp-image-702 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png 1024w, https://fa.wordpress.org/files/2020/12/about-duotone-300x245.png 300w, https://fa.wordpress.org/files/2020/12/about-duotone-768x628.png 768w, https://fa.wordpress.org/files/2020/12/about-duotone.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">سبک‌دهی و رنگ‌آمیزی تصاویر</h3>\n\n\n\n<p>با جلوه دوتون عکس‌ها و بلوک‌های پوشش را رنگی کنید! دوتون می‌تواند رنگ‌های زیادی را به طرح و سبک عکس‌های شما (یا ویدئوهایی در بلوک پوشش) برای ادغام خوب در پوسته‌های شما اضافه کند. شما می‌توانید جلوه دوتون را به عنوان یک فیلتر سیاه و سفید تصور کنید، اما به جای اینکه سایه‌ها سیاه و سفید و هایلایت باشند، رنگ‌های خود را برای سایه‌ها و هایلایت‌ها انتخاب می‌کنید. چیزهای بیشتری برای آموختن کارکرد آن در مستندات وجود دارد.</p>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">برای توسعه‌دهندگان که بررسی کنند</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1020\" height=\"610\" src=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\" alt=\"\" class=\"wp-image-703\" srcset=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png 1020w, https://fa.wordpress.org/files/2020/12/about-theme-json-300x179.png 300w, https://fa.wordpress.org/files/2020/12/about-theme-json-768x459.png 768w\" sizes=\"auto, (max-width: 1020px) 100vw, 1020px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:50%\">\n<h3 class=\"wp-block-heading\">Theme.json</h3>\n\n\n\n<p>معرفی APIهای تنظیمات عمومی و سبک‌های عمومی: تنظیمات ویرایشگر، ابزارهای شخصی‌سازی در دسترس، و سبک‌های بلوک‌ها را با استفاده از پرونده theme.json در پوسته فعال کنترل کنید. این پرونده پیکربندی قابلیت‌ها و مجموعه سبک‌های پیش‌فرض برای سایت و بلوک‌ها را فعال یا غیرفعال می‌کند. اگر شما پوسته می‌سازید، شما می‌توانید این ویژگی جدید مفید را آزمایش کنید. برای اینکه بدانید هم‌اکنون چه چیزی در دسترس است و چگونه کار می‌کند، <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">این توضیحات فنی را بخوانید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">کنار گذاشتن پشتیبانی از اینترنت اکسپلورر ۱۱</h3>\n\n\n\n<p>در این انتشار، پشتیبانی از اینترنت اکسپلورر ۱۱ کنار گذاشته شده است. این یعنی شما ممکن است نیاز به مدیریت مشکلاتی روی وبگاه‌تان داشته باشید که در آینده رفع نخواهند شد. اگر در حال حاضر از اینترنت اکسپلورر ۱۱ استفاده می‌کنید، اکیدا پیشنهاد می‌کنیم که <a href=\"https://browsehappy.com/\">به مرورگر مدرن‌تری نقل مکان کنید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی از WebP</h3>\n\n\n\n<p>WebP یک قالب ذخیره تصویر مدرن است که امکان فشرده‌سازی بی‌اتلاف و یا بااتلاف بهبودیافته را برای تصاویر در فضای وب فراهم می‌کند. تصاویر WebP به طور میانگین حدود ۳۰٪ کم‌حجم‌تر از معادل‌های‌شان در قالب‌های JPEG و PNG هستند که این یعنی وب‌گاه‌ها سریع‌تر شده و پهنای باند کم‌تری مصرف می‌کنند.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی بلوک اضافی</h3>\n\n\n\n<p>به عنوان قابلیتی بسط داده شده بر روی پشتیبانی بلوک پیاده‌سازی شده در وردپرس <a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">۵٫۶</a> و <a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">۵٬۷</a>، وردپرس ۵٫۸ چندین پرچم و گزینه پشتیبانی بلوک جدید را برای سفارشی‌سازی بلوک‌های ثبت شده معرفی می‌کند. اطلاعات بیشتر در <a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">یادداشت توسعه پشتیبانی بلوک</a> در دسترس است.</p>\n</div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h3>\n\n\n\n<p>آخرین نگارش از راهنمای میدانی وردپرس را بررسی کنید. این یادداشت‌های توسعه‌دهنده برای هر تغییری که شاید بخواهید از آنها آگاه باشید را برجسته می‌کند. <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">راهنمای میدانی وردپرس .۵.۸</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/08/11/wp-persian-55/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2020 20:42:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=641\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:570:\"در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت. سرعت عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری نوشته‌ها و برگه‌ها سریعتر شدند. تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند. در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8171:\"\n<p>در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت.</p>\n\n\n\n<h2 class=\"wp-block-heading\">سرعت</h2>\n\n\n\n<p><strong>عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری</strong> <strong>نوشته‌ها و برگه‌ها سریعتر شدند.</strong></p>\n\n\n\n<p>تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند.</p>\n\n\n\n<p>در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل مشاهده می‌شوند، برای بارگذاری صبر می‌کنند. واژه تکنیکال آن &#8216;lazy loading&#8217; است.</p>\n\n\n\n<p>روی موبایل، لِیزی-لود می‌تواند مرورگرها را از دریافت پرونده‌های درنظرگرفته‌شده برای سایر دستگاه‌ها باز دارد. آن می‌تواند باعث صرفه‌جویی خوانندگان شما در داده شود — و کمک کند عمر باتری حفظ شود.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جستجو</h2>\n\n\n\n<p><strong>به نقشهٔ سایت جدید سلام کنید.</strong></p>\n\n\n\n<p>سایت‌های وردپرس با موتورهای جستجو به خوبی کار می‌کنند.</p>\n\n\n\n<p>اکنون، به طور پیش‌فرض، وردپرس ۵.۵ دارای یک نقشهٔ سایت XML است که به موتورهای جستجو کمک می‌کند تا از همان دقایقی آغاز کار، مهم‌ترین برگه‌های شما را کشف کنند.</p>\n\n\n\n<p>بنابراین تعداد بیشتری از افراد سایت شما را زودتر پیدا می‌کنند و به شما فرصت بیشتری می‌دهند تا مشارکت داشته باشند، آنها را حفظ نمایید و به مشترکین، مشتریان یا هر آن‌چه که با تعریف موفقیت شما مناسب باشد، تبدیل نمایید.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group has-background\" style=\"background-color:#ebcd3d\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"has-background wp-block-heading\" style=\"background-color:#ebcd3d\">امنیت</h2>\n\n\n\n<p><strong>به‌روزرسانی‌های خودکار برای افزونه‌ها و پوسته‌ها</strong></p>\n\n\n\n<p>اکنون می‌توانید افزونه‌ها و پوسته‌ها را تنظیم نمایید تا به صورت خودکار در مدیریت وردپرس به‌روزرسانی شوند — یا نه! —. بنابراین همیشه می‌دانید سایت شما آخرین کد موجود را اجرا می‌نماید.</p>\n\n\n\n<p>همچنین می‌توانید برای هر افزونه یا پوسته‌ای که نصب نموده‌اید، به‌روزرسانی‌های خودکار را روشن یا خاموش نمایید — همه در همان صفحه‌هایی که همیشه از آن‌ها استفاده شده است.</p>\n\n\n\n<p><strong>به‌روزرسانی با بارگذاری پروندهٔ ZIP</strong> <strong>شده</strong></p>\n\n\n\n<p>اگر به‌روزرسانی افزونه‌ها و پوسته‌هایتان به صورت دستی انجام می‌شود، اکنون این کار نیز ساده‌تر است — فقط یک پروندهٔ ZIP را بارگذاری نمایید.</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group has-background\" style=\"background-color:#f3ecda\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"wp-block-heading\">نکات برجسته از بلوک ویرایشگر</h2>\n\n\n\n<p>یک بار دیگر، تازه‌ترین نگارش وردپرس فهرست طولانی از ویژگی‌های جدید هیجان‌انگیز را برای ویرایشگر بلوک منتشر نمود. برای نمونه:</p>\n\n\n\n<h4 class=\"wp-block-heading\">الگوهای بلوک</h4>\n\n\n\n<p>الگوهای بلوک جدید ایجاد طرح‌های زیبا، پیچیده را با کمک ترکیبی از متن و رسانه که می‌توانید آنها را مخلوط و متناسب با داستانتان کنید، ساده و سرگرم‌کننده می‌کند.</p>\n\n\n\n<p>شما همچنین می‌توانید الگوهای بلوک را در طیف گسترده‌ای از افزونه‌ها و پوسته‌ها، با تعداد زیادی که بیشتر از همیشه اضافه شده، پیدا کنید. هر یک از آنها را از یک کشویی انتخاب کنید — فقط کلیک کنید و بروید!</p>\n\n\n\n<h4 class=\"wp-block-heading\">ویرایش تصویر توکار</h4>\n\n\n\n<p>تصاویرتان را به درستی از بلوک تصویر برش داده‌، بچرخانید، و زوم نمایید. اگر زمان زیادی را صرف تصاویر می‌نمایید، این می‌تواند در وقت شما ساعت‌ها صرفه‌جویی نماید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">پوشه بلوک جدید</h4>\n\n\n\n<p>حالا این ساده‌تر از هر زمانی است که بلوک موردنیازتان را پیدا کنید. پوشه بلوک جدید برای ویرایشگر بلوک ساخته شده، پس شما می‌توانید نوع‌های بلوک جدیدی برای سایتتان بدون خروج از ویرایشگر نصب کنید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">و خیلی بیشتر.</h4>\n\n\n\n<p>هایلایت‌های بالا بخش کوچکی از امکانات ویرایشگر بلوک جدید است که شما نصب کردید. ویرایشگر بلوک را باز کنید و لذت ببرید!</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">دسترس‌پذیری</h2>\n\n\n\n<p>هر نگارش پیشرفت‌هایی را به تجربهٔ دستر‌س‌پذیری انتشار می‌افزاید، و این دربارهٔ وردپرس ۵.۵ نیز صدق می‌کند.</p>\n\n\n\n<p>هم‌اکنون می‌توانید پیوندها را در صفحه رسانه و کادر مودال با یک دکمه، بجای تلاش برای هایلایت کردن یک خط از متن کپی کنید.</p>\n\n\n\n<p>همچنین شما می‌توانید جعبه‌های متا را با صفحه کلید حرکت دهید، و عکس‌ها را در وردپرس با دستگاه کمک‌کننده خود ویرایش کنید، همان‌گونه که این می‌تواند دستورالعمل‌های موجود را در ویرایشگر تصویر بخواند.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#ffffff\">&#8230;..</p>\n\n\n\n<h5 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h5>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵.۵ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را جلا می‌دهند، <a href=\"https://make.wordpress.org/core/wordpress-5-5-field-guide/\">راهنمای زمینه وردپرس ۵.۵</a> را بررسی نمایید.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/04/01/wp-persian-54/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Apr 2020 20:16:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=603\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:614:\"وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم: چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند. بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته. &#8230;.. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6203:\"\n<p>وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم:</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png\" alt=\"\" class=\"wp-image-605\" srcset=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png 500w, https://fa.wordpress.org/files/2020/04/blocks-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/blocks-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png\" alt=\"\" class=\"wp-image-614\" srcset=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png 500w, https://fa.wordpress.org/files/2020/04/ui-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/ui-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش رابط کاربری ساده‌تر، راهبری واضح‌تر و تب‌زدن ساده‌تر شده است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">سرعت بارگذاری ۱۴% سریعتر و زمان نوشتن هم ۵۱% سریعتر شده است!</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش، در بخش نوشتن، ویرایشگر بصورت پیش‌فرض تمام صفحه شده است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png\" alt=\"\" class=\"wp-image-607\" srcset=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png 500w, https://fa.wordpress.org/files/2020/04/privacy-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/privacy-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش همچنان بخش حفظ حریم خصوصی بهبودهای فنی و ظاهری داشته است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">هم‌اکنون برون‌بری داده‌های شخصی شامل اطلاعات نشست کاربران و داده‌های موقیعت مکانی کاربران به اضافهٔ جدول محتوا در دسترس است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p><strong>برای توسعه دهندگان:</strong></p>\n\n\n\n<p style=\"font-size:15px\">&#8211; زمینه‌های دلخواه به گزینه‌های فهرست افزوده شدند، بدون افزونه و بدون نوشتن واکرهای سفارشی میتوانید آنها را استفاده نمایید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; در بلوک‌ها، هم‌اکنون می‌توانید ظاهر بلوک‌ها را به شیوه‌ای که می‌خواهید تغییر دهید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; اگر افزونه‌ای دارید، هم‌اکنون می‌توانید بلوک‌هایتان را در دسته‌های مختلف ثبت نمایید — این یک راهکار عالی برای بیشتر دیده شدن برند شما است.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; به کاربران اجازه دهید با دو API تازه کارهای بیشتری انجام دهند: متغییرهای بلوک و گرادیانت.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; همچنین در جاسازها، هم‌اکنون ویرایشگر بلوک، TikTok را پشتیبانی می‌کند— و CollegeHumor حذف شد.</p>\n\n\n\n<p></p>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background has-vivid-cyan-blue-background-color\" href=\"https://fa.wordpress.org/download/\" style=\"color:#ffffff;border-radius:8px\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵٫۴ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را زیبایی و بهبود می‌دهند، <a href=\"https://make.wordpress.org/core/2020/03/03/wordpress-5-4-field-guide/\">راهنمای زمینه وردپرس ۵.۴</a> را بررسی نمایید.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"603\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 22 May 2025 12:29:40 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 26 Apr 2025 07:24:59 GMT\";s:4:\"link\";s:61:\"<https://fa.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1739618436;s:21:\"cache_expiration_time\";i:1747960186;s:23:\"__cache_expiration_time\";i:1747960186;}", "off");
INSERT INTO `dgfdcv_options` VALUES("24581", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":6,\"critical\":1}", "on");
INSERT INTO `dgfdcv_options` VALUES("24846", "_transient_td_update_plugin_subscription", "1", "off");
INSERT INTO `dgfdcv_options` VALUES("24845", "_transient_timeout_td_update_plugin_subscription", "1748176378", "off");
INSERT INTO `dgfdcv_options` VALUES("24594", "_transient_woocommerce_product_task_product_count_transient", "0", "on");
INSERT INTO `dgfdcv_options` VALUES("24606", "can_compress_scripts", "1", "on");
INSERT INTO `dgfdcv_options` VALUES("24301", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `dgfdcv_options` VALUES("24600", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"sHTNGvpX-b.JMk=Ofmj9_n1i,&ke79IgMBqoLdnGa97I\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1739682481,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 287.91,\n    \"siteNumFiles\": 22681,\n    \"siteDbSizeMB\": 10.42,\n    \"siteDbNumTables\": 71\n}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24879", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `dgfdcv_options` VALUES("24545", "_transient_TD_THEME_VERSION", "12.7.1", "on");
INSERT INTO `dgfdcv_options` VALUES("24547", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `dgfdcv_options` VALUES("16941", "duplicator_notifications", "a:4:{s:6:\"update\";i:1747917546;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("17566", "woocommerce_store_id", "40b456e3-2cdf-4f74-88ba-081408f8a957", "yes");
INSERT INTO `dgfdcv_options` VALUES("17887", "wc_downloads_approved_directories_mode", "disabled", "yes");
INSERT INTO `dgfdcv_options` VALUES("19707", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "auto");
INSERT INTO `dgfdcv_options` VALUES("19708", "revslider_server_refresh", "1747917173", "auto");
INSERT INTO `dgfdcv_options` VALUES("19709", "revslider-update-check-short", "1747917173", "auto");
INSERT INTO `dgfdcv_options` VALUES("19710", "revslider-connection", "1", "auto");
INSERT INTO `dgfdcv_options` VALUES("19711", "revslider-update-hash", "f926876ae0d074cc9e289f3e884145b2", "auto");
INSERT INTO `dgfdcv_options` VALUES("19712", "revslider-latest-version", "6.7.34", "auto");
INSERT INTO `dgfdcv_options` VALUES("19713", "revslider-stable-version", "4.2.0", "auto");
INSERT INTO `dgfdcv_options` VALUES("19714", "revslider-notices", "a:4:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "auto");
INSERT INTO `dgfdcv_options` VALUES("19715", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "auto");
INSERT INTO `dgfdcv_options` VALUES("19716", "rs-addons-counter", "1", "auto");
INSERT INTO `dgfdcv_options` VALUES("19717", "revslider-addons", "O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:6:\"6.7.31\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-01-17\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-shapeburst-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"613\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:26:\"revslider-shapeburst-addon\";s:12:\"version_from\";s:6:\"6.7.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"ShapeBurst\";s:6:\"line_1\";s:8:\"Shape...\";s:6:\"line_2\";s:9:\"and Burst\";s:9:\"available\";s:5:\"7.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"670\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_shape_burst.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_shape_burst.jpg\";s:7:\"img_md5\";s:32:\"2b1b6cb4613bdfcfff4c8c46660be8f5\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:14:\"Visual Effects\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24627", "_transient_product_query-transient-version", "1746013882", "on");
INSERT INTO `dgfdcv_options` VALUES("24836", "_transient_TD_CHECKED_LICENSE", "SUCCESS", "on");
INSERT INTO `dgfdcv_options` VALUES("24651", "_transient_shipping-transient-version", "1739619686", "on");
INSERT INTO `dgfdcv_options` VALUES("24816", "_site_transient_timeout_php_check_7ec5f04fef1dc985019fbdb14afad4b2", "1748521754", "off");
INSERT INTO `dgfdcv_options` VALUES("24817", "_site_transient_php_check_7ec5f04fef1dc985019fbdb14afad4b2", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `dgfdcv_options` VALUES("24922", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1747917542;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:11:\"amp/amp.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"w.org/plugins/amp\";s:4:\"slug\";s:3:\"amp\";s:6:\"plugin\";s:11:\"amp/amp.php\";s:11:\"new_version\";s:5:\"2.5.5\";s:3:\"url\";s:34:\"https://wordpress.org/plugins/amp/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/amp.2.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:48:\"https://ps.w.org/amp/assets/icon.svg?rev=2527602\";s:3:\"svg\";s:48:\"https://ps.w.org/amp/assets/icon.svg?rev=2527602\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/amp/assets/banner-1544x500.png?rev=2527602\";s:2:\"1x\";s:58:\"https://ps.w.org/amp/assets/banner-772x250.png?rev=2527602\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.12\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:5:\"9.8.5\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}}s:7:\"checked\";a:25:{s:11:\"amp/amp.php\";s:5:\"2.5.5\";s:45:\"td-demo-app-find-pro/td-app-find-pro-demo.php\";s:5:\"1.0.0\";s:45:\"td-demo-cali-sight-pro/td-cali-sight-demo.php\";s:5:\"1.0.0\";s:45:\"td-demo-coaching-pro/td-coaching-pro-demo.php\";s:5:\"1.0.0\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.12\";s:45:\"td-demo-job-hunt-pro/td-job-hunt-pro-demo.php\";s:5:\"1.0.0\";s:45:\"td-demo-momentum-pro/td-momentum-pro-demo.php\";s:5:\"1.0.0\";s:23:\"revslider/revslider.php\";s:6:\"6.7.31\";s:43:\"td-custom-post-type/td-custom-post-type.php\";s:3:\"1.0\";s:37:\"td-cloud-library/td-cloud-library.php\";s:31:\"3.9 | built on 27.03.2025 10:27\";s:43:\"td-demo-compass-pro/td-compass-pro-demo.php\";s:5:\"1.0.0\";s:27:\"td-composer/td-composer.php\";s:33:\"5.4.1 | built on 29.04.2025 10:27\";s:43:\"td-demo-doctors-pro/td-doctors-pro-demo.php\";s:5:\"1.0.0\";s:59:\"td-demo-eastcoast-check-pro/td-eastcoast-check-pro-demo.php\";s:5:\"1.0.0\";s:37:\"td-mobile-plugin/td-mobile-plugin.php\";s:31:\"2.7 | built on 27.03.2025 10:27\";s:31:\"td-newsletter/td-newsletter.php\";s:31:\"2.1 | built on 27.03.2025 10:27\";s:35:\"td-subscription/td-subscription.php\";s:33:\"1.7.1 | built on 29.04.2025 10:50\";s:51:\"td-demo-real-estate-pro/td-real-estate-pro-demo.php\";s:5:\"1.0.0\";s:41:\"td-demo-rent-a-car/td-demo-rent-a-car.php\";s:5:\"1.0.0\";s:17:\"td-woo/td-woo.php\";s:31:\"2.6 | built on 10.02.2025 10:50\";s:39:\"td-social-counter/td-social-counter.php\";s:31:\"5.6 | built on 27.03.2025 10:27\";s:37:\"td-standard-pack/td-standard-pack.php\";s:31:\"2.7 | built on 27.03.2025 10:27\";s:27:\"woocommerce/woocommerce.php\";s:5:\"9.8.5\";s:27:\"js_composer/js_composer.php\";s:5:\"8.4.1\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:5:\"2.6.3\";}}", "off");
INSERT INTO `dgfdcv_options` VALUES("6449", "new_admin_email", "bghjgjh@dffgdfg.com", "yes");
INSERT INTO `dgfdcv_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("119", "recovery_keys", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("120", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1649849592;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `dgfdcv_options` VALUES("328", "woocommerce_inbox_variant_assignment", "5", "yes");
INSERT INTO `dgfdcv_options` VALUES("335", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"KEaiGOyKEgkRf0xMAB2zVg6P3SLPusyp\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("333", "action_scheduler_lock_async-request-runner", "682f1b6bade547.37341579|1747917735", "yes");
INSERT INTO `dgfdcv_options` VALUES("334", "woocommerce_admin_notices", "a:1:{i:0;s:6:\"update\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("337", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("338", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("339", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("340", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("341", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("342", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("343", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("344", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("345", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("346", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("347", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("348", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("352", "woocommerce_admin_install_timestamp", "1649849694", "yes");
INSERT INTO `dgfdcv_options` VALUES("353", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `dgfdcv_options` VALUES("351", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `dgfdcv_options` VALUES("123", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:41:\"درخواست HTTPS ناموفق بود.\";}}", "off");
INSERT INTO `dgfdcv_options` VALUES("149", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"bghjgjh@dffgdfg.com\";s:7:\"version\";s:5:\"6.8.1\";s:9:\"timestamp\";i:1747916953;}", "off");
INSERT INTO `dgfdcv_options` VALUES("157", "current_theme", "Newspaper", "yes");
INSERT INTO `dgfdcv_options` VALUES("158", "theme_mods_Newspaper", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:6:{s:0:\"\";i:45;s:8:\"top-menu\";s:0:\"\";s:11:\"header-menu\";s:0:\"\";s:11:\"footer-menu\";s:0:\"\";s:18:\"header-menu-mobile\";s:2:\"45\";s:18:\"footer-menu-mobile\";s:0:\"\";}s:18:\"custom_css_post_id\";i:725;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("159", "theme_switched", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("160", "td_011", "a:518:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.7.1\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:27:\"theme_update_latest_version\";s:85:\"{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:429:\"[{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"},{\"12.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/03\\/Newspaper.zip\"},{\"12.6.9\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/Newspaper.zip\"},{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:90:\"{\"1.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("24849", "td_011_generated_css", "@font-face{font-family:\"iranyekanwebthinfanum\";src:local(\"iranyekanwebthinfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebregularfanum\";src:local(\"iranyekanwebregularfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebmediumfanum\";src:local(\"iranyekanwebmediumfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebextraboldfanum\";src:local(\"iranyekanwebextraboldfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebextrablackfanum\";src:local(\"iranyekanwebextrablackfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");font-display:swap}:root{--td_excl_label:\'انحصاری\'}@font-face{font-family:\"iranyekanwebthinfanum\";src:local(\"iranyekanwebthinfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebregularfanum\";src:local(\"iranyekanwebregularfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebmediumfanum\";src:local(\"iranyekanwebmediumfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebextraboldfanum\";src:local(\"iranyekanwebextraboldfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");font-display:swap}@font-face{font-family:\"iranyekanwebextrablackfanum\";src:local(\"iranyekanwebextrablackfanum\"),url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");font-display:swap}.top-header-menu .menu-item-has-children li a{font-family:iranyekanwebregularfanum}", "auto");
INSERT INTO `dgfdcv_options` VALUES("24850", "_transient_timeout_wpb_notice_list", "1747960381", "off");
INSERT INTO `dgfdcv_options` VALUES("24851", "_transient_wpb_notice_list", "[{\"id\":16,\"title\":\"\\ud83e\\udd73 WPBakery Turns 14: Save Up to 50%\",\"description\":\"It\\u2019s our birthday and we\\u2019re celebrating with our biggest sale yet \\u2013 save up to 50% on multisite and bulk licenses, our new support subscription, and partner hosting. Hurry \\u2013 offers end May 26, 2025.\",\"image\":\"https:\\/\\/s3.us-west-2.amazonaws.com\\/notifications.wpbakery.com\\/wp-dashboard-icon-160x160.1745845267.png\",\"link_type\":0,\"link\":\"https:\\/\\/wpbakery.com\\/birthday-sale\\/?utm_campaign=wpd-bday-25&utm_source=wpdashboard&utm_medium=banner&utm_content=banner&utm_activity=announcement\",\"button_text\":\"Explore Deals\",\"version_from\":\"6.14.0\",\"version_to\":\"8.4.1\",\"date_from\":\"2025-05-12T07:15:00.000000Z\",\"date_to\":\"2025-05-26T23:45:00.000000Z\"}]", "off");
INSERT INTO `dgfdcv_options` VALUES("24852", "wpb_license_errors", "a:0:{}", "auto");
INSERT INTO `dgfdcv_options` VALUES("17608", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[24],\"failedPackageIds\":[]}", "yes");
INSERT INTO `dgfdcv_options` VALUES("17691", "acf_version", "6.3.5", "yes");
INSERT INTO `dgfdcv_options` VALUES("15174", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:25;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("15175", "duplicator_version_plugin", "1.5.12", "yes");
INSERT INTO `dgfdcv_options` VALUES("15180", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-05-22 12:40:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:9:\"newspaper\";s:4:\"Hash\";s:35:\"978f84dac597629a8130_20250522124056\";s:8:\"NameHash\";s:45:\"newspaper_978f84dac597629a8130_20250522124056\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:55:\"newspaper_978f84dac597629a8130_20250522124056_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"F:/laragon/www/news-demo\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2496;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:20185;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-05-22 12:40:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:9:\"newspaper\";s:4:\"Hash\";s:35:\"978f84dac597629a8130_20250522124056\";s:8:\"NameHash\";s:45:\"newspaper_978f84dac597629a8130_20250522124056\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"F:/laragon/www/news-demo/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"F:/laragon/www/news-demo/wp-admin\";i:1;s:36:\"F:/laragon/www/news-demo/wp-includes\";i:2;s:45:\"F:/laragon/www/news-demo/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"F:/laragon/www/news-demo\";i:1;s:24:\"F:/laragon/www/news-demo\";i:2;s:35:\"F:/laragon/www/news-demo/wp-content\";i:3;s:43:\"F:/laragon/www/news-demo/wp-content/uploads\";i:4;s:43:\"F:/laragon/www/news-demo/wp-content/plugins\";i:5;s:46:\"F:/laragon/www/news-demo/wp-content/mu-plugins\";i:6;s:42:\"F:/laragon/www/news-demo/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"F:/laragon/www/news-demo/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("19683", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `dgfdcv_options` VALUES("15181", "duplicator_ui_view_state", "a:6:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:29:\"dup-package-dtl-general-panel\";s:1:\"1\";s:29:\"dup-package-dtl-storage-panel\";s:1:\"1\";s:29:\"dup-package-dtl-archive-panel\";s:1:\"1\";s:29:\"dup-package-dtl-install-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("162", "recently_activated", "a:0:{}", "off");
INSERT INTO `dgfdcv_options` VALUES("166", "widget_td_block_ad_box_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("167", "widget_td_block_authors_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("168", "widget_td_block_author_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("169", "widget_td_block_popular_categories_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("170", "widget_td_block_slide_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("171", "widget_td_block_text_with_title_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("172", "widget_td_block_weather_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("173", "widget_td_block_exchange_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("174", "widget_td_block_instagram_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("175", "widget_td_block_pinterest_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("176", "widget_td_block_image_box_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("178", "td_011_settings", "a:5:{s:19:\"2025-05-22 16:03:01\";a:519:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.6.9\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:20:\"tds_user_compile_css\";s:4628:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n:root{--td_excl_label:\'انحصاری\';}\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n.top-header-menu .menu-item-has-children li a {\r\n    	font-family:iranyekanwebregularfanum;\n	\r\n    }\";s:27:\"theme_update_latest_version\";s:85:\"{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:429:\"[{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"},{\"12.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/03\\/Newspaper.zip\"},{\"12.6.9\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/Newspaper.zip\"},{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:90:\"{\"1.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}s:19:\"2025-04-30 15:21:22\";a:519:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.6.9\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:20:\"tds_user_compile_css\";s:4628:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n:root{--td_excl_label:\'انحصاری\';}\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n.top-header-menu .menu-item-has-children li a {\r\n    	font-family:iranyekanwebregularfanum;\n	\r\n    }\";s:27:\"theme_update_latest_version\";s:85:\"{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:515:\"[{\"12.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/Newspaper.zip\"},{\"12.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/03\\/Newspaper.zip\"},{\"12.6.9\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/Newspaper.zip\"},{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"},{\"12.6.6\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/05\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:90:\"{\"1.7.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/04\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}s:19:\"2025-02-15 15:07:42\";a:519:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.6.8\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:20:\"tds_user_compile_css\";s:4628:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n:root{--td_excl_label:\'انحصاری\';}\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n.top-header-menu .menu-item-has-children li a {\r\n    	font-family:iranyekanwebregularfanum;\n	\r\n    }\";s:27:\"theme_update_latest_version\";s:85:\"{\"12.6.9\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:603:\"[{\"12.6.9\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/Newspaper.zip\"},{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"},{\"12.6.6\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/05\\/Newspaper.zip\"},{\"12.6.5\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/03\\/Newspaper.zip\"},{\"12.6.4\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/02\\/Newspaper.zip\"},{\"12.6.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2023\\/12\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:88:\"{\"1.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2025\\/02\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}s:19:\"2024-10-02 09:09:03\";a:519:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.6.8\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:20:\"tds_user_compile_css\";s:4628:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n:root{--td_excl_label:\'انحصاری\';}\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n.top-header-menu .menu-item-has-children li a {\r\n    	font-family:iranyekanwebregularfanum;\n	\r\n    }\";s:27:\"theme_update_latest_version\";s:85:\"{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:517:\"[{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"},{\"12.6.6\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/05\\/Newspaper.zip\"},{\"12.6.5\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/03\\/Newspaper.zip\"},{\"12.6.4\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/02\\/Newspaper.zip\"},{\"12.6.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2023\\/12\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:90:\"{\"1.6.2\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}s:19:\"2024-10-02 08:56:58\";a:519:{s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:18:\"tds_thumb_td_0x420\";s:3:\"yes\";s:18:\"tds_thumb_td_80x60\";s:3:\"yes\";s:19:\"tds_thumb_td_100x70\";s:3:\"yes\";s:20:\"tds_thumb_td_324x160\";s:3:\"yes\";s:20:\"tds_thumb_td_324x235\";s:3:\"yes\";s:20:\"tds_thumb_td_356x220\";s:3:\"yes\";s:20:\"tds_thumb_td_356x364\";s:3:\"yes\";s:20:\"tds_thumb_td_533x261\";s:3:\"yes\";s:20:\"tds_thumb_td_534x462\";s:3:\"yes\";s:20:\"tds_thumb_td_696x385\";s:3:\"yes\";s:21:\"tds_thumb_td_1068x580\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:21:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";b:0;s:6:\"reddit\";b:0;s:4:\"mail\";b:0;s:5:\"print\";b:0;s:6:\"tumblr\";b:0;s:8:\"telegram\";b:0;s:11:\"stumbleupon\";b:0;s:2:\"vk\";b:0;s:4:\"digg\";b:0;s:4:\"line\";b:0;s:5:\"viber\";b:0;s:5:\"naver\";b:0;s:9:\"flipboard\";b:0;s:8:\"copy_url\";b:0;s:5:\"kakao\";b:0;s:5:\"gettr\";b:0;s:3:\"koo\";b:0;}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"12.6.8\";s:16:\"td_updated_fonts\";b:1;s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1656184188;s:11:\"test_status\";s:9:\"wordpress\";}s:9:\"td_011_tp\";i:1656221216;s:19:\"tdb_header_template\";s:16:\"tdb_template_186\";s:16:\"tds_header_style\";s:1:\"4\";s:20:\"tds_search_placement\";s:0:\"\";s:11:\"tds_top_bar\";s:0:\"\";s:20:\"tds_top_bar_template\";s:0:\"\";s:12:\"tds_top_menu\";s:0:\"\";s:23:\"td_social_networks_show\";s:0:\"\";s:17:\"tds_data_top_menu\";s:0:\"\";s:20:\"tds_data_time_format\";s:0:\"\";s:11:\"tds_data_js\";s:0:\"\";s:20:\"tds_weather_top_menu\";s:0:\"\";s:24:\"tds_weather_key_top_menu\";s:0:\"\";s:29:\"tds_weather_location_top_menu\";s:0:\"\";s:26:\"tds_weather_units_top_menu\";s:0:\"\";s:29:\"tds_mega_menu_ajax_preloading\";s:0:\"\";s:13:\"tds_snap_menu\";s:0:\"\";s:18:\"tds_logo_on_sticky\";s:0:\"\";s:28:\"td_social_networks_menu_show\";s:0:\"\";s:15:\"tds_logo_upload\";s:0:\"\";s:17:\"tds_logo_upload_r\";s:0:\"\";s:18:\"tds_favicon_upload\";s:0:\"\";s:12:\"tds_logo_alt\";s:0:\"\";s:14:\"tds_logo_title\";s:0:\"\";s:13:\"tds_logo_text\";s:0:\"\";s:16:\"tds_tagline_text\";s:0:\"\";s:20:\"tds_logo_menu_upload\";s:0:\"\";s:22:\"tds_logo_menu_upload_r\";s:0:\"\";s:11:\"tds_captcha\";s:0:\"\";s:20:\"tds_captcha_site_key\";s:0:\"\";s:22:\"tds_captcha_secret_key\";s:0:\"\";s:17:\"tds_captcha_score\";s:0:\"\";s:27:\"tds_header_background_image\";s:0:\"\";s:28:\"tds_header_background_repeat\";s:0:\"\";s:26:\"tds_header_background_size\";s:0:\"\";s:30:\"tds_header_background_position\";s:0:\"\";s:29:\"tds_header_background_opacity\";s:0:\"\";s:15:\"tds_ios_icon_76\";s:0:\"\";s:16:\"tds_ios_icon_114\";s:0:\"\";s:16:\"tds_ios_icon_120\";s:0:\"\";s:16:\"tds_ios_icon_144\";s:0:\"\";s:16:\"tds_ios_icon_152\";s:0:\"\";s:19:\"tdb_footer_template\";s:16:\"tdb_template_185\";s:10:\"tds_footer\";s:0:\"\";s:19:\"tds_footer_template\";s:0:\"\";s:15:\"tds_footer_page\";s:0:\"\";s:20:\"tds_footer_instagram\";s:0:\"\";s:23:\"tds_footer_instagram_id\";s:0:\"\";s:29:\"tds_footer_instagram_business\";s:0:\"\";s:41:\"tds_footer_instagram_on_row_images_number\";s:0:\"\";s:32:\"tds_footer_instagram_rows_number\";s:0:\"\";s:31:\"tds_footer_instagram_image_size\";s:0:\"\";s:30:\"tds_footer_instagram_image_gap\";s:0:\"\";s:22:\"tds_footer_logo_upload\";s:0:\"\";s:29:\"tds_footer_retina_logo_upload\";s:0:\"\";s:19:\"tds_footer_logo_alt\";s:0:\"\";s:21:\"tds_footer_logo_title\";s:0:\"\";s:15:\"tds_footer_text\";s:0:\"\";s:16:\"tds_footer_email\";s:0:\"\";s:17:\"tds_footer_social\";s:0:\"\";s:27:\"tds_footer_background_image\";s:0:\"\";s:28:\"tds_footer_background_repeat\";s:0:\"\";s:26:\"tds_footer_background_size\";s:0:\"\";s:30:\"tds_footer_background_position\";s:0:\"\";s:29:\"tds_footer_background_opacity\";s:0:\"\";s:14:\"tds_sub_footer\";s:0:\"\";s:23:\"tds_sub_footer_template\";s:0:\"\";s:20:\"tds_footer_copyright\";s:0:\"\";s:22:\"tds_footer_copy_symbol\";s:0:\"\";s:18:\"tds_modal_video_ad\";s:0:\"\";s:24:\"tds_modal_video_ad_title\";s:0:\"\";s:26:\"tds_modal_video_ad_disable\";s:0:\"\";s:24:\"tds_background_click_url\";s:0:\"\";s:27:\"tds_background_click_target\";s:0:\"\";s:17:\"tds_smart_sidebar\";s:7:\"enabled\";s:10:\"tds_to_top\";s:0:\"\";s:20:\"tds_to_top_on_mobile\";s:0:\"\";s:20:\"tds_breadcrumbs_show\";s:0:\"\";s:25:\"tds_breadcrumbs_show_home\";s:0:\"\";s:27:\"tds_breadcrumbs_show_parent\";s:0:\"\";s:28:\"tds_breadcrumbs_show_article\";s:0:\"\";s:19:\"tds_animation_stack\";s:0:\"\";s:26:\"tds_animation_stack_effect\";s:0:\"\";s:15:\"td_full_top_bar\";s:0:\"\";s:14:\"td_full_header\";s:0:\"\";s:12:\"td_full_menu\";s:0:\"\";s:25:\"td_full_header_background\";s:0:\"\";s:24:\"td_full_footer_instagram\";s:0:\"\";s:14:\"td_full_footer\";s:0:\"\";s:19:\"tds_404_page_layout\";s:0:\"\";s:23:\"tds_archive_page_layout\";s:0:\"\";s:23:\"tds_archive_sidebar_pos\";s:0:\"\";s:19:\"tds_archive_sidebar\";s:0:\"\";s:26:\"tds_attachment_sidebar_pos\";s:0:\"\";s:22:\"tds_attachment_sidebar\";s:0:\"\";s:22:\"tds_author_page_layout\";s:0:\"\";s:22:\"tds_author_sidebar_pos\";s:0:\"\";s:18:\"tds_author_sidebar\";s:0:\"\";s:20:\"tds_home_page_layout\";s:0:\"\";s:20:\"tds_home_sidebar_pos\";s:0:\"\";s:16:\"tds_home_sidebar\";s:19:\"نوار کناری\";s:20:\"tds_page_layout_size\";s:0:\"\";s:20:\"tds_page_sidebar_pos\";s:0:\"\";s:16:\"tds_page_sidebar\";s:0:\"\";s:26:\"tds_disable_comments_pages\";s:0:\"\";s:22:\"tds_search_page_layout\";s:0:\"\";s:22:\"tds_search_sidebar_pos\";s:0:\"\";s:18:\"tds_search_sidebar\";s:0:\"\";s:19:\"tds_tag_page_layout\";s:0:\"\";s:19:\"tds_tag_sidebar_pos\";s:0:\"\";s:15:\"tds_tag_sidebar\";s:0:\"\";s:19:\"tds_woo_sidebar_pos\";s:0:\"\";s:15:\"tds_woo_sidebar\";s:0:\"\";s:26:\"tds_woo_single_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_single_sidebar\";s:0:\"\";s:23:\"tds_bbpress_sidebar_pos\";s:0:\"\";s:19:\"tds_bbpress_sidebar\";s:0:\"\";s:36:\"tds_taxonomy_post_format_page_layout\";s:0:\"\";s:36:\"tds_taxonomy_post_format_sidebar_pos\";s:0:\"\";s:32:\"tds_taxonomy_post_format_sidebar\";s:0:\"\";s:21:\"tdb_category_template\";s:16:\"tdb_template_183\";s:21:\"tds_category_template\";s:0:\"\";s:22:\"tds_category_pull_down\";s:0:\"\";s:28:\"tds_category_top_posts_style\";s:0:\"\";s:26:\"tds_category_td_grid_style\";s:15:\"td-grid-style-1\";s:24:\"tds_category_page_layout\";s:0:\"\";s:29:\"tds_category_pagination_style\";s:0:\"\";s:24:\"tds_category_sidebar_pos\";s:0:\"\";s:20:\"tds_category_sidebar\";s:0:\"\";s:23:\"tds_general_modal_image\";s:0:\"\";s:26:\"tds_disable_article_schema\";s:0:\"\";s:29:\"td_default_site_post_template\";s:16:\"tdb_template_184\";s:21:\"tds_p_categories_tags\";s:0:\"\";s:28:\"tds_default_category_display\";s:0:\"\";s:22:\"tds_p_show_author_name\";s:0:\"\";s:15:\"tds_p_show_date\";s:0:\"\";s:16:\"tds_p_show_views\";s:0:\"\";s:19:\"tds_p_show_comments\";s:0:\"\";s:13:\"tds_show_tags\";s:0:\"\";s:19:\"tds_show_author_box\";s:0:\"\";s:18:\"tds_show_next_prev\";s:0:\"\";s:29:\"tds_disable_comments_sidewide\";s:0:\"\";s:23:\"tds_show_featured_image\";s:0:\"\";s:35:\"tds_hide_featured_image_placeholder\";s:0:\"\";s:31:\"tds_featured_image_view_setting\";s:0:\"\";s:20:\"tds_similar_articles\";s:0:\"\";s:25:\"tds_similar_articles_type\";s:0:\"\";s:25:\"tds_similar_articles_rows\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_enable\";s:0:\"\";s:49:\"tds_more_articles_on_post_pages_distance_from_top\";s:0:\"\";s:39:\"tds_more_articles_on_post_pages_display\";s:0:\"\";s:46:\"tds_more_articles_on_post_pages_display_module\";s:0:\"\";s:38:\"tds_more_articles_on_post_pages_number\";s:0:\"\";s:44:\"tds_more_articles_on_post_pages_time_to_wait\";s:0:\"\";s:24:\"tds_ajax_post_view_count\";s:0:\"\";s:21:\"tds_video_playing_one\";s:0:\"\";s:22:\"tds_video_pause_hidden\";s:0:\"\";s:14:\"tds_video_lazy\";s:0:\"\";s:16:\"tds_video_scroll\";s:0:\"\";s:15:\"tds_video_width\";s:0:\"\";s:20:\"tds_video_position_v\";s:0:\"\";s:20:\"tds_video_distance_v\";s:0:\"\";s:20:\"tds_video_position_h\";s:0:\"\";s:20:\"tds_video_distance_h\";s:0:\"\";s:25:\"tds_global_block_template\";s:20:\"td_block_template_14\";s:25:\"tds_category_module_slide\";s:0:\"\";s:29:\"tds_category_module_mega_menu\";s:0:\"\";s:21:\"tds_category_module_1\";s:0:\"\";s:21:\"tds_category_module_2\";s:0:\"\";s:21:\"tds_category_module_3\";s:0:\"\";s:21:\"tds_category_module_4\";s:0:\"\";s:21:\"tds_category_module_5\";s:0:\"\";s:21:\"tds_category_module_6\";s:0:\"\";s:21:\"tds_category_module_7\";s:0:\"\";s:21:\"tds_category_module_8\";s:0:\"\";s:21:\"tds_category_module_9\";s:0:\"\";s:22:\"tds_category_module_10\";s:0:\"\";s:22:\"tds_category_module_11\";s:0:\"\";s:22:\"tds_category_module_12\";s:0:\"\";s:22:\"tds_category_module_13\";s:0:\"\";s:22:\"tds_category_module_14\";s:0:\"\";s:22:\"tds_category_module_15\";s:0:\"\";s:22:\"tds_category_module_16\";s:0:\"\";s:22:\"tds_category_module_17\";s:0:\"\";s:22:\"tds_category_module_18\";s:0:\"\";s:22:\"tds_category_module_19\";s:0:\"\";s:23:\"tds_category_module_mx1\";s:0:\"\";s:23:\"tds_category_module_mx2\";s:0:\"\";s:23:\"tds_category_module_mx3\";s:0:\"\";s:23:\"tds_category_module_mx4\";s:0:\"\";s:23:\"tds_category_module_mx5\";s:0:\"\";s:23:\"tds_category_module_mx6\";s:0:\"\";s:23:\"tds_category_module_mx7\";s:0:\"\";s:23:\"tds_category_module_mx8\";s:0:\"\";s:23:\"tds_category_module_mx9\";s:0:\"\";s:24:\"tds_category_module_mx10\";s:0:\"\";s:24:\"tds_category_module_mx11\";s:0:\"\";s:24:\"tds_category_module_mx12\";s:0:\"\";s:24:\"tds_category_module_mx13\";s:0:\"\";s:24:\"tds_category_module_mx14\";s:0:\"\";s:24:\"tds_category_module_mx15\";s:0:\"\";s:24:\"tds_category_module_mx16\";s:0:\"\";s:24:\"tds_category_module_mx17\";s:0:\"\";s:24:\"tds_category_module_mx18\";s:0:\"\";s:24:\"tds_category_module_mx19\";s:0:\"\";s:24:\"tds_category_module_mx20\";s:0:\"\";s:24:\"tds_category_module_mx21\";s:0:\"\";s:24:\"tds_category_module_mx22\";s:0:\"\";s:24:\"tds_category_module_mx23\";s:0:\"\";s:24:\"tds_category_module_mx24\";s:0:\"\";s:24:\"tds_category_module_mx25\";s:0:\"\";s:24:\"tds_category_module_mx26\";s:0:\"\";s:33:\"tds_category_module_related_posts\";s:0:\"\";s:22:\"tds_m_show_author_name\";s:0:\"\";s:15:\"tds_m_show_date\";s:0:\"\";s:24:\"tds_m_show_modified_date\";s:0:\"\";s:19:\"tds_m_show_comments\";s:0:\"\";s:17:\"tds_m_show_review\";s:0:\"\";s:20:\"tds_m_nofollow_image\";s:0:\"\";s:25:\"tds_p_enable_7_days_count\";s:0:\"\";s:25:\"tds_site_background_image\";s:0:\"\";s:26:\"tds_site_background_repeat\";s:0:\"\";s:30:\"tds_site_background_position_x\";s:0:\"\";s:30:\"tds_site_background_attachment\";s:0:\"\";s:22:\"tds_stretch_background\";s:0:\"\";s:27:\"tds_mobile_background_image\";s:0:\"\";s:28:\"tds_mobile_background_repeat\";s:0:\"\";s:26:\"tds_mobile_background_size\";s:0:\"\";s:30:\"tds_mobile_background_position\";s:0:\"\";s:26:\"tds_login_background_image\";s:0:\"\";s:27:\"tds_login_background_repeat\";s:0:\"\";s:25:\"tds_login_background_size\";s:0:\"\";s:29:\"tds_login_background_position\";s:0:\"\";s:17:\"tds_excerpts_type\";s:0:\"\";s:29:\"td_module_slide_title_excerpt\";s:0:\"\";s:33:\"td_module_mega_menu_title_excerpt\";s:0:\"\";s:36:\"td_module_trending_now_title_excerpt\";s:0:\"\";s:25:\"td_module_1_title_excerpt\";s:0:\"\";s:25:\"td_module_2_title_excerpt\";s:0:\"\";s:27:\"td_module_2_content_excerpt\";s:0:\"\";s:25:\"td_module_3_title_excerpt\";s:0:\"\";s:25:\"td_module_4_title_excerpt\";s:0:\"\";s:27:\"td_module_4_content_excerpt\";s:0:\"\";s:25:\"td_module_5_title_excerpt\";s:0:\"\";s:27:\"td_module_5_content_excerpt\";s:0:\"\";s:25:\"td_module_6_title_excerpt\";s:0:\"\";s:25:\"td_module_7_title_excerpt\";s:0:\"\";s:25:\"td_module_8_title_excerpt\";s:0:\"\";s:25:\"td_module_9_title_excerpt\";s:0:\"\";s:26:\"td_module_10_title_excerpt\";s:0:\"\";s:28:\"td_module_10_content_excerpt\";s:0:\"\";s:26:\"td_module_11_title_excerpt\";s:0:\"\";s:28:\"td_module_11_content_excerpt\";s:0:\"\";s:26:\"td_module_12_title_excerpt\";s:0:\"\";s:28:\"td_module_12_content_excerpt\";s:0:\"\";s:26:\"td_module_13_title_excerpt\";s:0:\"\";s:26:\"td_module_14_title_excerpt\";s:0:\"\";s:28:\"td_module_14_content_excerpt\";s:0:\"\";s:26:\"td_module_16_title_excerpt\";s:0:\"\";s:28:\"td_module_16_content_excerpt\";s:0:\"\";s:26:\"td_module_17_title_excerpt\";s:0:\"\";s:28:\"td_module_17_content_excerpt\";s:0:\"\";s:26:\"td_module_18_title_excerpt\";s:0:\"\";s:28:\"td_module_18_content_excerpt\";s:0:\"\";s:26:\"td_module_19_title_excerpt\";s:0:\"\";s:28:\"td_module_19_content_excerpt\";s:0:\"\";s:27:\"td_module_mx1_title_excerpt\";s:0:\"\";s:27:\"td_module_mx2_title_excerpt\";s:0:\"\";s:27:\"td_module_mx3_title_excerpt\";s:0:\"\";s:27:\"td_module_mx4_title_excerpt\";s:0:\"\";s:27:\"td_module_mx5_title_excerpt\";s:0:\"\";s:27:\"td_module_mx6_title_excerpt\";s:0:\"\";s:27:\"td_module_mx7_title_excerpt\";s:0:\"\";s:29:\"td_module_mx7_content_excerpt\";s:0:\"\";s:27:\"td_module_mx8_title_excerpt\";s:0:\"\";s:27:\"td_module_mx9_title_excerpt\";s:0:\"\";s:28:\"td_module_mx10_title_excerpt\";s:0:\"\";s:28:\"td_module_mx11_title_excerpt\";s:0:\"\";s:28:\"td_module_mx12_title_excerpt\";s:0:\"\";s:28:\"td_module_mx13_title_excerpt\";s:0:\"\";s:28:\"td_module_mx14_title_excerpt\";s:0:\"\";s:28:\"td_module_mx15_title_excerpt\";s:0:\"\";s:28:\"td_module_mx16_title_excerpt\";s:0:\"\";s:30:\"td_module_mx16_content_excerpt\";s:0:\"\";s:28:\"td_module_mx17_title_excerpt\";s:0:\"\";s:28:\"td_module_mx18_title_excerpt\";s:0:\"\";s:28:\"td_module_mx19_title_excerpt\";s:0:\"\";s:28:\"td_module_mx20_title_excerpt\";s:0:\"\";s:28:\"td_module_mx21_title_excerpt\";s:0:\"\";s:28:\"td_module_mx22_title_excerpt\";s:0:\"\";s:28:\"td_module_mx23_title_excerpt\";s:0:\"\";s:28:\"td_module_mx24_title_excerpt\";s:0:\"\";s:28:\"td_module_mx25_title_excerpt\";s:0:\"\";s:28:\"td_module_mx26_title_excerpt\";s:0:\"\";s:37:\"td_module_related_posts_title_excerpt\";s:0:\"\";s:12:\"tds_language\";s:0:\"\";s:21:\"tds_header_wrap_color\";s:0:\"\";s:19:\"tds_text_logo_color\";s:0:\"\";s:27:\"tds_text_logo_tagline_color\";s:0:\"\";s:16:\"tds_footer_color\";s:0:\"\";s:21:\"tds_footer_text_color\";s:0:\"\";s:28:\"tds_footer_widget_text_color\";s:0:\"\";s:29:\"tds_footer_social_icons_color\";s:0:\"\";s:35:\"tds_footer_social_icons_hover_color\";s:0:\"\";s:23:\"tds_footer_bottom_color\";s:0:\"\";s:28:\"tds_footer_bottom_text_color\";s:0:\"\";s:29:\"tds_footer_bottom_hover_color\";s:0:\"\";s:18:\"g_use_google_fonts\";s:0:\"\";s:22:\"g_mob_use_google_fonts\";s:0:\"\";s:14:\"tds_custom_css\";s:0:\"\";s:26:\"tds_responsive_css_desktop\";s:0:\"\";s:33:\"tds_responsive_css_ipad_landscape\";s:0:\"\";s:32:\"tds_responsive_css_ipad_portrait\";s:0:\"\";s:24:\"tds_responsive_css_phone\";s:0:\"\";s:15:\"td_body_classes\";s:0:\"\";s:21:\"tds_custom_javascript\";s:0:\"\";s:15:\"tds_custom_html\";s:0:\"\";s:12:\"td_analytics\";s:0:\"\";s:12:\"td_body_code\";s:0:\"\";s:14:\"td_footer_code\";s:0:\"\";s:19:\"tds_top_social_show\";s:0:\"\";s:17:\"tds_top_like_show\";s:0:\"\";s:28:\"tds_top_like_share_text_show\";s:0:\"\";s:28:\"tds_social_sharing_top_style\";s:0:\"\";s:22:\"tds_bottom_social_show\";s:0:\"\";s:20:\"tds_bottom_like_show\";s:0:\"\";s:31:\"tds_bottom_like_share_text_show\";s:0:\"\";s:31:\"tds_social_sharing_bottom_style\";s:0:\"\";s:20:\"tds_tweeter_username\";s:0:\"\";s:26:\"tds_social_login_fb_enable\";s:5:\"false\";s:26:\"tds_social_login_fb_app_id\";s:0:\"\";s:14:\"tds_yt_api_key\";s:0:\"\";s:18:\"tds_flickr_api_key\";s:0:\"\";s:12:\"tds_rel_type\";s:0:\"\";s:7:\"tdm_amp\";s:0:\"\";s:16:\"tdm_is_multisite\";s:0:\"\";s:15:\"tdm_sticky_menu\";s:0:\"\";s:16:\"tds_login_mobile\";s:0:\"\";s:19:\"tds_live_search_mob\";s:0:\"\";s:14:\"tds_h1_on_logo\";s:0:\"\";s:19:\"tds_theme_color_mob\";s:0:\"\";s:23:\"tds_menu_background_mob\";s:0:\"\";s:23:\"tds_menu_icon_color_mob\";s:0:\"\";s:25:\"tds_menu_gradient_one_mob\";s:0:\"\";s:25:\"tds_menu_gradient_two_mob\";s:0:\"\";s:23:\"tds_menu_text_color_mob\";s:0:\"\";s:30:\"tds_menu_text_active_color_mob\";s:0:\"\";s:30:\"tds_menu_button_background_mob\";s:0:\"\";s:25:\"tds_menu_button_color_mob\";s:0:\"\";s:25:\"tds_footer_background_mob\";s:0:\"\";s:25:\"tds_footer_text_color_mob\";s:0:\"\";s:29:\"tds_sub_footer_background_mob\";s:0:\"\";s:29:\"tds_sub_footer_text_color_mob\";s:0:\"\";s:31:\"tds_mobile_background_image_mob\";s:0:\"\";s:32:\"tds_mobile_background_repeat_mob\";s:0:\"\";s:30:\"tds_mobile_background_size_mob\";s:0:\"\";s:34:\"tds_mobile_background_position_mob\";s:0:\"\";s:16:\"tds_ad_title_mob\";s:0:\"\";s:22:\"tds_loop_ad_module_mob\";s:0:\"\";s:27:\"tds_inline_ad_paragraph_mob\";s:0:\"\";s:17:\"tdm_amp_ads_title\";s:0:\"\";s:17:\"tdm_amp_analytics\";s:0:\"\";s:15:\"tdm_smartlist_2\";s:0:\"\";s:29:\"td_module_mob_1_title_excerpt\";s:0:\"\";s:29:\"td_module_mob_2_title_excerpt\";s:0:\"\";s:18:\"tds_custom_css_mob\";s:0:\"\";s:25:\"tds_custom_javascript_mob\";s:0:\"\";s:19:\"tds_custom_html_mob\";s:0:\"\";s:18:\"tdm_frontpage_grid\";s:0:\"\";s:17:\"tdm_category_grid\";s:0:\"\";s:21:\"tdm_grids_posts_limit\";s:0:\"\";s:29:\"tdm_frontpage_grid_cat_filter\";s:0:\"\";s:41:\"tdm_frontpage_latest_articles_posts_limit\";s:0:\"\";s:25:\"tds_category_mobule_mob_1\";s:0:\"\";s:25:\"tds_category_mobule_mob_2\";s:0:\"\";s:20:\"tds_m_show_exclusive\";s:0:\"\";s:10:\"tds_button\";s:0:\"\";s:14:\"tdm_btn_radius\";s:0:\"\";s:9:\"tds_title\";s:0:\"\";s:16:\"tdm_phone_number\";s:0:\"\";s:9:\"tdm_email\";s:0:\"\";s:14:\"tdm_extra_info\";s:0:\"\";s:21:\"tdm_info_show_top_bar\";s:0:\"\";s:24:\"tdm_info_show_sub_footer\";s:0:\"\";s:20:\"tdm_bordered_website\";s:0:\"\";s:15:\"tdm_menu_active\";s:0:\"\";s:19:\"tdm_menu_btn1_style\";s:0:\"\";s:18:\"tdm_menu_btn1_text\";s:0:\"\";s:17:\"tdm_menu_btn1_url\";s:0:\"\";s:32:\"tdm_menu_btn1_open_in_new_window\";s:0:\"\";s:19:\"tdm_menu_btn2_style\";s:0:\"\";s:18:\"tdm_menu_btn2_text\";s:0:\"\";s:17:\"tdm_menu_btn2_url\";s:0:\"\";s:32:\"tdm_menu_btn2_open_in_new_window\";s:0:\"\";s:24:\"tdm_menu_btn1_base_color\";s:0:\"\";s:24:\"tdm_menu_btn2_base_color\";s:0:\"\";s:24:\"tdm_menu_btn1_text_color\";s:0:\"\";s:24:\"tdm_menu_btn2_text_color\";s:0:\"\";s:30:\"tdm_menu_btn1_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_base_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn1_text_hover_color\";s:0:\"\";s:30:\"tdm_menu_btn2_text_hover_color\";s:0:\"\";s:22:\"td_fonts_user_inserted\";a:31:{s:11:\"font_file_1\";s:80:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\";s:13:\"font_family_1\";s:21:\"iranyekanwebthinfanum\";s:11:\"font_file_2\";s:83:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\";s:13:\"font_family_2\";s:24:\"iranyekanwebregularfanum\";s:11:\"font_file_3\";s:82:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\";s:13:\"font_family_3\";s:23:\"iranyekanwebmediumfanum\";s:11:\"font_file_4\";s:85:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\";s:13:\"font_family_4\";s:26:\"iranyekanwebextraboldfanum\";s:11:\"font_file_5\";s:86:\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\";s:13:\"font_family_5\";s:27:\"iranyekanwebextrablackfanum\";s:10:\"typekit_js\";s:0:\"\";s:22:\"type_kit_font_family_1\";s:0:\"\";s:22:\"type_kit_font_family_2\";s:0:\"\";s:22:\"type_kit_font_family_3\";s:0:\"\";s:10:\"g_100_thin\";s:0:\"\";s:17:\"g_100_thin_italic\";s:0:\"\";s:17:\"g_200_extra_light\";s:0:\"\";s:24:\"g_200_extra_light_italic\";s:0:\"\";s:11:\"g_300_light\";s:0:\"\";s:18:\"g_300_light_italic\";s:0:\"\";s:19:\"g_400_normal_italic\";s:0:\"\";s:12:\"g_500_medium\";s:0:\"\";s:19:\"g_500_medium_italic\";s:0:\"\";s:15:\"g_600_semi_bold\";s:0:\"\";s:22:\"g_600_semi_bold_italic\";s:0:\"\";s:10:\"g_700_bold\";s:0:\"\";s:17:\"g_700_bold_italic\";s:0:\"\";s:16:\"g_800_extra_bold\";s:0:\"\";s:23:\"g_800_extra_bold_italic\";s:0:\"\";s:11:\"g_900_black\";s:0:\"\";s:18:\"g_900_black_italic\";s:0:\"\";}s:19:\"td_fonts_css_buffer\";s:2243:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \";s:18:\"td_fonts_js_buffer\";s:0:\"\";s:16:\"td_fonts_default\";a:1:{s:13:\"default_fonts\";s:0:\"\";}s:8:\"td_fonts\";a:31:{s:12:\"top_sub_menu\";a:1:{s:11:\"font_family\";s:6:\"file_2\";}s:16:\"mt_main_menu_mob\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_text_logo\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_tagline_text\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:17:\"mt_module_general\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:11:\"mt_module_2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_post_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:15:\"mt_post_content\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_blockquote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_box_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:13:\"mt_pull_quote\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:8:\"mt_lists\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h1\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h2\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h3\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h4\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h5\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:5:\"mt_h6\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:16:\"mt_post_category\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_post_author\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:12:\"mt_post_date\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:22:\"mt_post_views_comments\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_via_source_tags\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:23:\"mt_post_next_prev_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:18:\"mt_post_author_url\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_post_author_descr\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:21:\"mt_post_related_title\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:20:\"mt_footer_text_about\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:19:\"mt_footer_copyright\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}s:14:\"mt_footer_menu\";a:1:{s:11:\"font_family\";s:4:\"fs_1\";}}s:6:\"td_ads\";a:8:{s:10:\"header_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:10:\"footer_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:14:\"smart_list_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:8:\"loop_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:15:\"content_top_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_bottom_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:18:\"content_inline_mob\";a:1:{s:7:\"ad_code\";s:0:\"\";}s:16:\"tdm_amp_auto_ads\";a:1:{s:7:\"ad_code\";s:0:\"\";}}s:20:\"tds_user_compile_css\";s:4628:\"\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n:root{--td_excl_label:\'انحصاری\';}\r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebthinfanum\";\r\n                                      src: local(\"iranyekanwebthinfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebthinfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebregularfanum\";\r\n                                      src: local(\"iranyekanwebregularfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebregularfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebmediumfanum\";\r\n                                      src: local(\"iranyekanwebmediumfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebmediumfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextraboldfanum\";\r\n                                      src: local(\"iranyekanwebextraboldfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextraboldfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \r\n                                    @font-face {\r\n                                      font-family: \"iranyekanwebextrablackfanum\";\r\n                                      src: local(\"iranyekanwebextrablackfanum\"), url(\"http://localhost/news-demo/wp-content/uploads/2024/01/iranyekanwebextrablackfanum.woff\") format(\"woff\");\r\n                                      font-display: swap;\r\n                                    }\r\n                                \n.top-header-menu .menu-item-has-children li a {\r\n    	font-family:iranyekanwebregularfanum;\n	\r\n    }\";s:27:\"theme_update_latest_version\";s:85:\"{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:517:\"[{\"12.6.8\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/Newspaper.zip\"},{\"12.6.7\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/08\\/Newspaper.zip\"},{\"12.6.6\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/05\\/Newspaper.zip\"},{\"12.6.5\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/03\\/Newspaper.zip\"},{\"12.6.4\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/02\\/Newspaper.zip\"},{\"12.6.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2023\\/12\\/Newspaper.zip\"}]\";s:41:\"plugin_subscription_update_latest_version\";s:90:\"{\"1.6.2\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2024\\/09\\/td-subscription.zip\"}\";s:16:\"tdb_404_template\";s:16:\"tdb_template_182\";s:19:\"tdb_author_template\";s:16:\"tdb_template_177\";s:23:\"tdb_attachment_template\";s:16:\"tdb_template_179\";s:17:\"tdb_date_template\";s:16:\"tdb_template_178\";s:19:\"tdb_search_template\";s:16:\"tdb_template_181\";s:16:\"tdb_tag_template\";s:16:\"tdb_template_180\";s:21:\"tdb_p_autoload_status\";s:3:\"off\";s:19:\"tdb_p_autoload_type\";s:0:\"\";s:20:\"tdb_p_autoload_count\";s:0:\"\";s:29:\"tdb_p_autoload_scroll_percent\";s:0:\"\";s:9:\"td_011_ta\";s:7:\"lp_sent\";s:28:\"td_theme_deactivated_plugins\";a:4:{s:11:\"td-composer\";s:32:\"def8edc4e13d95bdf49953a9dce2f608\";s:16:\"td-cloud-library\";s:32:\"b33652f2535d2f3812f59e306e26300d\";s:16:\"td-standard-pack\";s:32:\"1b3d5bf2c64738aa07b4643e31257da9\";s:6:\"td-woo\";s:32:\"085843b7bc6cdbfd91bea15b506c2586\";}s:23:\"theme_update_to_version\";s:0:\"\";s:17:\"tds_logo_h1_pages\";s:0:\"\";s:27:\"tds_search_taxonomies_terms\";s:0:\"\";s:35:\"tds_general_modal_image_disable_mob\";s:0:\"\";s:26:\"tds_smart_list_modal_image\";s:0:\"\";s:11:\"tds_reviews\";s:0:\"\";s:27:\"tds_aggregate_rating_schema\";s:0:\"\";s:27:\"tds_loader_background_image\";s:0:\"\";s:24:\"tds_tweeter_username_via\";s:0:\"\";s:14:\"tds_gm_api_key\";s:0:\"\";s:24:\"tds_twitch_api_client_id\";s:0:\"\";s:28:\"tds_twitch_api_client_secret\";s:0:\"\";s:31:\"tds_woo_archive_cat_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_cat_sidebar\";s:0:\"\";s:31:\"tds_woo_archive_tag_sidebar_pos\";s:0:\"\";s:27:\"tds_woo_archive_tag_sidebar\";s:0:\"\";s:32:\"tds_woo_archive_atts_sidebar_pos\";s:0:\"\";s:28:\"tds_woo_archive_atts_sidebar\";s:0:\"\";s:26:\"tds_woo_search_sidebar_pos\";s:0:\"\";s:22:\"tds_woo_search_sidebar\";s:0:\"\";s:29:\"tds_woo_shop_base_sidebar_pos\";s:0:\"\";s:25:\"tds_woo_shop_base_sidebar\";s:0:\"\";s:22:\"tds_woo_price_excl_tax\";s:0:\"\";s:11:\"tdc_savings\";a:2:{s:11:\"recentFonts\";a:7:{i:0;s:4:\"fs_1\";i:1;s:6:\"file_5\";i:2;s:6:\"file_1\";i:3;s:6:\"file_4\";i:4;s:6:\"file_3\";i:5;s:6:\"file_2\";i:6;s:0:\"\";}s:12:\"recentColors\";a:1:{i:0;s:12:\"IiNmZmZmZmYi\";}}s:36:\"td_updated_td_posts_form_submit_meta\";b:1;s:36:\"td_theme_deactivated_current_plugins\";a:7:{s:11:\"td-composer\";s:32:\"3833ae26cf1f9d406448012ce1734aa1\";s:16:\"td-cloud-library\";s:32:\"34c58173fa732974ccb0ca4df5ede162\";s:17:\"td-social-counter\";s:32:\"2ed7fe863d425d73a6ed286703ee234b\";s:13:\"td-newsletter\";s:32:\"34a5749be48de23015036cdfbdca02e1\";s:15:\"td-subscription\";s:21:\"___td-subscription___\";s:16:\"td-mobile-plugin\";s:32:\"cd46972e145ee7f8326f48bd537ad46c\";s:16:\"td-standard-pack\";s:32:\"9c79b36358200da4c4662c5aa9454675\";}s:20:\"tds_hide_mobile_menu\";s:0:\"\";s:22:\"tds_hide_mobile_search\";s:0:\"\";s:19:\"tds_footer_ui_delay\";s:0:\"\";s:21:\"tds_minify_inline_css\";s:0:\"\";s:24:\"tds_aggregate_inline_css\";s:0:\"\";s:27:\"tds_m_show_links_in_excerpt\";s:0:\"\";s:15:\"tds_captcha_url\";s:0:\"\";s:14:\"tds_bm_api_key\";s:0:\"\";s:23:\"td_translation_map_user\";a:525:{s:9:\"EXCLUSIVE\";s:14:\"انحصاری\";s:4:\"Tel:\";s:9:\"تلفن:\";s:6:\"Email:\";s:11:\"ایمیل:\";s:16:\"View all results\";s:32:\"مشاهده تمام نتایج\";s:10:\"No results\";s:22:\"هیچ نتیجه ای\";s:4:\"Home\";s:8:\"خانه\";s:5:\"CLOSE\";s:10:\"نزدیک\";s:7:\"Loading\";s:16:\"بارگذاری\";s:36:\"Here are the results for the search:\";s:54:\"در اینجا نتایج جستجو آمده است:\";s:4:\"Page\";s:8:\"صفحه\";s:3:\"All\";s:6:\"همه\";s:2:\"By\";s:8:\"توسط\";s:9:\"Load more\";s:25:\"بارگیری بیشتر\";s:14:\"Modified date:\";s:22:\"تاریخ تغییر:\";s:13:\"Modified date\";s:28:\"تاریخ اصلاح شده\";s:19:\"Alphabetical A -> Z\";s:21:\"الفبایی a -> z\";s:12:\"Oldest posts\";s:31:\"قدیمی ترین پست ها\";s:6:\"Select\";s:21:\"انتخاب کنید\";s:17:\"View all posts in\";s:33:\"مشاهده تمام پست در\";s:4:\"Tags\";s:15:\"برچسب ها\";s:16:\"Previous article\";s:19:\"مقاله قبلی\";s:12:\"Next article\";s:19:\"مقاله بعدی\";s:7:\"Authors\";s:18:\"نویسندگان\";s:6:\"Author\";s:14:\"نویسنده\";s:16:\"RELATED ARTICLES\";s:23:\"مقالات مرتبط\";s:16:\"MORE FROM AUTHOR\";s:26:\"بیش از نویسنده\";s:3:\"VIA\";s:13:\"از طریق\";s:6:\"SOURCE\";s:8:\"منبع\";s:4:\"TAGS\";s:15:\"برچسب ها\";s:5:\"Share\";s:23:\"اشتراک گذاری\";s:5:\"SHARE\";s:12:\"اشتراک\";s:8:\"Continue\";s:10:\"ادامه\";s:9:\"Read more\";s:25:\"بیشتر بخوانید\";s:5:\"views\";s:15:\"نمایش ها\";s:5:\"Print\";s:6:\"چاپ\";s:5:\"Name:\";s:7:\"نام:\";s:8:\"Website:\";s:14:\"وب سایت:\";s:8:\"Comment:\";s:14:\"دیدگاه :\";s:13:\"LEAVE A REPLY\";s:15:\"پاسخ ترک\";s:12:\"Post Comment\";s:17:\"نظر ارسال\";s:12:\"Cancel reply\";s:15:\"لغو پاسخ\";s:5:\"Reply\";s:8:\"پاسخ\";s:25:\"Log in to leave a comment\";s:27:\"ورود به ترک نظر\";s:11:\"NO COMMENTS\";s:15:\"بدون نظر\";s:9:\"1 COMMENT\";s:8:\"1 نظر\";s:8:\"COMMENTS\";s:10:\"نظرات\";s:35:\"Your comment is awaiting moderation\";s:47:\"نظر خود را در انتظار تعدیل\";s:27:\"Please enter your name here\";s:56:\"لطفا نام خود را اینجا وارد کنید\";s:36:\"Please enter your email address here\";s:74:\"لطفا آدرس ایمیل خود را در اینجا وارد کنید\";s:44:\"You have entered an incorrect email address!\";s:69:\"شما یک آدرس ایمیل اشتباه وارد کرده اید\";s:26:\"Please enter your comment!\";s:45:\"لطفا نظر خود را وارد کنید\";s:12:\"Logged in as\";s:31:\"وارد شده به عنوان\";s:8:\"Log out?\";s:10:\"خروج؟\";s:35:\"Logged in as %s. Edit your profile.\";s:85:\"به عنوان٪ s وارد شدید پروفایل خودت را ویرایش کن.\";s:4:\"Edit\";s:21:\"ویرایش کنید\";s:2:\"At\";s:4:\"در\";s:2:\"on\";s:4:\"بر\";s:20:\"Comments are closed.\";s:26:\"نظرات بسته است\";s:15:\"REVIEW OVERVIEW\";s:34:\"بررسی اجمالی بررسی\";s:7:\"SUMMARY\";s:10:\"خلاصه\";s:13:\"OVERALL SCORE\";s:15:\"نمره کلی\";s:18:\"Ooops... Error 404\";s:21:\"وای ... خطا 404\";s:54:\"Sorry, but the page you are looking for doesn_t exist.\";s:82:\"با عرض پوزش، اما صفحه شما به دنبال وجود ندارد.\";s:17:\"You can go to the\";s:38:\"شما می توانید به رفتن\";s:8:\"HOMEPAGE\";s:19:\"صفحه خانگی\";s:16:\"OUR LATEST POSTS\";s:27:\"ما همه ارسال ها\";s:8:\"Posts by\";s:13:\"پست های\";s:5:\"POSTS\";s:6:\"پست\";s:17:\"Posts tagged with\";s:22:\"پست با برچسب\";s:3:\"Tag\";s:10:\"برچسب\";s:15:\"Daily Archives:\";s:24:\"آرشیو روزانه:\";s:17:\"Monthly Archives:\";s:24:\"آرشیو ماهانه:\";s:16:\"Yearly Archives:\";s:24:\"آرشیو سالانه:\";s:8:\"Archives\";s:14:\"بایگانی\";s:15:\"LATEST ARTICLES\";s:23:\"آخرین مقالات\";s:14:\"search results\";s:21:\"نتایج جستجو\";s:6:\"Search\";s:10:\"جستجو\";s:62:\"If you_re not happy with the results, please do another search\";s:82:\"اگر شما خوشحال نبود با نتایج، لطفا جستجو دیگر\";s:10:\"Contact us\";s:18:\"تماس با ما\";s:22:\"Follow us on Instagram\";s:60:\"به دنبال ما در نمایش مشخصات عمومی\";s:36:\"Page %CURRENT_PAGE% of %TOTAL_PAGES%\";s:43:\"صفحه  %CURRENT_PAGE% از %TOTAL_PAGES%\";s:4:\"Next\";s:6:\"بعد\";s:4:\"Prev\";s:8:\"قبلی\";s:4:\"Back\";s:12:\"بازگشت\";s:26:\"No results for your search\";s:51:\"هیچ نتیجه ای برای جستجوی شما\";s:19:\"No posts to display\";s:17:\"هیچ آیتمی\";s:19:\"No bookmarked posts\";s:67:\"هیچ پست نشانه گذاری شده ای وجود ندارد\";s:6:\"LOG IN\";s:8:\"ورود\";s:14:\"Sign in / Join\";s:42:\"ورود به سیستم / عضویت در\";s:7:\"Sign in\";s:8:\"ورود\";s:7:\"Sign up\";s:13:\"ثبت نام\";s:20:\"Log in With Facebook\";s:36:\"برای ورود با فیس بوک\";s:4:\"Join\";s:12:\"پیوستن\";s:6:\"Log In\";s:8:\"ورود\";s:5:\"Login\";s:8:\"ورود\";s:8:\"REGISTER\";s:8:\"ثبات\";s:8:\"Welcome!\";s:16:\"خوش آمدی!\";s:21:\"Log into your account\";s:46:\"وارد حساب کاربری خود شوید\";s:17:\"Password recovery\";s:30:\"بازیابی رمز عبور\";s:12:\"Send My Pass\";s:22:\"ارسال پاس من\";s:16:\"Send My Password\";s:36:\"رمز عبور من را بفرست\";s:21:\"Forgot your password?\";s:58:\"رمز عبور خود را فراموش کرده اید؟\";s:30:\"Forgot your password? Get help\";s:74:\"رمز عبور خود را فراموش کرده اید؟ کمک بگیر\";s:17:\"Create an account\";s:37:\"ایجاد یک حساب کاربری\";s:14:\"Please wait...\";s:28:\"لطفا صبر کنید ...\";s:27:\"User or password incorrect!\";s:52:\"کاربر یا رمز عبور اشتباه است!\";s:28:\"Email or username incorrect!\";s:56:\"ایمیل یا نام کاربری اشتباه است!\";s:16:\"Email incorrect!\";s:24:\"ایمیل نادرست!\";s:29:\"User or email already exists!\";s:81:\"کاربر یا پست الکترونیک در حال حاضر وجود دارد!\";s:76:\"Please check your email (inbox or spam folder), the password was sent there.\";s:0:\"\";s:24:\"Email address not found!\";s:36:\"آدرس ایمیل یافت نشد!\";s:41:\"Your password is reset, check your email.\";s:94:\"رمز عبور خود را تنظیم مجدد است، چک کردن ایمیل خود را.\";s:30:\"Welcome! Log into your account\";s:71:\"خوش آمدید ، به پنل کاربری خود وارد شوید.\";s:32:\"Welcome! Register for an account\";s:66:\"خوش آمدی! ثبت نام برای یک حساب کاربری\";s:23:\"Register for an account\";s:49:\"ثبت نام برای یک حساب کاربری\";s:21:\"Recover your password\";s:54:\"رمز عبور خود را بهبود می یابند\";s:13:\"your username\";s:31:\"نام کاربری خود را\";s:13:\"your password\";s:27:\"رمز عبور خود را\";s:10:\"your email\";s:17:\"ایمیل شما\";s:35:\"A password will be e-mailed to you.\";s:95:\"رمز عبور خواهد بود الکترونیکی نامه برای شما فرستاده.\";s:6:\"Logout\";s:24:\"خروج از سیستم\";s:28:\"CAPTCHA verification failed!\";s:40:\"تأیید کپچا ناموفق بود!\";s:45:\"CAPTCHA user score failed. Please contact us!\";s:95:\"امتیاز کاربر کپچا ناموفق بود. لطفا با ما تماس بگیرید!\";s:65:\"Someone has requested a password reset for the following account:\";s:98:\"شخصی برای حساب زیر درخواست بازنشانی رمز عبور داده است:\";s:12:\"Username: %s\";s:23:\"نام کاربری: %s\";s:70:\"If this was a mistake, just ignore this email and nothing will happen.\";s:136:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نمی افتد.\";s:52:\"To reset your password, visit the following address:\";s:92:\"برای بازنشانی رمز عبور خود به آدرس زیر مراجعه کنید:\";s:4:\"Like\";s:10:\"مانند\";s:5:\"Likes\";s:8:\"دوست\";s:4:\"Fans\";s:16:\"طرفداران\";s:6:\"Follow\";s:19:\"دنبال کردن\";s:9:\"Followers\";s:12:\"پیروان\";s:7:\"Members\";s:8:\"اعضا\";s:9:\"Subscribe\";s:10:\"مشترک\";s:11:\"Subscribers\";s:14:\"مشترکین\";s:12:\"MORE STORIES\";s:12:\"داستان\";s:6:\"Latest\";s:10:\"آخرین\";s:14:\"Featured posts\";s:22:\"پست های ویژه\";s:12:\"Most popular\";s:19:\"محبوب ترین\";s:14:\"7 days popular\";s:19:\"7 روز محبوب\";s:15:\"By review score\";s:28:\"توسط نمره بررسی\";s:6:\"Random\";s:12:\"تصادفی\";s:12:\"Trending Now\";s:29:\"در حال حاضر روند\";s:16:\"POPULAR CATEGORY\";s:17:\"رده محبوب\";s:13:\"POPULAR POSTS\";s:24:\"پست های محبوب\";s:12:\"EDITOR PICKS\";s:29:\"میدارد ویرایشگر\";s:8:\"ABOUT US\";s:19:\"دربارهی ما\";s:8:\"About me\";s:17:\"درمورد من\";s:9:\"FOLLOW US\";s:29:\"ما را دنبال کنید\";s:14:\"EVEN MORE NEWS\";s:31:\"اخبار و حتی بیشتر\";s:25:\"Previous (Left arrow key)\";s:49:\"قبلی (کلید های arrow به سمت چپ)\";s:22:\"Next (Right arrow key)\";s:42:\"بعدی (کلید فلش سمت راست)\";s:17:\"%curr% of %total%\";s:19:\"%curr% از %total%\";s:43:\"The content from %url% could not be loaded.\";s:57:\"محتوا از %url% نمی تواند بارگذاری.\";s:38:\"The image #%curr% could not be loaded.\";s:54:\"#%curr% تصویر نمی تواند بارگذاری.\";s:4:\"Blog\";s:10:\"وبلاگ\";s:17:\"Share on Facebook\";s:25:\"سهم در فیس بوک\";s:16:\"Tweet on Twitter\";s:40:\"صدای جیر جیر در توییتر\";s:8:\"Featured\";s:12:\"برجسته\";s:16:\"All time popular\";s:28:\"تمام زمان محبوب\";s:4:\"More\";s:6:\"بیش\";s:8:\"Register\";s:8:\"ثبات\";s:2:\"of\";s:4:\"از\";s:21:\"Euro Member Countries\";s:30:\"کشورهای عضو یورو\";s:17:\"Australian Dollar\";s:25:\"دلار استرالیا\";s:13:\"Bulgarian Lev\";s:17:\"بلغاری لو\";s:14:\"Brazilian Real\";s:21:\"برزیل واقعی\";s:15:\"Canadian Dollar\";s:25:\"دلار کانادایی\";s:11:\"Swiss Franc\";s:21:\"فرانک سوئیس\";s:21:\"Chinese Yuan Renminbi\";s:30:\"رنمینبی یوان چین\";s:21:\"Czech Republic Koruna\";s:30:\"کرونای جمهوری چک\";s:12:\"Danish Krone\";s:23:\"کرون دانمارک\";s:13:\"British Pound\";s:21:\"پوند انگلیس\";s:16:\"Hong Kong Dollar\";s:22:\"دلار هنگ کنگ\";s:13:\"Croatian Kuna\";s:21:\"کونا کرواتی\";s:16:\"Hungarian Forint\";s:29:\"فورینت مجارستان\";s:17:\"Indonesian Rupiah\";s:25:\"روپیه اندونزی\";s:14:\"Israeli Shekel\";s:21:\"شکل اسرائیل\";s:12:\"Indian Rupee\";s:17:\"روپیه هند\";s:12:\"Japanese Yen\";s:13:\"ین ژاپن\";s:18:\"Korean (South) Won\";s:35:\"کره ای (جنوبی) برنده\";s:12:\"Mexican Peso\";s:19:\"پزوی مکزیک\";s:17:\"Malaysian Ringgit\";s:18:\"مالزی Ringgit\";s:15:\"Norwegian Krone\";s:19:\"کرون نروژی\";s:18:\"New Zealand Dollar\";s:25:\"دلار نیوزیلند\";s:15:\"Philippine Peso\";s:23:\"پزوی فیلیپین\";s:12:\"Polish Zloty\";s:20:\"Zloty لهستانی\";s:18:\"Romanian (New) Leu\";s:33:\"رومانیایی (جدید) LEU\";s:13:\"Russian Ruble\";s:19:\"روبل روسیه\";s:13:\"Swedish Krona\";s:17:\"کرون سوئد\";s:16:\"Singapore Dollar\";s:23:\"دلار سنگاپور\";s:9:\"Thai Baht\";s:19:\"بات تایلند\";s:12:\"Turkish Lira\";s:19:\"لیره ترکیه\";s:20:\"United States Dollar\";s:21:\"دلار آمریکا\";s:18:\"South African Rand\";s:32:\"رند آفریقای جنوبی\";s:77:\"Save my name, email, and website in this browser for the next time I comment.\";s:140:\"نام من، ایمیل، و وب سایت را در این مرورگر برای دفعه بعد که نظر میدهم ذخیره کنم.\";s:14:\"Privacy Policy\";s:37:\"سیاست حفظ حریم خصوصی\";s:10:\"My account\";s:0:\"\";s:6:\"Orders\";s:14:\"سفارشات\";s:9:\"Downloads\";s:16:\"دانلودها\";s:9:\"Addresses\";s:13:\"آدرس ها\";s:16:\"Account settings\";s:23:\"تنظیمات حساب\";s:5:\"Hello\";s:8:\"سلام\";s:24:\"No products in the cart.\";s:49:\"هیچ محصولی در سبدخرید نیست.\";s:18:\"Product categories\";s:32:\"دسته بندی محصولات\";s:12:\"Product tags\";s:28:\"برچسب های محصول\";s:8:\"inc. TAX\";s:21:\"شرکت مالیات\";s:7:\"ex. TAX\";s:22:\"سابق. مالیات\";s:83:\"An unexpected error has occured while trying to create your post. Please try again.\";s:151:\"هنگام تلاش برای ایجاد پست شما، یک خطای غیرمنتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:40:\"Your post has been successfully created.\";s:47:\"پست شما با موفقیت ایجاد شد\";s:40:\"Your post has been successfully updated.\";s:48:\"پست شما با موفقیت به روز شد\";s:64:\"An unexpected error has occurred and the mail could not be sent.\";s:84:\"یک خطای غیرمنتظره رخ داده است و نامه ارسال نشد.\";s:9:\"Location:\";s:7:\"محل:\";s:37:\"The email has been successfully sent.\";s:44:\"ایمیل با موفقیت ارسال شد\";s:51:\"An unexpected error has occurred. Please try again.\";s:96:\"یک خطای غیر منتظره رخ داده است. لطفا دوباره تلاش کنید.\";s:23:\"Drag and drop or browse\";s:52:\"بکشید و رها کنید یا مرور کنید\";s:20:\"Search by keyword...\";s:35:\"جستجو با کلیدواژه...\";s:13:\"Select parent\";s:35:\"والد را انتخاب کنید\";s:7:\"Add new\";s:24:\"جدید اضافه کن\";s:12:\"Select child\";s:37:\"فرزند را انتخاب کنید\";s:16:\"Select sub-child\";s:46:\"فرزند فرعی را انتخاب کنید\";s:9:\"Posted by\";s:26:\"ارسال شده توسط\";s:7:\"Overall\";s:18:\"به طور کلی\";s:11:\"Post review\";s:17:\"پست بررسی\";s:23:\"This field is required!\";s:36:\"این فیلد الزامی است!\";s:75:\"Your review has been published. Please refresh the page in order to see it.\";s:108:\"نظر شما انتشار پیدا کرد. لطفا صفحه را برای دیدن آن رفرش کنید.\";s:57:\"Your review has been registered and is awaiting approval.\";s:78:\"بررسی شما ثبت شده است و در انتظار تایید است.\";s:12:\"Submit reply\";s:36:\"پاسخ خود را ثبت کنید\";s:16:\"Enter your reply\";s:38:\"پاسخ خود را وارد کنید\";s:4:\"Name\";s:6:\"نام\";s:13:\"Email address\";s:19:\"آدرس ایمیل\";s:6:\"Cancel\";s:6:\"لغو\";s:42:\"Some required fields have been left blank.\";s:76:\"برخی از فیلدهای ضروری خالی گذاشته شده اند.\";s:35:\"Please enter a valid email address.\";s:63:\"لطفا یک آدرس ایمیل معتبر وارد کنید.\";s:31:\"The number cannot be lower than\";s:42:\"تعداد نمی تواند کمتر از\";s:32:\"The number cannot be higher than\";s:54:\"عدد نمی تواند بیشتر از آن باشد\";s:14:\"Leave a review\";s:30:\"یک بررسی بگذارید\";s:6:\"Submit\";s:10:\"ارسال\";s:6:\"Update\";s:22:\"به روز رسانی\";s:8:\"out of 5\";s:6:\"از 5\";s:74:\"You have reached the limit of reviews that you can submit for this article\";s:126:\"شما به حد مجاز نظراتی که می توانید برای این مقاله ارسال کنید رسیده اید\";s:25:\"Log in to leave a review.\";s:46:\"برای گذاشتن نظر وارد شوید\";s:29:\"Enter a title for your review\";s:62:\"عنوانی را برای بررسی خود وارد کنید\";s:17:\"Enter your review\";s:36:\"نظر خود را وارد کنید\";s:15:\"Review criteria\";s:27:\"معیارهای بررسی\";s:26:\"Enter Your Name or Company\";s:50:\"نام یا شرکت خود را وارد کنید\";s:13:\"Submit review\";s:21:\"ارسال بررسی\";s:6:\"Delete\";s:6:\"حذف\";s:74:\"Your reply has been published. Please refresh the page in order to see it.\";s:96:\"پاسخ شما منتشر شد لطفا صفحه را برای دیدن آن رفرش کنید.\";s:31:\"You have not created any posts.\";s:51:\"شما هیچ پستی ایجاد نکرده اید\";s:30:\"You have not bought any posts.\";s:0:\"\";s:48:\"The selected post has been successfully deleted.\";s:52:\"پست انتخابی با موفقیت حذف شد.\";s:2:\"ID\";s:10:\"شناسه\";s:6:\"Rating\";s:17:\"رتبه بندی\";s:5:\"Title\";s:10:\"عنوان\";s:10:\"Post image\";s:21:\"ارسال تصویر\";s:10:\"Categories\";s:22:\"دسته بندی ها\";s:4:\"Date\";s:10:\"تاریخ\";s:12:\"Source title\";s:19:\"عنوان منبع\";s:12:\"Credits cost\";s:0:\"\";s:9:\"No rating\";s:17:\"بدون رتبه\";s:4:\"View\";s:17:\"چشم انداز\";s:7:\"Publish\";s:12:\"انتشار\";s:12:\"Add new post\";s:35:\"اضافه کردن پست جدید\";s:9:\"Edit post\";s:19:\"ویرایش پست\";s:14:\"Publish a post\";s:31:\"یک پست منتشر کنید\";s:45:\"The status for %POST_TITLE% has been changed.\";s:51:\"وضعیت %post_title% تغییر کرده است.\";s:46:\"Are you sure you want to publish %POST_TITLE%?\";s:91:\"آیا مطمئن هستید که می خواهید %post_title% را منتشر کنید؟\";s:13:\"Delete a post\";s:32:\"یک پست را حذف کنید\";s:45:\"Are you sure you want to delete %POST_TITLE%?\";s:87:\"آیا مطمئن هستید که می خواهید %post_title% را حذف کنید؟\";s:37:\"%POST_TITLE% has been moved to trash.\";s:52:\"%post_title% به سطل زباله منتقل شد.\";s:64:\"You do not hold the required privileges to execute this request.\";s:0:\"\";s:18:\"No search results.\";s:59:\"هیچ نتیجه ای برای جستجو یافت نشد.\";s:3:\"Yes\";s:6:\"آره\";s:2:\"No\";s:4:\"نه\";s:4:\"Save\";s:17:\"صرفه جویی\";s:21:\"Search for a location\";s:33:\"جستجو برای یک مکان\";s:12:\"Address line\";s:13:\"خط آدرس\";s:10:\"(Optional)\";s:16:\"(اختیاری)\";s:4:\"City\";s:6:\"شهر\";s:5:\"State\";s:8:\"حالت\";s:7:\"Country\";s:8:\"کشور\";s:15:\"Create new term\";s:32:\"ایجاد اصطلاح جدید\";s:6:\"Parent\";s:12:\"والدین\";s:11:\"Description\";s:6:\"شرح\";s:16:\"Delete bookmarks\";s:27:\"حذف بوک مارک ها\";s:7:\"Success\";s:12:\"موفقیت\";s:27:\"Acknowledgment is required!\";s:27:\"تایید لازم است!\";s:29:\"Please fill in a valid email.\";s:49:\"لطفا یک ایمیل معتبر پر کنید\";s:32:\"Please fill in an email address.\";s:52:\"لطفا یک آدرس ایمیل را پر کنید\";s:22:\"Get into your account.\";s:33:\"وارد حساب خود شوید\";s:23:\"My subscription account\";s:26:\"حساب اشتراک من\";s:15:\"Account details\";s:21:\"جزئیات حساب\";s:15:\"Billing details\";s:29:\"جزئیات صورتحساب\";s:13:\"Subscriptions\";s:17:\"اشتراک ها\";s:14:\"My woo account\";s:20:\"اکانت وو من\";s:7:\"Log out\";s:8:\"خروج\";s:8:\"Username\";s:19:\"نام کاربری\";s:8:\"Password\";s:17:\"کلمه عبور\";s:43:\"must contain at least one lower case (a..z)\";s:70:\"باید حداقل یک حروف کوچک (a..z) داشته باشد.\";s:43:\"must contain at least one upper case (A..Z)\";s:70:\"باید حداقل یک حروف بزرگ (a..z) داشته باشد.\";s:44:\"must contain at least 6 characters in length\";s:68:\"باید حداقل 6 کاراکتر در طول داشته باشد\";s:15:\"Repeat password\";s:26:\"تکرار رمز عبور\";s:24:\"Already have an account?\";s:60:\"در حال حاضر یک حساب کاربری دارید؟\";s:16:\"Recover password\";s:30:\"بازیابی رمز عبور\";s:25:\"Username or Email address\";s:44:\"نام کاربری یا آدرس ایمیل\";s:16:\"Forgot password?\";s:51:\"رمز عبور را فراموش کرده اید؟\";s:19:\"Reset your password\";s:53:\"رمز عبور خود را بازنشانی کنید\";s:35:\"The password reset key has expired.\";s:70:\"کلید تنظیم مجدد رمز عبور منقضی شده است.\";s:34:\"The password reset key is invalid.\";s:67:\"کلید تنظیم مجدد رمز عبور نامعتبر است.\";s:14:\"New password *\";s:26:\"رمز عبور جدید *\";s:21:\"Repeat new password *\";s:37:\"تکرار رمز عبور جدید *\";s:13:\"Save password\";s:26:\"ذخیره رمز عبور\";s:45:\"Your account has been successfully activated!\";s:48:\"حساب شما با موفقیت فعال شد!\";s:40:\"Your account has already been activated!\";s:50:\"حساب شما قبلاً فعال شده است!\";s:71:\"Check your email for the correct activation link. This link is invalid.\";s:126:\"ایمیل خود را برای لینک فعال سازی صحیح بررسی کنید. این لینک نامعتبر است\";s:18:\"Account activation\";s:26:\"فعال سازی حساب\";s:46:\"Please enter a new password before proceeding.\";s:75:\"لطفا قبل از ادامه رمز عبور جدید وارد کنید.\";s:50:\"Please confirm the new password before proceeding.\";s:84:\"لطفاً قبل از ادامه رمز عبور جدید را تأیید کنید.\";s:42:\"Please make sure that the passwords match.\";s:80:\"لطفا مطمئن شوید که رمزهای عبور مطابقت دارند.\";s:41:\"The password has been reset successfully.\";s:56:\"رمز عبور با موفقیت بازنشانی شد.\";s:22:\"Don\'t have an account?\";s:0:\"\";s:9:\"Dashboard\";s:14:\"داشبورد\";s:24:\"Welcome to your account!\";s:38:\"به حساب خود خوش آمدید\";s:121:\"Hello %1$s (not %2$s? %3$s)! From your account dashboard you can view your subscriptions and manage your account details.\";s:201:\"سلام %1$s (نه %2$s؟ %3$s)! از داشبورد حساب خود می توانید اشتراک های خود را مشاهده کرده و جزئیات حساب خود را مدیریت کنید.\";s:13:\"Lost Password\";s:26:\"رمز فراموش شده\";s:28:\"Manage your account details.\";s:55:\"جزئیات حساب خود را مدیریت کنید\";s:28:\"Manage your billing details.\";s:63:\"جزئیات صورتحساب خود را مدیریت کنید\";s:15:\"Profile picture\";s:21:\"عکس پروفایل\";s:10:\"First name\";s:15:\"نام کوچک\";s:9:\"Last name\";s:23:\"نام خانوادگی\";s:12:\"Display name\";s:19:\"نام نمایشی\";s:16:\"Current password\";s:24:\"رمز عبور فعلی\";s:32:\"(leave blank to leave unchanged)\";s:70:\"(خالی بگذارید تا بدون تغییر باقی بماند)\";s:12:\"New password\";s:24:\"رمز عبور جدید\";s:20:\"Confirm new password\";s:49:\"رمز عبور جدید را تایید کنید\";s:12:\"Save changes\";s:25:\"ذخیره تغییرات\";s:23:\"All your subscriptions.\";s:35:\"تمام اشتراک های شما\";s:28:\"Remaining publishing rights.\";s:41:\"حقوق انتشار باقی مانده\";s:76:\"The number of articles you have left to publish across different post types.\";s:121:\"تعداد مقالاتی که برای انتشار در انواع پست های مختلف باقی مانده است.\";s:4:\"Plan\";s:6:\"طرح\";s:12:\"Payment type\";s:19:\"نوع پرداخت\";s:5:\"Price\";s:8:\"قیمت\";s:6:\"Status\";s:10:\"وضعیت\";s:6:\"Months\";s:11:\"ماه ها\";s:10:\"Start date\";s:19:\"تاریخ شروع\";s:8:\"End date\";s:21:\"تاریخ پایان\";s:12:\"missing plan\";s:18:\"طرح گم شده\";s:13:\"Bank transfer\";s:23:\"انتقال بانکی\";s:4:\"Free\";s:12:\"رایگان\";s:6:\"Active\";s:8:\"فعال\";s:5:\"Trial\";s:12:\"آزمایش\";s:7:\"Blocked\";s:10:\"مسدود\";s:6:\"Closed\";s:8:\"بسته\";s:8:\"Canceled\";s:11:\"لغو شد\";s:8:\"Not paid\";s:21:\"پرداخت نشده\";s:16:\"Awaiting payment\";s:30:\"در انتظار پرداخت\";s:17:\"Subscription info\";s:27:\"اطلاعات اشتراک\";s:12:\"Company name\";s:15:\"نام شرکت\";s:3:\"VAT\";s:39:\"مالیات بر ارزش افزوده\";s:10:\"VAT number\";s:0:\"\";s:7:\"Address\";s:10:\"نشانی\";s:13:\"Country/State\";s:19:\"کشور/ایالت\";s:5:\"Email\";s:25:\"پست الکترونیک\";s:11:\"Postal code\";s:13:\"کد پستی\";s:28:\"Direct bank transfer details\";s:49:\"جزئیات انتقال مستقیم بانکی\";s:12:\"Account name\";s:19:\"نام کاربری\";s:14:\"Account number\";s:19:\"شماره حساب\";s:9:\"Bank name\";s:15:\"نام بانک\";s:14:\"Routing number\";s:27:\"شماره مسیریابی\";s:4:\"IBAN\";s:10:\"ایبان\";s:9:\"Bic/Swift\";s:9:\"Bic/swift\";s:12:\"Instructions\";s:25:\"دستورالعمل ها\";s:24:\"No subscription created.\";s:39:\"هیچ اشتراکی ایجاد نشد\";s:11:\"Choose plan\";s:33:\"طرح را انتخاب کنید\";s:15:\"Payment methods\";s:26:\"روش های پرداخت\";s:20:\"Direct Bank Transfer\";s:36:\"انتقال مستقیم بانکی\";s:14:\"Payment method\";s:19:\"روش پرداخت\";s:5:\"Total\";s:6:\"جمع\";s:14:\"Cycle Interval\";s:19:\"فاصله چرخه\";s:6:\"Period\";s:19:\"دوره زمانی\";s:20:\"Subscription summary\";s:23:\"خلاصه اشتراک\";s:5:\"Phone\";s:8:\"تلفن\";s:8:\"Postcode\";s:13:\"کد پستی\";s:6:\"County\";s:14:\"شهرستان\";s:9:\"Town/City\";s:13:\"شهر/شهر\";s:14:\"Street address\";s:21:\"آدرس خیابان\";s:14:\"Country/Region\";s:19:\"کشور/منطقه\";s:10:\"VAT Number\";s:50:\"شماره مالیات بر ارزش افزوده\";s:10:\"(optional)\";s:16:\"(اختیاری)\";s:16:\"User information\";s:25:\"اطلاعات کاربر\";s:64:\"It seems that no available payment methods have been configured.\";s:95:\"به نظر می رسد هیچ روش پرداخت موجود پیکربندی نشده است.\";s:86:\"Thank you! We are delighted to see you here. Your subscription will be activated soon!\";s:145:\"متشکرم! ما خوشحالیم که شما را در اینجا می بینیم. اشتراک شما به زودی فعال خواهد شد!\";s:16:\"Our bank details\";s:26:\"جزئیات بانک ما\";s:25:\"Your subscription details\";s:32:\"جزئیات اشتراک شما\";s:17:\"View subscription\";s:25:\"مشاهده اشتراک\";s:18:\"View subscriptions\";s:0:\"\";s:48:\"You have not selected a valid subscription plan.\";s:74:\"شما یک طرح اشتراک معتبر انتخاب نکرده اید.\";s:43:\"You have not selected a valid subscription.\";s:0:\"\";s:60:\"Payment is not available for subscriptions with %1$s status.\";s:0:\"\";s:11:\"Field empty\";s:17:\"فیلد خالی\";s:16:\"Empty first name\";s:24:\"نام کوچک خالی\";s:15:\"Empty last name\";s:32:\"نام خانوادگی خالی\";s:13:\"Empty country\";s:17:\"کشور خالی\";s:13:\"Empty address\";s:17:\"آدرس خالی\";s:10:\"Empty city\";s:15:\"شهر خالی\";s:12:\"Empty county\";s:23:\"شهرستان خالی\";s:14:\"Empty postcode\";s:22:\"کد پستی خالی\";s:11:\"Empty phone\";s:17:\"گوشی خالی\";s:11:\"Empty email\";s:19:\"ایمیل خالی\";s:24:\"Email or username empty!\";s:45:\"ایمیل یا نام کاربری خالی!\";s:11:\"Pass empty!\";s:18:\"خالی بگذر!\";s:19:\"Username incorrect!\";s:40:\"نام کاربری اشتباه است!\";s:21:\"Invalid Pass Pattern!\";s:33:\"الگوی پاس نامعتبر!\";s:23:\"Retyped Pass incorrect!\";s:36:\"پاس مجدد اشتباه است!\";s:78:\"Please activate your account by following the link sent to your email address.\";s:145:\"لطفا با دنبال کردن لینک ارسال شده به آدرس ایمیل خود حساب کاربری خود را فعال کنید.\";s:22:\"Resend activation link\";s:46:\"ارسال مجدد لینک فعال سازی\";s:75:\"In order to have access to this section, you have to activate your account.\";s:102:\"برای دسترسی به این بخش باید حساب کاربری خود را فعال کنید.\";s:65:\"In order to update this filed, you have to activate your account.\";s:111:\"برای به روز رسانی این فایل، باید حساب کاربری خود را فعال کنید.\";s:12:\"Email empty!\";s:20:\"ایمیل خالی!\";s:15:\"Username empty!\";s:29:\"نام کاربری خالی!\";s:23:\"Pass pattern incorrect!\";s:40:\"الگوی عبور نادرست است!\";s:19:\"Retyped pass empty!\";s:34:\"پاس تایپ مجدد خالی!\";s:21:\"Retyped pass exactly!\";s:47:\"پاس دوباره تایپ شده دقیقا!\";s:20:\"User already exists!\";s:41:\"کاربر از قبل وجود دارد!\";s:21:\"Email already exists!\";s:41:\"ایمیل از قبل وجود دارد!\";s:34:\"Your account could not be created.\";s:33:\"حساب شما ایجاد نشد\";s:91:\"This username is invalid because it uses illegal characters. Please enter a valid username.\";s:0:\"\";s:72:\"Please check your email (inbox or spam folder) to validate your account.\";s:151:\"لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:11:\"User empty!\";s:20:\"کاربر خالی!\";s:21:\"User does not exists!\";s:31:\"کاربر وجود ندارد!\";s:107:\"New activation link was generated. Please check your email (inbox or spam folder) to validate your account.\";s:204:\"لینک فعال سازی جدید ایجاد شد. لطفا ایمیل خود (صندوق ورودی یا پوشه هرزنامه) را بررسی کنید تا حساب خود را تأیید کنید.\";s:41:\"You must be logged out to view this page.\";s:81:\"برای مشاهده این صفحه باید از سیستم خارج شوید.\";s:23:\"%s is a required field.\";s:37:\"%s یک فیلد الزامی است.\";s:24:\"Cannot process %s field.\";s:55:\"نمی تواند فیلد %s را پردازش کند.\";s:37:\"Please provide a valid email address.\";s:65:\"لطفا یک آدرس ایمیل معتبر ارائه کنید.\";s:41:\"This email address is already registered.\";s:72:\"این آدرس پست الکترونیک قبلا ثبت شده است.\";s:36:\"Please fill out all password fields.\";s:68:\"لطفا تمام فیلدهای رمز عبور را پر کنید.\";s:35:\"Please enter your current password.\";s:63:\"لطفا رمز عبور فعلی خود را وارد کنید\";s:30:\"Please re-enter your password.\";s:57:\"لطفا رمز خود را مجددا وارد کنید.\";s:27:\"New passwords do not match.\";s:57:\"رمزهای عبور جدید مطابقت ندارند.\";s:35:\"Your current password is incorrect.\";s:51:\"رمز عبور فعلی شما نادرست است\";s:37:\"Account details changed successfully.\";s:58:\"جزئیات حساب با موفقیت تغییر کرد.\";s:58:\"A new activation link has been sent to your email address!\";s:98:\"یک لینک فعال سازی جدید به آدرس ایمیل شما ارسال شده است!\";s:9:\"unlimited\";s:14:\"نامحدود\";s:15:\"Pay with Stripe\";s:31:\"پرداخت با راه راه\";s:19:\"Cancel subscription\";s:17:\"لغو عضویت\";s:49:\"Please check your email and confirm subscription!\";s:93:\"لطفا ایمیل خود را بررسی کنید و اشتراک را تایید کنید!\";s:27:\"Post successfully unlocked!\";s:0:\"\";s:31:\"Insufficient credits available!\";s:0:\"\";s:24:\"Successfully subscribed!\";s:34:\"با موفقیت مشترک شد!\";s:26:\"Successfully unsubscribed!\";s:38:\"با موفقیت لغو اشتراک!\";s:21:\"Enter promo code here\";s:55:\"کد تبلیغاتی را اینجا وارد کنید\";s:5:\"Apply\";s:23:\"درخواست دادن\";s:14:\"Coupon applied\";s:24:\"کوپن اعمال شد\";s:71:\"Uncaught Error: Something went wrong, please reload page and try again!\";s:153:\"خطای کشف نشده: مشکلی پیش آمد، لطفاً صفحه را دوباره بارگیری کنید و دوباره امتحان کنید!\";s:38:\"The coupon code you entered is invalid\";s:67:\"کد کوپنی که وارد کرده اید نامعتبر است\";s:55:\"The coupon code you entered has reached its usage limit\";s:99:\"کد کوپنی که وارد کردید به حد مجاز استفاده خود رسیده است\";s:39:\"The coupon code you entered has expired\";s:70:\"کد کوپنی که وارد کرده اید منقضی شده است\";s:25:\"Coupon name is required !\";s:41:\"نام کوپن مورد نیاز است!\";s:33:\"Please enter a coupon code first!\";s:57:\"لطفا ابتدا یک کد کوپن وارد کنید!\";s:7:\"Invalid\";s:17:\"بی اعتبار\";s:7:\"Applied\";s:14:\"کاربردی\";s:6:\"Remove\";s:14:\"برداشتن\";s:13:\"Price not set\";s:28:\"قیمت تعیین نشده\";s:11:\"Grand Total\";s:9:\"کل کل\";s:70:\"You already have a subscription, but it\'s still in waiting to be paid!\";s:0:\"\";s:66:\"This subscription has been canceled and it will end on %END_DATE%.\";s:87:\"این اشتراک لغو شده است و در %end_date به پایان می رسد.\";s:14:\"Go to checkout\";s:35:\"به تسویه حساب بروید\";s:22:\"Stripe invoice details\";s:32:\"جزئیات فاکتور خطی\";s:27:\"Stripe subscription details\";s:39:\"جزئیات اشتراک راه راه\";s:14:\"Current status\";s:19:\"وضعیت فعلی\";s:20:\"Initial Invoice Paid\";s:43:\"فاکتور اولیه پرداخت شده\";s:41:\"Subscription Create: Initial Invoice Paid\";s:75:\"ایجاد اشتراک: فاکتور اولیه پرداخت شده است\";s:53:\"Subscription Create: Initial Invoice has been created\";s:73:\"ایجاد اشتراک: فاکتور اولیه ایجاد شده است\";s:83:\"Subscription Create: Initial Invoice has been finalized, and it is ready to be paid\";s:100:\"ایجاد اشتراک: فاکتور اولیه نهایی شده و آماده پرداخت است\";s:33:\"Subscription Update: Invoice Paid\";s:76:\"به روز رسانی اشتراک: فاکتور پرداخت شده است\";s:32:\"Subscription Renew: Invoice Paid\";s:64:\"تمدید اشتراک: فاکتور پرداخت شده است\";s:37:\"Subscription Renew: Invoice Finalized\";s:53:\"تمدید اشتراک: فاکتور نهایی شد\";s:35:\"Subscription Renew: Invoice Created\";s:53:\"تمدید اشتراک: فاکتور ایجاد شد\";s:36:\"Subscription Renew: Invoice Upcoming\";s:56:\"تمدید اشتراک: فاکتور در راه است\";s:68:\"Subscription Expired: Invoice Voided(the first invoice was not paid)\";s:102:\"اشتراک منقضی شد: فاکتور باطل شد (اولین فاکتور پرداخت نشد)\";s:20:\"Subscription Deleted\";s:24:\"اشتراک حذف شد\";s:29:\"Subscription Create: Trialing\";s:39:\"ایجاد اشتراک: آزمایشی\";s:21:\"Subscription Canceled\";s:24:\"اشتراک لغو شد\";s:43:\"Subscription Create: Initial Invoice voided\";s:62:\"ایجاد اشتراک: فاکتور اولیه باطل شد\";s:34:\"Subscription Renew: Invoice voided\";s:51:\"تمدید اشتراک: فاکتور باطل شد\";s:35:\"Subscription Update: Invoice voided\";s:63:\"به روز رسانی اشتراک: فاکتور باطل شد\";s:15:\"Invoice updated\";s:29:\"فاکتور به روز شد\";s:249:\"Trial end renew failed due to an invalid or missing a default payment method for your subscription. <br>Please consider updating your subscription\'s payment details. <br>To retry payment now using a different payment method please view invoice page.\";s:0:\"\";s:48:\"Subscription has been canceled and will end on: \";s:0:\"\";s:88:\"Setup successful - You have successfully set up your payment method for future payments.\";s:186:\"راه‌اندازی با موفقیت انجام شد - شما با موفقیت روش پرداخت خود را برای پرداخت‌های آینده تنظیم کرده‌اید.\";s:129:\"Setup failed - We are sorry, there was an error setting up your payment method. Please try again with a different payment method.\";s:210:\"راه‌اندازی انجام نشد - متأسفیم، در تنظیم روش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:81:\"Payment successful - Your latest subscription payment was completed successfully.\";s:127:\"پرداخت با موفقیت انجام شد - آخرین پرداخت اشتراک شما با موفقیت انجام شد.\";s:73:\"Payment processing - Your latest subscription payment is being processed.\";s:104:\"پردازش پرداخت - آخرین پرداخت اشتراک شما در حال پردازش است.\";s:124:\"Payment failed - We are sorry, there was an error processing your payment. Please try again with a different payment method.\";s:196:\"پرداخت انجام نشد - متأسفیم، در پردازش پرداخت شما خطایی روی داد. لطفاً با روش پرداخت دیگری دوباره امتحان کنید.\";s:8:\"Download\";s:12:\"دانلود\";s:14:\"Stripe invoice\";s:26:\"فاکتور راه راه\";s:3:\"N/A\";s:3:\"N/a\";s:14:\"Latest invoice\";s:23:\"آخرین فاکتور\";s:7:\"Invoice\";s:16:\"صورتحساب\";s:20:\"Unpaid subscription.\";s:34:\"اشتراک بدون پرداخت\";s:20:\"Locked subscription.\";s:26:\"اشتراک قفل شده\";s:21:\"Invalid subscription.\";s:27:\"اشتراک نامعتبر\";s:7:\"Pay now\";s:26:\"الان پرداخت کن\";s:14:\"Show more info\";s:36:\"نمایش اطلاعات بیشتر\";s:14:\"Show less info\";s:41:\"نشان دادن اطلاعات کمتر\";s:16:\"Complete payment\";s:21:\"پرداخت کامل\";s:2:\"or\";s:4:\"یا\";s:13:\"Setup Payment\";s:32:\"پرداخت راه اندازی\";s:13:\"Go to Payment\";s:28:\"به پرداخت بروید\";s:7:\"Credits\";s:0:\"\";s:17:\"Available credits\";s:0:\"\";s:65:\"The number of available credits you have left to unlock articles.\";s:0:\"\";s:28:\"Subscription Update: Renewed\";s:0:\"\";s:22:\"Update payment details\";s:0:\"\";s:20:\"No payment required.\";s:0:\"\";s:23:\"Invoice payment failed.\";s:0:\"\";s:15:\"No updates yet.\";s:0:\"\";s:3:\"Pay\";s:0:\"\";s:3:\"Day\";s:0:\"\";s:4:\"Days\";s:0:\"\";s:5:\"Month\";s:0:\"\";s:4:\"Year\";s:0:\"\";s:5:\"Years\";s:0:\"\";}s:21:\"tds_woo_prod_img_zoom\";s:0:\"\";s:21:\"tds_logo_width_height\";b:1;s:17:\"td_banners_status\";s:0:\"\";s:21:\"tds_logo_upload_width\";s:0:\"\";s:22:\"tds_logo_upload_height\";s:0:\"\";s:26:\"tds_logo_menu_upload_width\";s:0:\"\";s:27:\"tds_logo_menu_upload_height\";s:0:\"\";s:28:\"tds_footer_logo_upload_width\";s:0:\"\";s:29:\"tds_footer_logo_upload_height\";s:0:\"\";s:16:\"tds_to_top_style\";s:0:\"\";s:37:\"tds_enable_products_schema_on_reviews\";s:0:\"\";}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("179", "td_011_log", "a:3:{i:0;a:5:{s:4:\"file\";s:95:\"F:/laragon/www/news-demo/wp-content/themes/Newspaper/includes/wp-booster/tagdiv-remote-http.php\";s:8:\"function\";s:8:\"get_page\";s:3:\"msg\";s:48:\"first run -> test passed with channel: wordpress\";s:9:\"more_data\";s:56:\"https://cloud.tagdiv.com/wp-json/wp/v2/media?search=.zip\";s:9:\"timestamp\";i:1649849604;}i:1;a:5:{s:4:\"file\";s:83:\"F:/laragon/www/news-demo\\wp-content\\plugins\\td-subscription\\includes\\tds_update.php\";s:8:\"function\";s:7:\"_to_1p5\";s:3:\"msg\";s:25:\"tds_update to_1p5 results\";s:9:\"more_data\";a:4:{s:19:\"tds_paypal_payments\";s:41:\"the tds_paypal_payments table was created\";s:17:\"tds_subscriptions\";a:8:{s:25:\"paypal_column_drop_result\";s:56:\"paypal_order.. columns found | drop query was successful\";s:41:\"billing_company_name_column_modify_result\";s:27:\"modify query was successful\";s:21:\"stripe_payment_method\";s:5:\"added\";s:20:\"cycle_interval_count\";s:5:\"added\";s:14:\"cycle_interval\";s:5:\"added\";s:12:\"is_unlimited\";s:5:\"added\";s:32:\"tds_subscriptions_columns_update\";s:3:\"yes\";s:39:\"tds_subscriptions_columns_update_result\";s:7:\"updated\";}s:18:\"tds_payment_stripe\";a:6:{s:23:\"webhook_endpoint_secret\";s:5:\"found\";s:16:\"webhook_endpoint\";s:5:\"found\";s:15:\"payment_methods\";s:5:\"added\";s:11:\"description\";s:5:\"added\";s:12:\"instructions\";s:5:\"added\";s:20:\"stripe_payments_data\";s:3:\"N/A\";}s:9:\"tds_plans\";a:7:{s:32:\"convert_to_character_set_utf8mb4\";s:7:\"updated\";s:8:\"interval\";s:5:\"added\";s:14:\"interval_count\";s:5:\"added\";s:12:\"is_unlimited\";s:5:\"added\";s:20:\"automatic_delistings\";s:5:\"found\";s:24:\"tds_plans_columns_update\";s:3:\"yes\";s:31:\"tds_plans_columns_update_result\";s:7:\"updated\";}}s:9:\"timestamp\";i:1703396987;}i:2;a:5:{s:4:\"file\";s:83:\"F:\\laragon\\www\\news-demo\\wp-content\\plugins\\td-subscription\\includes\\tds_update.php\";s:8:\"function\";s:7:\"_to_1p7\";s:3:\"msg\";s:26:\"tds_update _to_1p7 results\";s:9:\"more_data\";a:1:{s:18:\"tds_payment_stripe\";a:1:{s:20:\"stripe_payments_data\";s:3:\"N/A\";}}s:9:\"timestamp\";i:1739619646;}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("182", "widget_td_block_social_counter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("4191", "tds_list_children", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("184", "default_term_tds_list", "48", "yes");
INSERT INTO `dgfdcv_options` VALUES("185", "tds_default_locker_id", "8", "yes");
INSERT INTO `dgfdcv_options` VALUES("192", "finished_updating_comment_type", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("200", "action_scheduler_hybrid_store_demarkation", "12", "yes");
INSERT INTO `dgfdcv_options` VALUES("201", "schema-ActionScheduler_StoreSchema", "7.0.1703396843", "yes");
INSERT INTO `dgfdcv_options` VALUES("202", "schema-ActionScheduler_LoggerSchema", "3.0.1649849686", "yes");
INSERT INTO `dgfdcv_options` VALUES("205", "woocommerce_schema_version", "920", "yes");
INSERT INTO `dgfdcv_options` VALUES("206", "woocommerce_store_address", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("207", "woocommerce_store_address_2", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("208", "woocommerce_store_city", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("209", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `dgfdcv_options` VALUES("210", "woocommerce_store_postcode", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("211", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `dgfdcv_options` VALUES("212", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("213", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("214", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("215", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("216", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `dgfdcv_options` VALUES("217", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("218", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("219", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("220", "woocommerce_currency", "IRT", "yes");
INSERT INTO `dgfdcv_options` VALUES("221", "woocommerce_currency_pos", "right", "yes");
INSERT INTO `dgfdcv_options` VALUES("222", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `dgfdcv_options` VALUES("223", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `dgfdcv_options` VALUES("224", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `dgfdcv_options` VALUES("225", "woocommerce_shop_page_id", "13", "yes");
INSERT INTO `dgfdcv_options` VALUES("226", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("227", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("228", "woocommerce_placeholder_image", "12", "yes");
INSERT INTO `dgfdcv_options` VALUES("229", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `dgfdcv_options` VALUES("230", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `dgfdcv_options` VALUES("231", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("232", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("233", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("234", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("235", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("236", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("237", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `dgfdcv_options` VALUES("238", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("239", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("240", "woocommerce_stock_email_recipient", "bghjgjh@dffgdfg.com", "no");
INSERT INTO `dgfdcv_options` VALUES("241", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `dgfdcv_options` VALUES("242", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("243", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("244", "woocommerce_stock_format", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("245", "woocommerce_file_download_method", "force", "no");
INSERT INTO `dgfdcv_options` VALUES("246", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("247", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("248", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("249", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("251", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("252", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("253", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `dgfdcv_options` VALUES("254", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `dgfdcv_options` VALUES("255", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("256", "woocommerce_tax_classes", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("257", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `dgfdcv_options` VALUES("258", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `dgfdcv_options` VALUES("259", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("260", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `dgfdcv_options` VALUES("261", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("262", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("263", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `dgfdcv_options` VALUES("264", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("265", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("266", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("267", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("268", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("269", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("270", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `dgfdcv_options` VALUES("271", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("272", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("273", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("274", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `dgfdcv_options` VALUES("275", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `dgfdcv_options` VALUES("276", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `dgfdcv_options` VALUES("277", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `dgfdcv_options` VALUES("278", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `dgfdcv_options` VALUES("279", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `dgfdcv_options` VALUES("280", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `dgfdcv_options` VALUES("281", "woocommerce_email_from_name", "", "no");
INSERT INTO `dgfdcv_options` VALUES("282", "woocommerce_email_from_address", "bghjgjh@dffgdfg.com", "no");
INSERT INTO `dgfdcv_options` VALUES("283", "woocommerce_email_header_image", "", "no");
INSERT INTO `dgfdcv_options` VALUES("284", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `dgfdcv_options` VALUES("285", "woocommerce_email_base_color", "#7f54b3", "no");
INSERT INTO `dgfdcv_options` VALUES("286", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `dgfdcv_options` VALUES("287", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `dgfdcv_options` VALUES("288", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `dgfdcv_options` VALUES("289", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("290", "woocommerce_cart_page_id", "14", "no");
INSERT INTO `dgfdcv_options` VALUES("291", "woocommerce_checkout_page_id", "15", "no");
INSERT INTO `dgfdcv_options` VALUES("292", "woocommerce_myaccount_page_id", "16", "no");
INSERT INTO `dgfdcv_options` VALUES("293", "woocommerce_terms_page_id", "", "no");
INSERT INTO `dgfdcv_options` VALUES("294", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `dgfdcv_options` VALUES("295", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `dgfdcv_options` VALUES("296", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `dgfdcv_options` VALUES("297", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `dgfdcv_options` VALUES("298", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `dgfdcv_options` VALUES("299", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `dgfdcv_options` VALUES("300", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `dgfdcv_options` VALUES("301", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `dgfdcv_options` VALUES("302", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `dgfdcv_options` VALUES("303", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `dgfdcv_options` VALUES("304", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `dgfdcv_options` VALUES("305", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `dgfdcv_options` VALUES("306", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `dgfdcv_options` VALUES("307", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("308", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("309", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("310", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `dgfdcv_options` VALUES("311", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `dgfdcv_options` VALUES("312", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("313", "woocommerce_demo_store", "no", "no");
INSERT INTO `dgfdcv_options` VALUES("314", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("315", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("316", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("318", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("319", "default_product_cat", "17", "yes");
INSERT INTO `dgfdcv_options` VALUES("362", "wc_blocks_surface_cart_checkout_probability", "24", "yes");
INSERT INTO `dgfdcv_options` VALUES("322", "woocommerce_refund_returns_page_id", "17", "yes");
INSERT INTO `dgfdcv_options` VALUES("364", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `dgfdcv_options` VALUES("325", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:19:\"bghjgjh@dffgdfg.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:19:\"bghjgjh@dffgdfg.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("326", "woocommerce_version", "9.8.5", "yes");
INSERT INTO `dgfdcv_options` VALUES("327", "woocommerce_db_version", "9.1.4", "yes");
INSERT INTO `dgfdcv_options` VALUES("356", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "no");
INSERT INTO `dgfdcv_options` VALUES("357", "wc_admin_show_legacy_coupon_menu", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("363", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `dgfdcv_options` VALUES("382", "woocommerce_task_list_completed_lists", "a:2:{i:0;s:8:\"extended\";i:1;s:19:\"extended_two_column\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("383", "widget_td_block_1_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("384", "widget_td_block_2_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("385", "widget_td_block_3_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("386", "widget_td_block_4_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("387", "widget_td_block_5_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("388", "widget_td_block_6_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("389", "widget_td_block_7_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("390", "widget_td_block_8_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("391", "widget_td_block_9_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("392", "widget_td_block_10_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("393", "widget_td_block_11_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("394", "widget_td_block_12_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("395", "widget_td_block_13_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("396", "widget_td_block_14_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("397", "widget_td_block_15_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("398", "widget_td_block_16_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("399", "widget_td_block_17_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("400", "widget_td_block_18_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("401", "widget_td_block_19_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("402", "widget_td_block_20_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("403", "widget_td_block_21_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("404", "widget_td_block_22_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("405", "widget_td_block_23_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("406", "widget_td_block_24_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("407", "widget_td_block_25_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("421", "amp-options", "a:17:{s:13:\"theme_support\";s:6:\"reader\";s:20:\"supported_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:9:\"analytics\";a:0:{}s:23:\"all_templates_supported\";b:1;s:19:\"supported_templates\";a:1:{i:0;s:11:\"is_singular\";}s:7:\"version\";s:5:\"2.5.4\";s:12:\"reader_theme\";s:6:\"legacy\";s:20:\"paired_url_structure\";s:9:\"query_var\";s:17:\"plugin_configured\";b:0;s:24:\"delete_data_at_uninstall\";b:1;s:18:\"use_native_img_tag\";b:0;s:15:\"mobile_redirect\";b:1;s:17:\"late_defined_slug\";N;s:18:\"suppressed_plugins\";a:0:{}s:18:\"sandboxing_enabled\";b:0;s:16:\"sandboxing_level\";i:1;s:21:\"primary_theme_support\";N;}", "off");
INSERT INTO `dgfdcv_options` VALUES("506", "Newspaper_demo_state", "a:2:{s:7:\"demo_id\";s:11:\"default_pro\";s:17:\"demo_install_type\";s:4:\"full\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("505", "Newspaper_demo_history", "a:8:{s:13:\"page_on_front\";s:1:\"0\";s:13:\"show_on_front\";s:5:\"posts\";s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:10:\"td-default\";a:0:{}s:13:\"array_version\";i:3;}s:12:\"used_widgets\";a:1:{s:5:\"block\";a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}}s:13:\"theme_options\";a:44:{s:7:\"td_011_\";i:2;s:6:\"td_011\";s:44:\"KioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKio=\";s:27:\"theme_update_latest_version\";s:85:\"{\"11.4.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2022\\/04\\/Newspaper.zip\"}\";s:21:\"theme_update_versions\";s:517:\"[{\"11.4.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2022\\/04\\/Newspaper.zip\"},{\"11.4.2\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2022\\/03\\/Newspaper.zip\"},{\"11.4.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2022\\/02\\/Newspaper.zip\"},{\"11.4\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2021\\/12\\/Newspaper.zip\"},{\"11.3.2\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2021\\/11\\/Newspaper.zip\"},{\"11.3.1\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2021\\/10\\/Newspaper-1.zip\"}]\";s:14:\"td_remote_http\";a:2:{s:9:\"test_time\";i:1649849604;s:11:\"test_status\";s:9:\"wordpress\";}s:12:\"firstInstall\";s:14:\"themeInstalled\";s:13:\"td_log_status\";s:3:\"off\";s:24:\"tds_login_sign_in_widget\";s:4:\"show\";s:18:\"tds_thumb_td_150x0\";s:3:\"yes\";s:20:\"tds_thumb_td_218x150\";s:3:\"yes\";s:18:\"tds_thumb_td_300x0\";s:3:\"yes\";s:20:\"tds_thumb_td_324x400\";s:3:\"yes\";s:20:\"tds_thumb_td_485x360\";s:3:\"yes\";s:18:\"tds_thumb_td_696x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1068x0\";s:3:\"yes\";s:19:\"tds_thumb_td_1920x0\";s:3:\"yes\";s:23:\"td_social_drag_and_drop\";a:18:{s:8:\"facebook\";b:1;s:7:\"twitter\";b:1;s:9:\"pinterest\";b:1;s:8:\"whatsapp\";b:1;s:8:\"linkedin\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:4:\"mail\";s:0:\"\";s:5:\"print\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:2:\"vk\";s:0:\"\";s:4:\"digg\";s:0:\"\";s:4:\"line\";s:0:\"\";s:5:\"viber\";s:0:\"\";s:5:\"naver\";s:0:\"\";s:9:\"flipboard\";s:0:\"\";s:8:\"copy_url\";s:0:\"\";}s:18:\"td_social_networks\";a:0:{}s:10:\"td_version\";s:6:\"11.3.1\";s:9:\"td_011_tp\";i:1649849604;s:16:\"td_updated_fonts\";b:1;s:41:\"plugin_subscription_update_latest_version\";s:88:\"{\"1.3\":\"https:\\/\\/cloud.tagdiv.com\\/wp-content\\/uploads\\/2022\\/04\\/td-subscription.zip\"}\";s:15:\"firstinstallMob\";s:20:\"mobilethemeInstalled\";s:24:\"tds_logo_menu_upload_mob\";s:0:\"\";s:26:\"tds_logo_menu_upload_r_mob\";s:0:\"\";s:16:\"tds_logo_alt_mob\";s:0:\"\";s:18:\"tds_logo_title_mob\";s:0:\"\";s:14:\"tds_footer_mob\";s:0:\"\";s:26:\"tds_footer_logo_upload_mob\";s:0:\"\";s:33:\"tds_footer_retina_logo_upload_mob\";s:0:\"\";s:19:\"tds_footer_text_mob\";s:0:\"\";s:20:\"tds_footer_email_mob\";s:0:\"\";s:23:\"tds_footer_logo_alt_mob\";s:0:\"\";s:25:\"tds_footer_logo_title_mob\";s:0:\"\";s:21:\"tds_footer_social_mob\";s:0:\"\";s:18:\"tds_sub_footer_mob\";s:0:\"\";s:24:\"tds_footer_copyright_mob\";s:0:\"\";s:26:\"tds_footer_copy_symbol_mob\";s:0:\"\";s:20:\"tds_thumb_td_265x198\";s:3:\"yes\";s:20:\"tds_thumb_td_741x486\";s:3:\"yes\";s:23:\"tdm_frontpage_grid_sort\";s:6:\"latest\";s:42:\"tdm_frontpage_latest_articles_posts_offset\";s:1:\"3\";s:28:\"td_theme_deactivated_plugins\";a:0:{}s:23:\"theme_update_to_version\";s:0:\"\";}s:18:\"td_social_networks\";b:0;s:18:\"demo_settings_date\";i:1649850137;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("425", "amp_css_transient_monitor_time_series", "a:14:{i:20230925;i:85;i:20230926;i:85;i:20230929;i:85;i:20231006;i:98;i:20231009;i:115;i:20231010;i:115;i:20231011;i:115;i:20231012;i:115;i:20231216;i:13;i:20231224;i:31;i:20240118;i:41;i:20240804;i:10;i:20240906;i:14;i:20240908;i:14;}", "off");
INSERT INTO `dgfdcv_options` VALUES("426", "amp_url_validation_queue", "a:3:{s:4:\"urls\";a:1:{i:0;s:46:\"http://localhost/news-demo/%d8%aa%d8%b3%d8%aa/\";}s:9:\"timestamp\";i:1739619533;s:3:\"env\";a:3:{s:5:\"theme\";a:1:{s:9:\"Newspaper\";s:6:\"12.6.8\";}s:7:\"plugins\";a:9:{s:22:\"advanced-custom-fields\";s:5:\"6.3.5\";s:3:\"amp\";s:5:\"2.5.4\";s:14:\"classic-editor\";s:5:\"1.6.4\";s:10:\"duplicator\";s:8:\"1.5.10.2\";s:12:\"RTL-CareUnit\";s:5:\"1.7.7\";s:9:\"revslider\";s:6:\"6.7.10\";s:11:\"woocommerce\";s:5:\"9.1.4\";s:18:\"wordpress-importer\";s:5:\"0.8.2\";s:9:\"wp-shamsi\";s:5:\"4.3.3\";}s:7:\"options\";a:5:{s:23:\"all_templates_supported\";b:1;s:12:\"reader_theme\";s:6:\"legacy\";s:20:\"supported_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"supported_templates\";a:1:{i:0;s:11:\"is_singular\";}s:13:\"theme_support\";s:6:\"reader\";}}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("14158", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("24543", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.10.2\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"F:\\/laragon\\/www\\/news-demo\\/newspaper_274db7cf73e92ea05958_20241002074521_archive.zip\",\n    \"packageHash\": \"274db7c-02074521\",\n    \"installerPath\": \"F:\\/laragon\\/www\\/news-demo\\/installer.php\",\n    \"installerBootLog\": \"F:\\/laragon\\/www\\/news-demo\\/dup-installer-bootlog__956f92f-02074521.txt\",\n    \"installerLog\": \"F:\\/laragon\\/www\\/news-demo\\/dup-installer\\/dup-installer-log__956f92f-02074521.txt\",\n    \"dupInstallerPath\": \"F:\\/laragon\\/www\\/news-demo\\/dup-installer\",\n    \"origFileFolderPath\": \"F:\\/laragon\\/www\\/news-demo\\/dup-installer\\/original_files_274db7c-02074521\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"7.4.3\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 106650148,\n    \"siteNumFiles\": 20204,\n    \"siteDbSize\": 11307459,\n    \"siteDBNumTables\": 71,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1739618418\n}", "no");
INSERT INTO `dgfdcv_options` VALUES("2624", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `dgfdcv_options` VALUES("1024", "recovery_mode_email_last_sent", "1725781906", "yes");
INSERT INTO `dgfdcv_options` VALUES("648", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("649", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("508", "td_demo_categories_id", "a:26:{i:0;i:18;i:1;i:19;i:2;i:20;i:3;i:21;i:4;i:22;i:5;s:1:\"2\";i:6;i:23;i:7;i:24;i:8;i:25;i:9;i:26;i:10;i:27;i:11;i:28;i:12;i:29;i:13;i:30;i:14;i:31;i:15;i:32;i:16;i:33;i:17;i:34;i:18;i:35;i:19;i:36;i:20;i:37;i:21;i:38;i:22;i:39;i:23;i:40;i:24;i:41;i:25;i:42;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("533", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("537", "td_011_remote_cache", "a:1:{s:13:\"td_social_api\";a:3:{s:10:\"facebook_#\";a:3:{s:5:\"value\";i:0;s:7:\"expires\";i:10800;s:9:\"timestamp\";i:1747917232;}s:9:\"twitter_#\";a:3:{s:5:\"value\";i:0;s:7:\"expires\";i:10800;s:9:\"timestamp\";i:1747917232;}s:9:\"youtube_#\";a:3:{s:5:\"value\";i:0;s:7:\"expires\";i:10800;s:9:\"timestamp\";i:1747917232;}}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("712", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("5641", "woocommerce_analytics_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("5644", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("5638", "woocommerce_task_list_reminder_bar_hidden", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("6447", "woocommerce_task_list_tracked_completed_tasks", "a:4:{i:0;s:13:\"store_details\";i:1;s:8:\"purchase\";i:2;s:14:\"store_creation\";i:3;s:17:\"launch-your-store\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("6763", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "off");
INSERT INTO `dgfdcv_options` VALUES("6764", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("6762", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `dgfdcv_options` VALUES("6768", "RTL-CareUnit-PCS", "KyjMy3LySLPwctVOjMj1z_TSD6wMtAwxqAjIzCouSinNTUopsgwJd9R2qXKs8PPLzfDyLveONPW0LIvKMcv0SjeO8PLULkzXrwopMbXQd9X2MYssNE63rKpKNMmL8q_0jIxKSzLIcsrxTyu2BQA", "off");
INSERT INTO `dgfdcv_options` VALUES("6435", "wpsh_pro_license_status", "0", "yes");
INSERT INTO `dgfdcv_options` VALUES("6437", "wpsh", "a:27:{s:15:\"activate-shamsi\";s:3:\"yes\";s:14:\"country-select\";s:2:\"ir\";s:23:\"activate-shamsi-archive\";s:3:\"yes\";s:24:\"activate-shamsi-calendar\";s:3:\"yes\";s:14:\"admin-bar-date\";s:3:\"yes\";s:22:\"dashboard-font-default\";s:11:\"IRANSansWeb\";s:8:\"fa-theme\";s:3:\"yes\";s:20:\"activate-woocommerce\";s:3:\"yes\";s:23:\"activate-classic-editor\";s:3:\"yes\";s:20:\"activate-contactform\";s:3:\"yes\";s:17:\"activate-rankmath\";s:3:\"yes\";s:18:\"activate-elementor\";s:3:\"yes\";s:12:\"activate-ssl\";s:3:\"yes\";s:16:\"activate-bbpress\";s:3:\"yes\";s:18:\"activate-buddyboss\";s:3:\"yes\";s:21:\"activate-gravityforms\";s:3:\"yes\";s:13:\"fa-custom-css\";s:0:\"\";s:14:\"activate-stats\";s:2:\"no\";s:11:\"persian-num\";s:2:\"no\";s:17:\"persian-admin-num\";s:2:\"no\";s:13:\"disable_admin\";s:2:\"no\";s:17:\"disable_admin_bar\";s:2:\"no\";s:12:\"disable_copy\";s:2:\"no\";s:11:\"maintenance\";s:2:\"no\";s:9:\"woo_price\";s:2:\"no\";s:21:\"activate-admin-shamsi\";s:2:\"no\";s:26:\"activate-no-lang-no-shamsi\";s:2:\"no\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("6779", "s_DSzw-zKAjOcy52iXT0rTRIqzSvCrS1BQA", "DdJFtqNAAADAA7FAgyxmASG4JTg7JGg3GqxPP_8K9ep3sytwBOY5tw5IC75qynZxnFqbuWDmmuFJIc-j5x_BfXAg0uR1IKMuRNWO58x3smBY0Yf54dviSs6WL9Ti-r-xXjQ65h6btWpElP46Iw3wpoWBVlHpKJFU83JO3dr44ZJMOoEg2iApGKDv8gmbHNjoHR2Y3xO-Sf0gfT9yMmjbsqoMVoRQTpNoAtQLs_OZaMVdwHZs5VkemnDXxcjd8r2NGC5dtawvcM7h8G7CaIOkbEXvCK4yy4GT2C326iMokys-S7vRJoB1yZS2y6EztCY0Evw1ajoC21Fv2-6bEFByf3JToyPUraeQN-z1IOl5FsM3RFlLqX7D3vKMwjwYwGSiM9SXC6OUlCG-X66coqp4QsOymOpVI7Oo9nxA8Ad6axYg4z-NmCUnpiMLaZJPuVMFNOXIZICXeq91kcTAturcRe8a027MCIYPBRwCtj77_C7kkPl31n_Ej6DXaSEF7HwEj9QbAVM4zmWmolsmYqSLqVja9-J8Oiob-KCuSOkrWMt75TdlFqcRLPLsES9FaHusFMkMkLen4Nm-6vdiHjDA_7hSKUwvY71E7l6JT5xldtwSncBB6v1oqbq_CcUg7owI2fCGaqnfTMivqavuJW4GutBtR1_K7aUtPYNfwTWCAzRx_ejL8XNmD5_vFJdhZ0NhWIxbEZKlwMWe9Vwl_V7Vcu_maoSxeVKgQvgS_Mha5Z2gR7uTirMdV5JhyfFXIRLxgyNMuumKxCZ43a2mZZj-_Qc", "no");
INSERT INTO `dgfdcv_options` VALUES("6780", "4ae82f8dfcb51ae9e45b93fe0c618f15bcdb5192", "def502003167000e218ccf83efab359b55dadb7b15b74ad563f15cb23e4be23efacb9dc6172387ca463be5a8cf5664496cf2fe489754d81fce182ba461eadf47183c447546f238e9f268911aef4c620a902b8ffb0ee018f9ed17a7942c3e3ce109ff4c29755bb3c190ee25f823fd9f24959a05c6f3905e971c556d5e5636e6a1dd04594c96224e002e840f5543b8e66199c9cc8c7b6fca329bf96df811577337bef2748998b790e8fd4878877453975672c0a9337e718c4a6b322dbd27fce9a92cafdfcd9799b803956514a3a1b45d61c9353038d52b6654b8b2bd07559771e63b0fd7ee959cbf2c5d7312952b5e6bb1e14998a41c17407449fd9fdbef1b27edc88b1cb0dc26ffd8ae39ab1f71639ce0dd112cd1d7bdda4eab0e279c74bc6401e665877ad09bed5de0c727163c5222dcb9831d9a5243854acd3ee8817c9ed7252a9fa547ff10ad771b7e3a15440d4601c1e1af939af3a8f3f61a537673bced3ed5b553e49b991e915ec78877dd091966101ec20262a882d8f98fc233c869baf2f4cee57ee20b0330dd467fc11982d4c517c9c51c699040a4d393ef18a908777a1a35ee6f892c31fd3c045f0ad37e8c2221fecca7be17f11e061b32b0b2e010e50ee19d962977426f9274cd825574f32fea754fd5", "no");
INSERT INTO `dgfdcv_options` VALUES("14166", "rcuPluginHealthyServerIndex", "1", "no");
INSERT INTO `dgfdcv_options` VALUES("14167", "rcuPluginLastHealthyServerIndex", "1", "no");
INSERT INTO `dgfdcv_options` VALUES("9099", "user_count", "2", "no");
INSERT INTO `dgfdcv_options` VALUES("13027", "woocommerce_task_list_prompt_shown", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("13956", "woocommerce_feature_custom_order_tables_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("14071", "db_upgraded", "", "on");
INSERT INTO `dgfdcv_options` VALUES("13440", "category_children", "a:3:{i:21;a:2:{i:0;i:25;i:1;i:27;}i:22;a:4:{i:0;i:30;i:1;i:36;i:2;i:37;i:3;i:42;}i:26;a:2:{i:0;i:33;i:1;i:39;}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("13953", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `dgfdcv_options` VALUES("13954", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("13955", "woocommerce_new_product_management_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("15182", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `dgfdcv_options` VALUES("15632", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("16478", "td_covid19_data", "a:2:{s:4:\"data\";a:231:{s:11:\"Afghanistan\";a:6:{s:15:\"confirmed_cases\";i:226220;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:7950;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:206760;s:6:\"active\";i:11510;}s:7:\"Albania\";a:6:{s:15:\"confirmed_cases\";i:334726;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3602;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:329428;s:6:\"active\";i:1696;}s:7:\"Algeria\";a:6:{s:15:\"confirmed_cases\";i:271853;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:6881;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:183061;s:6:\"active\";i:81911;}s:7:\"Andorra\";a:6:{s:15:\"confirmed_cases\";i:48015;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:165;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:47563;s:6:\"active\";i:287;}s:6:\"Angola\";a:6:{s:15:\"confirmed_cases\";i:105384;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1934;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:103419;s:6:\"active\";i:31;}s:8:\"Anguilla\";a:6:{s:15:\"confirmed_cases\";i:3904;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:12;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:3879;s:6:\"active\";i:13;}s:19:\"Antigua and Barbuda\";a:6:{s:15:\"confirmed_cases\";i:9106;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:146;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8954;s:6:\"active\";i:6;}s:9:\"Argentina\";a:6:{s:15:\"confirmed_cases\";i:10070247;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:130608;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:9939639;s:6:\"active\";i:0;}s:7:\"Armenia\";a:6:{s:15:\"confirmed_cases\";i:449357;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8751;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:435162;s:6:\"active\";i:5444;}s:5:\"Aruba\";a:6:{s:15:\"confirmed_cases\";i:44224;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:292;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:42438;s:6:\"active\";i:1494;}s:9:\"Australia\";a:6:{s:15:\"confirmed_cases\";i:11774220;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:22798;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:11745992;s:6:\"active\";i:5430;}s:7:\"Austria\";a:6:{s:15:\"confirmed_cases\";i:6081287;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:22542;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6054934;s:6:\"active\";i:3811;}s:10:\"Azerbaijan\";a:6:{s:15:\"confirmed_cases\";i:833189;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:10332;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:822484;s:6:\"active\";i:373;}s:7:\"Bahamas\";a:6:{s:15:\"confirmed_cases\";i:38084;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:844;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:36366;s:6:\"active\";i:874;}s:7:\"Bahrain\";a:6:{s:15:\"confirmed_cases\";i:728744;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1574;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:726969;s:6:\"active\";i:201;}s:10:\"Bangladesh\";a:6:{s:15:\"confirmed_cases\";i:2045734;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:29477;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1998448;s:6:\"active\";i:17809;}s:8:\"Barbados\";a:6:{s:15:\"confirmed_cases\";i:109503;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:620;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:108647;s:6:\"active\";i:236;}s:7:\"Belarus\";a:6:{s:15:\"confirmed_cases\";i:994037;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:7118;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:985592;s:6:\"active\";i:1327;}s:7:\"Belgium\";a:6:{s:15:\"confirmed_cases\";i:4819546;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:34376;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4775312;s:6:\"active\";i:9858;}s:6:\"Belize\";a:6:{s:15:\"confirmed_cases\";i:70782;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:688;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:70085;s:6:\"active\";i:9;}s:5:\"Benin\";a:6:{s:15:\"confirmed_cases\";i:28014;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:163;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:27847;s:6:\"active\";i:4;}s:7:\"Bermuda\";a:6:{s:15:\"confirmed_cases\";i:18860;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:165;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:18685;s:6:\"active\";i:10;}s:6:\"Bhutan\";a:6:{s:15:\"confirmed_cases\";i:62697;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:21;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:61564;s:6:\"active\";i:1112;}s:7:\"Bolivia\";a:6:{s:15:\"confirmed_cases\";i:1207206;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:22399;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1177145;s:6:\"active\";i:7662;}s:6:\"Bosnia\";a:6:{s:15:\"confirmed_cases\";i:403117;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:16352;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:379084;s:6:\"active\";i:7681;}s:8:\"Botswana\";a:6:{s:15:\"confirmed_cases\";i:330256;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2801;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:327049;s:6:\"active\";i:406;}s:6:\"Brazil\";a:6:{s:15:\"confirmed_cases\";i:37827912;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:705962;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:36249161;s:6:\"active\";i:872789;}s:22:\"British Virgin Islands\";a:6:{s:15:\"confirmed_cases\";i:7305;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:64;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:7241;}s:6:\"Brunei\";a:6:{s:15:\"confirmed_cases\";i:311449;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:225;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:243601;s:6:\"active\";i:67623;}s:8:\"Bulgaria\";a:6:{s:15:\"confirmed_cases\";i:1315706;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:38476;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1273515;s:6:\"active\";i:3715;}s:12:\"Burkina Faso\";a:6:{s:15:\"confirmed_cases\";i:22056;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:396;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:21596;s:6:\"active\";i:64;}s:7:\"Burundi\";a:6:{s:15:\"confirmed_cases\";i:54366;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:38;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:53569;s:6:\"active\";i:759;}s:10:\"Cabo Verde\";a:6:{s:15:\"confirmed_cases\";i:64238;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:415;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:63755;s:6:\"active\";i:68;}s:8:\"Cambodia\";a:6:{s:15:\"confirmed_cases\";i:138941;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3056;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:135885;s:6:\"active\";i:0;}s:8:\"Cameroon\";a:6:{s:15:\"confirmed_cases\";i:125090;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1974;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:122807;s:6:\"active\";i:309;}s:6:\"Canada\";a:6:{s:15:\"confirmed_cases\";i:4738938;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:53936;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4659015;s:6:\"active\";i:25987;}s:21:\"Caribbean Netherlands\";a:6:{s:15:\"confirmed_cases\";i:11682;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:38;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:10476;s:6:\"active\";i:1168;}s:14:\"Cayman Islands\";a:6:{s:15:\"confirmed_cases\";i:31472;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:37;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8553;s:6:\"active\";i:22882;}s:24:\"Central African Republic\";a:6:{s:15:\"confirmed_cases\";i:15368;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:113;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:15200;s:6:\"active\";i:55;}s:4:\"Chad\";a:6:{s:15:\"confirmed_cases\";i:7701;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:194;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4874;s:6:\"active\";i:2633;}s:15:\"Channel Islands\";a:6:{s:15:\"confirmed_cases\";i:101717;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:228;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:101321;s:6:\"active\";i:168;}s:5:\"Chile\";a:6:{s:15:\"confirmed_cases\";i:5293935;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:64497;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5229316;s:6:\"active\";i:122;}s:5:\"China\";a:6:{s:15:\"confirmed_cases\";i:503302;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5272;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:379053;s:6:\"active\";i:118977;}s:8:\"Colombia\";a:6:{s:15:\"confirmed_cases\";i:6382628;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:143042;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6190683;s:6:\"active\";i:48903;}s:7:\"Comoros\";a:6:{s:15:\"confirmed_cases\";i:9109;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:161;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8939;s:6:\"active\";i:9;}s:5:\"Congo\";a:6:{s:15:\"confirmed_cases\";i:25375;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:386;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:24006;s:6:\"active\";i:983;}s:12:\"Cook Islands\";a:6:{s:15:\"confirmed_cases\";i:7158;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:7150;s:6:\"active\";i:6;}s:10:\"Costa Rica\";a:6:{s:15:\"confirmed_cases\";i:1238883;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:9428;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:860711;s:6:\"active\";i:368744;}s:7:\"Croatia\";a:6:{s:15:\"confirmed_cases\";i:1275559;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:18358;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1256843;s:6:\"active\";i:358;}s:4:\"Cuba\";a:6:{s:15:\"confirmed_cases\";i:1115131;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8530;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1106537;s:6:\"active\";i:64;}s:8:\"Curaçao\";a:6:{s:15:\"confirmed_cases\";i:45986;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:295;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:44720;s:6:\"active\";i:971;}s:6:\"Cyprus\";a:6:{s:15:\"confirmed_cases\";i:660854;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1364;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:659490;s:6:\"active\";i:0;}s:7:\"Czechia\";a:6:{s:15:\"confirmed_cases\";i:4654097;s:10:\"todayCases\";i:471;s:6:\"deaths\";i:42859;s:11:\"todayDeaths\";i:1;s:9:\"recovered\";i:4607172;s:6:\"active\";i:4066;}s:14:\"Côte d\'Ivoire\";a:6:{s:15:\"confirmed_cases\";i:88338;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:835;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:87497;s:6:\"active\";i:6;}s:3:\"DRC\";a:6:{s:15:\"confirmed_cases\";i:97697;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1468;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:84489;s:6:\"active\";i:11740;}s:7:\"Denmark\";a:6:{s:15:\"confirmed_cases\";i:3183756;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8814;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:3174942;s:6:\"active\";i:0;}s:16:\"Diamond Princess\";a:6:{s:15:\"confirmed_cases\";i:712;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:13;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:699;s:6:\"active\";i:0;}s:8:\"Djibouti\";a:6:{s:15:\"confirmed_cases\";i:15690;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:189;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:15427;s:6:\"active\";i:74;}s:8:\"Dominica\";a:6:{s:15:\"confirmed_cases\";i:15760;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:74;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:15673;s:6:\"active\";i:13;}s:18:\"Dominican Republic\";a:6:{s:15:\"confirmed_cases\";i:670627;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4384;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:666104;s:6:\"active\";i:139;}s:7:\"Ecuador\";a:6:{s:15:\"confirmed_cases\";i:1069114;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:36042;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1033072;s:6:\"active\";i:0;}s:5:\"Egypt\";a:6:{s:15:\"confirmed_cases\";i:516023;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:24613;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:442182;s:6:\"active\";i:49228;}s:11:\"El Salvador\";a:6:{s:15:\"confirmed_cases\";i:201785;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4230;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:179410;s:6:\"active\";i:18145;}s:17:\"Equatorial Guinea\";a:6:{s:15:\"confirmed_cases\";i:17229;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:183;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:16907;s:6:\"active\";i:139;}s:7:\"Eritrea\";a:6:{s:15:\"confirmed_cases\";i:10189;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:103;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:10086;s:6:\"active\";i:0;}s:7:\"Estonia\";a:6:{s:15:\"confirmed_cases\";i:619989;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3001;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:524990;s:6:\"active\";i:91998;}s:8:\"Ethiopia\";a:6:{s:15:\"confirmed_cases\";i:501032;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:7574;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:488171;s:6:\"active\";i:5287;}s:27:\"Falkland Islands (Malvinas)\";a:6:{s:15:\"confirmed_cases\";i:1930;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:0;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1930;s:6:\"active\";i:0;}s:13:\"Faroe Islands\";a:6:{s:15:\"confirmed_cases\";i:34658;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:28;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:34630;}s:4:\"Fiji\";a:6:{s:15:\"confirmed_cases\";i:69117;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:885;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:67226;s:6:\"active\";i:1006;}s:7:\"Finland\";a:6:{s:15:\"confirmed_cases\";i:1486623;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:10283;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1474795;s:6:\"active\";i:1545;}s:6:\"France\";a:6:{s:15:\"confirmed_cases\";i:40138560;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:167642;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:39970918;s:6:\"active\";i:0;}s:13:\"French Guiana\";a:6:{s:15:\"confirmed_cases\";i:98041;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:420;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:11254;s:6:\"active\";i:86367;}s:16:\"French Polynesia\";a:6:{s:15:\"confirmed_cases\";i:78632;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:649;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:77983;}s:5:\"Gabon\";a:6:{s:15:\"confirmed_cases\";i:48992;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:307;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:48674;s:6:\"active\";i:11;}s:6:\"Gambia\";a:6:{s:15:\"confirmed_cases\";i:12626;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:372;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:12189;s:6:\"active\";i:65;}s:7:\"Georgia\";a:6:{s:15:\"confirmed_cases\";i:1855289;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:17132;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1776548;s:6:\"active\";i:61609;}s:7:\"Germany\";a:6:{s:15:\"confirmed_cases\";i:38499628;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:176145;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:38240600;s:6:\"active\";i:82883;}s:5:\"Ghana\";a:6:{s:15:\"confirmed_cases\";i:171780;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1462;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:170318;s:6:\"active\";i:0;}s:9:\"Gibraltar\";a:6:{s:15:\"confirmed_cases\";i:20550;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:113;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:16579;s:6:\"active\";i:3858;}s:6:\"Greece\";a:6:{s:15:\"confirmed_cases\";i:6101379;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:37089;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6064290;s:6:\"active\";i:0;}s:9:\"Greenland\";a:6:{s:15:\"confirmed_cases\";i:11971;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:21;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2761;s:6:\"active\";i:9189;}s:7:\"Grenada\";a:6:{s:15:\"confirmed_cases\";i:19693;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:238;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:19358;s:6:\"active\";i:97;}s:10:\"Guadeloupe\";a:6:{s:15:\"confirmed_cases\";i:203235;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1021;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:202214;}s:9:\"Guatemala\";a:6:{s:15:\"confirmed_cases\";i:1278035;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:20264;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1257237;s:6:\"active\";i:534;}s:6:\"Guinea\";a:6:{s:15:\"confirmed_cases\";i:38563;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:468;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:37757;s:6:\"active\";i:338;}s:13:\"Guinea-Bissau\";a:6:{s:15:\"confirmed_cases\";i:9614;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:177;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8929;s:6:\"active\";i:508;}s:6:\"Guyana\";a:6:{s:15:\"confirmed_cases\";i:73385;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1299;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:72013;s:6:\"active\";i:73;}s:5:\"Haiti\";a:6:{s:15:\"confirmed_cases\";i:34306;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:860;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:33372;s:6:\"active\";i:74;}s:29:\"Holy See (Vatican City State)\";a:6:{s:15:\"confirmed_cases\";i:29;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:0;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:29;s:6:\"active\";i:0;}s:8:\"Honduras\";a:6:{s:15:\"confirmed_cases\";i:474078;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:11165;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:462913;}s:9:\"Hong Kong\";a:6:{s:15:\"confirmed_cases\";i:2921527;s:10:\"todayCases\";i:806;s:6:\"deaths\";i:14274;s:11:\"todayDeaths\";i:20;s:9:\"recovered\";i:2903077;s:6:\"active\";i:4176;}s:7:\"Hungary\";a:6:{s:15:\"confirmed_cases\";i:2206311;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:48881;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2152155;s:6:\"active\";i:5275;}s:7:\"Iceland\";a:6:{s:15:\"confirmed_cases\";i:209191;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:229;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:208962;}s:5:\"India\";a:6:{s:15:\"confirmed_cases\";i:44999204;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:531930;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:44466791;s:6:\"active\";i:483;}s:9:\"Indonesia\";a:6:{s:15:\"confirmed_cases\";i:6813429;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:161918;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6646827;s:6:\"active\";i:4684;}s:4:\"Iran\";a:6:{s:15:\"confirmed_cases\";i:7617752;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:146410;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:7377233;s:6:\"active\";i:94109;}s:4:\"Iraq\";a:6:{s:15:\"confirmed_cases\";i:2465545;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:25375;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2439497;s:6:\"active\";i:673;}s:7:\"Ireland\";a:6:{s:15:\"confirmed_cases\";i:1721838;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:9262;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1709802;s:6:\"active\";i:2774;}s:11:\"Isle of Man\";a:6:{s:15:\"confirmed_cases\";i:38008;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:116;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:37892;}s:6:\"Israel\";a:6:{s:15:\"confirmed_cases\";i:4839886;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:12691;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4798473;s:6:\"active\";i:28722;}s:5:\"Italy\";a:6:{s:15:\"confirmed_cases\";i:26082645;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:191715;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:25736785;s:6:\"active\";i:154145;}s:7:\"Jamaica\";a:6:{s:15:\"confirmed_cases\";i:156469;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3664;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:103191;s:6:\"active\";i:49614;}s:5:\"Japan\";a:6:{s:15:\"confirmed_cases\";i:33803572;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:74694;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:33728878;}s:6:\"Jordan\";a:6:{s:15:\"confirmed_cases\";i:1746997;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:14122;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1731007;s:6:\"active\";i:1868;}s:10:\"Kazakhstan\";a:6:{s:15:\"confirmed_cases\";i:1411831;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:13848;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1383020;s:6:\"active\";i:14963;}s:5:\"Kenya\";a:6:{s:15:\"confirmed_cases\";i:343955;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5689;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:337309;s:6:\"active\";i:957;}s:8:\"Kiribati\";a:6:{s:15:\"confirmed_cases\";i:5085;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:24;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2703;s:6:\"active\";i:2358;}s:6:\"Kuwait\";a:6:{s:15:\"confirmed_cases\";i:666284;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2570;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:660237;s:6:\"active\";i:3477;}s:10:\"Kyrgyzstan\";a:6:{s:15:\"confirmed_cases\";i:206897;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2991;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:196406;s:6:\"active\";i:7500;}s:32:\"Lao People\'s Democratic Republic\";a:6:{s:15:\"confirmed_cases\";i:218875;s:10:\"todayCases\";i:3;s:6:\"deaths\";i:758;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:218117;}s:6:\"Latvia\";a:6:{s:15:\"confirmed_cases\";i:978872;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:6400;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:971406;s:6:\"active\";i:1066;}s:7:\"Lebanon\";a:6:{s:15:\"confirmed_cases\";i:1243838;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:10952;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1087587;s:6:\"active\";i:145299;}s:7:\"Lesotho\";a:6:{s:15:\"confirmed_cases\";i:34790;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:723;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:25980;s:6:\"active\";i:8087;}s:7:\"Liberia\";a:6:{s:15:\"confirmed_cases\";i:8090;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:295;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:7783;s:6:\"active\";i:12;}s:22:\"Libyan Arab Jamahiriya\";a:6:{s:15:\"confirmed_cases\";i:507270;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:6437;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:500833;s:6:\"active\";i:0;}s:13:\"Liechtenstein\";a:6:{s:15:\"confirmed_cases\";i:21491;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:94;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:21352;s:6:\"active\";i:45;}s:9:\"Lithuania\";a:6:{s:15:\"confirmed_cases\";i:1331205;s:10:\"todayCases\";i:229;s:6:\"deaths\";i:9710;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1316311;s:6:\"active\";i:5184;}s:10:\"Luxembourg\";a:6:{s:15:\"confirmed_cases\";i:319959;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1232;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:316690;s:6:\"active\";i:2037;}s:10:\"MS Zaandam\";a:6:{s:15:\"confirmed_cases\";i:9;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:7;s:6:\"active\";i:0;}s:5:\"Macao\";a:6:{s:15:\"confirmed_cases\";i:18897;s:10:\"todayCases\";i:496;s:6:\"deaths\";i:123;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:3487;s:6:\"active\";i:15287;}s:9:\"Macedonia\";a:6:{s:15:\"confirmed_cases\";i:348411;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:9941;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:337068;s:6:\"active\";i:1402;}s:10:\"Madagascar\";a:6:{s:15:\"confirmed_cases\";i:68330;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1425;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:66862;s:6:\"active\";i:43;}s:6:\"Malawi\";a:6:{s:15:\"confirmed_cases\";i:88908;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2686;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:85651;s:6:\"active\";i:571;}s:8:\"Malaysia\";a:6:{s:15:\"confirmed_cases\";i:5126683;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:37175;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5078210;s:6:\"active\";i:11298;}s:8:\"Maldives\";a:6:{s:15:\"confirmed_cases\";i:186694;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:316;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:163687;s:6:\"active\";i:22691;}s:4:\"Mali\";a:6:{s:15:\"confirmed_cases\";i:33152;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:743;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:32332;s:6:\"active\";i:77;}s:5:\"Malta\";a:6:{s:15:\"confirmed_cases\";i:120512;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:862;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:119089;s:6:\"active\";i:561;}s:16:\"Marshall Islands\";a:6:{s:15:\"confirmed_cases\";i:16138;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:17;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:16120;s:6:\"active\";i:1;}s:10:\"Martinique\";a:6:{s:15:\"confirmed_cases\";i:230354;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1102;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:229252;}s:10:\"Mauritania\";a:6:{s:15:\"confirmed_cases\";i:63757;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:997;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:62471;s:6:\"active\";i:289;}s:9:\"Mauritius\";a:6:{s:15:\"confirmed_cases\";i:42932;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1051;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:41201;s:6:\"active\";i:680;}s:7:\"Mayotte\";a:6:{s:15:\"confirmed_cases\";i:42027;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:188;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:41839;}s:6:\"Mexico\";a:6:{s:15:\"confirmed_cases\";i:7649199;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:334472;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6899865;s:6:\"active\";i:414862;}s:10:\"Micronesia\";a:6:{s:15:\"confirmed_cases\";i:26547;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:65;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:26482;}s:7:\"Moldova\";a:6:{s:15:\"confirmed_cases\";i:621865;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:12126;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:504142;s:6:\"active\";i:105597;}s:6:\"Monaco\";a:6:{s:15:\"confirmed_cases\";i:17001;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:67;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:15992;s:6:\"active\";i:942;}s:8:\"Mongolia\";a:6:{s:15:\"confirmed_cases\";i:1010975;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2179;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1008796;s:6:\"active\";i:0;}s:10:\"Montenegro\";a:6:{s:15:\"confirmed_cases\";i:293511;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2831;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:289945;s:6:\"active\";i:735;}s:10:\"Montserrat\";a:6:{s:15:\"confirmed_cases\";i:1403;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1376;s:6:\"active\";i:19;}s:7:\"Morocco\";a:6:{s:15:\"confirmed_cases\";i:1276812;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:16297;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1256151;s:6:\"active\";i:4364;}s:10:\"Mozambique\";a:6:{s:15:\"confirmed_cases\";i:233417;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2243;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:228805;s:6:\"active\";i:2369;}s:7:\"Myanmar\";a:6:{s:15:\"confirmed_cases\";i:641293;s:10:\"todayCases\";i:3;s:6:\"deaths\";i:19495;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:619922;s:6:\"active\";i:1876;}s:8:\"N. Korea\";a:6:{s:15:\"confirmed_cases\";i:4772813;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:74;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4772739;s:6:\"active\";i:0;}s:7:\"Namibia\";a:6:{s:15:\"confirmed_cases\";i:171998;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4098;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:167099;s:6:\"active\";i:801;}s:5:\"Nauru\";a:6:{s:15:\"confirmed_cases\";i:5393;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5347;s:6:\"active\";i:45;}s:5:\"Nepal\";a:6:{s:15:\"confirmed_cases\";i:1003441;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:12031;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:991322;s:6:\"active\";i:88;}s:11:\"Netherlands\";a:6:{s:15:\"confirmed_cases\";i:8618815;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:22992;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8594711;s:6:\"active\";i:1112;}s:13:\"New Caledonia\";a:6:{s:15:\"confirmed_cases\";i:79922;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:314;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:79605;s:6:\"active\";i:3;}s:11:\"New Zealand\";a:6:{s:15:\"confirmed_cases\";i:2470435;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4849;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2464120;s:6:\"active\";i:1466;}s:9:\"Nicaragua\";a:6:{s:15:\"confirmed_cases\";i:18491;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:225;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4225;s:6:\"active\";i:14041;}s:5:\"Niger\";a:6:{s:15:\"confirmed_cases\";i:9931;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:312;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:8890;s:6:\"active\";i:729;}s:7:\"Nigeria\";a:6:{s:15:\"confirmed_cases\";i:266675;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3155;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:259953;s:6:\"active\";i:3567;}s:4:\"Niue\";a:6:{s:15:\"confirmed_cases\";i:887;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:0;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:887;s:6:\"active\";i:0;}s:6:\"Norway\";a:6:{s:15:\"confirmed_cases\";i:1489076;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5705;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1482549;s:6:\"active\";i:822;}s:4:\"Oman\";a:6:{s:15:\"confirmed_cases\";i:399449;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4628;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:384669;s:6:\"active\";i:10152;}s:8:\"Pakistan\";a:6:{s:15:\"confirmed_cases\";i:1581867;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:30664;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1538689;s:6:\"active\";i:12514;}s:5:\"Palau\";a:6:{s:15:\"confirmed_cases\";i:6241;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:9;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6227;s:6:\"active\";i:5;}s:9:\"Palestine\";a:6:{s:15:\"confirmed_cases\";i:621008;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5404;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:615445;s:6:\"active\";i:159;}s:6:\"Panama\";a:6:{s:15:\"confirmed_cases\";i:1048429;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8661;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1039693;s:6:\"active\";i:75;}s:16:\"Papua New Guinea\";a:6:{s:15:\"confirmed_cases\";i:46864;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:670;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:46168;s:6:\"active\";i:26;}s:8:\"Paraguay\";a:6:{s:15:\"confirmed_cases\";i:815869;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:20028;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:795841;}s:4:\"Peru\";a:6:{s:15:\"confirmed_cases\";i:4519976;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:222161;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4297815;s:6:\"active\";i:0;}s:11:\"Philippines\";a:6:{s:15:\"confirmed_cases\";i:4174101;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:66643;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4103828;s:6:\"active\";i:3630;}s:6:\"Poland\";a:6:{s:15:\"confirmed_cases\";i:6524464;s:10:\"todayCases\";i:265;s:6:\"deaths\";i:119654;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5335940;s:6:\"active\";i:1068870;}s:8:\"Portugal\";a:6:{s:15:\"confirmed_cases\";i:5623951;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:27509;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5589471;s:6:\"active\";i:6971;}s:5:\"Qatar\";a:6:{s:15:\"confirmed_cases\";i:514524;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:690;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:513687;s:6:\"active\";i:147;}s:7:\"Romania\";a:6:{s:15:\"confirmed_cases\";i:3468372;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:68372;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:3371974;s:6:\"active\";i:28026;}s:6:\"Russia\";a:6:{s:15:\"confirmed_cases\";i:23045833;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:400077;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:22482148;s:6:\"active\";i:163608;}s:6:\"Rwanda\";a:6:{s:15:\"confirmed_cases\";i:133194;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1468;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:131647;s:6:\"active\";i:79;}s:8:\"Réunion\";a:6:{s:15:\"confirmed_cases\";i:486588;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:921;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:418572;s:6:\"active\";i:67095;}s:8:\"S. Korea\";a:6:{s:15:\"confirmed_cases\";i:34571873;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:35934;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:34535939;s:6:\"active\";i:0;}s:12:\"Saint Helena\";a:6:{s:15:\"confirmed_cases\";i:2166;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:0;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2;s:6:\"active\";i:2164;}s:21:\"Saint Kitts and Nevis\";a:6:{s:15:\"confirmed_cases\";i:6607;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:48;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6559;s:6:\"active\";i:0;}s:11:\"Saint Lucia\";a:6:{s:15:\"confirmed_cases\";i:30122;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:409;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:29095;s:6:\"active\";i:618;}s:12:\"Saint Martin\";a:6:{s:15:\"confirmed_cases\";i:12324;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:63;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1399;s:6:\"active\";i:10862;}s:21:\"Saint Pierre Miquelon\";a:6:{s:15:\"confirmed_cases\";i:3452;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2449;s:6:\"active\";i:1001;}s:32:\"Saint Vincent and the Grenadines\";a:6:{s:15:\"confirmed_cases\";i:9631;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:124;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:9493;s:6:\"active\";i:14;}s:5:\"Samoa\";a:6:{s:15:\"confirmed_cases\";i:16778;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:31;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1605;s:6:\"active\";i:15142;}s:10:\"San Marino\";a:6:{s:15:\"confirmed_cases\";i:24695;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:126;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:24537;s:6:\"active\";i:32;}s:21:\"Sao Tome and Principe\";a:6:{s:15:\"confirmed_cases\";i:6597;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:80;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6517;s:6:\"active\";i:0;}s:12:\"Saudi Arabia\";a:6:{s:15:\"confirmed_cases\";i:841469;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:9646;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:827923;s:6:\"active\";i:3900;}s:7:\"Senegal\";a:6:{s:15:\"confirmed_cases\";i:89014;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1971;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:87024;s:6:\"active\";i:19;}s:6:\"Serbia\";a:6:{s:15:\"confirmed_cases\";i:2560024;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:18057;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2531318;s:6:\"active\";i:10649;}s:10:\"Seychelles\";a:6:{s:15:\"confirmed_cases\";i:50937;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:172;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:50750;s:6:\"active\";i:15;}s:12:\"Sierra Leone\";a:6:{s:15:\"confirmed_cases\";i:7762;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:126;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:7636;}s:9:\"Singapore\";a:6:{s:15:\"confirmed_cases\";i:2603819;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1885;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2149583;s:6:\"active\";i:452351;}s:12:\"Sint Maarten\";a:6:{s:15:\"confirmed_cases\";i:11051;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:92;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:10905;s:6:\"active\";i:54;}s:8:\"Slovakia\";a:6:{s:15:\"confirmed_cases\";i:1867647;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:21167;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1846254;s:6:\"active\";i:226;}s:8:\"Slovenia\";a:6:{s:15:\"confirmed_cases\";i:1345516;s:10:\"todayCases\";i:57;s:6:\"deaths\";i:7100;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1337079;s:6:\"active\";i:1337;}s:15:\"Solomon Islands\";a:6:{s:15:\"confirmed_cases\";i:24575;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:153;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:24422;}s:7:\"Somalia\";a:6:{s:15:\"confirmed_cases\";i:27334;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1361;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:13182;s:6:\"active\";i:12791;}s:12:\"South Africa\";a:6:{s:15:\"confirmed_cases\";i:4076463;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:102595;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:3912506;s:6:\"active\";i:61362;}s:11:\"South Sudan\";a:6:{s:15:\"confirmed_cases\";i:18368;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:138;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:18115;s:6:\"active\";i:115;}s:5:\"Spain\";a:6:{s:15:\"confirmed_cases\";i:13914811;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:121760;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:13762417;s:6:\"active\";i:30634;}s:9:\"Sri Lanka\";a:6:{s:15:\"confirmed_cases\";i:672587;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:16882;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:655699;s:6:\"active\";i:6;}s:9:\"St. Barth\";a:6:{s:15:\"confirmed_cases\";i:5507;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:6;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:5501;}s:5:\"Sudan\";a:6:{s:15:\"confirmed_cases\";i:63993;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5046;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:58947;s:6:\"active\";i:0;}s:8:\"Suriname\";a:6:{s:15:\"confirmed_cases\";i:82588;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1408;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:81180;}s:9:\"Swaziland\";a:6:{s:15:\"confirmed_cases\";i:74882;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1427;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:73116;s:6:\"active\";i:339;}s:6:\"Sweden\";a:6:{s:15:\"confirmed_cases\";i:2718172;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:24922;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:2690896;s:6:\"active\";i:2354;}s:11:\"Switzerland\";a:6:{s:15:\"confirmed_cases\";i:4414441;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:14452;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4396008;s:6:\"active\";i:3981;}s:20:\"Syrian Arab Republic\";a:6:{s:15:\"confirmed_cases\";i:57743;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3165;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:54578;s:6:\"active\";i:0;}s:6:\"Taiwan\";a:6:{s:15:\"confirmed_cases\";i:10241523;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:19005;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:10222518;s:6:\"active\";i:0;}s:10:\"Tajikistan\";a:6:{s:15:\"confirmed_cases\";i:17786;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:125;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:17264;s:6:\"active\";i:397;}s:8:\"Tanzania\";a:6:{s:15:\"confirmed_cases\";i:43078;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:846;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:42232;}s:8:\"Thailand\";a:6:{s:15:\"confirmed_cases\";i:4757473;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:34475;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:4692636;s:6:\"active\";i:30362;}s:11:\"Timor-Leste\";a:6:{s:15:\"confirmed_cases\";i:23460;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:138;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:23102;s:6:\"active\";i:220;}s:4:\"Togo\";a:6:{s:15:\"confirmed_cases\";i:39513;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:290;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:39216;s:6:\"active\";i:7;}s:7:\"Tokelau\";a:6:{s:15:\"confirmed_cases\";i:80;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:0;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:80;}s:5:\"Tonga\";a:6:{s:15:\"confirmed_cases\";i:16825;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:13;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:15638;s:6:\"active\";i:1174;}s:19:\"Trinidad and Tobago\";a:6:{s:15:\"confirmed_cases\";i:191496;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4390;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:187078;s:6:\"active\";i:28;}s:7:\"Tunisia\";a:6:{s:15:\"confirmed_cases\";i:1153361;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:29423;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:1123938;}s:6:\"Turkey\";a:6:{s:15:\"confirmed_cases\";i:17232066;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:102174;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:17129892;}s:24:\"Turks and Caicos Islands\";a:6:{s:15:\"confirmed_cases\";i:6630;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:39;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:6576;s:6:\"active\";i:15;}s:6:\"Tuvalu\";a:6:{s:15:\"confirmed_cases\";i:2943;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:0;s:6:\"active\";i:2942;}s:3:\"UAE\";a:6:{s:15:\"confirmed_cases\";i:1067030;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2349;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1054525;s:6:\"active\";i:10156;}s:2:\"UK\";a:6:{s:15:\"confirmed_cases\";i:24715857;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:229307;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:24480726;s:6:\"active\";i:5824;}s:3:\"USA\";a:6:{s:15:\"confirmed_cases\";i:108821916;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1178150;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:106612254;s:6:\"active\";i:1031512;}s:6:\"Uganda\";a:6:{s:15:\"confirmed_cases\";i:171829;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:3632;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:100431;s:6:\"active\";i:67766;}s:7:\"Ukraine\";a:6:{s:15:\"confirmed_cases\";i:5557995;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:112418;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:5445577;s:6:\"active\";i:0;}s:7:\"Uruguay\";a:6:{s:15:\"confirmed_cases\";i:1038774;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:7634;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:1030944;s:6:\"active\";i:196;}s:10:\"Uzbekistan\";a:6:{s:15:\"confirmed_cases\";i:253662;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1637;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:241486;s:6:\"active\";i:10539;}s:7:\"Vanuatu\";a:6:{s:15:\"confirmed_cases\";i:12019;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:14;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:11976;s:6:\"active\";i:29;}s:9:\"Venezuela\";a:6:{s:15:\"confirmed_cases\";i:552695;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5856;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:546537;s:6:\"active\";i:302;}s:7:\"Vietnam\";a:6:{s:15:\"confirmed_cases\";i:11623834;s:10:\"todayCases\";i:32;s:6:\"deaths\";i:43206;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:10640857;s:6:\"active\";i:939771;}s:17:\"Wallis and Futuna\";a:6:{s:15:\"confirmed_cases\";i:3550;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:8;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:438;s:6:\"active\";i:3104;}s:14:\"Western Sahara\";a:6:{s:15:\"confirmed_cases\";i:10;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:1;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:9;s:6:\"active\";i:0;}s:5:\"Yemen\";a:6:{s:15:\"confirmed_cases\";i:11945;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:2159;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:9124;s:6:\"active\";i:662;}s:6:\"Zambia\";a:6:{s:15:\"confirmed_cases\";i:349287;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:4069;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:341316;s:6:\"active\";i:3902;}s:8:\"Zimbabwe\";a:6:{s:15:\"confirmed_cases\";i:265748;s:10:\"todayCases\";i:0;s:6:\"deaths\";i:5718;s:11:\"todayDeaths\";i:0;s:9:\"recovered\";i:258888;s:6:\"active\";i:1142;}}s:9:\"timestamp\";i:1696604196;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("15934", "theplus_verified", "a:3:{s:6:\"expire\";s:8:\"lifetime\";s:7:\"license\";s:5:\"valid\";s:6:\"verify\";i:1;}", "yes");
INSERT INTO `dgfdcv_options` VALUES("15935", "theplus_purchase_code", "a:1:{s:10:\"tp_api_key\";s:20:\"********************\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("15838", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `dgfdcv_options` VALUES("17308", "t_011_options_check", "true", "no");
INSERT INTO `dgfdcv_options` VALUES("18632", "td_live_css_local_storage", "a:3:{i:0;b:0;s:3:\"css\";s:161:\"[class*=\"td-icon-\"] {\r\n  margin-left: 12px!important;\r\n  margin-right: unset !important;\r\n  line-height: 1;\r\n  text-align: center;\r\n  display: inline-block;\r\n}\r\n\";s:4:\"less\";s:169:\"[class*=\"td-icon-\"] {\r\n    margin-left: 12px!important;\r\n    margin-right: unset !important;\r\n    line-height: 1;\r\n    text-align: center;\r\n    display: inline-block;\r\n}\";}", "yes");
INSERT INTO `dgfdcv_options` VALUES("17557", "wc_blocks_use_blockified_product_grid_block_as_template", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("17558", "wc_blocks_version", "11.8.0-dev", "yes");
INSERT INTO `dgfdcv_options` VALUES("17559", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}", "yes");
INSERT INTO `dgfdcv_options` VALUES("17563", "woocommerce_custom_orders_table_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("17564", "woocommerce_feature_marketplace_enabled", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("17565", "woocommerce_feature_product_block_editor_enabled", "no", "yes");
INSERT INTO `dgfdcv_options` VALUES("17339", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `dgfdcv_options` VALUES("17562", "woocommerce_custom_orders_table_created", "yes", "yes");
INSERT INTO `dgfdcv_options` VALUES("24671", "duplicator_expire_search-replace-wpcode", "{\"expire\":1740829328,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `dgfdcv_options` VALUES("24672", "duplicator_expire_wp-mail-smtp", "{\"expire\":1740829329,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.2\"}}", "on");
INSERT INTO `dgfdcv_options` VALUES("24673", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1740829329,\"value\":{\"wp_version\":\"4.6\",\"php_version\":\"5.5\"}}", "on");
INSERT INTO `dgfdcv_options` VALUES("19537", "acf_site_health", "{\"version\":\"6.3.5\",\"plugin_type\":\"Free\",\"wp_version\":\"6.8\",\"mysql_version\":\"8.0.30\",\"is_multisite\":false,\"active_theme\":{\"name\":\"Newspaper\",\"version\":\"12.6.9\",\"theme_uri\":\"https:\\/\\/tagdiv.com\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields\\/acf.php\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.3.5\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"amp\\/amp.php\":{\"name\":\"AMP\",\"version\":\"2.5.5\",\"plugin_uri\":\"https:\\/\\/amp-wp.org\"},\"td-demo-app-find-pro\\/td-app-find-pro-demo.php\":{\"name\":\"APP Find PRO Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-demo-cali-sight-pro\\/td-cali-sight-demo.php\":{\"name\":\"Cali Sight Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"classic-editor\\/classic-editor.php\":{\"name\":\"Classic Editor\",\"version\":\"1.6.4\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/classic-editor\\/\"},\"td-demo-coaching-pro\\/td-coaching-pro-demo.php\":{\"name\":\"Coaching PRO Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"duplicator\\/duplicator.php\":{\"name\":\"Duplicator\",\"version\":\"1.5.10.2\",\"plugin_uri\":\"https:\\/\\/duplicator.com\\/\"},\"td-demo-job-hunt-pro\\/td-job-hunt-pro-demo.php\":{\"name\":\"Job Hunt PRO Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-demo-momentum-pro\\/td-momentum-pro-demo.php\":{\"name\":\"Momentum PRO Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"RTL-CareUnit\\/RTL-CareUnit.php\":{\"name\":\"RTL license management\",\"version\":\"1.7.7\",\"plugin_uri\":\"https:\\/\\/www.rtl-theme.com\\/\"},\"revslider\\/revslider.php\":{\"name\":\"Slider Revolution\",\"version\":\"6.7.10\",\"plugin_uri\":\"https:\\/\\/www.sliderrevolution.com\\/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=info\"},\"td-cloud-library\\/td-cloud-library.php\":{\"name\":\"tagDiv Cloud Library\",\"version\":\"3.8 | built on 10.02.2025 10:50\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-demo-compass-pro\\/td-compass-pro-demo.php\":{\"name\":\"tagDiv Compass PRO Demo Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-composer\\/td-composer.php\":{\"name\":\"tagDiv Composer\",\"version\":\"5.3 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"td-demo-doctors-pro\\/td-doctors-pro-demo.php\":{\"name\":\"tagDiv Doctors PRO Demo Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-demo-eastcoast-check-pro\\/td-eastcoast-check-pro-demo.php\":{\"name\":\"tagDiv EastCoast Check PRO Demo Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-mobile-plugin\\/td-mobile-plugin.php\":{\"name\":\"tagDiv Mobile Theme\",\"version\":\"2.7 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/forum.tagdiv.com\\/the-mobile-theme\\/\"},\"td-newsletter\\/td-newsletter.php\":{\"name\":\"tagDiv Newsletter\",\"version\":\"2.1 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"td-subscription\\/td-subscription.php\":{\"name\":\"tagDiv Opt-In Builder\",\"version\":\"1.7 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"td-demo-real-estate-pro\\/td-real-estate-pro-demo.php\":{\"name\":\"tagDiv Real Estate PRO Demo Plugin\",\"version\":\"1.0.0\",\"plugin_uri\":\"http:\\/\\/tagdiv.com\"},\"td-woo\\/td-woo.php\":{\"name\":\"tagDiv Shop\",\"version\":\"2.6 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"td-social-counter\\/td-social-counter.php\":{\"name\":\"tagDiv Social Counter\",\"version\":\"5.6 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"td-standard-pack\\/td-standard-pack.php\":{\"name\":\"tagDiv Standard Pack\",\"version\":\"2.7 | built on 10.02.2025 10:50\",\"plugin_uri\":\"https:\\/\\/tagdiv.com\"},\"woocommerce\\/woocommerce.php\":{\"name\":\"WooCommerce\",\"version\":\"9.1.4\",\"plugin_uri\":\"https:\\/\\/woocommerce.com\\/\"},\"wordpress-importer\\/wordpress-importer.php\":{\"name\":\"WordPress Importer\",\"version\":\"0.8.2\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-importer\\/\"},\"wp-shamsi\\/wp-shamsi.php\":{\"name\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0634\\u0645\\u0633\\u06cc \\u0648 \\u0641\\u0627\\u0631\\u0633\\u06cc \\u0633\\u0627\\u0632 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"version\":\"4.3.3\",\"plugin_uri\":\"https:\\/\\/wpvar.com\\/wp-shamsi\"}},\"ui_field_groups\":\"0\",\"php_field_groups\":\"0\",\"json_field_groups\":\"16\",\"rest_field_groups\":\"0\",\"number_of_fields_by_type\":{\"url\":12,\"tab\":2,\"text\":33,\"email\":8,\"textarea\":9,\"file\":2,\"image\":10,\"wysiwyg\":3,\"number\":8,\"select\":13,\"message\":2,\"radio\":1,\"checkbox\":4},\"number_of_third_party_fields_by_type\":{\"\\u0645\\u062a\\u0646\":1},\"post_types_enabled\":true,\"ui_post_types\":\"27\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"35\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":true,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":9,\"last_updated\":1746013846}", "off");
INSERT INTO `dgfdcv_options` VALUES("24300", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `dgfdcv_options` VALUES("19685", "woocommerce_remote_variant_assignment", "99", "auto");
INSERT INTO `dgfdcv_options` VALUES("24891", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `dgfdcv_options` VALUES("19684", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `dgfdcv_options` VALUES("19718", "revslider-library-check", "1747917174", "auto");
INSERT INTO `dgfdcv_options` VALUES("19719", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "auto");
INSERT INTO `dgfdcv_options` VALUES("19720", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"B