<!-- used to validate the theme settings reset input value -->
<script type="text/javascript">
    function tdValidateReset() {
        var resetInputField = document.forms["td_panel_reset_settings"]["td_unregistered[tds_reset_theme_options]"];

        if (resetInputField.value != "reset") {
            alert('لطفاً مطمئن شوید که در قسمت ورودی "تنظیم مجدد" نوشته اید.');

            // clear field value
            resetInputField.value = '';
            return false;
        }
        return true;
    }
</script>

<?php

$show_update_msg = 0;


// import theme settings
if (!empty($_REQUEST['action_import']) && $_REQUEST['action_import'] == 'import_theme_settings') {


    if (empty($_POST['td_magic_token']) || wp_verify_nonce($_POST['td_magic_token'], 'td-import-panel') === false) {
        echo 'Permission denied';
        die;
    }


    if (!empty($_POST['td_update_theme_options']['tds_update_theme_options'])) {
        if (td_util::tdc_is_installed()) {
            try {
                $theme_settings = unserialize(tdc_b64_decode($_POST['td_update_theme_options']['tds_update_theme_options']));
            } catch (Exception $ex) {
                //
            }
        }
        if (is_array($theme_settings)) {
            if (update_option(TD_THEME_OPTIONS_NAME, $theme_settings)) {
                td_options::save_all_options($theme_settings);
                $show_update_msg = 1;
            }
        } else {
            //imported data is invalid
            $show_update_msg = 3;
        }
    }
}


// reset theme settings
if (!empty($_REQUEST['action_reset']) && $_REQUEST['action_reset'] == 'reset_theme_settings') {

    if (empty($_POST['td_magic_token']) || wp_verify_nonce($_POST['td_magic_token'], 'td-import-panel') === false) {
        echo 'Permission denied';
        die;
    }

    if (isset($_POST['td_unregistered']['tds_reset_theme_options']) && $_POST['td_unregistered']['tds_reset_theme_options'] == 'reset') {

        // if a demo is installed remove it
        $installed_demo = td_demo_state::get_installed_demo();
        if ($installed_demo !== false) {

            //            // remove demo content
            //            td_demo_media::remove();
            //            td_demo_content::remove();
            //            td_demo_category::remove();
            //            td_demo_menus::remove();
            //            td_demo_widgets::remove();
            //
            // restore all settings to the state before a demo was loaded
            //            $td_demo_history = new td_demo_history();
            //            $td_demo_history->restore_all();
            //
            //            // update status to default - no demo installed
            //            td_demo_state::update_state('', '');
        }

        // delete the theme settings
        if (delete_option(TD_THEME_OPTIONS_NAME)) {
            $show_update_msg = 2;

            // Composer does itself an update for TD_THEME_OPTIONS_NAME on wp shutdown hook. That's why we need to come a little bit later for deleting TD_THEME_OPTIONS_NAME
            add_action('shutdown', function () {
                delete_option(TD_THEME_OPTIONS_NAME);
            }, 11);
        }
    }
}

// export demo settings
$show_demo_export_settings_textarea = false;
if (!empty($_REQUEST['action_export_demo']) && $_REQUEST['action_export_demo'] == 'export_demo_settings') {

    // remove ads
    td_demo_misc::clear_all_ads();

    // remove all other uploaded images
    td_demo_misc::clear_uploads_for_demo_export();

    // update this variable to show the textarea box with demo serialized settings
    $show_demo_export_settings_textarea = true;
}

?>
<div class="td_displaying_saving"></div>
<div class="td_wrapper_saving_gifs">
    <img class="td_displaying_saving_gif" src="<?php echo td_global::$get_template_directory_uri ?>/legacy/common/wp_booster/wp-admin/images/panel/loading.gif">
    <img class="td_displaying_ok_gif" src="<?php echo td_global::$get_template_directory_uri ?>/legacy/common/wp_booster/wp-admin/images/panel/saved.gif">
</div>


<div class="wrap">

    <div class="td-container-wrap">

        <div class="td-panel-main-header">
            <img src="<?php echo td_util::get_wl_val('tds_wl_logo', td_global::$get_template_directory_uri . '/legacy/common/wp_booster/wp-admin/images/panel/panel-wrap/panel-logo.png') ?>" alt="Panel logo" />
            <div class="td-panel-header-desc">
                <span class="td-panel-header-name">نیوزپیپر - پنل قالب </span>
                <span class="td-panel-header-version">نسخه: <?php echo TD_THEME_VERSION; ?></span>
            </div>
        </div>


        <div id="td-container-left">
            <div id="td-container-right">
                <div id="td-col-left">
                    <ul class="td-panel-menu">
                        <li class="td-welcome-menu">
                            <a data-td-is-back="yes" class="td-panel-menu-active" href="?page=td_theme_panel">
                                <span class="td-sp-nav-icon td-ico-export"></span>
                                درون ریز / برون ریز <span class="td-no-arrow"></span>
                            </a>
                        </li>

                        <li>
                            <a data-td-is-back="yes" href="?page=td_theme_panel">
                                <span class="td-sp-nav-icon td-ico-back"></span>
                                برگشت
                                <span class="td-no-arrow"></span>
                            </a>
                        </li>
                    </ul>
                </div>
                <div id="td-col-right" class="td-panel-content">

                    <div id="td-panel-welcome" class="td-panel-active td-panel">

                        <?php echo td_panel_generator::box_start('درون ریزی کردن / برون ریزی کردن تنظیمات تم'); ?>

                        <!-- Import/Export theme settings -->
                        <form id="td_panel_import_export_settings" name="td_panel_import_export_settings" action="?page=td_theme_panel&td_page=td_view_import_export_settings&action_import=import_theme_settings" method="post" onsubmit="tdConfirm.showModal( 'آیا مطمئن هستید که می خواهید این تنظیمات را وارد کنید؟',

		                window,

		                function( formObject ) {
		                    formObject.submit();
		                    tb_remove();
		                },

		                [this],

                        'اونی که الان دارید رونویسی میکنه!'); return false">

                            <input type="hidden" name="td_magic_token" value="<?php echo wp_create_nonce("td-import-panel") ?>" />
                            <input type="hidden" name="action" value="td_ajax_update_panel">

                            <div class="td-box-row">
                                <div class="td-box-description td-box-full">
                                    <span class="td-box-title">صادر کردن تنظیمات تم</span>
                                    <p>
                                        این کادر شامل تمامی گزینه های پنل تم است که به صورت رشته ای کدگذاری شده اند تا بتوانید به راحتی آنها را کپی کرده و به سرور دیگری منتقل کنید.
                                    </p>
                                </div>
                                <div class="td-box-control-full">
                                    <?php
                                    // encode only if the value is set - else it displays some strange characters
                                    $td_read_theme_settings = get_option(TD_THEME_OPTIONS_NAME);
                                    if (!empty($td_read_theme_settings) && td_util::tdc_is_installed()) {
                                        $td_read_theme_settings = tdc_b64_encode(serialize(get_option(TD_THEME_OPTIONS_NAME)));
                                    }
                                    echo td_panel_generator::textarea(array(
                                        'ds' => 'td_unregistered',
                                        'option_id' => 'tds_read_theme_options',
                                        'value' => $td_read_theme_settings
                                    ));
                                    ?>
                                </div>
                                <div class="td-box-row-margin-bottom"></div>
                            </div>

                            <div class="td-box-row td-import-settings-col-1">
                                <div class="td-box-description td-box-full">
                                    <span class="td-box-title">وارد کردن تنظیمات تم</span>
                                    <p>رشته تنظیمات رمزگذاری شده خود را در اینجا جای‌گذاری کنید، و طرح زمینه گزینه‌ها را در پایگاه داده بارگیری می‌کند.</p>
                                </div>
                                <div class="td-box-control-full">
                                    <?php
                                    echo td_panel_generator::textarea(array(
                                        'ds' => 'td_update_theme_options',
                                        'option_id' => 'tds_update_theme_options'
                                    ));
                                    ?>
                                </div>

                                <div class="td-box-row-margin-bottom"></div>
                            </div>

                            <div class="td-box-row td-import-settings-col-2">
                                <div class="td-box-description td-box-full">
                                    <?php
                                    echo td_panel_generator::checkbox(array(
                                        'ds' => 'td_option',
                                        'option_id' => TD_THEME_OPTIONS_NAME . '_settings_disabled',
                                        'true_value' => '',
                                        'false_value' => 'no',
                                        'class' => 'test'
                                    ));
                                    ?>
                                    <div class="td-box-row-bk-limit">

                                        <span class=" td-box-title td-title-on-row">محدودیت پشتیبان گیری
                                            <?php td_util::tooltip_html('
                                        <ul>
<li>این گزینه به شما اجازه می‌دهد تا محدودیت پشتیبان‌گیری را برای ذخیره در پایگاه داده تنظیم کنید. </li>
 <li>در اقدام بعدی تنظیمات ذخیره، شماره پشتیبان در پایگاه داده منعکس خواهد شد.</li>
                                        </ul>
                                    ', 'left') ?>
                                        </span>
                                        <?php
                                        echo td_panel_generator::dropdown(array(
                                            'ds' => 'td_option',
                                            'option_id' => 'td_tp_backup_limit',
                                            'values' => array(
                                                array('text' => '5', 'val' => 5),
                                                array('text' => '4', 'val' => 4),
                                                array('text' => '3', 'val' => 3),
                                                array('text' => '2', 'val' => 2),
                                                array('text' => '1', 'val' => 1),
                                            ),
                                            'class' => 'td_tp_backup_limit'
                                        ));
                                        ?>
                                    </div>
                                    <script>
                                        (function() {
                                            jQuery().ready(function() {

                                                var $tdBackupSelect = jQuery('.td-select-style-overwrite.td_tp_backup_limit'),
                                                    $tdBackupLimit = $tdBackupSelect.find('انتخاب [name^="td_option[td_tp_backup_limit"]');

                                                if ($tdBackupSelect.length) {
                                                    $tdBackupSelect.find('.td-panel-dropdown').on('change', function() {
                                                        var backupLimit = $tdBackupLimit.val();

                                                        jQuery.ajax({
                                                            type: 'POST',
                                                            url: td_ajax_url,
                                                            data: {
                                                                action: 'td_ajax_backup_limit',
                                                                limit: backupLimit,
                                                            },
                                                            success: function(data, textStatus, XMLHttpRequest) {},
                                                            error: function(MLHttpRequest, textStatus, errorThrown) {
                                                                //console.log(errorThrown);
                                                            }
                                                        });
                                                    });
                                                }

                                                jQuery('.td-checkbox.test').on('click', function() {
                                                    if ('' === jQuery(this).parent().find('input[type="hidden"]').val()) {
                                                        tdConfirm.modal({
                                                            caption: 'پشتیبان گیری پنل شما متوقف می شود!',
                                                            htmlInfoContent: function() {
                                                                return "شما می توانید آن را دوباره فعال کنید.<br><div class="
                                                                td - backup - wrap ">' +
                                                                '<input type="checkbox" name="tdc-delete-backups" style="background-color: #FFF; width: auto">' +
                                                                '<label for="tdc-delete-backups">آیا می خواهید نسخه های پشتیبان موجود را حذف کنید؟</label>' +
                                                                '</div>'
                                                            },
                                                            callbackYes: function() {
                                                                var deleteBackups = jQuery('input[type="checkbox"][name="tdc-delete-backups"]').is(':checked');
                                                                if (deleteBackups) {
                                                                    jQuery('.td-theme-settings-list').html('');
                                                                    jQuery('.td-theme-settings-diff').hide();
                                                                }

                                                                jQuery.ajax({
                                                                    type: 'POST',
                                                                    url: td_ajax_url,
                                                                    data: {
                                                                        action: 'td_ajax_backup_panel',
                                                                        status: 1,
                                                                        delete: deleteBackups ? 1 : 0
                                                                    },
                                                                    success: function(data, textStatus, XMLHttpRequest) {},
                                                                    error: function(MLHttpRequest, textStatus, errorThrown) {
                                                                        //console.log(errorThrown);
                                                                    }
                                                                });
                                                                tb_remove();
                                                            },
                                                            callbackNo: function() {
                                                                jQuery('.td-checkbox.test').trigger('click');
                                                            },
                                                            offOverlayClick: true,
                                                            hideCloseButton: true
                                                        });
                                                    } else {
                                                        jQuery.ajax({
                                                            type: 'POST',
                                                            url: td_ajax_url,
                                                            data: {
                                                                action: 'td_ajax_backup_panel',
                                                                status: '',
                                                            },
                                                            success: function(data, textStatus, XMLHttpRequest) {},
                                                            error: function(MLHttpRequest, textStatus, errorThrown) {
                                                                //console.log(errorThrown);
                                                            }
                                                        });
                                                    }
                                                });
                                            });
                                        })();
                                    </script>
                                    <span class="td-box-title">پشتیبان‌گیری تنظیمات پانل تم</span>
                                    <p>پشتیبان‌های ذخیره شده قبلی شما</p>
                                </div>
                                <div class="td-box-control-full">
                                    <ul class="td-theme-settings-list">
                                        <?php

                                        $option_settings = get_option(TD_THEME_OPTIONS_NAME . '_settings');
                                        // is_null() was replaced with empty() to fix warning error
                                        if (!empty($option_settings)) {
                                            foreach ($option_settings as $key => $option_setting) {
                                                echo '<li class="td-theme-settings" data-value="' . tdc_b64_encode(serialize($option_setting)) . '" data-compare="' . tdc_b64_encode(json_encode($option_setting)) . '">' . $key . '</li>';
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>

                            <div class="td-box-row">
                                <input type="submit" class="td-big-button td-button-remove-border" name="action" value="تنظیمات تم را وارد کنید">
                            </div>

                            <div class="td-box-section-separator"></div>
                        </form>

                        <!-- Reset theme settings -->
                        <form id="td_panel_reset_settings" name="td_panel_reset_settings" action="?page=td_theme_panel&td_page=td_view_import_export_settings&action_reset=reset_theme_settings" method="post" onsubmit="return tdValidateReset();">
                            <input type="hidden" name="td_magic_token" value="<?php echo wp_create_nonce("td-import-panel") ?>" />
                            <input type="hidden" name="action" value="td_ajax_update_panel">

                            <div class="td-box-row">
                                <div class="td-box-description td-box-full">
                                    <span class="td-box-title">تنظیمات تم را بازنشانی کنید</span>
                                    <p>
                                        برای بازنشانی تنظیمات تم، در فیلد زیر "تنظیم مجدد" را وارد کرده و دکمه "تنظیم مجدد تنظیمات تم" را فشار دهید.
                                        <?php td_util::tooltip_html('
<h3>تنظیمات طرح زمینه را بازنشانی کنید:</h3>
 <p>این گزینه به شما امکان می دهد تنظیمات طرح زمینه را بازنشانی کنید:</p>
 <ul>
 <li>اگر نسخه آزمایشی نصب شده باشد، محتوای آن نیز حذف خواهد شد.</li>
 <li>زمینه به حالت پیش فرض برمی گردد، همانطور که در اولین نصب آن بود.</li>
 <li>توجه داشته باشید که طول این فرآیند ممکن است متفاوت باشد (10 تا 40 ثانیه)، لطفاً صبر کنید تا پیام تأیید بازنشانی ظاهر شود.</li>
 </ul>
                                    ', 'left') ?>
                                    </p>
                                </div>
                                <div class="td-box-control-full">
                                    <?php
                                    echo td_panel_generator::input(array(
                                        'ds' => 'td_unregistered',
                                        'option_id' => 'tds_reset_theme_options',
                                        'placeholder' => 'reset',
                                    ));
                                    ?>
                                </div>
                                <div class="td-box-row-margin-bottom"></div>
                            </div>

                            <div class="td-box-row td-reset-theme-settings">
                                <input type="submit" class="td-big-button td-button-remove-border" name="action" value="تنظیمات تم را بازنشانی کنید">
                            </div>
                        </form>

                        <?php echo td_panel_generator::box_end(); ?>

                        <?php if (TD_DEPLOY_MODE == 'demo' or TD_DEPLOY_MODE == 'dev') { ?>

                            <?php echo td_panel_generator::box_start('صادرات تنظیمات تم برای نسخه ی نمایشی'); ?>

                            <!-- Export Settings for Demo -->
                            <form id="td_panel_export_demo_settings"
                                name="td_panel_export_demo_settings"
                                action="?page=td_theme_panel&td_page=td_view_import_export_settings&action_export_demo=export_demo_settings"
                                method="post"
                                onsubmit="
                      tdConfirm.showModal( 'آیا مطمئنید که می‌خواهید این تنظیمات نمایشی را صادر کنید؟',
		                window,
		                function( formObject ) {
		                    formObject.submit();
		                    tb_remove();
		                },
		                [this],
                        'تمام تصاویر لوگو و پس زمینه آپلود شده را حذف می کند و همچنین تمام کدهای تبلیغات پانل را حذف می کند!');
                        return false
                        ">

                                <input type="hidden" name="action" value="td_ajax_update_panel">

                                <div class="td-box-row">
                                    <div class="td-box-description td-box-full">
                                        <span class="td-box-title">صادر کردن تنظیمات آزمایشی</span>
                                        <p>
                                            این بخش شامل تمام گزینه های پانل برای صادرات تنظیمات دمو (بدون لوگو، تبلیغات، پس زمینه...) است.
                                        </p>
                                    </div>

                                    <?php
                                    if ($show_demo_export_settings_textarea) { ?>

                                        <div class="td-box-control-full">
                                            <?php
                                            $td_export_demo_settings_ref = &td_options::get_all_by_ref();

                                            $td_export_demo_settings = '';
                                            if (!empty($td_export_demo_settings_ref) && td_util::tdc_is_installed()) {
                                                $td_export_demo_settings = tdc_b64_encode(serialize($td_export_demo_settings_ref));
                                            }
                                            echo td_panel_generator::textarea(array(
                                                'ds' => 'td_unregistered',
                                                'option_id' => 'tds_export_demo_settings',
                                                'value' => $td_export_demo_settings
                                            ));
                                            ?>
                                        </div>

                                    <?php } ?>

                                    <div class="td-box-row-margin-bottom"></div>
                                </div>

                                <div class="td-box-row td-demo-export-settings">
                                    <input type="submit" class="td-big-button td-button-remove-border" name="action" value="صادرات تنظیمات نسخه ی نمایشی">
                                </div>

                            </form>

                            <?php echo td_panel_generator::box_end(); ?>

                        <?php } ?>

                    </div>


                </div>
            </div>
        </div>

        <div class="td-clear"></div>

    </div>

    <div class="td-clear"></div>

</div>
<?php if ($show_update_msg == 1) { ?><script type="text/javascript">
        alert('درون ریزی انجام شد!');
    </script><?php } ?>
<?php if ($show_update_msg == 2) { ?><script type="text/javascript">
        alert('بازنشانی تنظیمات طرح زمینه کامل شد!');
    </script><?php } ?>
<?php if ($show_update_msg == 3) { ?><script type="text/javascript">
        alert('داده های وارد شده نامعتبر است. تنظیمات طرح زمینه به روز نشد!');
    </script><?php } ?>
<br><br><br><br><br><br><br>
