<?php
/**
 * Created by ra on 1/13/2015.
 */
$category_id = td_util::get_http_post_val('category_id');

//$tdb_gloobal_category_template_is_set = td_util::get_http_post_val('tdb_category_template_is_set');
//$tdb_individual_category_template = td_util::get_category_option($category_id, 'tdb_category_template');  // read the category setting

    if ( td_global::is_tdb_registered() ) {

        $tdb_category_template_type_values = array();

        // read the tdb category templates
        $wp_query_templates = new WP_Query( array(
                'post_type' => 'tdb_templates',
                'posts_per_page' => -1
            )
        );

        if ( !empty( $wp_query_templates->posts ) ) {

            foreach ( $wp_query_templates->posts as $post ) {

                $tdb_template_type = get_post_meta( $post->ID, 'tdb_template_type', true );
                $meta_is_mobile_template = get_post_meta($post->ID, 'tdc_is_mobile_template', true);

                if ( $tdb_template_type === 'category' && (empty($meta_is_mobile_template) || '0' === $meta_is_mobile_template)) {
                    $tdb_category_template_type_values [] = array(
                        'text' => $post->post_title,
                        'val' => 'tdb_template_' . $post->ID
                    );
                }
            }
        }

        $option_id = 'tdb_category_template';
        $lang = '';

        if (class_exists('SitePress', false)) {
            global $sitepress;
            $sitepress_settings = $sitepress->get_settings();
            if ( isset($sitepress_settings['custom_posts_sync_option'][ 'tdb_templates']) ) {
                $translation_mode = (int)$sitepress_settings['custom_posts_sync_option']['tdb_templates'];
                if (1 === $translation_mode) {
                    $lang = $sitepress->get_current_language();
                }
            }
        }

?>

    <!-- TDB Category template -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">الگوی دسته بندی کتابخانه ابری</span>
            <p>یک <a href="<?php echo admin_url( 'admin.php?page=tdb_cloud_templates' ) ?>" target="_blank">الگوی ابر</a> برای این دسته تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full">

            <?php

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdb_category_template' . $lang,
                'values' => array_merge(
                    array(
                        array(
                            'text' => 'از تنظیمات جهانی ارث ببرید',
                            'val' => ''
                        ),
                        array(
                            'text' => 'قالب های تم',
                            'val' => 'theme_templates'
                        ),
                    ),
                    $tdb_category_template_type_values
                )
            ));

            ?>

        </div>
    </div>

    <!-- TDB Category template -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">الگوی Post Cloud Library</span>
            <p>یک <a href="<?php echo admin_url( 'admin.php?page=tdb_cloud_templates' ) ?>" target="_blank">الگوی پست ابر</a> برای پست‌های این دسته تنظیم کنید.</p>
        </div>
        <div class="td-box-control-full">

            <?php

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdb_post_category_template' . $lang,
                'values' => array_merge(
                    array(
                        array(
                            'text' => 'از Post Global Settings ارث ببرید',
                            'val' => ''
                        ),
                    ),
                    array_filter( td_api_single_template::_helper_td_global_list_to_panel_values(), function( $el ) {
                        return strpos( $el['val'], 'tdb_template_' ) !== false;
                    })
                )
            ));

            ?>

        </div>
    </div>

    <div class="td-box-section-separator"></div>

<?php }

if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK') ) ) { ?>

    <!-- Category template -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">قالب دسته</span>
            <p>این سرفصل دسته است</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_category_template',
                'values' => td_api_category_template::_helper_to_panel_values('default+get_all')
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- Category top posts style -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">سبک پست های برتر دسته</span>
            <p>نحوه نمایش پست های برتر را انتخاب کنید. به‌طور پیش‌فرض، تنظیمات رده جهانی را از بالای این صفحه به ارث می‌برد.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_category_top_posts_style',
                'values' => td_api_category_top_posts_style::_helper_to_panel_values('default+get_all')
            ));
            ?>
        </div>
    </div>

<?php
// show the $big_grid_styles_list only if we have big grids
// Newsmag as of 10 march is not using $big_grid_styles_list
if (!empty(td_global::$big_grid_styles_list)) { ?>
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">رده پست های برتر GRID STYLE</span>
            <p>هر شبکه دسته بندی از چندین سبک پشتیبانی می کند</p>
        </div>
        <div class="td-box-control-full">
            <?php
            $td_grid_style_values = array(
                array(
                    'text' => 'از تنظیمات جهانی ارث بری کنید',
                    'val' => ''
                )
            );
            foreach (td_global::$big_grid_styles_list as $big_grid_id => $params) {
                $td_grid_style_values []= array(
                    'text' => $params['text'],
                    'val' => $big_grid_id
                );
            }

            echo td_panel_generator::dropdown(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_category_td_grid_style',
                'values' => $td_grid_style_values
            ));
            ?>
        </div>
    </div>
<?php } ?>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_layout',
                'values' => td_panel_generator::helper_display_modules('default+enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">سبک صفحه بندی</span>
            <p>یک سبک صفحه بندی برای این دسته تنظیم کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_category',
                'option_id' => 'tdc_category_pagination_style',
                'item_id' => $category_id,
                'values' => array(
                    array (
                        'val' => '',
                        'text' => 'از تنظیمات جهانی ارث بری کنید',
                    ),

                    array (
                        'val' => 'normal',
                        'text' => 'Normal pagination'
                    ),
                    array (
                        'val' => 'infinite',
                        'text' => 'Infinite loading'
                    ),
                    array (
                        'val' => 'infinite_load_more',
                        'text' => 'Infinite loading + Load more'
                    )
                )
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator tdb-hide"></div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_category',
                    'item_id' => $category_id,
                    'option_id' => 'tdc_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Default', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-default.png'),
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => 'sidebar_right', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_category',
                    'item_id' => $category_id,
                    'option_id' => 'tdc_sidebar_name'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>
<?php } ?>

    <!-- Category color -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">رنگ تگ رده در صفحه پست</span>
            <p>یک رنگ برای برچسب این دسته در صفحه پست انتخاب کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::color_picker(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_color',
                'default_color' => ''
            ));
            ?>
        </div>
    </div>

    <!-- BACKGROUND UPLOAD -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">آپلود پس زمینه</span>
            <p>تصویر پس زمینه خود را آپلود کنید.</br> می توانید از:</p>
            <ul>
                <li>تک تصویر</li>
                <li>الگو</li>
            </ul>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::upload_image(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_image'
            ));
            ?>
        </div>
    </div>

<?php if ( td_global::is_tdb_registered() ) { ?>

    <!-- BACKGROUND BOXED LAYOUT -->
    <div class="td-box-row tdb-show">
        <div class="td-box-description">
            <span class="td-box-title">طرح بندی جعبه ای پس زمینه</span>
            <p>طرح بندی جعبه پس زمینه را ایجاد کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox( array(
                'ds'          => 'td_category',
                'item_id'     => $category_id,
                'option_id'   => 'tdb_show_background',
                'true_value'  => '',
                'false_value' => 'hide'
            ) );
            ?>
        </div>
    </div>

<?php }
if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK') ) ) { ?>

    <!-- BACKGROUND STYLE -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">سبک پس زمینه</span>
            <p>نحوه نمایش پس زمینه</p>
            <ul>
                <li><b>کشش:</b> هنگامی که از یک تصویر واحد برای پس زمینه خود استفاده می کنید و می خواهید این تصویر کل پس زمینه را پر کند از این گزینه استفاده کنید.</li>
                <li><b>Tiled:</b> از این گزینه زمانی که از یک الگو برای پس زمینه خود استفاده می کنید استفاده کنید.</li>
            </ul>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_bg_repeat',
                'values' => array(
                    array('text' => 'پیش فرض', 'val' => ''),
                    array('text' => 'کشش', 'val' => 'stretch'),
                    array('text' => 'Tiled', 'val' => 'tile')
                )
            ));
            ?>
        </div>
    </div>
<?php } ?>

    <!-- Background color -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">رنگ پس زمینه</span>
            <p>به جای تصویر از رنگ ثابت استفاده کنید</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::color_picker(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_bg_color',
                'default_color' => ''
            ));
            ?>
        </div>
    </div>

    <!-- Hide category tag on post -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">رده را در پست و در صفحات دسته پنهان کنید</span>
            <p>نمایش یا پنهان کردن دسته در صفحه تک پست و در صفحات دسته. اگر می‌خواهید دسته‌های پنهانی برای مرتب کردن چیزها داشته باشید مفید است.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_category',
                'item_id' => $category_id,
                'option_id' => 'tdc_hide_on_post',
                'true_value' => 'hide',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>
