<!-- smart sidebar support -->
<?php echo td_panel_generator::box_start('نوار کناری هوشمند', false); ?>

<div class="td-box-row">

    <div class="td-box-description td-box-full">
        <?php echo td_api_text::get('text_smart_sidebar_widget_support') ?>
    </div>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <span class="td-box-title">هشدار</span>
            <p>اگر قصد دارید از Google AdSense در نوار کناری استفاده کنید، این ویژگی را فعال نکنید. خط‌مشی Google اجازه نمی‌دهد آگهی را در یک "جعبه شناور" قرار دهید، می‌توانید درباره آن بیشتر بخوانید <a target="_blank" href="https://support.google.com/adsense/answer/1354742?hl=en">اینجا</a>.</p>
        </div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری هوشمند</span>
            <p>فعال / غیرفعال کردن نوار کناری هوشمند در همه الگوها</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_smart_sidebar',
                'true_value' => 'enabled',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row-margin-bottom"></div>

</div>

<?php echo td_panel_generator::box_end();?>

<!-- smart sidebar support -->
<?php echo td_panel_generator::box_start('دکمه برو بالا', false); ?>

<div class="td-box-row">

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>از اینجا می توانید دکمه برو بالا را فعال و غیرفعال کنید:</p>
        </div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">دکمه فعال کردن</span>
            <p>نمایش دکمه برو بالا.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_to_top',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش در موبایل</span>
            <p>دکمه را در دستگاه های تلفن همراه فعال کنید.</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_to_top_on_mobile',
                'true_value' => 'show',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <?php if ( 'Newspaper' == TD_THEME_NAME ) { ?>
        <div class="td-box-row">
            <div class="td-box-description">
                <span class="td-box-title">سبک</span>
                <p></p>
            </div>
            <div class="td-box-control-full">
                <?php
                echo td_panel_generator::radio_button_control(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_to_top_style',
                    'values' => array (
                        array('text' => '<strong>استایل 1</strong> - پیش فرض', 'val' => ''),
                        array('text' => '<strong>استایل 2</strong> - دایره پیشرفت', 'val' => 'style2'),
                    )
                ));
                ?>
            </div>
        </div>
    <?php } ?>

    <div class="td-box-row-margin-bottom"></div>

</div>

<?php echo td_panel_generator::box_end();?>



<!-- breadcrumbs -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK') ) ) {
    echo td_panel_generator::box_start('Breadcrumbs', false); ?>

    <!-- text -->
    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>از اینجا می‌توانید نان‌هایی را که در سایتتان ظاهر می‌شوند سفارشی کنید. آرد سوخاری بسیار مفید است
 عنصر ناوبری که شبیه این «صفحه اصلی > دسته من > عنوان مقاله من» است.
 از آنجایی که پودر سوخاری برای انسان و موتورهای جستجو بسیار مهم است
 خزنده ها، تم با گزینه های پیکربندی گسترده ای برای آنها ارائه می شود.
            </p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <div class="td-box-section-separator"></div>

    <!-- Show breadcrumbs on post -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">خرده نان را نشان دهید</span>
            <p>
                breadcrumbs را فعال یا غیرفعال کنید
                <?php td_util::tooltip_html('
                    <h3>فعال/غیرفعال کردن  breadcrumbs:</h3>
                    <p>از اینجا می توانید breadcrumbs را فعال و غیرفعال کنید. این تنظیمات بر تمام صفحات سایت تاثیر می گذارد.</p>

            ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_breadcrumbs_show',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

    <!-- Show breadcrumbs home link -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">پیوند صفحه اصلی خرده نان را نشان دهید</span>
            <p>
            نمایش یا پنهان کردن پیوند خانه در breadcrumbs
                <?php td_util::tooltip_html('
                    <h3>نمایش یا پنهان کردن پیوند خانه در breadcrumbs:</h3>
                    <p>توصیه می کنیم برای استفاده بهتر و سئو این تنظیم را فعال بگذارید. پیوند \'home\' در breadcrumbs دسترسی آسان به صفحه اصلی سایت را فراهم می کند.</p>

            ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_breadcrumbs_show_home',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <!-- Show breadcrumbs parent category -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نمایش رده والدین</span>
            <p>
            نمایش یا پنهان کردن پیوند دسته والد مانند: صفحه اصلی > دسته والدین > دسته
                <?php td_util::tooltip_html('
                    <h3>نمایش دسته والد:</h3>
                    <p>اگر \'دسته اصلی\' پست یک دسته والد داشته باشد، فقط در صورتی که این تنظیم فعال باشد، در خرده نان نشان داده می‌شود.</p>
            ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_breadcrumbs_show_parent',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <!-- show Breadcrumbs article title -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">عنوان مقاله را نشان دهید</span>
            <p>
            نمایش یا پنهان کردن عنوان مقاله در صفحات پست
                <?php td_util::tooltip_html('
                    <h3>نمایش عنوان مقاله در  breadcrumbs:</h3>
                    <p>اگر به دلایل خاصی به این نیاز ندارید، می توان آن را غیرفعال کرد. این تنظیم فقط روی breadcrumbs تاثیر می گذارد. عنوان مقاله پست نیست!</p>
            ', 'right') ?>
            </p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => 'tds_breadcrumbs_show_article',
                'true_value' => '',
                'false_value' => 'hide'
            ));
            ?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- Lazy loading animation -->
<?php echo td_panel_generator::box_start('بارگذاری تصویر - انیمیشن ها (LazyLoad)', false); ?>

<!-- text -->
<div class="td-box-row">
    <div class="td-box-description td-box-full">
        <p>انیمیشن افکت به شما امکان می دهد تصاویر تم خود را در حین حرکت از بالا به پایین متحرک کنید.
        حتی در عملیات بعدی و قبلی نیز اعمال می شود و جلوه بارگذاری تصاویر را به سمت راست یا چپ ایجاد می کند.</p>
        <p>اگر همه تصاویر مورد نیاز در <b>2 ثانیه</b> بارگیری نشوند، جلوه انیمیشن لغو می شود. اگر انیمیشن فعال باشد، این قانون در محتوای بارگیری بلوک با استفاده از ajax نیز موجود است.</p>
    </div>
    <div class="td-box-row-margin-bottom"></div>
</div>

<!-- use lazy loading animation -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">از بارگذاری تصویر انیمیشن استفاده کنید</span>
        <p>بارگیری جلوه انیمیشن را غیرفعال یا فعال کنید.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_animation_stack',
            'true_value' => '',
            'false_value' => 'no'
        ));
        ?>
    </div>
</div>

<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">جلوه بارگذاری</span>
        <p>می توانید یکی از افکت های زیر را انتخاب کنید که در اولین بارگذاری تصاویر استفاده می شود.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::radio_button_control(array(
            'ds' => 'td_option',
            'option_id' => 'tds_animation_stack_effect',
            'values' => td_global::$td_animation_stack_effects
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>



<?php if ( 'Newspaper' == TD_THEME_NAME && defined('TD_STANDARD_PACK')  ) { ?>

    <!-- Force full width -->
    <?php echo td_panel_generator::box_start('اجبار به عرض کامل', false); ?>
    <!-- text -->
    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <p>از اینجا می توانید ظرف یا محتوا را برای بخش های مختلف مانند سرصفحه، منو یا پاورقی گسترش دهید.</p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">هدر ⇢ نوار بالا</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_top_bar',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'کانتینر کشش' , 'val' => 'td_stretch_container'), // .td_stretch_container
                    array('text' => 'ظرف کششی و محتوای 1200 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1200'),
                    array('text' => 'ظرف کشش و محتوای 1400 پیکسل' , 'val' => 'td_stretch_container td_stretch_content_1400'),
                    array('text' => 'ظرف کششی و محتوای 1600 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1600'),
                    array('text' => 'ظرف کششی و محتوای 1800 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1800'),
                    array('text' => 'ظرف کشش و محتوا' , 'val' => 'td_stretch_content') // .td_stretch_content
                )
            ));
            ?>
        </div>

        <div class="td-box-description">
            <span class="td-box-title">سربرگ ⇢ لوگو و فضای تبلیغاتی</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_header',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'کانتینر کشش' , 'val' => 'td_stretch_container'), // stretch_container
                    array('text' => 'ظرف کششی و محتوای 1200 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1200'),
                    array('text' => 'ظرف کشش و محتوای 1400 پیکسل' , 'val' => 'td_stretch_container td_stretch_content_1400'),
                    array('text' => 'ظرف کششی و محتوای 1600 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1600'),
                    array('text' => 'ظرف کششی و محتوای 1800 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1800'),
                    array('text' => 'ظرف کشش و محتوا' , 'val' => 'td_stretch_content') // stretch_content
                )
            ));
            ?>
        </div>

        <div class="td-box-description">
            <span class="td-box-title">هدر ⇢ منو</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_menu',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'کانتینر کشش' , 'val' => 'td_stretch_container'), // stretch_container
                    array('text' => 'ظرف کششی و محتوای 1200 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1200'),
                    array('text' => 'ظرف کشش و محتوای 1400 پیکسل' , 'val' => 'td_stretch_container td_stretch_content_1400'),
                    array('text' => 'ظرف کششی و محتوای 1600 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1600'),
                    array('text' => 'ظرف کششی و محتوای 1800 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1800'),
                    array('text' => 'ظرف کشش و محتوا' , 'val' => 'td_stretch_content') // stretch_content
                )
            ));
            ?>
        </div>

        <div class="td-box-description">
            <span class="td-box-title">هدر ⇢ پس زمینه</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_header_background',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'کانتینر کشش' , 'val' => 'td_stretch_container'), // stretch_container
                )
            ));
            ?>
        </div>

        <div class="td-box-description">
            <span class="td-box-title">پاورقی ⇢ اینستاگرام</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_footer_instagram',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'ظرف کششی و محتوای 1200 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1200'),

                    array('text' => 'ظرف کشش و محتوای 1400 پیکسل' , 'val' => 'td_stretch_container td_stretch_content_1400'),
                    array('text' => 'ظرف کششی و محتوای 1600 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1600'),
                    array('text' => 'ظرف کششی و محتوای 1800 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1800'),
                    array('text' => 'ظرف کشش و محتوا' , 'val' => 'td_stretch_content') // stretch_content
                )
            ));
            ?>
        </div>

        <div class="td-box-description">
            <span class="td-box-title">پاورقی</span>
            <p></p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::dropdown(array(
                'ds' => 'td_option',
                'option_id' => 'td_full_footer',
                'values' => array(
                    array('text' => 'بدون کشش' , 'val' => ''),
                    array('text' => 'کانتینر کشش' , 'val' => 'td_stretch_container'), // stretch_container
                    array('text' => 'ظرف کششی و محتوای 1200 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1200'),
                    array('text' => 'ظرف کشش و محتوای 1400 پیکسل' , 'val' => 'td_stretch_container td_stretch_content_1400'),
                    array('text' => 'ظرف کششی و محتوای 1600 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1600'),
                    array('text' => 'ظرف کششی و محتوای 1800 پیکسلی' , 'val' => 'td_stretch_container td_stretch_content_1800'),
                    array('text' => 'ظرف کشش و محتوا' , 'val' => 'td_stretch_content') // stretch_content
                )
            ));
            ?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();?>

<?php } ?>



<hr>
<div class="td-section-separator">قالب های وردپرس</div>



<!-- Theme information -->
<?php echo td_panel_generator::box_start('اطلاعات بیشتر'); ?>

<!-- text -->
<div class="td-box-row">
    <div class="td-box-description td-box-full">
        <p>در این بخش می توانید پیکربندی کنید <a href="http://codex.wordpress.org/Template_Hierarchy" target="_blank">قالب های پیش فرض وردپرس</a>. اکثر قالب ها از تنظیمات زیر پشتیبانی می کنند:</p>
        <ul>
            <li>نحوه نمایش پست ها در حلقه های پیش فرض وردپرس</li>
            <li>موقعیت نوار کناری</li>
            <li>چه نوار کناری نمایش داده شود</li>
        </ul>
    </div>

    <div class="td-box-row-margin-bottom"></div>
</div>

<?php echo td_panel_generator::box_end();?>



<!-- 404 template -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('قالب 404', false, 'td-wait-for-ajax');
    ?>


    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>هنگامی که کاربر صفحه یا پستی را درخواست می کند که وجود ندارد، وردپرس از این قالب استفاده می کند.</p>
        <ul>
            <li>این الگو در فایل <strong>404.php</strong> قرار دارد.</li>
            <li>آخرین 6 پست از سایت شما را نشان می دهد و "اوه... خطای 404، متأسفیم، اما صفحه مورد نظر شما
            وجود ندارد."
            </li>
            <li>اینجا را ببینید  <a href="<?php echo get_home_url() ?>/?p=9999999" target="_blank">نمونه خطای 404</a> از
            سایت شما
            </li>
            <li>بیشتر بخوانید: <a href="http://codex.wordpress.org/Creating_an_Error_404_Page" target="_blank">وردپرس 404
            خطا</a>, <a target="_blank" href="http://en.wikipedia.org/wiki/HTTP_404">HTTP 404</a></li>
        </ul>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_404_page_layout',
                'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- Archive page -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('قالب آرشیو', false, 'td-wait-for-ajax'); ?>

    <?php
    // prepare the archive links
    $cur_archive_year = date('Y');
    $cur_archive_month = date('n');
    $cur_archive_day = date('j');
    ?>

    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>این قالب توسط وردپرس برای تولید آرشیو استفاده می شود. به طور پیش فرض وردپرس روزانه، ماهانه تولید می کند
        و آرشیو سالانه</p>
        <ul>
            <li>این الگو در فایل <strong>archive.php</strong> قرار دارد.</li>
            <li>
            آخرین پست ها را بر اساس روز، ماه یا سال نشان می دهد. شما می توانید به هر سال یا ماه یا روز پیوند دهید، نه فقط به آن
            فعلی
                <a href="http://codex.wordpress.org/Creating_an_Archive_Index">ادامه مطلب</a>
            </li>
            <li>اگر هیچ پستی در دوره انتخابی منتشر نشده باشد، وردپرس خطای 404 را منتشر می کند. این خوب است برای
            سئو
            </li>
            <li>
            نمونه آرشیو از وبلاگ شما:
                <a href="<?php echo get_year_link($cur_archive_year) ?>" target="_blank">سال جاری</a>,
                <a href="<?php echo get_month_link($cur_archive_year, $cur_archive_month) ?>" target="_blank">ماه
                جاری</a>,
                <a href="<?php echo get_day_link($cur_archive_year, $cur_archive_month, $cur_archive_day) ?>"
                   target="_blank">امروز</a>
            </li>
        </ul>
    </div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_archive_page_layout',
                'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_archive_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_archive_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- Attachment template -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('الگوی پیوست', false, 'td-wait-for-ajax'); ?>

    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>این الگو برای نمایش پیوست (معمولا یک تصویر) استفاده می شود. معمولاً توسط وردپرس در قسمت جلو استفاده نمی شود
        فقط با گالری پیش فرض تمام شود.</p>
        <ul>
            <li>این الگو در فایل <strong>attachment.php</strong> قرار دارد.</li>
            <li>برای مشاهده این الگو به رسانه ⇢ کتابخانه ⇢ باز کردن تصویر ⇢ روی مشاهده صفحه پیوست کلیک کنید</li>
        </ul>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_attachment_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_attachment_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- AUTHOR page -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('الگوی نویسنده', false, 'td-wait-for-ajax'); ?>

    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>زمانی که کاربر روی نویسنده در قسمت جلویی سایت کلیک می کند، الگوی نویسنده نشان داده می شود.</p>
        <ul>
            <li>الگوی تم پیش فرض در فایل <strong>author.php</strong> قرار دارد.</li>
            <li>در زیر هدر نویسنده، این الگو حلقه ای از آخرین پست ها دارد (loop.php)</li>
            <li>ببین <a href="<?php echo get_author_posts_url(get_current_user_id()) ?>" target="_blank">نسخه ی نمایشی از
            صفحه نویسنده</a> برای کاربر وارد شده فعلی شما.
            </li>
        </ul>
    </div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_author_page_layout',
                'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_author_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_author_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- Blog and posts template -->
<?php echo td_panel_generator::box_start('قالب وبلاگ و پست ها', false); ?>

<div class="td-box-description td-box-full">
    <ul>
        <li>تمام تنظیمات از این کادر برای <strong>index.php</strong> اعمال می‌شود - فهرست پیش‌فرض وبلاگ (صفحه‌ای که همه پست‌ها یکی پس از دیگری فهرست می‌شوند)</li>
        <li>موقعیت نوار کناری و نوار کناری پیش‌فرض نیز برای الگوهای تکی اعمال می‌شود (<strong>single.php</strong>)</li>
        <li><strong>فقط یک نکته</strong> - وقتی هنگام ویرایش یک پست، موقعیت نوار کناری یا نوار کناری دیگری را تنظیم می‌کنید، آن موردی را که در اینجا تنظیم کرده‌اید بازنویسی می‌کند.</li>
    </ul>
</div>

<div class="td-box-section-separator"></div>

<!-- ARTICLE DISPLAY VIEW -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمای نمایش مقاله</span>
        <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
    </div>
    <div class="td-box-control-full td-panel-module">
        <?php
        echo td_panel_generator::visual_select_o(array(
            'ds' => 'td_option',
            'option_id' => 'tds_home_page_layout',
            'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
        ));
        ?>
    </div>
</div>

<!-- Custom Sidebar + position -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
        <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
    </div>
    <div class="td-box-control-full td-panel-sidebar-pos">
        <div class="td-display-inline-block">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_home_sidebar_pos',
                'values' => array(
                    array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                    array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                    array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                )
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
        </div>
        <div class="td-display-inline-block td_sidebars_pulldown_align">
            <?php
            echo td_panel_generator::sidebar_pulldown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_home_sidebar'
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
        </div>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>



<!-- Page template -->
<?php echo td_panel_generator::box_start('قالب صفحه', false); ?>

<div class="td-box-description td-box-full">
    <p>موقعیت نوار کناری صفحه و نوار کناری را از اینجا انتخاب کنید. این دو تنظیمات بر اساس هر صفحه قابل تغییر هستند.</p>
    <ul>
        <li>این الگو در فایل <strong>page.php</strong> قرار دارد.</li>
    </ul>
</div>

<div class="td-box-section-separator"></div>

<?php if ( 'Newspaper' == TD_THEME_NAME ) { ?>
<!-- Layout size -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">اندازه طرح بندی صفحه</span>
        <p>اندازه طرح بندی الگوهای صفحه پیش فرض را انتخاب کنید</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::dropdown(array(
            'ds' => 'td_option',
            'option_id' => 'tds_page_layout_size',
            'values' => array(
                array('text' => 'سایز پیش فرض' , 'val' => ''),
                array('text' => 'محتوای 1200 پیکسلی' , 'val' => 'td_cl tdc-row stretch_row_1200 td-stretch-content'),
                array('text' => 'محتوای 1400 پیکسلی' , 'val' => 'td_cl tdc-row stretch_row_1400 td-stretch-content'),
                array('text' => 'محتوای 1600 پیکسلی' , 'val' => 'td_cl tdc-row stretch_row_1600 td-stretch-content'),
                array('text' => 'محتوای 1800 پیکسلی' , 'val' => 'td_cl tdc-row stretch_row_1800 td-stretch-content'),
                array('text' => 'عرض کامل' , 'val' => 'td_cl tdc-row stretch_row_content td-stretch-content'),
                array('text' => 'عرض کامل (با بالشتک)' , 'val' => 'td_cl tdc-row stretch_row_content_no_space td-stretch-content'),
            )
        ));
        ?>
    </div>
</div>
<?php } ?>

<!-- Custom Sidebar + position -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
        <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
    </div>
    <div class="td-box-control-full td-panel-sidebar-pos">
        <div class="td-display-inline-block">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_page_sidebar_pos',
                'values' => array(
                    array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                    array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                    array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                )
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
        </div>
        <div class="td-display-inline-block td_sidebars_pulldown_align">
            <?php
            echo td_panel_generator::sidebar_pulldown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_page_sidebar'
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
        </div>
    </div>
</div>

<!-- Disable comments on pages -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">غیرفعال کردن نظرات در صفحات</span>
        <p>فعال یا غیرفعال کردن نظرات در صفحات، در کل سایت. این گزینه به طور پیش فرض غیرفعال است</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tds_disable_comments_pages',
            'true_value' => '',
            'false_value' => 'show_comments'
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end(); ?>




<!-- Search page -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('جستجوی قالب', false, 'td-wait-for-ajax'); ?>

    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>طرح بندی صفحه جستجو را انتخاب کنید.</p>
        <ul>
            <li>Check a <a href="<?php echo esc_url(home_url('/?s=and')) /** @see page-search-box.php */ ?>"
                           target="_blank">نمونه صفحه جستجو</a> از سایت شما.
            </li>
            <li>این الگو در فایل <strong>search.php</strong> قرار دارد.</li>
        </ul>
    </div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_search_page_layout',
                'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_search_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_search_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

    <!-- Enable search in taxonomies terms -->
    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">جستجو در اصطلاحات تاکسونومی</span>
            <p>اگر فعال باشد، رفتار جستجوی پیش‌فرض وردپرس را گسترش می‌دهد و پست‌هایی را در نتایج جستجو شامل می‌شود که عبارت‌های طبقه‌بندی را که شامل عبارت جستجو در نام یا توضیحات عبارت هستند، اختصاص داده‌اند. این گزینه به طور پیش فرض غیرفعال است.</p>
        </div>
        <div class="td-box-control-full">
			<?php
			echo td_panel_generator::checkbox( array(
				'ds' => 'td_option',
				'option_id' => 'tds_search_taxonomies_terms',
				'true_value' => 'yes',
				'false_value' => ''
			));
			?>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- TAG page -->
<?php if( 'Newsmag' == TD_THEME_NAME || ( 'Newspaper' == TD_THEME_NAME && ( defined('TD_STANDARD_PACK') || td_global::is_tdb_registered() ) ) ) {
    echo td_panel_generator::box_start('الگوی برچسب', false, 'td-wait-for-ajax'); ?>

    <div class="td-box-description td-box-full tdb-hide tdsp-hide">
        <p>طرح پیش فرض را برای همه تگ ها تنظیم کنید.</p>
        <ul>
            <li>می‌توانید هر صفحه برچسب را با رفتن به پست‌ها ⇢ برچسب‌ها ⇢ روی یک برچسب ⇢ انتخاب مشاهده</li> مشاهده کنید.
            <li>این الگو در فایل <strong>tag.php</strong> قرار دارد.</li>
        </ul>
    </div>

    <!-- DISPLAY VIEW -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نمای نمایش مقاله</span>
            <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود</p>
        </div>
        <div class="td-box-control-full td-panel-module">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_tag_page_layout',
                'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
            ));
            ?>
        </div>
    </div>

    <!-- Custom Sidebar + position -->
    <div class="td-box-row tdb-hide tdsp-hide">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + POSITION</span>
            <p>موقعیت نوار کناری و نوارهای جانبی سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_tag_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_tag_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

    <?php echo td_panel_generator::box_end();
} ?>



<!-- Woocommerce template -->
<?php echo td_panel_generator::box_start('قالب ووکامرس', false); ?>

<div class="td-box-description td-box-full">
    <p>نوار کناری و موقعیت سفارشی صفحات ووکامرس را تنظیم کنید.</p>
</div>

<div class="td-box-section-separator"></div>

<!-- Shop homepage + archives - custom Sidebar + position -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">صفحه اصلی فروشگاه + آرشیو</span>
        <p>موقعیت نوار کناری و نوار کناری سفارشی</p>
    </div>
    <div class="td-box-control-full td-panel-sidebar-pos">
        <div class="td-display-inline-block">
            <?php
           echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_woo_sidebar_pos',
                'values' => array(
                    array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                    array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                    array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                )
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
        </div>
        <div class="td-display-inline-block td_sidebars_pulldown_align">
            <?php
           echo td_panel_generator::sidebar_pulldown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_woo_sidebar'
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
        </div>
    </div>
</div>

<!-- Shop single product page - custom Sidebar + position -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">صفحه تک محصول خرید کنید</span>
        <p>موقعیت نوار کناری و نوار کناری سفارشی</p>
    </div>
    <div class="td-box-control-full td-panel-sidebar-pos">
        <div class="td-display-inline-block">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_woo_single_sidebar_pos',
                'values' => array(
                    array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                    array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                    array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                )
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
        </div>
        <div class="td-display-inline-block td_sidebars_pulldown_align">
            <?php
            echo td_panel_generator::sidebar_pulldown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_woo_single_sidebar'
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
        </div>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>



<!-- bbPress template -->
<?php echo td_panel_generator::box_start('قالب bbPress', false); ?>

<div class="td-box-description td-box-full">
        <p>تنظیمات قالب bbPress را از اینجا تنظیم کنید</p>
    </div>

<div class="td-box-section-separator"></div>

<!-- Custom Sidebar + position -->
<div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">نوار کناری سفارشی + موقعیت</span>
            <p>موقعیت نوار کناری و نوارهای کناری سفارشی</p>
        </div>
        <div class="td-box-control-full td-panel-sidebar-pos">
            <div class="td-display-inline-block">
                <?php
                echo td_panel_generator::visual_select_o(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_bbpress_sidebar_pos',
                    'values' => array(
                        array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                        array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                        array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                    )
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
            </div>
            <div class="td-display-inline-block td_sidebars_pulldown_align">
                <?php
                echo td_panel_generator::sidebar_pulldown(array(
                    'ds' => 'td_option',
                    'option_id' => 'tds_bbpress_sidebar'
                ));
                ?>
                <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
            </div>
        </div>
    </div>

<?php echo td_panel_generator::box_end();?>


<!-- Taxonomy + post format page template -->
<?php echo td_panel_generator::box_start('قالب آرشیو قالب های پست', false); ?>

<div class="td-box-description td-box-full">
    <p>این تنظیمات به شما کمک می‌کند صفحه آرشیو را که همه پست‌ها را در یک لیست خاص فهرست می‌کند، پیکربندی کنید <a href="https://codex.wordpress.org/Post_Formats" target="_blank">فرمت پست</a>.</p>
    <p>طرح‌بندی ویدیوی تم را انتخاب کنید <a href="https://codex.wordpress.org/Taxonomies#Post_Formats" target="_blank">صفحات طبقه بندی با فرمت پستی</a>.</p>

    <ul>
        <li>Check a <a href="<?php echo get_post_format_link('video') ?>" target="_blank">نمونه صفحه آرشیو قالب پست</a> از سایت شما.</li>
        <li>این الگو در فایل <strong>taxonomy-post_format.php</strong> قرار دارد.</li>
    </ul>
</div>

<div class="td-box-section-separator"></div>

<!-- Articles DISPLAY VIEW -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نمای نمایش مقاله</span>
        <p>یک نوع ماژول را انتخاب کنید، به این ترتیب لیست مقالات شما نمایش داده می شود.</p>
    </div>
    <div class="td-box-control-full td-panel-module">
        <?php
        echo td_panel_generator::visual_select_o(array(
            'ds' => 'td_option',
            'option_id' => 'tds_taxonomy_post_format_page_layout',
            'values' => td_panel_generator::helper_display_modules('enabled_on_loops')
        ));
        ?>
    </div>
</div>

<!-- Custom Sidebar + position -->
<div class="td-box-row">
    <div class="td-box-description">
        <span class="td-box-title">نوار کناری سفارشی + جایگاه</span>
        <p>موقعیت نوار کناری و نوارهای جانبی سفارشی</p>
    </div>
    <div class="td-box-control-full td-panel-sidebar-pos">
        <div class="td-display-inline-block">
            <?php
            echo td_panel_generator::visual_select_o(array(
                'ds' => 'td_option',
                'option_id' => 'tds_taxonomy_post_format_sidebar_pos',
                'values' => array(
                    array('text' => '', 'title' => 'Sidebar Left', 'val' => 'sidebar_left', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-left.png'),
                    array('text' => '', 'title' => 'No Sidebar', 'val' => 'no_sidebar', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-full.png'),
                    array('text' => '', 'title' => 'Sidebar Right', 'val' => '', 'img' => TDC_URL_LEGACY . '/assets/images/panel/sidebar/sidebar-right.png')
                )
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">موقعیت نوار کناری را انتخاب کنید</div>
        </div>
        <div class="td-display-inline-block td_sidebars_pulldown_align">
            <?php
            echo td_panel_generator::sidebar_pulldown(array(
                'ds' => 'td_option',
                'option_id' => 'tds_taxonomy_post_format_sidebar'
            ));
            ?>
            <div class="td-panel-control-comment td-text-align-right">یک نوار کناری موجود ایجاد یا انتخاب کنید</div>
        </div>
    </div>
</div>

<?php echo td_panel_generator::box_end();?>
