<?php
/*
	Plugin Name: tagDiv Books custom post types sample
	Plugin URI: http://tagdiv.com
	Description: adds the td_book post type and td_author + td_genre taxonomy
	Author: tagDiv
	Version: 1.0
	Author URI: http://tagdiv.com
*/

// to register Custom Post Types and taxonomies, the use of the init hook is required!
add_action('init', 'td_custom_post_type_init');
function td_custom_post_type_init() {

    /**
     * add the td_book custom post type
     * https://codex.wordpress.org/Function_Reference/register_post_type
     */
    $args = array(
        'public' => true,
        'label'  => 'کتاب ها',
        'supports' => array( // here we specify what the taxonomy supports
            'title',
            'editor',
            'thumbnail',
            'excerpt',
            'comments'
        )
    );
    register_post_type( 'td_book', $args );





    /**
     * Add new taxonomy, make it hierarchical (like categories) and associate it to the td_books Custom Post Type
     * https://codex.wordpress.org/Function_Reference/register_taxonomy
     */
    $labels = array(
        'name'              => _x( 'دسته بندی ها', 'taxonomy general name' ),
        'singular_name'     => _x( 'دسته بندی', 'taxonomy singular name' ),
        'search_items'      => __( 'جستجوی دسته بندی ها' ),
        'all_items'         => __( 'همه دسته بندی ها' ),
        'parent_item'       => __( 'دسته بندی والد' ),
        'parent_item_colon' => __( 'دسته بندی والد:' ),
        'edit_item'         => __( 'ویرایش دسته بندی' ),
        'update_item'       => __( 'به روز رسانی دسته بندی' ),
        'add_new_item'      => __( 'افزودن دسته بندی جدید' ),
        'new_item_name'     => __( 'نام دسته بندی جدید' ),
        'menu_name'         => __( 'دسته بندی' ),
    );
    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'genre' ),
    );
    register_taxonomy( 'td_genre', array('td_book'), $args );




    /**
     * Add new taxonomy, NOT hierarchical (like tags)  and associate it to the td_books Custom Post Type
     * https://codex.wordpress.org/Function_Reference/register_taxonomy
     */
    $labels = array(
        'name'                       => _x( 'نویسندگان', 'taxonomy general name' ),
        'singular_name'              => _x( 'نویسنده', 'taxonomy singular name' ),
        'search_items'               => __( 'جستجوی نویسندگان' ),
        'popular_items'              => __( 'Popular نویسندگان' ),
        'all_items'                  => __( 'همه نویسندگان' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => __( 'ویرایش نویسنده' ),
        'update_item'                => __( 'به روز رسانی نویسنده' ),
        'add_new_item'               => __( 'افزودن نویسنده جدید' ),
        'new_item_name'              => __( 'نام نویسنده جدید' ),
        'separate_items_with_commas' => __( 'از نویسندگان با ویرگول جدا کنید' ),
        'add_or_remove_items'        => __( 'افزودن یا حذف نویسندگان' ),
        'choose_from_most_used'      => __( 'از بیشترین استفاده شده ترین نویسندگان انتخاب کنید' ),
        'not_found'                  => __( 'نویسندگان یافت نشد' ),
        'menu_name'                  => __( 'نویسندگان' ),
    );
    $args = array(
        'hierarchical'          => false,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'rewrite'               => array( 'slug' => 'writer' ),
    );
    register_taxonomy( 'td_writer', 'td_book', $args );


}


/**
 * this hook will regenerate the permalinks when the plugin is activated. I would recommend that you work with the permalinks OFF until you make
 * your custom post types. After you make the final custom post types you can enable the permalinks and hit save in wp-admin -> settings -> permalinks.
 */
function td_regenerate_htaccess() {
    td_custom_post_type_init();
    flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'td_regenerate_htaccess');