<?php
/*
Plugin Name: APP Find PRO Plugin
Plugin URI: http://tagdiv.com
Description: tagDiv plugin for demos with custom post types & taxonomies
Author: tagDiv
Version: 1.0.0
Author URI: http://tagdiv.com
*/

defined( 'ABSPATH' ) || exit;

add_action( 'tdc_init', function() {
	new td_app_find_pro_demo_plugin();
}, 11 );

class td_app_find_pro_demo_plugin {

	var $plugin_url = '';
	var $plugin_path = '';

	public function __construct() {

		$this->plugin_url = plugins_url(__FILE__ );
		$this->plugin_path = dirname(__FILE__ );

		/**
		 * ACF
		 */

		// this will allow custom fields meta box on posts when the acf plugin is active
		add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );

		// add local acf fields
		add_action( 'init', array( $this, 'acf_add_local_field_groups' ) );

		// export acf fields: (via json sync)
		add_filter( 'acf/settings/save_json', array( $this, 'set_acf_json_save_folder' ) );
		add_filter( 'acf/settings/load_json', array( $this, 'add_acf_json_load_folder' ) );

		// sync json acf-json fields @see td-demo/includes/acf-json
		add_action( 'admin_init', array( $this, 'sync_acf_fields' ) );

		/**
		 * CPT UI
		 */
		add_action( 'after_setup_theme',  function () {

            // we need priority 9, to avoid invalid tax error
			add_action( 'init', array( $this, 'cptui_register_my_cpts' ), 9 );
			add_action( 'init', array( $this, 'cptui_register_my_taxes' ), 9 );

		});

	}

	public function set_acf_json_save_folder( $path ) {
		return $this->plugin_path . '/includes/acf-json';
	}

	public function add_acf_json_load_folder( $paths ) {
		unset( $paths[0] );

		$paths[] = $this->plugin_path . '/includes/acf-json';

		return $paths;
	}

	public function acf_add_local_field_groups() {

		/*
		 * ACF > Export Field Groups - Generated PHP goes here
		 */

	}

	public function sync_acf_fields() {

		if( ! function_exists('acf_get_field_groups' ) )
			return;

		$groups = acf_get_field_groups();
		$sync = array();

		// return here if no field groups
		if( empty( $groups ) )
			return;

		// find json field groups which have not yet been imported
		foreach( $groups as $group ) {
			$local    = acf_maybe_get( $group, 'local', false );
			$modified = acf_maybe_get( $group, 'modified', 0 );
			$private  = acf_maybe_get( $group, 'private', false );

			// ignore db/php/private field groups
			if( $local !== 'json' || $private ) {
				// do nothing
				continue;
			// append to sync if not yet in database
			} elseif( ! $group['ID'] ) {
				$sync[ $group['key'] ] = $group;
			// append to sync if "json" modified time is newer than database
			} elseif( $modified && $modified > get_post_modified_time( 'U', true, $group['ID'], true ) ) {
				$sync[ $group['key'] ]  = $group;
			}
		}

		// return here if no sync needed
		if( empty( $sync ) )
			return;

		foreach( $sync as $key => $v ) {

			// append fields
			if( acf_have_local_fields( $key ) ) {
				$sync[$key]['fields'] = acf_get_local_fields( $key );
			}

			// import
			$field_group = acf_import_field_group( $sync[$key] );

		}

	}

	// register cptui post types
	function cptui_register_my_cpts() {

        /**
         * Post Type: APP Listings
         */
        register_post_type( 'tdcpt_app_listing', array(
            'labels' => array(
                'name' => 'برنامه Listcvings',
                'singular_name' => 'فهرست برنامه',
                'menu_name' => 'لیست برنامه ها',
                'all_items' => 'همه لیست های برنامه',
                'edit_item' => 'ویرایش فهرست برنامه',
                'view_item' => 'مشاهده فهرست برنامه',
                'view_items' => 'مشاهده لیست برنامه ها',
                'add_new_item' => 'افزودن لیست برنامه جدید',
                'new_item' => 'فهرست برنامه جدید',
                'parent_item_colon' => 'لیست برنامه والدین:',
                'search_items' => 'جستجوی لیست های برنامه',
                'not_found' => 'هیچ لیست برنامه ای یافت نشد',
                'not_found_in_trash' => 'هیچ لیست برنامه ای در سطل زباله یافت نشد',
                'archives' => 'بایگانی فهرست APP',
                'attributes' => 'ویژگی های فهرست برنامه',
                'insert_into_item' => 'در لیست برنامه درج کنید',
                'uploaded_to_this_item' => 'در این فهرست برنامه آپلود شد',
                'filter_items_list' => 'لیست لیست برنامه ها را فیلتر کنید',
                'filter_by_date' => 'لیست برنامه ها را بر اساس تاریخ فیلتر کنید',
                'items_list_navigation' => 'پیمایش لیست لیست های برنامه',
                'items_list' => 'لیست لیست برنامه ها',
                'item_published' => 'فهرست APP منتشر شد.',
                'item_published_privately' => 'فهرست APP به صورت خصوصی منتشر شد.',
                'item_reverted_to_draft' => 'فهرست APP به پیش‌نویس بازگشت.',
                'item_scheduled' => 'فهرست برنامه برنامه ریزی شده است.',
                'item_updated' => 'فهرست برنامه به روز شد.',
                'item_link' => 'لینک فهرست برنامه',
                'item_link_description' => 'پیوندی به فهرست برنامه',
            ),
            'public' => true,
            'show_in_rest' => true,
            'menu_position' => 6,
            'menu_icon' => 'dashicons-welcome-widgets-menus',
            'supports' => array(
                0 => 'title',
                1 => 'author',
                2 => 'editor',
                3 => 'excerpt',
                4 => 'thumbnail',
                5 => 'custom-fields',
            ),
            'taxonomies' => array(
                0 => 'tdtax_app_category',
                1 => 'tdtax_app_tag',
                2 => 'tdtax_app_location',
            ),
            'delete_with_user' => false,
        ) );

	}

	// register cptui taxonomies
	function cptui_register_my_taxes() {

        /**
         * Taxonomy: APP Listings - Categories
         */
        register_taxonomy( 'tdtax_app_category', array(
            0 => 'tdcpt_app_listing',
        ), array(
            'labels' => array(
                'name' => 'دسته بندی',
                'singular_name' => 'دسته بندی',
                'menu_name' => 'دسته بندی برنامه ها',
                'all_items' => 'همه دسته ها',
                'edit_item' => 'ویرایش دسته',
                'view_item' => 'مشاهده دسته',
                'update_item' => 'به روز رسانی دسته',
                'add_new_item' => 'اضافه کردن دسته جدید',
                'new_item_name' => 'نام دسته جدید',
                'parent_item' => 'دسته والد',
                'parent_item_colon' => 'دسته والد:',
                'search_items' => 'جستجوی دسته ها',
                'not_found' => 'هیچ دسته ای یافت نشد',
                'no_terms' => 'بدون دسته',
                'filter_by_item' => 'بر اساس دسته بندی فیلتر کنید',
                'items_list_navigation' => 'پیمایش فهرست دسته ها',
                'items_list' => 'لیست دسته ها',
                'back_to_items' => '← به دسته ها بروید',
                'item_link' => 'لینک دسته',
                'item_link_description' => 'پیوند به یک دسته',
            ),
            'public' => true,
            'hierarchical' => true,
            'show_in_menu' => true,
            'show_in_rest' => true,
        ) );

        /**
         * Taxonomy: APP Listings - Tags
         */
        register_taxonomy( 'tdtax_app_tag', array(
            0 => 'tdcpt_app_listing',
        ), array(
            'labels' => array(
                'name' => 'برچسب ها',
                'singular_name' => 'برچسب',
                'menu_name' => 'برچسب های برنامه',
                'all_items' => 'همه برچسب ها',
                'edit_item' => 'ویرایش برچسب ها',
                'view_item' => 'مشاهده برچسب ها',
                'update_item' => 'بروزرسانی برچسب',
                'add_new_item' => 'تفزودن برچسب جدید',
                'new_item_name' => 'نام جدید برچسب',
                'search_items' => 'جستجو برچسب ها',
                'popular_items' => 'برچسب های محبوب',
                'separate_items_with_commas' => 'برچسب ها را با کاما جدا کنید',
                'add_or_remove_items' => 'برچسب ها را اضافه یا حذف کنید',
                'choose_from_most_used' => 'از بین برچسب های پر استفاده انتخاب کنید',
                'not_found' => 'هیچ برچسبی پیدا نشد',
                'no_terms' => 'بدون برچسب',
                'items_list_navigation' => 'پیمایش لیست برچسب ها',
                'items_list' => 'لیست برچسب ها',
                'back_to_items' => '← به برچسب ها بروید',
                'item_link' => 'لینک را برچسب کنید',
                'item_link_description' => 'پیوندی به یک برچسب',
            ),
            'public' => true,
            'show_in_menu' => true,
            'show_in_rest' => true,
        ) );

        /**
         * Taxonomy: APP Listings - Locations
         */
        register_taxonomy( 'tdtax_app_location', array(
            0 => 'tdcpt_app_listing',
        ), array(
            'labels' => array(
                'name' => 'مکان ها',
                'singular_name' => 'مکان',
                'menu_name' => 'مکان های برنامه',
                'all_items' => 'همه مکان ها',
                'edit_item' => 'ویرایش مکان',
                'view_item' => 'مشاهده مکان',
                'update_item' => 'به روز رسانی مکان',
                'add_new_item' => 'اضافه کردن مکان جدید',
                'new_item_name' => 'نام مکان جدید',
                'search_items' => 'جستجوی مکان ها',
                'not_found' => 'هیچ مکانی یافت نشد',
                'no_terms' => 'هیچ مکان',
                'items_list_navigation' => 'پیمایش فهرست مکان ها',
                'items_list' => 'لیست مکان ها',
                'back_to_items' => '← به مکان ها بروید',
                'item_link' => 'لینک مکان',
                'item_link_description' => 'پیوندی به یک مکان',
            ),
            'public' => true,
            'hierarchical' => true,
            'show_in_menu' => true,
            'show_in_rest' => true,
        ) );

	}
}
