<?php
/*
Plugin Name: tagDiv Compass PRO Demo Plugin
Plugin URI: http://tagdiv.com
Description: tagDiv plugin with custom post types, taxonomies & custom fields and more for Compass PRO Demo.
Author: tagDiv
Version: 1.0.0
Author URI: http://tagdiv.com
*/

defined( 'ABSPATH' ) || exit;

// load demo custom modules & styles
require_once('td-compass-pro-demo-cm-styles.php');
new td_compass_pro_demo_cm_styles( dirname(__FILE__ ), plugins_url( __FILE__ ) );

add_action( 'tdc_init', function() {
	new td_compass_pro_demo_plugin();
}, 11 );

class td_compass_pro_demo_plugin {

	var $plugin_url = '';
	var $plugin_path = '';

	public function __construct() {
		$this->plugin_url = plugins_url(__FILE__ );
		$this->plugin_path = dirname(__FILE__ );

		/**
		 * example on how to add new custom filter option for tdb_filters_loop_sorting_options shortcode
		 */

		// this adds sorting options for dropwdown & composer
		//add_filter( 'tdb_filters_loop_sorting_options', function ( $options ) {
		//
		//	// new custom sorting options
		//	$new_custom_sorting_options = array(
		//		'Caca order' => 'caca_order',
		//		'Hello World' => 'hello_world',
		//		'Lorem Ipsum' => 'lorem_ips'
		//	);
		//
		//	return array_merge(
		//		$options,
		//		$new_custom_sorting_options
		//	);
		//
		//});

		// this adds filter functionality for td query
		//add_filter( 'td_data_source_blocks_query_args', function ( $args, $atts ) {
		//
		//	// block type
		//	$block_type = $atts['block_type'] ?? null;
		//
		//	// get block sort
		//	$sort = $atts['sort'] ?? '';
		//
		//	// apply it on `tdb_filters_loop` blocks
		//	if ( $block_type === 'tdb_filters_loop' ) {
		//
		//		// set `caca_order` wp query args
		//		if ( $sort === 'caca_order' ) {
		//			$args['meta_key'] = 'tdcf_test_field';
		//			$args['orderby'] = 'meta_value_num';
		//			$args['order'] = 'ASC';
		//		}
		//
		//	}
		//
		//	return $args;
		//
		//}, 10, 2 );

		/**
		 * ACF
		 */

		// this will allow custom fields meta box on posts when the acf plugin is active
		add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );

		// add local acf fields
		add_action( 'init', array( $this, 'acf_add_local_field_groups' ) );

		// export acf fields: (via json sync)
		add_filter( 'acf/settings/save_json', array( $this, 'set_acf_json_save_folder' ) );
		add_filter( 'acf/settings/load_json', array( $this, 'add_acf_json_load_folder' ) );

		// sync json acf-json fields @see td-compass-pro-demo/includes/acf-json
		add_action( 'admin_init', array( $this, 'sync_acf_fields' ) );

		/**
		 * CPT UI
		 */
		add_action( 'after_setup_theme',  function () {
            // we need priority 9, to avoid invalid tax error
            add_action( 'init', array( $this, 'cptui_register_my_cpts' ), 9 );
			add_action( 'init', array( $this, 'cptui_register_my_taxes' ), 9 );
		});

		// load plugin's config/shortcodes
		add_action( 'tdc_loaded', array( $this, 'td_demo_plugin_config' ), 10 );

	}

	public function set_acf_json_save_folder( $path ) {
		return $this->plugin_path . '/includes/acf-json';
	}

	public function add_acf_json_load_folder( $paths ) {
		unset( $paths[0] );

		$paths[] = $this->plugin_path . '/includes/acf-json';

		return $paths;
	}

	public function acf_add_local_field_groups() {

		/*
		 * ACF > Export Field Groups - Generated PHP goes here
		 */

	}

	public function sync_acf_fields() {

		if( ! function_exists('acf_get_field_groups' ) )
			return;

		$groups = acf_get_field_groups();
		$sync = array();

		// return here if no field groups
		if( empty( $groups ) )
			return;

		// find json field groups which have not yet been imported
		foreach( $groups as $group ) {
			$local    = acf_maybe_get( $group, 'local', false );
			$modified = acf_maybe_get( $group, 'modified', 0 );
			$private  = acf_maybe_get( $group, 'private', false );

			// ignore db/php/private field groups
			if( $local !== 'json' || $private ) {
				// do nothing
				continue;
			// append to sync if not yet in database
			} elseif( ! $group['ID'] ) {
				$sync[ $group['key'] ] = $group;
			// append to sync if "json" modified time is newer than database
			} elseif( $modified && $modified > get_post_modified_time( 'U', true, $group['ID'], true ) ) {
				$sync[ $group['key'] ]  = $group;
			}
		}

		// return here if no sync needed
		if( empty( $sync ) )
			return;

		foreach( $sync as $key => $v ) {

			// append fields
			if( acf_have_local_fields( $key ) ) {
				$sync[$key]['fields'] = acf_get_local_fields( $key );
			}

			// import
			$field_group = acf_import_field_group( $sync[$key] );

		}

	}

	// register cptui post types
	function cptui_register_my_cpts() {

		/**
		 * Post Type: Tunes.
		 */

		$labels = [
			"name" => __( "آهنگ", "newspaper" ),
			"singular_name" => __( "آهنگ ها", "newspaper" ),
			"menu_name" => __( "اهنگ های من", "newspaper" ),
			"all_items" => __( "همه آهنگ", "newspaper" ),
			"add_new" => __( "اضافه کردن جدید", "newspaper" ),
			"add_new_item" => __( "اضافه کردن اهنگ جدید", "newspaper" ),
			"edit_item" => __( "ویرایش اهنگ", "newspaper" ),
			"new_item" => __( "اهنگ جدید", "newspaper" ),
			"view_item" => __( "مشاهده اهنگ", "newspaper" ),
			"view_items" => __( "مشاهده اهنگ", "newspaper" ),
			"search_items" => __( "جستجوی اهنگ", "newspaper" ),
			"not_found" => __( "نتیجه ای یافت نشد", "newspaper" ),
			"not_found_in_trash" => __( "نتجه ای یافت نسد", "newspaper" ),
			"parent" => __( "اهنگ ولد:", "newspaper" ),
			"featured_image" => __( "تصوبر ساخص اهنگ", "newspaper" ),
			"set_featured_image" => __( "تصویر ویژه را برای این آهنگ تنظیم کنید", "newspaper" ),
			"remove_featured_image" => __( "تصویر برجسته را برای این آهنگ حذف کنید", "newspaper" ),
			"use_featured_image" => __( "به عنوان تصویر برجسته برای این آهنگ استفاده کنید", "newspaper" ),
			"archives" => __( "دسته بندی اهنگ", "newspaper" ),
			"insert_into_item" => __( "درج کنید", "newspaper" ),
			"uploaded_to_this_item" => __( "در این آهنگ آپلود کنید", "newspaper" ),
			"filter_items_list" => __( "لیست آهنگ های فیلتر", "newspaper" ),
			"items_list_navigation" => __( "پیمایش لیست آهنگ ها", "newspaper" ),
			"items_list" => __( "لیست اهنگ", "newspaper" ),
			"attributes" => __( "صفات را تنظیم می کند", "newspaper" ),
			"name_admin_bar" => __( "اهنگ", "newspaper" ),
			"item_published" => __( "اهنگ منتشر شده", "newspaper" ),
			"item_published_privately" => __( "آهنگ به صورت خصوصی منتشر شد.", "newspaper" ),
			"item_reverted_to_draft" => __( "تنظیم به پیش‌نویس بازگشت.", "newspaper" ),
			"item_scheduled" => __( "تنظیم برنامه ریزی شده", "newspaper" ),
			"item_updated" => __( "اپدیت اهنگ", "newspaper" ),
			"parent_item_colon" => __( "والد اهنگ:", "newspaper" ),
		];

		$args = [
			"label" => __( "اهنگ", "newspaper" ),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => false,
			"rewrite" => [ "slug" => "tdcpt_tunes", "with_front" => true ],
			"query_var" => true,
			"supports" => [ "title", "editor", "thumbnail", "excerpt", "custom-fields", "comments" ],
			"show_in_graphql" => false,
		];

		register_post_type( "tdcpt_tunes", $args );

	}

	// register cptui taxonomies
	function cptui_register_my_taxes() {

		/**
		 * Taxonomy: Music.
		 */

		$labels = [
			"name" => __( "موزیک", "newspaper" ),
			"singular_name" => __( "موزیک", "newspaper" ),
			"menu_name" => __( "موزیک", "newspaper" ),
			"all_items" => __( "همه موزیک", "newspaper" ),
			"edit_item" => __( "ویرایش موزیک", "newspaper" ),
			"view_item" => __( "مشاهده موزیک", "newspaper" ),
			"update_item" => __( "اپدیت نام موزیک", "newspaper" ),
			"add_new_item" => __( "اضافه کردن موزیک جدید", "newspaper" ),
			"new_item_name" => __( "نام موزیک جدید", "newspaper" ),
			"parent_item" => __( "موسیقی والدین", "newspaper" ),
			"parent_item_colon" => __( "موسیقی والد:", "newspaper" ),
			"search_items" => __( "جستجوی موسیقی", "newspaper" ),
			"popular_items" => __( "موسیقی محبوب", "newspaper" ),
			"separate_items_with_commas" => __( "موسیقی را با کاما جدا کنید", "newspaper" ),
			"add_or_remove_items" => __( "موسیقی را اضافه یا حذف کنید", "newspaper" ),
			"choose_from_most_used" => __( "از بین پر استفاده ترین موسیقی انتخاب کنید", "newspaper" ),
			"not_found" => __( "موسیقی پیدا نشد", "newspaper" ),
			"no_terms" => __( "موسیقی وجود ندارد", "newspaper" ),
			"items_list_navigation" => __( "پیمایش لیست موسیقی", "newspaper" ),
			"items_list" => __( "لیست موسیقی", "newspaper" ),
			"back_to_items" => __( "بازگشت به موسیقی", "newspaper" ),
			"name_field_description" => __( "نام این است که چگونه در سایت شما ظاهر می شود.", "newspaper" ),
			"parent_field_description" => __( "برای ایجاد یک سلسله مراتب یک عبارت والد اختصاص دهید. برای مثال، اصطلاح جاز، والد Bebop و Big Band است.", "newspaper" ),
			"slug_field_description" => __( "Slug نسخه URL پسند نام است. معمولا تمام حروف کوچک است و فقط شامل حروف، اعداد و خط فاصله است.", "newspaper" ),
			"desc_field_description" => __( "شرح به طور پیش فرض برجسته نیست. با این حال، برخی از موضوعات ممکن است آن را نشان دهد.", "newspaper" ),
		];


		$args = [
			"label" => __( "موزیک", "newspaper" ),
			"labels" => $labels,
			"public" => true,
			"publicly_queryable" => true,
			"hierarchical" => true,
			"show_ui" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"query_var" => true,
			"rewrite" => [ 'slug' => 'tdtax_music', 'with_front' => true,  'hierarchical' => true, ],
			"show_admin_column" => false,
			"show_in_rest" => true,
			"show_tagcloud" => false,
			"rest_base" => "tdtax_music",
			"rest_controller_class" => "WP_REST_Terms_Controller",
			"rest_namespace" => "wp/v2",
			"show_in_quick_edit" => false,
			"sort" => false,
			"show_in_graphql" => false,
		];
		register_taxonomy( "tdtax_music", [ "tdcpt_tunes" ], $args );

		/**
		 * Taxonomy: Subgenres.
		 */

		$labels = [
			"name" => __( "زیر ژانرها", "newspaper" ),
			"singular_name" => __( "زیر ژانر ها", "newspaper" ),
			"menu_name" => __( "ژانر", "newspaper" ),
			"all_items" => __( "همه ژانر", "newspaper" ),
			"edit_item" => __( "ویرایش ژانر", "newspaper" ),
			"view_item" => __( "مشاعد ژانر", "newspaper" ),
			"update_item" => __( "نام زیرژانر را به روز کنید", "newspaper" ),
			"add_new_item" => __( "اضافه کردن زیرژانر جدید", "newspaper" ),
			"new_item_name" => __( "نام زیر ژانر جدید", "newspaper" ),
			"parent_item" => __( "زیرژانر پدر و مادر", "newspaper" ),
			"parent_item_colon" => __( "زیرژانر والدین:", "newspaper" ),
			"search_items" => __( "جستجو در ژانرهای فرعی", "newspaper" ),
			"popular_items" => __( "زیرژانرهای محبوب", "newspaper" ),
			"separate_items_with_commas" => __( "ژانرهای فرعی را با کاما از هم جدا کنید", "newspaper" ),
			"add_or_remove_items" => __( "اضافه کردن یا حذف زیرژانرها", "newspaper" ),
			"choose_from_most_used" => __( "از پرکاربردترین زیرژانرها انتخاب کنید", "newspaper" ),
			"not_found" => __( "هیچ زیرژانری یافت نشد", "newspaper" ),
			"no_terms" => __( "بدون زیرژانر", "newspaper" ),
			"items_list_navigation" => __( "پیمایش فهرست زیرژانرها", "newspaper" ),
			"items_list" => __( "فهرست زیر ژانرها", "newspaper" ),
			"back_to_items" => __( "بازگشت به زیرژانرها", "newspaper" ),
			"name_field_description" => __( "نام این است که چگونه در سایت شما ظاهر می شود.", "newspaper" ),
			"parent_field_description" => __( "برای ایجاد یک سلسله مراتب یک عبارت والد اختصاص دهید. برای مثال، اصطلاح جاز، والد Bebop و Big Band است.", "newspaper" ),
			"slug_field_description" => __( "Slug نسخه URL پسند نام است. معمولا تمام حروف کوچک است و فقط شامل حروف، اعداد و خط فاصله است.", "newspaper" ),
			"desc_field_description" => __( "شرح به طور پیش فرض برجسته نیست. با این حال، برخی از موضوعات ممکن است آن را نشان دهد.", "newspaper" ),
		];


		$args = [
			"label" => __( "زیر ژانرها", "newspaper" ),
			"labels" => $labels,
			"public" => true,
			"publicly_queryable" => true,
			"hierarchical" => false,
			"show_ui" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"query_var" => true,
			"rewrite" => [ 'slug' => 'tdtax_subgenres', 'with_front' => true, ],
			"show_admin_column" => false,
			"show_in_rest" => true,
			"show_tagcloud" => false,
			"rest_base" => "tdtax_subgenres",
			"rest_controller_class" => "WP_REST_Terms_Controller",
			"rest_namespace" => "wp/v2",
			"show_in_quick_edit" => false,
			"sort" => false,
			"show_in_graphql" => false,
		];
		register_taxonomy( "tdtax_subgenres", [ "tdcpt_tunes" ], $args );

	}

	public function td_demo_plugin_config() {

		//td_api_block::add( 'td_demo_plugin_shortcode',
		//	array(
		//		"map_in_td_composer" => true,
		//		"name" => 'TD Demo Plugin',
		//		"base" => 'td_demo_plugin',
		//		'tdc_category' => 'Single post',
		//		"file" => $this->plugin_path . '/includes/shortcodes/td_demo_plugin_shortcode.php',
		//		"params" => array(),
		//	)
		//);

	}

}
