<?php
/*
Plugin Name: Momentum PRO Plugin
Plugin URI: http://tagdiv.com
Description: tagDiv plugin for demos with custom post types & taxonomies
Author: tagDiv
Version: 1.0.0
Author URI: http://tagdiv.com
*/

defined( 'ABSPATH' ) || exit;

add_action( 'tdc_init', function() {
	new td_momentum_pro_demo_plugin();
}, 11 );

class td_momentum_pro_demo_plugin {

	var $plugin_url = '';
	var $plugin_path = '';

	public function __construct() {
		$this->plugin_url = plugins_url(__FILE__ );
		$this->plugin_path = dirname(__FILE__ );


		/**
		 * ACF
		 */

		// this will allow custom fields meta box on posts when the acf plugin is active
		add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );

		// add local acf fields
		add_action( 'init', array( $this, 'acf_add_local_field_groups' ) );

		// export acf fields: (via json sync)
		add_filter( 'acf/settings/save_json', array( $this, 'set_acf_json_save_folder' ) );
		add_filter( 'acf/settings/load_json', array( $this, 'add_acf_json_load_folder' ) );

		// sync json acf-json fields @see td-demo/includes/acf-json
		add_action( 'admin_init', array( $this, 'sync_acf_fields' ) );

		/**
		 * CPT UI
		 */
		add_action( 'after_setup_theme',  function () {
            // we need priority 9, to avoid invalid tax error
			add_action( 'init', array( $this, 'cptui_register_my_cpts' ), 9 );
			add_action( 'init', array( $this, 'cptui_register_my_taxes' ), 9 );
		});

	}

	public function set_acf_json_save_folder( $path ) {
		return $this->plugin_path . '/includes/acf-json';
	}

	public function add_acf_json_load_folder( $paths ) {
		unset( $paths[0] );

		$paths[] = $this->plugin_path . '/includes/acf-json';

		return $paths;
	}

	public function acf_add_local_field_groups() {

		/*
		 * ACF > Export Field Groups - Generated PHP goes here
		 */

	}

	public function sync_acf_fields() {

		if( ! function_exists('acf_get_field_groups' ) )
			return;

		$groups = acf_get_field_groups();
		$sync = array();

		// return here if no field groups
		if( empty( $groups ) )
			return;

		// find json field groups which have not yet been imported
		foreach( $groups as $group ) {
			$local    = acf_maybe_get( $group, 'local', false );
			$modified = acf_maybe_get( $group, 'modified', 0 );
			$private  = acf_maybe_get( $group, 'private', false );

			// ignore db/php/private field groups
			if( $local !== 'json' || $private ) {
				// do nothing
				continue;
			// append to sync if not yet in database
			} elseif( ! $group['ID'] ) {
				$sync[ $group['key'] ] = $group;
			// append to sync if "json" modified time is newer than database
			} elseif( $modified && $modified > get_post_modified_time( 'U', true, $group['ID'], true ) ) {
				$sync[ $group['key'] ]  = $group;
			}
		}

		// return here if no sync needed
		if( empty( $sync ) )
			return;

		foreach( $sync as $key => $v ) {

			// append fields
			if( acf_have_local_fields( $key ) ) {
				$sync[$key]['fields'] = acf_get_local_fields( $key );
			}

			// import
			$field_group = acf_import_field_group( $sync[$key] );

		}

	}

	// register cptui post types
	function cptui_register_my_cpts() {

        /**
         * Post Type: case studies.
         */

        $labels = [
            "name" => esc_html__( "مطالعات موردی", "newspaper" ),
            "singular_name" => esc_html__( "case_study", "newspaper" ),
            "menu_name" => esc_html__( "مطالعات موردی", "newspaper" ),
            "all_items" => esc_html__( "همه مطالعات موردی", "newspaper" ),
            "add_new" => esc_html__( "افزودن جدید", "newspaper" ),
            "add_new_item" => esc_html__( "مطالعه موردی جدید اضافه کنید", "newspaper" ),
            "edit_item" => esc_html__( "ویرایش مطالعه موردی", "newspaper" ),
            "new_item" => esc_html__( "مطالعه موردی جدید", "newspaper" ),
            "view_item" => esc_html__( "مشاهده مطالعه موردی", "newspaper" ),
            "view_items" => esc_html__( "مشاهده مطالعات موردی", "newspaper" ),
            "search_items" => esc_html__( "جستجو در مطالعات موردی", "newspaper" ),
            "not_found" => esc_html__( "هیچ مطالعه موردی یافت نشد", "newspaper" ),
            "not_found_in_trash" => esc_html__( "هیچ مطالعه موردی در سطل زباله یافت نشد", "newspaper" ),
            "parent" => esc_html__( "مطالعه موردی والد:", "newspaper" ),
            "featured_image" => esc_html__( "تصویر ویژه برای این مطالعه موردی", "newspaper" ),
            "set_featured_image" => esc_html__( "تصویر ویژه را برای این مطالعه موردی تنظیم کنید", "newspaper" ),
            "remove_featured_image" => esc_html__( "تصویر ویژه را برای این مطالعه موردی حذف کنید", "newspaper" ),
            "use_featured_image" => esc_html__( "به عنوان تصویر برجسته برای این مطالعه موردی استفاده کنید", "newspaper" ),
            "archives" => esc_html__( "آرشیو مورد مطالعه", "newspaper" ),
            "insert_into_item" => esc_html__( "درج در مطالعه موردی", "newspaper" ),
            "uploaded_to_this_item" => esc_html__( "در این مطالعه موردی آپلود کنید", "newspaper" ),
            "filter_items_list" => esc_html__( "فهرست مطالعات موردی را فیلتر کنید", "newspaper" ),
            "items_list_navigation" => esc_html__( "پیمایش لیست مطالعات موردی", "newspaper" ),
            "items_list" => esc_html__( "لیست مطالعات موردی", "newspaper" ),
            "attributes" => esc_html__( "ویژگی های مطالعات موردی", "newspaper" ),
            "name_admin_bar" => esc_html__( "مطالعه موردی", "newspaper" ),
            "item_published" => esc_html__( "مطالعه موردی منتشر شد", "newspaper" ),
            "item_published_privately" => esc_html__( "مطالعه موردی به صورت خصوصی منتشر شد.", "newspaper" ),
            "item_reverted_to_draft" => esc_html__( "مطالعه موردی به پیش نویس بازگشت.", "newspaper" ),
            "item_scheduled" => esc_html__( "مطالعه موردی برنامه ریزی شده است", "newspaper" ),
            "item_updated" => esc_html__( "مطالعه موردی به روز شد", "newspaper" ),
            "parent_item_colon" => esc_html__( "مطالعه موردی والد:", "newspaper" ),
        ];

        $args = [
            "label" => esc_html__( "مطالعات موردی", "newspaper" ),
            "labels" => $labels,
            "description" => "",
            "public" => true,
            "publicly_queryable" => true,
            "show_ui" => true,
            "show_in_rest" => true,
            "rest_base" => "",
            "rest_controller_class" => "WP_REST_Posts_Controller",
            "rest_namespace" => "wp/v2",
            "has_archive" => false,
            "show_in_menu" => true,
            "show_in_nav_menus" => true,
            "delete_with_user" => false,
            "exclude_from_search" => false,
            "capability_type" => "post",
            "map_meta_cap" => true,
            "hierarchical" => true,
            "can_export" => false,
            "rewrite" => [ "slug" => "tdcpt_case_studies", "with_front" => true ],
            "query_var" => true,
            "supports" => [ "title", "editor", "thumbnail", "excerpt", "custom-fields", "author", "page-attributes" ],
            "show_in_graphql" => false,
        ];

        register_post_type( "tdcpt_case_studies", $args );



	}

	// register cptui taxonomies
	function cptui_register_my_taxes() {
        /**
         * Taxonomy: Services.
         */

        $labels = [
            "name" => esc_html__( "خدمات", "newspaper" ),
            "singular_name" => esc_html__( "خدمات", "newspaper" ),
        ];


        $args = [
            "label" => esc_html__( "خدمات", "newspaper" ),
            "labels" => $labels,
            "public" => true,
            "publicly_queryable" => true,
            "hierarchical" => false,
            "show_ui" => true,
            "show_in_menu" => true,
            "show_in_nav_menus" => true,
            "query_var" => true,
            "rewrite" => [ 'slug' => 'tdtax_services', 'with_front' => true, ],
            "show_admin_column" => false,
            "show_in_rest" => true,
            "show_tagcloud" => false,
            "rest_base" => "tdtax_services",
            "rest_controller_class" => "WP_REST_Terms_Controller",
            "rest_namespace" => "wp/v2",
            "show_in_quick_edit" => false,
            "sort" => false,
            "show_in_graphql" => false,
        ];
        register_taxonomy( "tdtax_services", [ "tdcpt_case_studies" ], $args );

	}
}
