<?php
/*

Plugin Name: tagDiv Rent a Car PRO Demo Plugin
Plugin URI: http://tagdiv.com
Description: tagDiv plugin with custom post types, taxonomies & custom fields and more for Rent a Car PRO Demo.
Author: tagDiv
Version: 1.0.0
Author URI: http://tagdiv.com

*/

define('TD_CMSTYLES_DIR', dirname(__FILE__));
define('TD_CMSTYLES_URL', plugins_url(__FILE__));


new td_demo_rent_a_car_styles();


class td_demo_rent_a_car_styles
{

    function __construct()
    {

        // Hook used to add or modify items via API, called early for registering styles
        add_action('td_global_after', function () {
            self::register_styles();
        }, 9);


        // Hook used to add or modify items via API
        add_action('td_global_after', function () {

            /**
             * Modules
             */
            td_api_module::add('tds_rent_a_car_1',
                array(
                    'file' => TD_CMSTYLES_DIR . '/includes/modules/tds_rent_a_car_1.php',
                    'text' => 'Loop Car Module',
                    'img' => '',
                    'used_on_blocks' => array(),
                    'excerpt_title' => 25,
                    'excerpt_content' => 25,
                    'enabled_excerpt_in_panel' => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops' => false,
                    'uses_columns' => false,
                    // if the module uses columns on the page template + loop
                    'category_label' => false,
                    'class' => 'td_module_wrap td-animation-stack',
                    'group' => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );
            td_api_module::add('tds_rent_a_car_2',
                array(
                    'file' => TD_CMSTYLES_DIR . '/includes/modules/tds_rent_a_car_2.php',
                    'text' => 'Loop Car Module 2',
                    'img' => '',
                    'used_on_blocks' => array(),
                    'excerpt_title' => 25,
                    'excerpt_content' => 25,
                    'enabled_excerpt_in_panel' => false,
                    'enabled_on_more_articles_box' => false,
                    'enabled_on_loops' => false,
                    'uses_columns' => false,
                    // if the module uses columns on the page template + loop
                    'category_label' => false,
                    'class' => 'td_module_wrap td-animation-stack',
                    'group' => ''
                    // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
                )
            );

        });

    }


    /**
     * Modules styles
     */
    static function register_styles()
    {
        td_api_style::add('tds_rent_a_car_1_style', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Loop Car Custom',
                'file' => TD_CMSTYLES_DIR . '/styles/tds_module_loop_style/tds_rent_a_car_1_style.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Content length',
                            "value" => "",
                            "class" => "",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_tl",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Title length',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_el",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Excerpt length',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
                            "group" => "Module"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "container_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Container width (0-100 percent)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
                        ),
                        array(
                            "param_name" => "modules_on_row",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                '1' => '100%',
                                '2' => '50%',
                                '3' => '33.33333333%',
                                '4' => '25%',
                                '5' => '20%',
                                '6' => '16.66666667%',
                                '7' => '14.28571428%',
                                '8' => '12.5%',
                                '9' => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading" => 'Modules per row',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name" => "modules_gap",
                            "type" => "textfield-responsive",
                            "value" => '48',
                            "heading" => 'Modules gap',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "m_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "all_modules_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules bottom space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Module background',
                            "param_name" => "m_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name" => "modules_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "modules_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "m_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules divider',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_divider",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Modules divider',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Divider color',
                            "param_name" => "modules_divider_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Hover',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "h_effect",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Shadow' => 'shadow',
                                'Move up & shadow' => 'up-shadow',
                            ),
                            "heading" => 'Hover effect',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article image',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "image_size",
                            "type" => "dropdown",
                            "value" => array(
                                'Medium - Default - 696x0px' => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px' => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px' => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading" => 'Image size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name" => "image_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name" => "image_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name" => "image_floated",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Normal' => 'no_float',
                                'Float left' => 'float_left',
                                'Float right' => 'float_right',
                                'Hidden' => 'hidden',
                            ),
                            "heading" => 'Image position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
                        ),
                        array(
                            "param_name" => "image_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),
                        array(
                            "param_name" => "hide_image",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide image",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article video',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_icon",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video icon size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "video_popup",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Enable video pop-up",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group' => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Module',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '- Advertisement -',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group' => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-spot-controller tdc-spot-color",
                            "heading" => 'Ad title color',
                            "param_name" => "video_rec_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_rec_disable",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "autoplay_vid",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Autoplay video",
                            "description" => "When it is inactive, the sound will be ON",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_vid_t",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show video duration',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name" => "vid_t_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video duration space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name" => "vid_t_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video duration padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Style',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Video pop-up article title color',
                            "param_name" => "video_title_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Video pop-up article title hover color',
                            "param_name" => "video_title_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Video pop-up background color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Video pop-up overlay color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder" => "div",
                            "type" => "colorpicker",
                            'heading' => "Video duration text color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder" => "div",
                            "type" => "colorpicker",
                            'heading' => "Video duration background color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', ''),
                    td_config_helper::get_map_block_font_array('f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', ''),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article meta info',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "meta_info_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => '',
                                'Top' => 'initial',
                                'Center' => 'center',
                                'Bottom' => 'flex-end',
                            ),
                            "heading" => 'Meta info alignment',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name" => "meta_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info margin',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name" => "meta_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "13px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "meta_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta container space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Meta info background',
                            "param_name" => "meta_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_meta', false, 'Article meta info', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Meta info border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "meta_info_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_border_width.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style_general.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "meta_info_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color_general.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article title',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "art_title",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article title space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 6px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Article title text color',
                            "param_name" => "title_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Article title text hover',
                            "param_name" => "title_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_underline_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Underline size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Hover underline color',
                            "param_name" => "all_underline_color",
                            "value" => '#000',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
                        array(
                            "param_name" => "art_btn",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article button space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_title', true, 'Article title', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', ''),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Category tag',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "modules_category",
                            "type" => "dropdown",
                            "value" => array(
                                'Inline' => '',
                                'Above title' => 'above',
                                'Over image' => 'image',
                            ),
                            "heading" => 'Category tag position',
                            "description" => "Float image",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "modules_category_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category tag spacing',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_category_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category tag padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name" => "modules_cat_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
                        ),
                        array(
                            'param_name' => 'modules_category_radius',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '100',
                            'range_step' => '1',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
                        ),
                        array(
                            "param_name" => "show_cat",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show category',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "modules_extra_cat",
                            "type" => "dropdown",
                            "value" => array(
                                'Inline' => '',
                                'Above title' => 'above',
                                'Hide' => 'hide',
                            ),
                            "heading" => 'Show custom label',
                            "description" => "The custom label can be set individually for each post. Edit a single post and check Post Settings fields.",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category background',
                            "param_name" => "cat_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category background hover',
                            "param_name" => "cat_bg_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category text color',
                            "param_name" => "cat_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category text hover',
                            "param_name" => "cat_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category border color',
                            "param_name" => "cat_border",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category border hover',
                            "param_name" => "cat_border_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_cat', false, 'Article category tag', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Author',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_author",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show author',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name" => "author_photo",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show author photo",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
                        ),
                        array(
                            "param_name" => "author_photo_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
                        ),
                        array(
                            "param_name" => "author_photo_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "6",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
                        ),
                        array(
                            "param_name" => "author_photo_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "50%",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Author text color',
                            "param_name" => "author_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Author text hover',
                            "param_name" => "author_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Date',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_date",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show date',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name" => "show_modified_date",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show modified date",
                            "description" => "Show last modified date of the article",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "time_ago",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Enable time ago',
                            "description" => "Applicable only for posts newer than 7 days",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_time_ago.png"
                        ),
                        array(
                            "param_name" => "time_ago_add_txt",
                            "type" => "textfield",
                            "value" => 'ago',
                            "heading" => 'Time ago add. text',
                            "description" => "",
                            "placeholder" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_ago_text.png",
                        ),
                        array(
                            "param_name" => "time_ago_txt_pos",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Display additional text before the date',
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Date text color',
                            "param_name" => "date_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Comment count',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_com",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show comment',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Comment background',
                            "param_name" => "com_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Comment text color',
                            "param_name" => "com_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Review stars',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_review",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show review stars',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name" => "review_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Review stars space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'review_size',
                            'type' => 'range-responsive',
                            'value' => '2.5',
                            'heading' => 'Review stars size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '0.5',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name" => "review_distance",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Distance between rating stars',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Excerpt',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_excerpt",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show excerpt',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name" => "art_excerpt",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article excerpt space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "excerpt_col",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                            ),
                            "heading" => 'Article excerpt columns',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_article_excerpt_columns.png",
                        ),
                        array(
                            "param_name" => "excerpt_gap",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article excerpt columns gap',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "48",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "excerpt_middle",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Excerpt in middle",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "excerpt_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Inline Excerpt & Title",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_inline_excerpt_title.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Excerpt text color',
                            "param_name" => "ex_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_ex', false, 'Article excerpt', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article audio player',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_audio",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading" => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "hide_audio",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "art_audio",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Audio player space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name' => 'art_audio_size',
                            'type' => 'range-responsive',
                            'value' => '1.5',
                            'heading' => 'Audio player size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '0.5',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Buttons color',
                            "param_name" => "audio_btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Time text color',
                            "param_name" => "audio_time_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Bars background color',
                            "param_name" => "audio_bar_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Bars progress color',
                            "param_name" => "audio_bar_curr_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Read more button',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_btn",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show button',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_show.png",
                        ),
                        array(
                            "param_name" => "btn_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Button text',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "Read more",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
                        ),
                        array(
                            "param_name" => "btn_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 20px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_space.png",
                        ),
                        array(
                            "param_name" => "btn_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "10px 15px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_padding.png",
                        ),
                        array(
                            "param_name" => "btn_border_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border.png",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Button border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            'group' => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_radius.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button background',
                            "param_name" => "btn_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button background hover',
                            "param_name" => "btn_bg_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button text color',
                            "param_name" => "btn_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_text.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button text hover',
                            "param_name" => "btn_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button border color',
                            "param_name" => "btn_border",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button border hover',
                            "param_name" => "btn_border_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_btn', false, 'Article read more button', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_read.png', ''),
                ),
            )
        );
        td_api_style::add('tds_rent_a_car_2_style', array(
                'group' => 'tds_module_loop_style',
                'title' => 'Loop Car Custom 2',
                'file' => TD_CMSTYLES_DIR . '/styles/tds_module_loop_style/tds_rent_a_car_2_style.php',
                'params' => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Content length',
                            "value" => "",
                            "class" => "",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_tl",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Title length',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => '25',
                            "info_img" => "https://cloud.tagdiv.com/help/title_length.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_title_tag",
                            "type" => "dropdown",
                            "value" => array(
                                'Default - H3' => '',
                                'H1' => 'h1',
                                'H2' => 'h2',
                                'H4' => 'h4',
                                'Paragraph' => 'p'
                            ),
                            "heading" => 'Title tag (SEO)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "info_img" => "https://cloud.tagdiv.com/help/module_title_seo.png",
                            "group" => "Module"
                        ),
                        array(
                            "param_name" => "mc1_el",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Excerpt length',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "25",
                            "info_img" => "https://cloud.tagdiv.com/help/excerpt_length.png",
                            "group" => "Module"
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'General',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "container_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Container width (0-100 percent)',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_container.png",
                        ),
                        array(
                            "param_name" => "modules_on_row",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                '1' => '100%',
                                '2' => '50%',
                                '3' => '33.33333333%',
                                '4' => '25%',
                                '5' => '20%',
                                '6' => '16.66666667%',
                                '7' => '14.28571428%',
                                '8' => '12.5%',
                                '9' => '11.11111111%',
                                '10' => '10%',
                            ),
                            "heading" => 'Modules per row',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_per_row.png",
                        ),
                        array(
                            "param_name" => "modules_gap",
                            "type" => "textfield-responsive",
                            "value" => '48',
                            "heading" => 'Modules gap',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_gap.png",
                        ),
                        array(
                            "param_name" => "m_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_padding.png",
                        ),
                        array(
                            "param_name" => "all_modules_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Modules bottom space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "34",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_bottom_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Module background',
                            "param_name" => "m_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow', 'Module Shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_border_width.png",
                        ),
                        array(
                            "param_name" => "modules_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_style.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "modules_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_border_color.png",
                        ),
                        array(
                            "param_name" => "m_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Modules divider',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_divider",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Solid' => 'solid',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Modules divider',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_modules_divider.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Divider color',
                            "param_name" => "modules_divider_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_divider_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Hover',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "h_effect",
                            "type" => "dropdown",
                            "value" => array(
                                'None' => '',
                                'Shadow' => 'shadow',
                                'Move up & shadow' => 'up-shadow',
                            ),
                            "heading" => 'Hover effect',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hover_effect.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article image',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "image_size",
                            "type" => "dropdown",
                            "value" => array(
                                'Medium - Default - 696x0px' => '',
                                '-- [No crop] --' => '__',
                                'XSmall - 150x0px' => 'td_150x0',
                                'Small - 300x0px' => 'td_300x0',
                                'Large - 1068x0px' => 'td_1068x0',
                                'Full - 1920x0px' => 'td_1920x0',
                                '-- [Other sizes] --' => '__',
                                '218x150px' => 'td_218x150',
                                '324x400px' => 'td_324x400',
                                '485x360' => 'td_485x360'
                            ),
                            "heading" => 'Image size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_image_size.png",
                        ),
                        array(
                            "param_name" => "image_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_height.png",
                        ),
                        array(
                            "param_name" => "image_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image width (0-100 percent)',
                            "description" => "Default value in percent",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_width.png",
                        ),
                        array(
                            "param_name" => "image_floated",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Normal' => 'no_float',
                                'Float left' => 'float_left',
                                'Float right' => 'float_right',
                                'Hidden' => 'hidden',
                            ),
                            "heading" => 'Image position',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_position.png",
                        ),
                        array(
                            "param_name" => "image_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Image radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_image_radius.png",
                        ),
                        array(
                            "param_name" => "hide_image",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide image",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_hide_image.png",
                        ),
                    ),
                    td_config_helper::mix_blend('Module'),
                    td_config_helper::image_filters(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article video',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_icon",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video icon size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_video_icon_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "video_popup",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Enable video pop-up",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_enable_video_pop-up.png",
                        ),
                        array(
                            "param_name" => "video_rec",
                            "type" => "textarea_raw_html",
                            "holder" => "div",
                            "class" => "tdc-textarea-raw-small",
                            "heading" => 'Video pop-up ad',
                            "value" => "",
                            "description" => 'Paste your ad code here.',
                            'group' => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_popup_ad.png",
                        ),
                        array(
                            "param_name" => "spot_header",
                            "type" => "spot_header",
                            "value" => "",
                            "class" => '',
                            'group' => 'Module',
                        ),
                        array(
                            "param_name" => "video_rec_title",
                            "type" => "textfield",
                            "value" => '- Advertisement -',
                            "heading" => 'Ad title',
                            "description" => "",
                            "placeholder" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-extrabig tdc-spot-controller tdc-spot-title",
                            'group' => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "tdc-spot-controller tdc-spot-color",
                            "heading" => 'Ad title color',
                            "param_name" => "video_rec_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_rec_disable",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Hide ADS for admins/editors",
                            "description" => "Used to prevent fake clicks and views on ads by admins and editors",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "autoplay_vid",
                            "type" => "checkbox",
                            "value" => 'yes',
                            "heading" => "Autoplay video",
                            "description" => "When it is inactive, the sound will be ON",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_vid_t",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show video duration',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_show_video_duration.png",
                        ),
                        array(
                            "param_name" => "vid_t_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video duration space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_space.png",
                        ),
                        array(
                            "param_name" => "vid_t_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Video duration padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_padding.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Style',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Video pop-up article title color',
                            "param_name" => "video_title_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_title_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Video pop-up article title hover color',
                            "param_name" => "video_title_color_h",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "video_bg",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Video pop-up background color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_background.png",
                        ),
                        array(
                            "param_name" => "video_overlay",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Video pop-up overlay color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_overlay_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "param_name" => "vid_t_color",
                            "holder" => "div",
                            "type" => "colorpicker",
                            'heading' => "Video duration text color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_text_color.png",
                        ),
                        array(
                            "param_name" => "vid_t_bg_color",
                            "holder" => "div",
                            "type" => "colorpicker",
                            'heading' => "Video duration background color",
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_video_bg_color.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_vid_title', true, 'Video pop-up article title', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_article_title.png', ''),
                    td_config_helper::get_map_block_font_array('f_vid_time', false, 'Video duration text', 'Layout', '', '', 'https://cloud.tagdiv.com/help/module_video_duration_title.png', ''),
                    td_config::get_map_exclusive_label_array(),
                    array(

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article meta info',
                            "value" => "",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "meta_info_align",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Default' => '',
                                'Top' => 'initial',
                                'Center' => 'center',
                                'Bottom' => 'flex-end',
                            ),
                            "heading" => 'Meta info alignment',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_vertical_align.png",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_horiz_align.png",
                        ),
                        array(
                            "param_name" => "meta_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_info_width.png",
                        ),
                        array(
                            "param_name" => "meta_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info margin',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_margin.png",
                        ),
                        array(
                            "param_name" => "meta_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta info padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "13px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_padding.png",
                        ),
                        array(
                            "param_name" => "meta_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Meta container space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_container_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Meta info background',
                            "param_name" => "meta_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_background.png",
                        ),
                    ),
                    td_config_helper::get_map_block_shadow_array('shadow_m', 'Meta info shadow', 0, 0, 0, "Module", '', 0, true, '', 'https://cloud.tagdiv.com/help/module_meta_shadow.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_meta', false, 'Article meta info', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_meta.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Meta info border',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "meta_info_border_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_meta_border_width.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_style",
                            "type" => "dropdown",
                            "value" => array(
                                'Solid' => '',
                                'Dotted' => 'dotted',
                                'Dashed' => 'dashed',
                            ),
                            "heading" => 'Border style',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_style_general.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Border color',
                            "param_name" => "meta_info_border_color",
                            "value" => '#eaeaea',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_meta_border_color_general.png",
                        ),
                        array(
                            "param_name" => "meta_info_border_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Border radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article title',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "art_title",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article title space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 6px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_article_title_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Article title text color',
                            "param_name" => "title_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_article_title.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Article title text hover',
                            "param_name" => "title_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "all_underline_height",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Underline size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/style_underline.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Hover underline color',
                            "param_name" => "all_underline_color",
                            "value" => '#000',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_underline_color.png",
                        ),
                        array(
                            "param_name" => "art_btn",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article button space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => '',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_title', true, 'Article title', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_title.png', ''),

                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Category tag',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "modules_category",
                            "type" => "dropdown",
                            "value" => array(
                                'Inline' => '',
                                'Above title' => 'above',
                                'Over image' => 'image',
                            ),
                            "heading" => 'Category tag position',
                            "description" => "Float image",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "modules_category_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category tag spacing',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "modules_category_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category tag padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "3px 6px 4px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_padding.png",
                        ),
                        array(
                            "param_name" => "modules_cat_border",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Category border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_border.png",
                        ),
                        array(
                            'param_name' => 'modules_category_radius',
                            'type' => 'range-responsive',
                            'value' => '0',
                            'heading' => 'Border radius',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '100',
                            'range_step' => '1',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_radius.png",
                        ),
                        array(
                            "param_name" => "show_cat",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show category',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_show.png",
                        ),
                        array(
                            "param_name" => "modules_extra_cat",
                            "type" => "dropdown",
                            "value" => array(
                                'Inline' => '',
                                'Above title' => 'above',
                                'Hide' => 'hide',
                            ),
                            "heading" => 'Show custom label',
                            "description" => "The custom label can be set individually for each post. Edit a single post and check Post Settings fields.",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_category_tag_position.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category background',
                            "param_name" => "cat_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category background hover',
                            "param_name" => "cat_bg_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category text color',
                            "param_name" => "cat_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category text hover',
                            "param_name" => "cat_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Category border color',
                            "param_name" => "cat_border",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_cat_color_border.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Category border hover',
                            "param_name" => "cat_border_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_cat', false, 'Article category tag', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_cat.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Author',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_author",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show author',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_show.png",
                        ),
                        array(
                            "param_name" => "author_photo",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show author photo",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo.png",
                        ),
                        array(
                            "param_name" => "author_photo_size",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo size',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_size.png",
                        ),
                        array(
                            "param_name" => "author_photo_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "6",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_space.png",
                        ),
                        array(
                            "param_name" => "author_photo_radius",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Author photo radius',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "50%",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_photo_radius.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Author text color',
                            "param_name" => "author_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_auth_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Author text hover',
                            "param_name" => "author_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Date',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_date",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show date',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_show.png",
                        ),
                        array(
                            "param_name" => "show_modified_date",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Show modified date",
                            "description" => "Show last modified date of the article",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "time_ago",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Enable time ago',
                            "description" => "Applicable only for posts newer than 7 days",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_time_ago.png"
                        ),
                        array(
                            "param_name" => "time_ago_add_txt",
                            "type" => "textfield",
                            "value" => 'ago',
                            "heading" => 'Time ago add. text',
                            "description" => "",
                            "placeholder" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_ago_text.png",
                        ),
                        array(
                            "param_name" => "time_ago_txt_pos",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => 'Display additional text before the date',
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Date text color',
                            "param_name" => "date_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_date_color.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Comment count',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "show_com",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show comment',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Comment background',
                            "param_name" => "com_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Comment text color',
                            "param_name" => "com_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_comment_text.png",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Review stars',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_review",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show review stars',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_show.png",
                        ),
                        array(
                            "param_name" => "review_space",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Review stars space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            'param_name' => 'review_size',
                            'type' => 'range-responsive',
                            'value' => '2.5',
                            'heading' => 'Review stars size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '0.5',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_review_size.png",
                        ),
                        array(
                            "param_name" => "review_distance",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Distance between rating stars',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Excerpt',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_excerpt",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show excerpt',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_show_excerpt.png",
                        ),
                        array(
                            "param_name" => "art_excerpt",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article excerpt space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "20px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_excerpt_space.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "excerpt_col",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                            ),
                            "heading" => 'Article excerpt columns',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/layout_article_excerpt_columns.png",
                        ),
                        array(
                            "param_name" => "excerpt_gap",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Article excerpt columns gap',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "48",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "excerpt_middle",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Excerpt in middle",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout'
                        ),
                        array(
                            "param_name" => "excerpt_inline",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Inline Excerpt & Title",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/layout_inline_excerpt_title.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Excerpt text color',
                            "param_name" => "ex_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_excerpt.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_ex', false, 'Article excerpt', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_excerpt.png', ''),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Article audio player',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "show_audio",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Visible' => 'block',
                                'Hidden' => 'none',
                            ),
                            "heading" => 'Show audio player',
                            "description" => "This will hide the audio player responsive",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "hide_audio",
                            "type" => "checkbox",
                            "value" => '',
                            "heading" => "Remove audio player",
                            "description" => "This will remove the audio player from code",
                            "holder" => "div",
                            "class" => "",
                            "group" => 'Layout',
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_show.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Layout',
                        ),
                        array(
                            "param_name" => "art_audio",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Audio player space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_space.png",
                        ),
                        array(
                            'param_name' => 'art_audio_size',
                            'type' => 'range-responsive',
                            'value' => '1.5',
                            'heading' => 'Audio player size',
                            'description' => '',
                            'class' => 'tdc-textfield-small',
                            'range_min' => '0',
                            'range_max' => '10',
                            'range_step' => '0.5',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_audio_size.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Buttons color',
                            "param_name" => "audio_btn_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_buttons.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Time text color',
                            "param_name" => "audio_time_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_time.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Bars background color',
                            "param_name" => "audio_bar_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_bar.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => 'Bars progress color',
                            "param_name" => "audio_bar_curr_color",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_color_audio_progress.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Read more button',
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module'
                        ),
                        array(
                            "param_name" => "show_btn",
                            "type" => "dropdown-responsive",
                            "value" => array(
                                'Show' => 'block',
                                'Hide' => 'none',
                            ),
                            "heading" => 'Show button',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-big",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_show.png",
                        ),
                        array(
                            "param_name" => "btn_title",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Button text',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "Read more",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_text.png",
                        ),
                        array(
                            "param_name" => "btn_margin",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button space',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "0px 0px 20px 0px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_space.png",
                        ),
                        array(
                            "param_name" => "btn_padding",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button padding',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-big",
                            "placeholder" => "10px 15px",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_padding.png",
                        ),
                        array(
                            "param_name" => "btn_border_width",
                            "type" => "textfield-responsive",
                            "value" => '',
                            "heading" => 'Button border width',
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            "placeholder" => "0",
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border.png",
                        ),
                        array(
                            "param_name" => "btn_radius",
                            "type" => "textfield",
                            "value" => '',
                            "heading" => 'Button border radius',
                            "description" => "",
                            "placeholder" => "0",
                            "holder" => "div",
                            "class" => "tdc-textfield-small",
                            'group' => 'Module',
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_radius.png",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button background',
                            "param_name" => "btn_bg",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_bg.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button background hover',
                            "param_name" => "btn_bg_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button text color',
                            "param_name" => "btn_txt",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_color_text.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button text hover',
                            "param_name" => "btn_txt_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-a",
                            "heading" => 'Button border color',
                            "param_name" => "btn_border",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                            "info_img" => "https://cloud.tagdiv.com/help/module_button_border_color.png",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "td-colorpicker-double-b",
                            "heading" => 'Button border hover',
                            "param_name" => "btn_border_hover",
                            "value" => '',
                            "description" => '',
                            "group" => "Module",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => "tdc-separator-small",
                            "group" => 'Module',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array('f_btn', false, 'Article read more button', "Module", '', '', 'https://cloud.tagdiv.com/help/module_font_article_read.png', ''),
                ),
            )
        );
    }

}



