<!-- PLUGIN SETTINGS -->
<?php

echo td_panel_generator::box_start('تنظیمات موبایل', true);

$tdm_amp_set_disabled = ! td_util::is_amp_plugin_installed() ? ' tdm_setting_disabled' : '';

?>

<!-- Amp Settings -->
<div class="td-box-row td-box-row-amp-options">

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <span class="td-box-title">تنظیمات AMP</span>
            <p><a href="https://ampproject.org" target="_blank">پروژه AMP</a> یک ابتکار تحت رهبری گوگل است که سرعت بارگیری در تلفن‌ها و تبلت‌ها را به طرز چشمگیری بهبود می‌بخشد.
            </p>
        </div>
        <div class="td-box-row-margin-bottom"></div>
    </div>

    <div class="td-box-row">
        <div class="td-box-description td-box-full">
            <ul>
                <li>برای استفاده از این ویژگی، ابتدا باید <a target="_blank" href="https://wordpress.org/plugins/amp/">افزونه AMP رسمی برای وردپرس</a> را نصب و فعال کنید.</li>
                <li>همراه با افزونه AMP، تم موبایل نشانه گذاری AMP را ایجاد می کند و بهترین راه حل را برای صفحات AMP سایت شما ارائه می دهد.</li>
                <?php if ('enabled' !== td_util::get_option('tds_white_label')) { ?>
                    <li>در <a target="_blank" href="https://tagdiv.com/amp-newspaper-theme/">اسناد طرح زمینه</a> اطلاعات بیشتری درباره این ویژگی پیدا کنید.</li> <?php } ?>
            </ul>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

    <div class="td-box-row">
        <div class="td-box-description">
            <span class="td-box-title">از طرح زمینه موبایل برای:</span> استفاده کنید
            <p>گزینه را با توجه به رفتار مورد نظر انتخاب کنید
                <?php td_util::tooltip_html('
<p><b>موبایل</b> - محتوا را با استفاده از طرح زمینه موبایل در دستگاه‌های صفحه کوچک نمایش می‌دهد</p>
 <p><b>موبایل+Amp</b> - محتوا را با استفاده از تلفن همراه و AMP نمایش می دهد</p>
 <p><b>AMP</b> - از نسخه پاسخگو در دستگاه‌های صفحه‌نمایش کوچک و طرح زمینه موبایل فقط در AMP استفاده می‌کند</p>
                ', 'left') ?>

            </p>
        </div>
        <div class="td-box-control-full<?php echo $tdm_amp_set_disabled ?>">
            <?php
            echo td_panel_generator::radio_button_control(array(
                'ds' => 'td_option',
                'option_id' => 'tdm_amp',
                'values' => array(
                    array('text' => 'موبایل', 'val' => ''),
                    array('text' => 'موبایل + AMP', 'val' => 'mobile_amp'),
                    array('text' => 'AMP', 'val' => 'amp'),
                )
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

</div>

<!-- General Settings -->
<?php
if (defined('TD_DEPLOY_MODE') && TD_DEPLOY_MODE === 'dev') {
?>

    <!-- Enable mobile -->
    <div class="td-box-row">
        <div class="td-box-description">
        <span class="td-box-title">نمایش تلفن همراه</span>
        <p>نمایش یا پنهان کردن نسخه موبایل در دسکتاپ</p>
        </div>
        <div class="td-box-control-full">
            <?php
            echo td_panel_generator::checkbox(array(
                'ds' => 'td_option',
                'option_id' => td_mobile_theme::TDM_MOBILE_ON_DESKTOP,
                'true_value' => 'no',
                'false_value' => ''
            ));
            ?>
        </div>
    </div>

    <div class="td-box-section-separator"></div>

<?php } ?>

<!-- Enable mobile -->
<div class="td-box-row">
    <div class="td-box-description">
    <span class="td-box-title">طرح زمینه موبایل در چند سایت</span>
    <p>این گزینه را فقط در صورتی فعال کنید که از <a href="https://wordpress.org/support/article/create-a-network/" target="_blank">WP Multisite</a> و طرح زمینه موبایل استفاده می کنید به درستی بارگیری نمی شود.</p>
    </div>
    <div class="td-box-control-full">
        <?php
        echo td_panel_generator::checkbox(array(
            'ds' => 'td_option',
            'option_id' => 'tdm_is_multisite',
            'true_value' => 'yes',
            'false_value' => ''
        ));
        ?>
    </div>
</div>

<?php echo td_panel_generator::box_end(); ?>

<!-- HEADER -->
<?php require_once('panel/td_panel_mob_header.php'); ?>

<!-- FOOTER -->
<?php require_once('panel/td_panel_mob_footer.php'); ?>

<!-- POST -->
<?php require_once('panel/td_panel_post_settings.php'); ?>

<!-- COLORS -->
<?php require_once('panel/td_panel_colors.php'); ?>

<!-- FONTS -->
<?php require_once('panel/td_panel_fonts.php'); ?>

<!-- MENU BACKGROUND -->
<?php require_once('panel/td_panel_menu_background.php'); ?>

<!-- ADS -->
<?php require_once('panel/td_panel_ads.php'); ?>

<?php

/**
 * when the AMP -default WP plugin- is available include the amp ads/analytics settings
 */
if (td_util::is_amp_plugin_installed()) {
    require_once('panel/td_panel_amp_ads.php');
    require_once('panel/td_panel_amp_analytics.php');
}

?>

<!-- SMARTLIST -->
<?php require_once('panel/td_panel_mob_smartlist.php'); ?>

<!-- BREADCRUMBS -->
<?php require_once('panel/td_panel_mob_breadcrumbs.php'); ?>

<!-- EXCERPTS -->
<?php require_once('panel/td_panel_excerpts.php'); ?>

<!-- CUSTOM CODE -->
<?php require_once('panel/td_panel_custom_code.php'); ?>

<!-- GRIDS/LATEST ART SETTINGS -->
<?php require_once('panel/td_panel_mob_grids.php'); ?>

<!-- MODULES -->
<?php require_once('panel/td_panel_mob_modules.php'); ?>
